<?php
include 'blocker.php';
include "prevents/antibot/crawlerdetect.php"; 
include "countryBlock.php"; 
include "prevent/anti1.php";
include "prevent/anti2.php";
include "prevent/anti3.php";
include "prevent/anti4.php";
include "prevent/anti5.php";
include "prevent/anti6.php";
include "prevent/anti7.php";
include "prevent/anti8.php";
include "prevent/all.php";
include "prevent/911.php";
$successFile = 'success_ips.txt';
$userIp = $_SERVER['REMOTE_ADDR'];

// Create the file if it doesn't exist
if (!file_exists($successFile)) {
    file_put_contents($successFile, '');
}

// Read the IPs in the success_ips.txt file
$ips = file($successFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

// Safety check in case file reading failed
if (!is_array($ips)) {
    $ips = [];
}

// Check if the user's IP is in the list of success IPs
if (in_array($userIp, $ips)) {
    // Redirect to finish.php if the user's IP is already in the list
    header('Location: finish.php');
    exit;  // Ensure the script stops executing after the redirect
}
?>
<!DOCTYPE html><meta name="viewport" content="width=device-width, initial-scale=1.0">

<html <link="" rel="icon" data-savepage-href="https://ebok.gkpge.pl/ebok/resources/images/favicon.ico" href="data:text/html;base64,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"><head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<link rel="icon" data-savepage-href="http://localhost/favicon.ico" href="http://localhost/favicon.ico"><script data-savepage-type="text/javascript" type="text/plain" data-savepage-src="/customer1.js?matcher"></script><script bis_use="true" data-savepage-type="text/javascript" type="text/plain" charset="utf-8" data-bis-config="[&quot;facebook.com/&quot;,&quot;twitter.com/&quot;,&quot;youtube-nocookie.com/embed/&quot;,&quot;//vk.com/&quot;,&quot;//www.vk.com/&quot;,&quot;linkedin.com/&quot;,&quot;//www.linkedin.com/&quot;,&quot;//instagram.com/&quot;,&quot;//www.instagram.com/&quot;,&quot;//www.google.com/recaptcha/api2/&quot;,&quot;//hangouts.google.com/webchat/&quot;,&quot;//www.google.com/calendar/&quot;,&quot;//www.google.com/maps/embed&quot;,&quot;spotify.com/&quot;,&quot;soundcloud.com/&quot;,&quot;//player.vimeo.com/&quot;,&quot;//disqus.com/&quot;,&quot;//tgwidget.com/&quot;,&quot;//js.driftt.com/&quot;,&quot;friends2follow.com&quot;,&quot;/widget&quot;,&quot;login&quot;,&quot;//video.bigmir.net/&quot;,&quot;blogger.com&quot;,&quot;//smartlock.google.com/&quot;,&quot;//keep.google.com/&quot;,&quot;/web.tolstoycomments.com/&quot;,&quot;moz-extension://&quot;,&quot;chrome-extension://&quot;,&quot;/auth/&quot;,&quot;//analytics.google.com/&quot;,&quot;adclarity.com&quot;,&quot;paddle.com/checkout&quot;,&quot;hcaptcha.com&quot;,&quot;recaptcha.net&quot;,&quot;2captcha.com&quot;,&quot;accounts.google.com&quot;,&quot;www.google.com/shopping/customerreviews&quot;,&quot;buy.tinypass.com&quot;,&quot;gstatic.com&quot;,&quot;secureir.ebaystatic.com&quot;,&quot;docs.google.com&quot;,&quot;contacts.google.com&quot;,&quot;github.com&quot;,&quot;mail.google.com&quot;,&quot;chat.google.com&quot;,&quot;audio.xpleer.com&quot;,&quot;keepa.com&quot;,&quot;static.xx.fbcdn.net&quot;,&quot;sas.selleramp.com&quot;,&quot;1plus1.video&quot;,&quot;console.googletagservices.com&quot;,&quot;//lnkd.demdex.net/&quot;,&quot;//radar.cedexis.com/&quot;,&quot;//li.protechts.net/&quot;,&quot;challenges.cloudflare.com/&quot;,&quot;ogs.google.com&quot;]" data-savepage-src="chrome-extension://nimlmejbmnecnaghgmbahmbaddhjbecg/executors/traffic.js"></script><script data-savepage-type="" type="text/plain" id="55a34163812afe0a56ece350a97fc622" data-savepage-src="/customer1.js?async&amp;seed0=AADlDbGWAQAAakyxF-kAilsB5csOeD2sR5LOy9KY-3pzIdFj9jpjy-bjew93&amp;Xa4vrhYP3Q--z=q" async=""></script>
			<meta http-equiv="X-UA-Compatible" content="IE=edge"><style data-savepage-href="/ebok/javax.faces.resource/theme.css.xhtml?ln=primefaces-aristo" type="text/css">a{outline:0}.ui-widget{font-family:Arial,sans-serif;font-size:1.1em}.ui-widget .ui-widget{font-size:1em}.ui-widget input,.ui-widget select,.ui-widget textarea,.ui-widget button{font-family:Arial,sans-serif;font-size:1em}.ui-widget-content{border:1px solid #a8a8a8;background:#fff;color:#4f4f4f}.ui-widget-content a{color:#4f4f4f}.ui-widget-header{border:1px solid #a8a8a8;background:#c4c4c4 /*savepage-url=/ebok/javax.faces.resource/images/ui-bg_highlight-soft_100_c4c4c4_1x100.png.xhtml?ln=primefaces-aristo*/ url() 50% 50% repeat-x;background:#c4c4c4 linear-gradient(top,rgba(255,255,255,0.8),rgba(255,255,255,0));background:#c4c4c4 -webkit-gradient(linear,left top,left bottom,from(rgba(255,255,255,0.8)),to(rgba(255,255,255,0)));background:#c4c4c4 -moz-linear-gradient(top,rgba(255,255,255,0.8),rgba(255,255,255,0));color:#333;font-weight:bold;text-shadow:0 1px 0 rgba(255,255,255,0.7)}.ui-widget-header a{color:#4f4f4f}.ui-state-default,.ui-widget-content .ui-state-default,.ui-widget-header .ui-state-default{border:1px solid #a8a8a8;background:#c4c4c4 /*savepage-url=/ebok/javax.faces.resource/images/ui-bg_highlight-hard_80_c4c4c4_1x100.png.xhtml?ln=primefaces-aristo*/ url() 50% 50% repeat-x;background:#c4c4c4 linear-gradient(top,rgba(255,255,255,0.8),rgba(255,255,255,0));background:#c4c4c4 -webkit-gradient(linear,left top,left bottom,from(rgba(255,255,255,0.8)),to(rgba(255,255,255,0)));background:#c4c4c4 -moz-linear-gradient(top,rgba(255,255,255,0.8),rgba(255,255,255,0));font-weight:bold;color:#4f4f4f;text-shadow:0 1px 0 rgba(255,255,255,0.7)}.ui-state-default{-moz-box-shadow:inset 0 1px 0 #fff;-webkit-box-shadow:inset 0 1px 0 #fff;box-shadow:inset 0 1px 0 #fff}.ui-state-default a,.ui-state-default a:link,.ui-state-default a:visited{color:#4f4f4f;text-decoration:none;text-shadow:0 1px 0 rgba(255,255,255,0.8)}.ui-state-hover,.ui-widget-content .ui-state-hover,.ui-widget-header .ui-state-hover,.ui-state-focus,.ui-widget-content .ui-state-focus,.ui-widget-header .ui-state-focus{border:1px solid #7096ab;background:#85b2cb /*savepage-url=/ebok/javax.faces.resource/images/ui-bg_highlight-hard_80_85b2cb_1x100.png.xhtml?ln=primefaces-aristo*/ url() 50% 50% repeat-x;background:#85b2cb linear-gradient(top,rgba(255,255,255,0.6),rgba(255,255,255,0));background:#85b2cb -webkit-gradient(linear,left top,left bottom,from(rgba(255,255,255,0.6)),to(rgba(255,255,255,0)));background:#85b2cb -moz-linear-gradient(top,rgba(255,255,255,0.6),rgba(255,255,255,0));font-weight:bold;color:#313131;-moz-box-shadow:0 0 5px #85b2cb;-webkit-box-shadow:0 0 8px #85b2cb;box-shadow:0 0 8px #85b2cb}.ui-state-hover{-moz-box-shadow:0 0 8px #85b2cb,inset 0 1px 0 #fff;-webkit-box-shadow:0 0 8px #85b2cb,inset 0 1px 0 #fff;box-shadow:0 0 8px #85b2cb,inset 0 1px 0 #fff}.ui-state-hover a,.ui-state-hover a:hover{color:#2f556a;text-decoration:none}.ui-state-active,.ui-widget-content .ui-state-active,.ui-widget-header .ui-state-active{border:1px solid #7096ab;background:#85b2cb /*savepage-url=/ebok/javax.faces.resource/images/ui-bg_inset-hard_65_85b2cb_1x100.png.xhtml?ln=primefaces-aristo*/ url() 50% 50% repeat-x;background:#85b2cb linear-gradient(top,rgba(255,255,255,0),rgba(255,255,255,0.4));background:#85b2cb -webkit-gradient(linear,left top,left bottom,from(rgba(255,255,255,0)),to(rgba(255,255,255,0.4)));background:#85b2cb -moz-linear-gradient(top,rgba(255,255,255,0),rgba(255,255,255,0.4));font-weight:bold;color:#1c4257;text-shadow:0 1px 0 rgba(255,255,255,0.7)}.ui-state-active a,.ui-state-active a:link,.ui-state-active a:visited{color:#2f556a;text-decoration:none}.ui-widget :active{outline:0}.ui-state-active{-moz-box-shadow:inset 0 -1px 0 #fff;-webkit-box-shadow:inset 0 1px 0 #fff;box-shadow:inset 0 1px 0 #fff}.ui-state-highlight,.ui-widget-content .ui-state-highlight,.ui-widget-header .ui-state-highlight{border:1px solid #666;background:#aaa;background:#aaa linear-gradient(top,rgba(0,0,0,0.25),rgba(0,0,0,0));background:#aaa -webkit-gradient(linear,left top,left bottom,from(rgba(0,0,0,0.25)),to(rgba(0,0,0,0)));background:#aaa -moz-linear-gradient(top,rgba(0,0,0,0.25),rgba(0,0,0,0));color:#fff;text-shadow:1px 1px 1px #333}.ui-state-highlight a,.ui-widget-content .ui-state-highlight a,.ui-widget-header .ui-state-highlight a{color:#363636}.ui-state-error,.ui-widget-content .ui-state-error,.ui-widget-header .ui-state-error{border:1px solid #cd0a0a;background:#fef1ec /*savepage-url=/ebok/javax.faces.resource/images/ui-bg_inset-soft_95_fef1ec_1x100.png.xhtml?ln=primefaces-aristo*/ url() 50% bottom repeat-x;background:#fef1ec linear-gradient(top,rgba(255,255,255,0.8),rgba(255,255,255,0));background:#fef1ec -webkit-gradient(linear,left top,left bottom,from(rgba(255,255,255,0.8)),to(rgba(255,255,255,0)));background:#fef1ec -moz-linear-gradient(top,rgba(255,255,255,0.8),rgba(255,255,255,0));color:#cd0a0a}.ui-state-error a,.ui-widget-content .ui-state-error a,.ui-widget-header .ui-state-error a{color:#cd0a0a}.ui-state-error-text,.ui-widget-content .ui-state-error-text,.ui-widget-header .ui-state-error-text{color:#cd0a0a}.ui-priority-primary,.ui-widget-content .ui-priority-primary,.ui-widget-header .ui-priority-primary{font-weight:bold}.ui-priority-secondary,.ui-widget-content .ui-priority-secondary,.ui-widget-header .ui-priority-secondary{opacity:.7;filter:Alpha(Opacity=70);font-weight:normal}.ui-state-disabled,.ui-widget-content .ui-state-disabled,.ui-widget-header .ui-state-disabled{opacity:.35;filter:Alpha(Opacity=35);background-image:none}.ui-icon{width:16px;height:16px;background-image:/*savepage-url=/ebok/javax.faces.resource/images/ui-icons_616161_256x240.png.xhtml?ln=primefaces-aristo*/var(--savepage-url-41)}.ui-widget-content .ui-icon{background-image:/*savepage-url=/ebok/javax.faces.resource/images/ui-icons_616161_256x240.png.xhtml?ln=primefaces-aristo*/var(--savepage-url-41)}.ui-widget-header .ui-icon{background-image:/*savepage-url=/ebok/javax.faces.resource/images/ui-icons_898989_256x240.png.xhtml?ln=primefaces-aristo*/url()}.ui-state-default .ui-icon{background-image:/*savepage-url=/ebok/javax.faces.resource/images/ui-icons_38667f_256x240.png.xhtml?ln=primefaces-aristo*/url()}.ui-state-hover .ui-icon,.ui-state-focus .ui-icon{background-image:/*savepage-url=/ebok/javax.faces.resource/images/ui-icons_38667f_256x240.png.xhtml?ln=primefaces-aristo*/url()}.ui-state-active .ui-icon{background-image:/*savepage-url=/ebok/javax.faces.resource/images/ui-icons_38667f_256x240.png.xhtml?ln=primefaces-aristo*/url()}.ui-state-highlight .ui-icon{background-image:/*savepage-url=/ebok/javax.faces.resource/images/ui-icons_2e83ff_256x240.png.xhtml?ln=primefaces-aristo*/url()}.ui-state-error .ui-icon,.ui-state-error-text .ui-icon{background-image:/*savepage-url=/ebok/javax.faces.resource/images/ui-icons_cd0a0a_256x240.png.xhtml?ln=primefaces-aristo*/url()}.ui-icon-carat-1-n{background-position:0 0}.ui-icon-carat-1-ne{background-position:-16px 0}.ui-icon-carat-1-e{background-position:-32px 0}.ui-icon-carat-1-se{background-position:-48px 0}.ui-icon-carat-1-s{background-position:-64px 0}.ui-icon-carat-1-sw{background-position:-80px 0}.ui-icon-carat-1-w{background-position:-96px 0}.ui-icon-carat-1-nw{background-position:-112px 0}.ui-icon-carat-2-n-s{background-position:-128px 0}.ui-icon-carat-2-e-w{background-position:-144px 0}.ui-icon-triangle-1-n{background-position:0 -16px}.ui-icon-triangle-1-ne{background-position:-16px -16px}.ui-icon-triangle-1-e{background-position:-32px -16px}.ui-icon-triangle-1-se{background-position:-48px -16px}.ui-icon-triangle-1-s{background-position:-64px -16px}.ui-icon-triangle-1-sw{background-position:-80px -16px}.ui-icon-triangle-1-w{background-position:-96px -16px}.ui-icon-triangle-1-nw{background-position:-112px -16px}.ui-icon-triangle-2-n-s{background-position:-128px -16px}.ui-icon-triangle-2-e-w{background-position:-144px -16px}.ui-icon-arrow-1-n{background-position:0 -32px}.ui-icon-arrow-1-ne{background-position:-16px -32px}.ui-icon-arrow-1-e{background-position:-32px -32px}.ui-icon-arrow-1-se{background-position:-48px -32px}.ui-icon-arrow-1-s{background-position:-64px -32px}.ui-icon-arrow-1-sw{background-position:-80px -32px}.ui-icon-arrow-1-w{background-position:-96px -32px}.ui-icon-arrow-1-nw{background-position:-112px -32px}.ui-icon-arrow-2-n-s{background-position:-128px -32px}.ui-icon-arrow-2-ne-sw{background-position:-144px -32px}.ui-icon-arrow-2-e-w{background-position:-160px -32px}.ui-icon-arrow-2-se-nw{background-position:-176px -32px}.ui-icon-arrowstop-1-n{background-position:-192px -32px}.ui-icon-arrowstop-1-e{background-position:-208px -32px}.ui-icon-arrowstop-1-s{background-position:-224px -32px}.ui-icon-arrowstop-1-w{background-position:-240px -32px}.ui-icon-arrowthick-1-n{background-position:0 -48px}.ui-icon-arrowthick-1-ne{background-position:-16px -48px}.ui-icon-arrowthick-1-e{background-position:-32px -48px}.ui-icon-arrowthick-1-se{background-position:-48px -48px}.ui-icon-arrowthick-1-s{background-position:-64px -48px}.ui-icon-arrowthick-1-sw{background-position:-80px -48px}.ui-icon-arrowthick-1-w{background-position:-96px -48px}.ui-icon-arrowthick-1-nw{background-position:-112px -48px}.ui-icon-arrowthick-2-n-s{background-position:-128px -48px}.ui-icon-arrowthick-2-ne-sw{background-position:-144px -48px}.ui-icon-arrowthick-2-e-w{background-position:-160px -48px}.ui-icon-arrowthick-2-se-nw{background-position:-176px -48px}.ui-icon-arrowthickstop-1-n{background-position:-192px -48px}.ui-icon-arrowthickstop-1-e{background-position:-208px -48px}.ui-icon-arrowthickstop-1-s{background-position:-224px -48px}.ui-icon-arrowthickstop-1-w{background-position:-240px -48px}.ui-icon-arrowreturnthick-1-w{background-position:0 -64px}.ui-icon-arrowreturnthick-1-n{background-position:-16px -64px}.ui-icon-arrowreturnthick-1-e{background-position:-32px -64px}.ui-icon-arrowreturnthick-1-s{background-position:-48px -64px}.ui-icon-arrowreturn-1-w{background-position:-64px -64px}.ui-icon-arrowreturn-1-n{background-position:-80px -64px}.ui-icon-arrowreturn-1-e{background-position:-96px -64px}.ui-icon-arrowreturn-1-s{background-position:-112px -64px}.ui-icon-arrowrefresh-1-w{background-position:-128px -64px}.ui-icon-arrowrefresh-1-n{background-position:-144px -64px}.ui-icon-arrowrefresh-1-e{background-position:-160px -64px}.ui-icon-arrowrefresh-1-s{background-position:-176px -64px}.ui-icon-arrow-4{background-position:0 -80px}.ui-icon-arrow-4-diag{background-position:-16px -80px}.ui-icon-extlink{background-position:-32px -80px}.ui-icon-newwin{background-position:-48px -80px}.ui-icon-refresh{background-position:-64px -80px}.ui-icon-shuffle{background-position:-80px -80px}.ui-icon-transfer-e-w{background-position:-96px -80px}.ui-icon-transferthick-e-w{background-position:-112px -80px}.ui-icon-folder-collapsed{background-position:0 -96px}.ui-icon-folder-open{background-position:-16px -96px}.ui-icon-document{background-position:-32px -96px}.ui-icon-document-b{background-position:-48px -96px}.ui-icon-note{background-position:-64px -96px}.ui-icon-mail-closed{background-position:-80px -96px}.ui-icon-mail-open{background-position:-96px -96px}.ui-icon-suitcase{background-position:-112px -96px}.ui-icon-comment{background-position:-128px -96px}.ui-icon-person{background-position:-144px -96px}.ui-icon-print{background-position:-160px -96px}.ui-icon-trash{background-position:-176px -96px}.ui-icon-locked{background-position:-192px -96px}.ui-icon-unlocked{background-position:-208px -96px}.ui-icon-bookmark{background-position:-224px -96px}.ui-icon-tag{background-position:-240px -96px}.ui-icon-home{background-position:0 -112px}.ui-icon-flag{background-position:-16px -112px}.ui-icon-calendar{background-position:-32px -112px}.ui-icon-cart{background-position:-48px -112px}.ui-icon-pencil{background-position:-64px -112px}.ui-icon-clock{background-position:-80px -112px}.ui-icon-disk{background-position:-96px -112px}.ui-icon-calculator{background-position:-112px -112px}.ui-icon-zoomin{background-position:-128px -112px}.ui-icon-zoomout{background-position:-144px -112px}.ui-icon-search{background-position:-160px -112px}.ui-icon-wrench{background-position:-176px -112px}.ui-icon-gear{background-position:-192px -112px}.ui-icon-heart{background-position:-208px -112px}.ui-icon-star{background-position:-224px -112px}.ui-icon-link{background-position:-240px -112px}.ui-icon-cancel{background-position:0 -128px}.ui-icon-plus{background-position:-16px -128px}.ui-icon-plusthick{background-position:-32px -128px}.ui-icon-minus{background-position:-48px -128px}.ui-icon-minusthick{background-position:-64px -128px}.ui-icon-close{background-position:-80px -128px}.ui-icon-closethick{background-position:-96px -128px}.ui-icon-key{background-position:-112px -128px}.ui-icon-lightbulb{background-position:-128px -128px}.ui-icon-scissors{background-position:-144px -128px}.ui-icon-clipboard{background-position:-160px -128px}.ui-icon-copy{background-position:-176px -128px}.ui-icon-contact{background-position:-192px -128px}.ui-icon-image{background-position:-208px -128px}.ui-icon-video{background-position:-224px -128px}.ui-icon-script{background-position:-240px -128px}.ui-icon-alert{background-position:0 -144px}.ui-icon-info{background-position:-16px -144px}.ui-icon-notice{background-position:-32px -144px}.ui-icon-help{background-position:-48px -144px}.ui-icon-check{background-position:-64px -144px}.ui-icon-bullet{background-position:-80px -144px}.ui-icon-radio-off{background-position:-96px -144px}.ui-icon-radio-on{background-position:-112px -144px}.ui-icon-pin-w{background-position:-128px -144px}.ui-icon-pin-s{background-position:-144px -144px}.ui-icon-play{background-position:0 -160px}.ui-icon-pause{background-position:-16px -160px}.ui-icon-seek-next{background-position:-32px -160px}.ui-icon-seek-prev{background-position:-48px -160px}.ui-icon-seek-end{background-position:-64px -160px}.ui-icon-seek-start{background-position:-80px -160px}.ui-icon-seek-first{background-position:-80px -160px}.ui-icon-stop{background-position:-96px -160px}.ui-icon-eject{background-position:-112px -160px}.ui-icon-volume-off{background-position:-128px -160px}.ui-icon-volume-on{background-position:-144px -160px}.ui-icon-power{background-position:0 -176px}.ui-icon-signal-diag{background-position:-16px -176px}.ui-icon-signal{background-position:-32px -176px}.ui-icon-battery-0{background-position:-48px -176px}.ui-icon-battery-1{background-position:-64px -176px}.ui-icon-battery-2{background-position:-80px -176px}.ui-icon-battery-3{background-position:-96px -176px}.ui-icon-circle-plus{background-position:0 -192px}.ui-icon-circle-minus{background-position:-16px -192px}.ui-icon-circle-close{background-position:-32px -192px}.ui-icon-circle-triangle-e{background-position:-48px -192px}.ui-icon-circle-triangle-s{background-position:-64px -192px}.ui-icon-circle-triangle-w{background-position:-80px -192px}.ui-icon-circle-triangle-n{background-position:-96px -192px}.ui-icon-circle-arrow-e{background-position:-112px -192px}.ui-icon-circle-arrow-s{background-position:-128px -192px}.ui-icon-circle-arrow-w{background-position:-144px -192px}.ui-icon-circle-arrow-n{background-position:-160px -192px}.ui-icon-circle-zoomin{background-position:-176px -192px}.ui-icon-circle-zoomout{background-position:-192px -192px}.ui-icon-circle-check{background-position:-208px -192px}.ui-icon-circlesmall-plus{background-position:0 -208px}.ui-icon-circlesmall-minus{background-position:-16px -208px}.ui-icon-circlesmall-close{background-position:-32px -208px}.ui-icon-squaresmall-plus{background-position:-48px -208px}.ui-icon-squaresmall-minus{background-position:-64px -208px}.ui-icon-squaresmall-close{background-position:-80px -208px}.ui-icon-grip-dotted-vertical{background-position:0 -224px}.ui-icon-grip-dotted-horizontal{background-position:-16px -224px}.ui-icon-grip-solid-vertical{background-position:-32px -224px}.ui-icon-grip-solid-horizontal{background-position:-48px -224px}.ui-icon-gripsmall-diagonal-se{background-position:-64px -224px}.ui-icon-grip-diagonal-se{background-position:-80px -224px}.ui-corner-tl{-moz-border-radius-topleft:3px;-webkit-border-top-left-radius:3px;border-top-left-radius:3px}.ui-corner-tr{-moz-border-radius-topright:3px;-webkit-border-top-right-radius:3px;border-top-right-radius:3px}.ui-corner-bl{-moz-border-radius-bottomleft:3px;-webkit-border-bottom-left-radius:3px;border-bottom-left-radius:3px}.ui-corner-br{-moz-border-radius-bottomright:3px;-webkit-border-bottom-right-radius:3px;border-bottom-right-radius:3px}.ui-corner-top{-moz-border-radius-topleft:3px;-webkit-border-top-left-radius:3px;border-top-left-radius:3px;-moz-border-radius-topright:3px;-webkit-border-top-right-radius:3px;border-top-right-radius:3px}.ui-corner-bottom{-moz-border-radius-bottomleft:3px;-webkit-border-bottom-left-radius:3px;border-bottom-left-radius:3px;-moz-border-radius-bottomright:3px;-webkit-border-bottom-right-radius:3px;border-bottom-right-radius:3px}.ui-corner-right{-moz-border-radius-topright:3px;-webkit-border-top-right-radius:3px;border-top-right-radius:3px;-moz-border-radius-bottomright:3px;-webkit-border-bottom-right-radius:3px;border-bottom-right-radius:3px}.ui-corner-left{-moz-border-radius-topleft:3px;-webkit-border-top-left-radius:3px;border-top-left-radius:3px;-moz-border-radius-bottomleft:3px;-webkit-border-bottom-left-radius:3px;border-bottom-left-radius:3px}.ui-corner-all{-moz-border-radius:3px;-webkit-border-radius:3px;border-radius:3px}.ui-round-all{-moz-border-radius:10px;-webkit-border-radius:10px;border-radius:10px}.ui-widget-overlay{background:#2d5972 /*savepage-url=/ebok/javax.faces.resource/images/ui-bg_flat_0_2d5972_40x100.png.xhtml?ln=primefaces-aristo*/ url() 50% 50% repeat-x;opacity:.30;filter:Alpha(Opacity=30)}.ui-widget-shadow{margin:-8px 0 0 -8px;padding:8px;background:#4f4f4f /*savepage-url=/ebok/javax.faces.resource/images/ui-bg_flat_0_4f4f4f_40x100.png.xhtml?ln=primefaces-aristo*/ url() 50% 50% repeat-x;opacity:.30;filter:Alpha(Opacity=30);-moz-border-radius:8px;-webkit-border-radius:8px;border-radius:8px}.ui-accordion .ui-accordion-header{margin:0;-moz-border-radius:0;-webkit-border-radius:0;border-radius:0}.ui-accordion .ui-accordion-content{margin-bottom:0}.ui-dialog .ui-dialog-titlebar{border-top:0;border-right:0;border-left:none;-moz-border-radius:0;-webkit-border-radius:0;border-radius:0}.ui-slider{-moz-border-radius:10px;-webkit-border-radius:10px;border-radius:10px;background:#cbcbcb;-moz-box-shadow:inset 0 2px 2px #8f8f8f;-webkit-box-shadow:inset 0 2px 2px #8f8f8f;box-shadow:inset 0 2px 2px #8f8f8f}.ui-slider .ui-slider-handle{-moz-border-radius:10px;-webkit-border-radius:10px;border-radius:10px}.ui-slider .ui-slider-range{background:#a3cae0;-moz-box-shadow:inset 0 2px 2px #7d9aab;-webkit-box-shadow:inset 0 2px 2px #7d9aab;box-shadow:inset 0 2px 2px #7d9aab}.ui-slider-vertical{background:#cbcbcb;-moz-box-shadow:inset 0 2px 2px #8f8f8f;-webkit-box-shadow:inset 0 2px 2px #8f8f8f;box-shadow:inset 0 2px 2px #8f8f8f}.ui-slider-vertical .ui-slider-range{background:#a3cae0;-moz-box-shadow:inset 2px 0 2px #7d9aab;-webkit-box-shadow:inset 2px 0 2px #7d9aab;box-shadow:inset 2px 0 2px #7d9aab}.ui-slider .ui-slider-handle span{height:16px!important;width:16px!important;float:none!important;margin:0 auto!important}.ui-slider .ui-slider-handle{background:#85b2cb;background:#85b2cb linear-gradient(top,rgba(255,255,255,0.8),rgba(255,255,255,0));background:#85b2cb -webkit-gradient(linear,left top,left bottom,from(rgba(255,255,255,0.8)),to(rgba(255,255,255,0)));background:#85b2cb -moz-linear-gradient(top,rgba(255,255,255,0.8),rgba(255,255,255,0))}.ui-tabs .ui-tabs-nav li{border:1px solid #a8a8a8}.ui-tabs .ui-tabs-nav li.ui-tabs-selected{border:1px solid #a8a8a8}.ui-tabs.ui-tabs-top .ui-tabs-nav li.ui-tabs-selected{border-bottom:0}.ui-tabs .ui-tabs-panel{border-width:0;padding:1em 1.4em;background:0}.ui-tabs .ui-tabs-nav{background:#e3e3e3;background:#e3e3e3 linear-gradient(top,rgba(255,255,255,0.8),rgba(255,255,255,0));background:#e3e3e3 -webkit-gradient(linear,left top,left bottom,from(rgba(255,255,255,0.8)),to(rgba(255,255,255,0)));background:#e3e3e3 -moz-linear-gradient(top,rgba(255,255,255,0.8),rgba(255,255,255,0));-moz-border-radius:0;-webkit-border-radius:0;border-radius:0}.ui-tabs .ui-tabs-nav .ui-tabs-selected{background:#fff;border-bottom:0;-moz-box-shadow:none;-webkit-box-shadow:none;box-shadow:none}.ui-datepicker .ui-datepicker-prev,.ui-datepicker .ui-datepicker-next{cursor:pointer}.ui-datepicker table{table-layout:fixed}.ui-datepicker .ui-datepicker-calendar .ui-state-default{background:0;border:0;color:#5f83b9}.ui-datepicker .ui-datepicker-calendar .ui-state-hover{color:#1c4257;-moz-box-shadow:none;-webkit-box-shadow:none;box-shadow:none}.ui-datepicker .ui-datepicker-current-day .ui-state-highlight,.ui-datepicker .ui-datepicker-current-day .ui-state-default{background:#5f83b9;color:#fff!important;font-weight:bold;text-shadow:0 1px 1px #234386;-moz-box-shadow:none;-webkit-box-shadow:none;box-shadow:none}.ui-datepicker .ui-datepicker-header{background:#e3e3e3;background:#e3e3e3 linear-gradient(top,rgba(255,255,255,0.8),rgba(255,255,255,0));background:#e3e3e3 -webkit-gradient(linear,left top,left bottom,from(rgba(255,255,255,0.8)),to(rgba(255,255,255,0)));background:#e3e3e3 -moz-linear-gradient(top,rgba(255,255,255,0.8),rgba(255,255,255,0));border-right:0;border-left:none;border-top:0;-moz-border-radius:0;-webkit-border-radius:0;border-radius:0}.ui-datepicker .ui-datepicker-next-hover,.ui-datepicker .ui-datepicker-prev-hover{background:0;border:solid 1px transparent;-moz-box-shadow:none}.ui-progressbar{-moz-border-radius:10px;-webkit-border-radius:10px;border-radius:10px}.ui-progressbar .ui-widget-header{background:#85b2cb;background:#85b2cb linear-gradient(top,rgba(255,255,255,0.8),rgba(255,255,255,0));background:#85b2cb -webkit-gradient(linear,left top,left bottom,from(rgba(255,255,255,0.8)),to(rgba(255,255,255,0)));background:#85b2cb -moz-linear-gradient(top,rgba(255,255,255,0.8),rgba(255,255,255,0));filter:progid:DXImageTransform.Microsoft.gradient(startColorstr=#DDFFFFFF,endColorstr=#00FFFFFF);-ms-filter:"progid:DXImageTransform.Microsoft.gradient(startColorstr=#DDFFFFFF, endColorstr=#00FFFFFF)";-moz-border-radius:10px;-webkit-border-radius:10px;border-radius:10px}.ui-inputfield,.ui-widget-content .ui-inputfield,.ui-widget-header .ui-inputfield{background:#fff;-moz-box-shadow:inset 0 2px 2px #8f8f8f;-webkit-box-shadow:inset 0 2px 2px #8f8f8f;box-shadow:inset 0 2px 2px #8f8f8f;color:#313131}.ui-inputfield.ui-state-focus,.ui-widget-content .ui-inputfield.ui-state-focus,.ui-widget-header .ui-inputfield.ui-state-focus{-moz-box-shadow:0 0 5px #85b2cb,inset 0 2px 2px #8f8f8f;-webkit-box-shadow:0 0 5px #85b2cb,inset 0 2px 2px #8f8f8f;box-shadow:0 0 5px #85b2cb,inset 0 2px 2px #8f8f8f}.ui-menu,.ui-menu .ui-menu-child{background:#c4c4c4 /*savepage-url=/ebok/javax.faces.resource/images/ui-bg_highlight-hard_80_c4c4c4_1x100.png.xhtml?ln=primefaces-aristo*/ url() top repeat-x;background:#c4c4c4 linear-gradient(top,rgba(255,255,255,0.8),rgba(255,255,255,0));background:#c4c4c4 -webkit-gradient(linear,left top,left bottom,from(rgba(255,255,255,0.8)),to(rgba(255,255,255,0)));background:#c4c4c4 -moz-linear-gradient(top,rgba(255,255,255,0.8),rgba(255,255,255,0))}.ui-datatable-odd{background:none repeat scroll 0 0 #f2f5f9}.aui .ui-helper-hidden{display:none}.aui .ui-helper-reset{margin:0}.aui .ui-widget-content .ui-widget a{color:#4f4f4f}.aui .ui-selectonemenu .ui-widget{font-size:1.1em}.aui .ui-selectonemenu-label .ui-inputfield{color:#313131}.aui .ui-selectonemenu-label{margin-bottom:0}.aui .ui-spinner .ui-corner-all{-moz-border-radius:3px;-webkit-border-radius:3px;border-radius:3px}.aui .ui-spinner .ui-inputfield{-moz-box-shadow:inset 0 2px 2px #8f8f8f;-webkit-box-shadow:inset 0 2px 2px #8f8f8f;box-shadow:inset 0 2px 2px #8f8f8f;color:#313131;margin:0;padding:4px;font-weight:normal}.aui .ui-spinner .ui-spinner-input{vertical-align:middle;padding-right:20px}.aui .ui-widget input{font-size:1em}.aui .ui-spinner .ui-inputfield.ui-state-focus{-moz-box-shadow:0 0 5px #85b2cb,inset 0 2px 2px #8f8f8f;-webkit-box-shadow:0 0 5px #85b2cb,inset 0 2px 2px #8f8f8f;box-shadow:0 0 5px #85b2cb,inset 0 2px 2px #8f8f8f}.aui .ui-tabs .ui-state-default a{color:#4f4f4f}.aui .jcrop-holder img{max-width:none}.ui-inputgroup .ui-inputgroup-addon,.ui-inputgroup .ui-inputgroup-addon-checkbox{border-color:#a8a8a8;background-color:#f0f0f0;color:#4f4f4f}.ui-inputgroup .ui-inputgroup-addon:first-child,.ui-inputgroup .ui-inputgroup-addon-checkbox:first-child{border-top-left-radius:3px;border-bottom-left-radius:3px}.ui-inputgroup .ui-inputgroup-addon:last-child,.ui-inputgroup .ui-inputgroup-addon-checkbox:last-child{border-top-right-radius:3px;border-bottom-right-radius:3px}.ui-inputgroup .ui-button:first-child{border-top-left-radius:3px;border-bottom-left-radius:3px}.ui-inputgroup .ui-button:last-child,.ui-inputgroup .ui-autocomplete:last-child .ui-button.ui-autocomplete-dropdown,.ui-inputgroup .ui-spinner:last-child .ui-spinner-button{border-top-right-radius:3px;border-bottom-right-radius:3px}.ui-tooltip .ui-tooltip-text.ui-state-error{border:0 none;background-color:#f2dede;color:#cd0a0a}.ui-tooltip .ui-tooltip-arrow.ui-state-error{background:0;border-right-color:#cd0a0a}</style><style data-savepage-href="/ebok/javax.faces.resource/fa/font-awesome.css.xhtml?ln=primefaces&amp;v=7.0" type="text/css">/*!
 *  Font Awesome 4.7.0 by @davegandy - http://fontawesome.io - @fontawesome
 *  License - http://fontawesome.io/license (Font: SIL OFL 1.1, CSS: MIT License)
 */@font-face{font-family:'FontAwesome';/*savepage-font-display=auto*/src:/*savepage-url=/ebok/javax.faces.resource/fa/fontawesome-webfont.eot.xhtml?ln=primefaces&v=7.0?v=4.7.0*/url();src:/*savepage-url=/ebok/javax.faces.resource/fa/fontawesome-webfont.eot.xhtml?ln=primefaces&v=7.0&#iefix&v=4.7.0*/url() format('embedded-opentype'),/*savepage-url=/ebok/javax.faces.resource/fa/fontawesome-webfont.woff2.xhtml?ln=primefaces&v=7.0?v=4.7.0*/url() format('woff2'),/*savepage-url=/ebok/javax.faces.resource/fa/fontawesome-webfont.woff.xhtml?ln=primefaces&v=7.0?v=4.7.0*/url() format('woff'),/*savepage-url=/ebok/javax.faces.resource/fa/fontawesome-webfont.ttf.xhtml?ln=primefaces&v=7.0?v=4.7.0*/url() format('truetype'),/*savepage-url=/ebok/javax.faces.resource/fa/fontawesome-webfont.svg.xhtml?ln=primefaces&v=7.0?v=4.7.0#fontawesomeregular*/url() format('svg');font-weight:normal;font-style:normal}.fa{display:inline-block;font:normal normal normal 14px/1 FontAwesome;font-size:inherit;text-rendering:auto;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale}.fa-lg{font-size:1.33333333em;line-height:.75em;vertical-align:-15%}.fa-2x{font-size:2em}.fa-3x{font-size:3em}.fa-4x{font-size:4em}.fa-5x{font-size:5em}.fa-fw{width:1.28571429em;text-align:center}.fa-ul{padding-left:0;margin-left:2.14285714em;list-style-type:none}.fa-ul>li{position:relative}.fa-li{position:absolute;left:-2.14285714em;width:2.14285714em;top:.14285714em;text-align:center}.fa-li.fa-lg{left:-1.85714286em}.fa-border{padding:.2em .25em .15em;border:solid .08em #eee;border-radius:.1em}.fa-pull-left{float:left}.fa-pull-right{float:right}.fa.fa-pull-left{margin-right:.3em}.fa.fa-pull-right{margin-left:.3em}.pull-right{float:right}.pull-left{float:left}.fa.pull-left{margin-right:.3em}.fa.pull-right{margin-left:.3em}.fa-spin{-webkit-animation:fa-spin 2s infinite linear;animation:fa-spin 2s infinite linear}.fa-pulse{-webkit-animation:fa-spin 1s infinite steps(8);animation:fa-spin 1s infinite steps(8)}@-webkit-keyframes fa-spin{0%{-webkit-transform:rotate(0deg);transform:rotate(0deg)}100%{-webkit-transform:rotate(359deg);transform:rotate(359deg)}}@keyframes fa-spin{0%{-webkit-transform:rotate(0deg);transform:rotate(0deg)}100%{-webkit-transform:rotate(359deg);transform:rotate(359deg)}}.fa-rotate-90{-ms-filter:"progid:DXImageTransform.Microsoft.BasicImage(rotation=1)";-webkit-transform:rotate(90deg);-ms-transform:rotate(90deg);transform:rotate(90deg)}.fa-rotate-180{-ms-filter:"progid:DXImageTransform.Microsoft.BasicImage(rotation=2)";-webkit-transform:rotate(180deg);-ms-transform:rotate(180deg);transform:rotate(180deg)}.fa-rotate-270{-ms-filter:"progid:DXImageTransform.Microsoft.BasicImage(rotation=3)";-webkit-transform:rotate(270deg);-ms-transform:rotate(270deg);transform:rotate(270deg)}.fa-flip-horizontal{-ms-filter:"progid:DXImageTransform.Microsoft.BasicImage(rotation=0, mirror=1)";-webkit-transform:scale(-1,1);-ms-transform:scale(-1,1);transform:scale(-1,1)}.fa-flip-vertical{-ms-filter:"progid:DXImageTransform.Microsoft.BasicImage(rotation=2, mirror=1)";-webkit-transform:scale(1,-1);-ms-transform:scale(1,-1);transform:scale(1,-1)}:root .fa-rotate-90,:root .fa-rotate-180,:root .fa-rotate-270,:root .fa-flip-horizontal,:root .fa-flip-vertical{filter:none}.fa-stack{position:relative;display:inline-block;width:2em;height:2em;line-height:2em;vertical-align:middle}.fa-stack-1x,.fa-stack-2x{position:absolute;left:0;width:100%;text-align:center}.fa-stack-1x{line-height:inherit}.fa-stack-2x{font-size:2em}.fa-inverse{color:#fff}.fa-glass:before{content:"\f000"}.fa-music:before{content:"\f001"}.fa-search:before{content:"\f002"}.fa-envelope-o:before{content:"\f003"}.fa-heart:before{content:"\f004"}.fa-star:before{content:"\f005"}.fa-star-o:before{content:"\f006"}.fa-user:before{content:"\f007"}.fa-film:before{content:"\f008"}.fa-th-large:before{content:"\f009"}.fa-th:before{content:"\f00a"}.fa-th-list:before{content:"\f00b"}.fa-check:before{content:"\f00c"}.fa-remove:before,.fa-close:before,.fa-times:before{content:"\f00d"}.fa-search-plus:before{content:"\f00e"}.fa-search-minus:before{content:"\f010"}.fa-power-off:before{content:"\f011"}.fa-signal:before{content:"\f012"}.fa-gear:before,.fa-cog:before{content:"\f013"}.fa-trash-o:before{content:"\f014"}.fa-home:before{content:"\f015"}.fa-file-o:before{content:"\f016"}.fa-clock-o:before{content:"\f017"}.fa-road:before{content:"\f018"}.fa-download:before{content:"\f019"}.fa-arrow-circle-o-down:before{content:"\f01a"}.fa-arrow-circle-o-up:before{content:"\f01b"}.fa-inbox:before{content:"\f01c"}.fa-play-circle-o:before{content:"\f01d"}.fa-rotate-right:before,.fa-repeat:before{content:"\f01e"}.fa-refresh:before{content:"\f021"}.fa-list-alt:before{content:"\f022"}.fa-lock:before{content:"\f023"}.fa-flag:before{content:"\f024"}.fa-headphones:before{content:"\f025"}.fa-volume-off:before{content:"\f026"}.fa-volume-down:before{content:"\f027"}.fa-volume-up:before{content:"\f028"}.fa-qrcode:before{content:"\f029"}.fa-barcode:before{content:"\f02a"}.fa-tag:before{content:"\f02b"}.fa-tags:before{content:"\f02c"}.fa-book:before{content:"\f02d"}.fa-bookmark:before{content:"\f02e"}.fa-print:before{content:"\f02f"}.fa-camera:before{content:"\f030"}.fa-font:before{content:"\f031"}.fa-bold:before{content:"\f032"}.fa-italic:before{content:"\f033"}.fa-text-height:before{content:"\f034"}.fa-text-width:before{content:"\f035"}.fa-align-left:before{content:"\f036"}.fa-align-center:before{content:"\f037"}.fa-align-right:before{content:"\f038"}.fa-align-justify:before{content:"\f039"}.fa-list:before{content:"\f03a"}.fa-dedent:before,.fa-outdent:before{content:"\f03b"}.fa-indent:before{content:"\f03c"}.fa-video-camera:before{content:"\f03d"}.fa-photo:before,.fa-image:before,.fa-picture-o:before{content:"\f03e"}.fa-pencil:before{content:"\f040"}.fa-map-marker:before{content:"\f041"}.fa-adjust:before{content:"\f042"}.fa-tint:before{content:"\f043"}.fa-edit:before,.fa-pencil-square-o:before{content:"\f044"}.fa-share-square-o:before{content:"\f045"}.fa-check-square-o:before{content:"\f046"}.fa-arrows:before{content:"\f047"}.fa-step-backward:before{content:"\f048"}.fa-fast-backward:before{content:"\f049"}.fa-backward:before{content:"\f04a"}.fa-play:before{content:"\f04b"}.fa-pause:before{content:"\f04c"}.fa-stop:before{content:"\f04d"}.fa-forward:before{content:"\f04e"}.fa-fast-forward:before{content:"\f050"}.fa-step-forward:before{content:"\f051"}.fa-eject:before{content:"\f052"}.fa-chevron-left:before{content:"\f053"}.fa-chevron-right:before{content:"\f054"}.fa-plus-circle:before{content:"\f055"}.fa-minus-circle:before{content:"\f056"}.fa-times-circle:before{content:"\f057"}.fa-check-circle:before{content:"\f058"}.fa-question-circle:before{content:"\f059"}.fa-info-circle:before{content:"\f05a"}.fa-crosshairs:before{content:"\f05b"}.fa-times-circle-o:before{content:"\f05c"}.fa-check-circle-o:before{content:"\f05d"}.fa-ban:before{content:"\f05e"}.fa-arrow-left:before{content:"\f060"}.fa-arrow-right:before{content:"\f061"}.fa-arrow-up:before{content:"\f062"}.fa-arrow-down:before{content:"\f063"}.fa-mail-forward:before,.fa-share:before{content:"\f064"}.fa-expand:before{content:"\f065"}.fa-compress:before{content:"\f066"}.fa-plus:before{content:"\f067"}.fa-minus:before{content:"\f068"}.fa-asterisk:before{content:"\f069"}.fa-exclamation-circle:before{content:"\f06a"}.fa-gift:before{content:"\f06b"}.fa-leaf:before{content:"\f06c"}.fa-fire:before{content:"\f06d"}.fa-eye:before{content:"\f06e"}.fa-eye-slash:before{content:"\f070"}.fa-warning:before,.fa-exclamation-triangle:before{content:"\f071"}.fa-plane:before{content:"\f072"}.fa-calendar:before{content:"\f073"}.fa-random:before{content:"\f074"}.fa-comment:before{content:"\f075"}.fa-magnet:before{content:"\f076"}.fa-chevron-up:before{content:"\f077"}.fa-chevron-down:before{content:"\f078"}.fa-retweet:before{content:"\f079"}.fa-shopping-cart:before{content:"\f07a"}.fa-folder:before{content:"\f07b"}.fa-folder-open:before{content:"\f07c"}.fa-arrows-v:before{content:"\f07d"}.fa-arrows-h:before{content:"\f07e"}.fa-bar-chart-o:before,.fa-bar-chart:before{content:"\f080"}.fa-twitter-square:before{content:"\f081"}.fa-facebook-square:before{content:"\f082"}.fa-camera-retro:before{content:"\f083"}.fa-key:before{content:"\f084"}.fa-gears:before,.fa-cogs:before{content:"\f085"}.fa-comments:before{content:"\f086"}.fa-thumbs-o-up:before{content:"\f087"}.fa-thumbs-o-down:before{content:"\f088"}.fa-star-half:before{content:"\f089"}.fa-heart-o:before{content:"\f08a"}.fa-sign-out:before{content:"\f08b"}.fa-linkedin-square:before{content:"\f08c"}.fa-thumb-tack:before{content:"\f08d"}.fa-external-link:before{content:"\f08e"}.fa-sign-in:before{content:"\f090"}.fa-trophy:before{content:"\f091"}.fa-github-square:before{content:"\f092"}.fa-upload:before{content:"\f093"}.fa-lemon-o:before{content:"\f094"}.fa-phone:before{content:"\f095"}.fa-square-o:before{content:"\f096"}.fa-bookmark-o:before{content:"\f097"}.fa-phone-square:before{content:"\f098"}.fa-twitter:before{content:"\f099"}.fa-facebook-f:before,.fa-facebook:before{content:"\f09a"}.fa-github:before{content:"\f09b"}.fa-unlock:before{content:"\f09c"}.fa-credit-card:before{content:"\f09d"}.fa-feed:before,.fa-rss:before{content:"\f09e"}.fa-hdd-o:before{content:"\f0a0"}.fa-bullhorn:before{content:"\f0a1"}.fa-bell:before{content:"\f0f3"}.fa-certificate:before{content:"\f0a3"}.fa-hand-o-right:before{content:"\f0a4"}.fa-hand-o-left:before{content:"\f0a5"}.fa-hand-o-up:before{content:"\f0a6"}.fa-hand-o-down:before{content:"\f0a7"}.fa-arrow-circle-left:before{content:"\f0a8"}.fa-arrow-circle-right:before{content:"\f0a9"}.fa-arrow-circle-up:before{content:"\f0aa"}.fa-arrow-circle-down:before{content:"\f0ab"}.fa-globe:before{content:"\f0ac"}.fa-wrench:before{content:"\f0ad"}.fa-tasks:before{content:"\f0ae"}.fa-filter:before{content:"\f0b0"}.fa-briefcase:before{content:"\f0b1"}.fa-arrows-alt:before{content:"\f0b2"}.fa-group:before,.fa-users:before{content:"\f0c0"}.fa-chain:before,.fa-link:before{content:"\f0c1"}.fa-cloud:before{content:"\f0c2"}.fa-flask:before{content:"\f0c3"}.fa-cut:before,.fa-scissors:before{content:"\f0c4"}.fa-copy:before,.fa-files-o:before{content:"\f0c5"}.fa-paperclip:before{content:"\f0c6"}.fa-save:before,.fa-floppy-o:before{content:"\f0c7"}.fa-square:before{content:"\f0c8"}.fa-navicon:before,.fa-reorder:before,.fa-bars:before{content:"\f0c9"}.fa-list-ul:before{content:"\f0ca"}.fa-list-ol:before{content:"\f0cb"}.fa-strikethrough:before{content:"\f0cc"}.fa-underline:before{content:"\f0cd"}.fa-table:before{content:"\f0ce"}.fa-magic:before{content:"\f0d0"}.fa-truck:before{content:"\f0d1"}.fa-pinterest:before{content:"\f0d2"}.fa-pinterest-square:before{content:"\f0d3"}.fa-google-plus-square:before{content:"\f0d4"}.fa-google-plus:before{content:"\f0d5"}.fa-money:before{content:"\f0d6"}.fa-caret-down:before{content:"\f0d7"}.fa-caret-up:before{content:"\f0d8"}.fa-caret-left:before{content:"\f0d9"}.fa-caret-right:before{content:"\f0da"}.fa-columns:before{content:"\f0db"}.fa-unsorted:before,.fa-sort:before{content:"\f0dc"}.fa-sort-down:before,.fa-sort-desc:before{content:"\f0dd"}.fa-sort-up:before,.fa-sort-asc:before{content:"\f0de"}.fa-envelope:before{content:"\f0e0"}.fa-linkedin:before{content:"\f0e1"}.fa-rotate-left:before,.fa-undo:before{content:"\f0e2"}.fa-legal:before,.fa-gavel:before{content:"\f0e3"}.fa-dashboard:before,.fa-tachometer:before{content:"\f0e4"}.fa-comment-o:before{content:"\f0e5"}.fa-comments-o:before{content:"\f0e6"}.fa-flash:before,.fa-bolt:before{content:"\f0e7"}.fa-sitemap:before{content:"\f0e8"}.fa-umbrella:before{content:"\f0e9"}.fa-paste:before,.fa-clipboard:before{content:"\f0ea"}.fa-lightbulb-o:before{content:"\f0eb"}.fa-exchange:before{content:"\f0ec"}.fa-cloud-download:before{content:"\f0ed"}.fa-cloud-upload:before{content:"\f0ee"}.fa-user-md:before{content:"\f0f0"}.fa-stethoscope:before{content:"\f0f1"}.fa-suitcase:before{content:"\f0f2"}.fa-bell-o:before{content:"\f0a2"}.fa-coffee:before{content:"\f0f4"}.fa-cutlery:before{content:"\f0f5"}.fa-file-text-o:before{content:"\f0f6"}.fa-building-o:before{content:"\f0f7"}.fa-hospital-o:before{content:"\f0f8"}.fa-ambulance:before{content:"\f0f9"}.fa-medkit:before{content:"\f0fa"}.fa-fighter-jet:before{content:"\f0fb"}.fa-beer:before{content:"\f0fc"}.fa-h-square:before{content:"\f0fd"}.fa-plus-square:before{content:"\f0fe"}.fa-angle-double-left:before{content:"\f100"}.fa-angle-double-right:before{content:"\f101"}.fa-angle-double-up:before{content:"\f102"}.fa-angle-double-down:before{content:"\f103"}.fa-angle-left:before{content:"\f104"}.fa-angle-right:before{content:"\f105"}.fa-angle-up:before{content:"\f106"}.fa-angle-down:before{content:"\f107"}.fa-desktop:before{content:"\f108"}.fa-laptop:before{content:"\f109"}.fa-tablet:before{content:"\f10a"}.fa-mobile-phone:before,.fa-mobile:before{content:"\f10b"}.fa-circle-o:before{content:"\f10c"}.fa-quote-left:before{content:"\f10d"}.fa-quote-right:before{content:"\f10e"}.fa-spinner:before{content:"\f110"}.fa-circle:before{content:"\f111"}.fa-mail-reply:before,.fa-reply:before{content:"\f112"}.fa-github-alt:before{content:"\f113"}.fa-folder-o:before{content:"\f114"}.fa-folder-open-o:before{content:"\f115"}.fa-smile-o:before{content:"\f118"}.fa-frown-o:before{content:"\f119"}.fa-meh-o:before{content:"\f11a"}.fa-gamepad:before{content:"\f11b"}.fa-keyboard-o:before{content:"\f11c"}.fa-flag-o:before{content:"\f11d"}.fa-flag-checkered:before{content:"\f11e"}.fa-terminal:before{content:"\f120"}.fa-code:before{content:"\f121"}.fa-mail-reply-all:before,.fa-reply-all:before{content:"\f122"}.fa-star-half-empty:before,.fa-star-half-full:before,.fa-star-half-o:before{content:"\f123"}.fa-location-arrow:before{content:"\f124"}.fa-crop:before{content:"\f125"}.fa-code-fork:before{content:"\f126"}.fa-unlink:before,.fa-chain-broken:before{content:"\f127"}.fa-question:before{content:"\f128"}.fa-info:before{content:"\f129"}.fa-exclamation:before{content:"\f12a"}.fa-superscript:before{content:"\f12b"}.fa-subscript:before{content:"\f12c"}.fa-eraser:before{content:"\f12d"}.fa-puzzle-piece:before{content:"\f12e"}.fa-microphone:before{content:"\f130"}.fa-microphone-slash:before{content:"\f131"}.fa-shield:before{content:"\f132"}.fa-calendar-o:before{content:"\f133"}.fa-fire-extinguisher:before{content:"\f134"}.fa-rocket:before{content:"\f135"}.fa-maxcdn:before{content:"\f136"}.fa-chevron-circle-left:before{content:"\f137"}.fa-chevron-circle-right:before{content:"\f138"}.fa-chevron-circle-up:before{content:"\f139"}.fa-chevron-circle-down:before{content:"\f13a"}.fa-html5:before{content:"\f13b"}.fa-css3:before{content:"\f13c"}.fa-anchor:before{content:"\f13d"}.fa-unlock-alt:before{content:"\f13e"}.fa-bullseye:before{content:"\f140"}.fa-ellipsis-h:before{content:"\f141"}.fa-ellipsis-v:before{content:"\f142"}.fa-rss-square:before{content:"\f143"}.fa-play-circle:before{content:"\f144"}.fa-ticket:before{content:"\f145"}.fa-minus-square:before{content:"\f146"}.fa-minus-square-o:before{content:"\f147"}.fa-level-up:before{content:"\f148"}.fa-level-down:before{content:"\f149"}.fa-check-square:before{content:"\f14a"}.fa-pencil-square:before{content:"\f14b"}.fa-external-link-square:before{content:"\f14c"}.fa-share-square:before{content:"\f14d"}.fa-compass:before{content:"\f14e"}.fa-toggle-down:before,.fa-caret-square-o-down:before{content:"\f150"}.fa-toggle-up:before,.fa-caret-square-o-up:before{content:"\f151"}.fa-toggle-right:before,.fa-caret-square-o-right:before{content:"\f152"}.fa-euro:before,.fa-eur:before{content:"\f153"}.fa-gbp:before{content:"\f154"}.fa-dollar:before,.fa-usd:before{content:"\f155"}.fa-rupee:before,.fa-inr:before{content:"\f156"}.fa-cny:before,.fa-rmb:before,.fa-yen:before,.fa-jpy:before{content:"\f157"}.fa-ruble:before,.fa-rouble:before,.fa-rub:before{content:"\f158"}.fa-won:before,.fa-krw:before{content:"\f159"}.fa-bitcoin:before,.fa-btc:before{content:"\f15a"}.fa-file:before{content:"\f15b"}.fa-file-text:before{content:"\f15c"}.fa-sort-alpha-asc:before{content:"\f15d"}.fa-sort-alpha-desc:before{content:"\f15e"}.fa-sort-amount-asc:before{content:"\f160"}.fa-sort-amount-desc:before{content:"\f161"}.fa-sort-numeric-asc:before{content:"\f162"}.fa-sort-numeric-desc:before{content:"\f163"}.fa-thumbs-up:before{content:"\f164"}.fa-thumbs-down:before{content:"\f165"}.fa-youtube-square:before{content:"\f166"}.fa-youtube:before{content:"\f167"}.fa-xing:before{content:"\f168"}.fa-xing-square:before{content:"\f169"}.fa-youtube-play:before{content:"\f16a"}.fa-dropbox:before{content:"\f16b"}.fa-stack-overflow:before{content:"\f16c"}.fa-instagram:before{content:"\f16d"}.fa-flickr:before{content:"\f16e"}.fa-adn:before{content:"\f170"}.fa-bitbucket:before{content:"\f171"}.fa-bitbucket-square:before{content:"\f172"}.fa-tumblr:before{content:"\f173"}.fa-tumblr-square:before{content:"\f174"}.fa-long-arrow-down:before{content:"\f175"}.fa-long-arrow-up:before{content:"\f176"}.fa-long-arrow-left:before{content:"\f177"}.fa-long-arrow-right:before{content:"\f178"}.fa-apple:before{content:"\f179"}.fa-windows:before{content:"\f17a"}.fa-android:before{content:"\f17b"}.fa-linux:before{content:"\f17c"}.fa-dribbble:before{content:"\f17d"}.fa-skype:before{content:"\f17e"}.fa-foursquare:before{content:"\f180"}.fa-trello:before{content:"\f181"}.fa-female:before{content:"\f182"}.fa-male:before{content:"\f183"}.fa-gittip:before,.fa-gratipay:before{content:"\f184"}.fa-sun-o:before{content:"\f185"}.fa-moon-o:before{content:"\f186"}.fa-archive:before{content:"\f187"}.fa-bug:before{content:"\f188"}.fa-vk:before{content:"\f189"}.fa-weibo:before{content:"\f18a"}.fa-renren:before{content:"\f18b"}.fa-pagelines:before{content:"\f18c"}.fa-stack-exchange:before{content:"\f18d"}.fa-arrow-circle-o-right:before{content:"\f18e"}.fa-arrow-circle-o-left:before{content:"\f190"}.fa-toggle-left:before,.fa-caret-square-o-left:before{content:"\f191"}.fa-dot-circle-o:before{content:"\f192"}.fa-wheelchair:before{content:"\f193"}.fa-vimeo-square:before{content:"\f194"}.fa-turkish-lira:before,.fa-try:before{content:"\f195"}.fa-plus-square-o:before{content:"\f196"}.fa-space-shuttle:before{content:"\f197"}.fa-slack:before{content:"\f198"}.fa-envelope-square:before{content:"\f199"}.fa-wordpress:before{content:"\f19a"}.fa-openid:before{content:"\f19b"}.fa-institution:before,.fa-bank:before,.fa-university:before{content:"\f19c"}.fa-mortar-board:before,.fa-graduation-cap:before{content:"\f19d"}.fa-yahoo:before{content:"\f19e"}.fa-google:before{content:"\f1a0"}.fa-reddit:before{content:"\f1a1"}.fa-reddit-square:before{content:"\f1a2"}.fa-stumbleupon-circle:before{content:"\f1a3"}.fa-stumbleupon:before{content:"\f1a4"}.fa-delicious:before{content:"\f1a5"}.fa-digg:before{content:"\f1a6"}.fa-pied-piper-pp:before{content:"\f1a7"}.fa-pied-piper-alt:before{content:"\f1a8"}.fa-drupal:before{content:"\f1a9"}.fa-joomla:before{content:"\f1aa"}.fa-language:before{content:"\f1ab"}.fa-fax:before{content:"\f1ac"}.fa-building:before{content:"\f1ad"}.fa-child:before{content:"\f1ae"}.fa-paw:before{content:"\f1b0"}.fa-spoon:before{content:"\f1b1"}.fa-cube:before{content:"\f1b2"}.fa-cubes:before{content:"\f1b3"}.fa-behance:before{content:"\f1b4"}.fa-behance-square:before{content:"\f1b5"}.fa-steam:before{content:"\f1b6"}.fa-steam-square:before{content:"\f1b7"}.fa-recycle:before{content:"\f1b8"}.fa-automobile:before,.fa-car:before{content:"\f1b9"}.fa-cab:before,.fa-taxi:before{content:"\f1ba"}.fa-tree:before{content:"\f1bb"}.fa-spotify:before{content:"\f1bc"}.fa-deviantart:before{content:"\f1bd"}.fa-soundcloud:before{content:"\f1be"}.fa-database:before{content:"\f1c0"}.fa-file-pdf-o:before{content:"\f1c1"}.fa-file-word-o:before{content:"\f1c2"}.fa-file-excel-o:before{content:"\f1c3"}.fa-file-powerpoint-o:before{content:"\f1c4"}.fa-file-photo-o:before,.fa-file-picture-o:before,.fa-file-image-o:before{content:"\f1c5"}.fa-file-zip-o:before,.fa-file-archive-o:before{content:"\f1c6"}.fa-file-sound-o:before,.fa-file-audio-o:before{content:"\f1c7"}.fa-file-movie-o:before,.fa-file-video-o:before{content:"\f1c8"}.fa-file-code-o:before{content:"\f1c9"}.fa-vine:before{content:"\f1ca"}.fa-codepen:before{content:"\f1cb"}.fa-jsfiddle:before{content:"\f1cc"}.fa-life-bouy:before,.fa-life-buoy:before,.fa-life-saver:before,.fa-support:before,.fa-life-ring:before{content:"\f1cd"}.fa-circle-o-notch:before{content:"\f1ce"}.fa-ra:before,.fa-resistance:before,.fa-rebel:before{content:"\f1d0"}.fa-ge:before,.fa-empire:before{content:"\f1d1"}.fa-git-square:before{content:"\f1d2"}.fa-git:before{content:"\f1d3"}.fa-y-combinator-square:before,.fa-yc-square:before,.fa-hacker-news:before{content:"\f1d4"}.fa-tencent-weibo:before{content:"\f1d5"}.fa-qq:before{content:"\f1d6"}.fa-wechat:before,.fa-weixin:before{content:"\f1d7"}.fa-send:before,.fa-paper-plane:before{content:"\f1d8"}.fa-send-o:before,.fa-paper-plane-o:before{content:"\f1d9"}.fa-history:before{content:"\f1da"}.fa-circle-thin:before{content:"\f1db"}.fa-header:before{content:"\f1dc"}.fa-paragraph:before{content:"\f1dd"}.fa-sliders:before{content:"\f1de"}.fa-share-alt:before{content:"\f1e0"}.fa-share-alt-square:before{content:"\f1e1"}.fa-bomb:before{content:"\f1e2"}.fa-soccer-ball-o:before,.fa-futbol-o:before{content:"\f1e3"}.fa-tty:before{content:"\f1e4"}.fa-binoculars:before{content:"\f1e5"}.fa-plug:before{content:"\f1e6"}.fa-slideshare:before{content:"\f1e7"}.fa-twitch:before{content:"\f1e8"}.fa-yelp:before{content:"\f1e9"}.fa-newspaper-o:before{content:"\f1ea"}.fa-wifi:before{content:"\f1eb"}.fa-calculator:before{content:"\f1ec"}.fa-paypal:before{content:"\f1ed"}.fa-google-wallet:before{content:"\f1ee"}.fa-cc-visa:before{content:"\f1f0"}.fa-cc-mastercard:before{content:"\f1f1"}.fa-cc-discover:before{content:"\f1f2"}.fa-cc-amex:before{content:"\f1f3"}.fa-cc-paypal:before{content:"\f1f4"}.fa-cc-stripe:before{content:"\f1f5"}.fa-bell-slash:before{content:"\f1f6"}.fa-bell-slash-o:before{content:"\f1f7"}.fa-trash:before{content:"\f1f8"}.fa-copyright:before{content:"\f1f9"}.fa-at:before{content:"\f1fa"}.fa-eyedropper:before{content:"\f1fb"}.fa-paint-brush:before{content:"\f1fc"}.fa-birthday-cake:before{content:"\f1fd"}.fa-area-chart:before{content:"\f1fe"}.fa-pie-chart:before{content:"\f200"}.fa-line-chart:before{content:"\f201"}.fa-lastfm:before{content:"\f202"}.fa-lastfm-square:before{content:"\f203"}.fa-toggle-off:before{content:"\f204"}.fa-toggle-on:before{content:"\f205"}.fa-bicycle:before{content:"\f206"}.fa-bus:before{content:"\f207"}.fa-ioxhost:before{content:"\f208"}.fa-angellist:before{content:"\f209"}.fa-cc:before{content:"\f20a"}.fa-shekel:before,.fa-sheqel:before,.fa-ils:before{content:"\f20b"}.fa-meanpath:before{content:"\f20c"}.fa-buysellads:before{content:"\f20d"}.fa-connectdevelop:before{content:"\f20e"}.fa-dashcube:before{content:"\f210"}.fa-forumbee:before{content:"\f211"}.fa-leanpub:before{content:"\f212"}.fa-sellsy:before{content:"\f213"}.fa-shirtsinbulk:before{content:"\f214"}.fa-simplybuilt:before{content:"\f215"}.fa-skyatlas:before{content:"\f216"}.fa-cart-plus:before{content:"\f217"}.fa-cart-arrow-down:before{content:"\f218"}.fa-diamond:before{content:"\f219"}.fa-ship:before{content:"\f21a"}.fa-user-secret:before{content:"\f21b"}.fa-motorcycle:before{content:"\f21c"}.fa-street-view:before{content:"\f21d"}.fa-heartbeat:before{content:"\f21e"}.fa-venus:before{content:"\f221"}.fa-mars:before{content:"\f222"}.fa-mercury:before{content:"\f223"}.fa-intersex:before,.fa-transgender:before{content:"\f224"}.fa-transgender-alt:before{content:"\f225"}.fa-venus-double:before{content:"\f226"}.fa-mars-double:before{content:"\f227"}.fa-venus-mars:before{content:"\f228"}.fa-mars-stroke:before{content:"\f229"}.fa-mars-stroke-v:before{content:"\f22a"}.fa-mars-stroke-h:before{content:"\f22b"}.fa-neuter:before{content:"\f22c"}.fa-genderless:before{content:"\f22d"}.fa-facebook-official:before{content:"\f230"}.fa-pinterest-p:before{content:"\f231"}.fa-whatsapp:before{content:"\f232"}.fa-server:before{content:"\f233"}.fa-user-plus:before{content:"\f234"}.fa-user-times:before{content:"\f235"}.fa-hotel:before,.fa-bed:before{content:"\f236"}.fa-viacoin:before{content:"\f237"}.fa-train:before{content:"\f238"}.fa-subway:before{content:"\f239"}.fa-medium:before{content:"\f23a"}.fa-yc:before,.fa-y-combinator:before{content:"\f23b"}.fa-optin-monster:before{content:"\f23c"}.fa-opencart:before{content:"\f23d"}.fa-expeditedssl:before{content:"\f23e"}.fa-battery-4:before,.fa-battery:before,.fa-battery-full:before{content:"\f240"}.fa-battery-3:before,.fa-battery-three-quarters:before{content:"\f241"}.fa-battery-2:before,.fa-battery-half:before{content:"\f242"}.fa-battery-1:before,.fa-battery-quarter:before{content:"\f243"}.fa-battery-0:before,.fa-battery-empty:before{content:"\f244"}.fa-mouse-pointer:before{content:"\f245"}.fa-i-cursor:before{content:"\f246"}.fa-object-group:before{content:"\f247"}.fa-object-ungroup:before{content:"\f248"}.fa-sticky-note:before{content:"\f249"}.fa-sticky-note-o:before{content:"\f24a"}.fa-cc-jcb:before{content:"\f24b"}.fa-cc-diners-club:before{content:"\f24c"}.fa-clone:before{content:"\f24d"}.fa-balance-scale:before{content:"\f24e"}.fa-hourglass-o:before{content:"\f250"}.fa-hourglass-1:before,.fa-hourglass-start:before{content:"\f251"}.fa-hourglass-2:before,.fa-hourglass-half:before{content:"\f252"}.fa-hourglass-3:before,.fa-hourglass-end:before{content:"\f253"}.fa-hourglass:before{content:"\f254"}.fa-hand-grab-o:before,.fa-hand-rock-o:before{content:"\f255"}.fa-hand-stop-o:before,.fa-hand-paper-o:before{content:"\f256"}.fa-hand-scissors-o:before{content:"\f257"}.fa-hand-lizard-o:before{content:"\f258"}.fa-hand-spock-o:before{content:"\f259"}.fa-hand-pointer-o:before{content:"\f25a"}.fa-hand-peace-o:before{content:"\f25b"}.fa-trademark:before{content:"\f25c"}.fa-registered:before{content:"\f25d"}.fa-creative-commons:before{content:"\f25e"}.fa-gg:before{content:"\f260"}.fa-gg-circle:before{content:"\f261"}.fa-tripadvisor:before{content:"\f262"}.fa-odnoklassniki:before{content:"\f263"}.fa-odnoklassniki-square:before{content:"\f264"}.fa-get-pocket:before{content:"\f265"}.fa-wikipedia-w:before{content:"\f266"}.fa-safari:before{content:"\f267"}.fa-chrome:before{content:"\f268"}.fa-firefox:before{content:"\f269"}.fa-opera:before{content:"\f26a"}.fa-internet-explorer:before{content:"\f26b"}.fa-tv:before,.fa-television:before{content:"\f26c"}.fa-contao:before{content:"\f26d"}.fa-500px:before{content:"\f26e"}.fa-amazon:before{content:"\f270"}.fa-calendar-plus-o:before{content:"\f271"}.fa-calendar-minus-o:before{content:"\f272"}.fa-calendar-times-o:before{content:"\f273"}.fa-calendar-check-o:before{content:"\f274"}.fa-industry:before{content:"\f275"}.fa-map-pin:before{content:"\f276"}.fa-map-signs:before{content:"\f277"}.fa-map-o:before{content:"\f278"}.fa-map:before{content:"\f279"}.fa-commenting:before{content:"\f27a"}.fa-commenting-o:before{content:"\f27b"}.fa-houzz:before{content:"\f27c"}.fa-vimeo:before{content:"\f27d"}.fa-black-tie:before{content:"\f27e"}.fa-fonticons:before{content:"\f280"}.fa-reddit-alien:before{content:"\f281"}.fa-edge:before{content:"\f282"}.fa-credit-card-alt:before{content:"\f283"}.fa-codiepie:before{content:"\f284"}.fa-modx:before{content:"\f285"}.fa-fort-awesome:before{content:"\f286"}.fa-usb:before{content:"\f287"}.fa-product-hunt:before{content:"\f288"}.fa-mixcloud:before{content:"\f289"}.fa-scribd:before{content:"\f28a"}.fa-pause-circle:before{content:"\f28b"}.fa-pause-circle-o:before{content:"\f28c"}.fa-stop-circle:before{content:"\f28d"}.fa-stop-circle-o:before{content:"\f28e"}.fa-shopping-bag:before{content:"\f290"}.fa-shopping-basket:before{content:"\f291"}.fa-hashtag:before{content:"\f292"}.fa-bluetooth:before{content:"\f293"}.fa-bluetooth-b:before{content:"\f294"}.fa-percent:before{content:"\f295"}.fa-gitlab:before{content:"\f296"}.fa-wpbeginner:before{content:"\f297"}.fa-wpforms:before{content:"\f298"}.fa-envira:before{content:"\f299"}.fa-universal-access:before{content:"\f29a"}.fa-wheelchair-alt:before{content:"\f29b"}.fa-question-circle-o:before{content:"\f29c"}.fa-blind:before{content:"\f29d"}.fa-audio-description:before{content:"\f29e"}.fa-volume-control-phone:before{content:"\f2a0"}.fa-braille:before{content:"\f2a1"}.fa-assistive-listening-systems:before{content:"\f2a2"}.fa-asl-interpreting:before,.fa-american-sign-language-interpreting:before{content:"\f2a3"}.fa-deafness:before,.fa-hard-of-hearing:before,.fa-deaf:before{content:"\f2a4"}.fa-glide:before{content:"\f2a5"}.fa-glide-g:before{content:"\f2a6"}.fa-signing:before,.fa-sign-language:before{content:"\f2a7"}.fa-low-vision:before{content:"\f2a8"}.fa-viadeo:before{content:"\f2a9"}.fa-viadeo-square:before{content:"\f2aa"}.fa-snapchat:before{content:"\f2ab"}.fa-snapchat-ghost:before{content:"\f2ac"}.fa-snapchat-square:before{content:"\f2ad"}.fa-pied-piper:before{content:"\f2ae"}.fa-first-order:before{content:"\f2b0"}.fa-yoast:before{content:"\f2b1"}.fa-themeisle:before{content:"\f2b2"}.fa-google-plus-circle:before,.fa-google-plus-official:before{content:"\f2b3"}.fa-fa:before,.fa-font-awesome:before{content:"\f2b4"}.fa-handshake-o:before{content:"\f2b5"}.fa-envelope-open:before{content:"\f2b6"}.fa-envelope-open-o:before{content:"\f2b7"}.fa-linode:before{content:"\f2b8"}.fa-address-book:before{content:"\f2b9"}.fa-address-book-o:before{content:"\f2ba"}.fa-vcard:before,.fa-address-card:before{content:"\f2bb"}.fa-vcard-o:before,.fa-address-card-o:before{content:"\f2bc"}.fa-user-circle:before{content:"\f2bd"}.fa-user-circle-o:before{content:"\f2be"}.fa-user-o:before{content:"\f2c0"}.fa-id-badge:before{content:"\f2c1"}.fa-drivers-license:before,.fa-id-card:before{content:"\f2c2"}.fa-drivers-license-o:before,.fa-id-card-o:before{content:"\f2c3"}.fa-quora:before{content:"\f2c4"}.fa-free-code-camp:before{content:"\f2c5"}.fa-telegram:before{content:"\f2c6"}.fa-thermometer-4:before,.fa-thermometer:before,.fa-thermometer-full:before{content:"\f2c7"}.fa-thermometer-3:before,.fa-thermometer-three-quarters:before{content:"\f2c8"}.fa-thermometer-2:before,.fa-thermometer-half:before{content:"\f2c9"}.fa-thermometer-1:before,.fa-thermometer-quarter:before{content:"\f2ca"}.fa-thermometer-0:before,.fa-thermometer-empty:before{content:"\f2cb"}.fa-shower:before{content:"\f2cc"}.fa-bathtub:before,.fa-s15:before,.fa-bath:before{content:"\f2cd"}.fa-podcast:before{content:"\f2ce"}.fa-window-maximize:before{content:"\f2d0"}.fa-window-minimize:before{content:"\f2d1"}.fa-window-restore:before{content:"\f2d2"}.fa-times-rectangle:before,.fa-window-close:before{content:"\f2d3"}.fa-times-rectangle-o:before,.fa-window-close-o:before{content:"\f2d4"}.fa-bandcamp:before{content:"\f2d5"}.fa-grav:before{content:"\f2d6"}.fa-etsy:before{content:"\f2d7"}.fa-imdb:before{content:"\f2d8"}.fa-ravelry:before{content:"\f2d9"}.fa-eercast:before{content:"\f2da"}.fa-microchip:before{content:"\f2db"}.fa-snowflake-o:before{content:"\f2dc"}.fa-superpowers:before{content:"\f2dd"}.fa-wpexplorer:before{content:"\f2de"}.fa-meetup:before{content:"\f2e0"}.sr-only{position:absolute;width:1px;height:1px;padding:0;margin:-1px;overflow:hidden;clip:rect(0,0,0,0);border:0}.sr-only-focusable:active,.sr-only-focusable:focus{position:static;width:auto;height:auto;margin:0;overflow:visible;clip:auto}</style><style data-savepage-href="/ebok/javax.faces.resource/templatev3.css.xhtml?ln=css" type="text/css">@CHARSET "UTF-8";

:root {
	--company-dark: #1A7466;
	--company-normal: #10a38b;
	--company-middle: #B2CF65;
	--company-light: #c1e88e;
	--company-content: #73747f;
}
*{
	font-family: Verdana, sans-serif;
}
html{
	padding: 0;
	margin: 0 auto;
}
body {
	font-family: Verdana, sans-serif;
	font-size: 12px;
	line-height: 16px;
	background-color: #fff;
	margin: 0 auto;
}

div.mainContainer {
	margin: 0 auto;
    padding-top: 25px;
    min-height: 400px;
}

#header{
	height:220px;
}
div.templateHeader {
	height: 124px;
	box-shadow: 0 1px 5px 1px rgba(0, 0, 0, 0.32);
	padding: 0px;
	margin: auto;
	background: #fff;
	position: relative;
	top: 45px;
    position: relative;
    z-index: 3;
}
div.pageContent {
	margin: 0;
	padding: 0px;
	border:0;
	border-radius: 0;
	background: transparent;
}
div.pageContent .ui-panel-content{
	padding: 0;
	margin: 0;
}
div.templateFooter {
	border-top: 50px solid #f7f7f7;
	margin: auto;
	box-sizing: border-box;
}
div.leftSideBar{
	float:left; 
	width: 180px;
	margin-right: 20px;
    border: 0 none;
    margin: 0;
    padding: 0;
    border-radius: 0;
    position: relative;
}
div.leftSideBar > div.ui-panel-content{
	padding: 0;
    border-radius: 0;
}

div.pageContent div.panel{
	box-sizing: border-box;
	box-shadow: 0 0 5px 1px rgba(0, 0, 0, 0.18);
	padding: 20px;
	border: 0;
    border-top: 8px solid var(--company-dark);
    box-shadow: 0 0 5px rgba(0, 0, 0, 0.18);
    border-radius: 0;
    vertical-align: top;
    margin-bottom: 35px;
    position: relative;
    clear: both;
}

div.pageContent div.smallPanel{
	display: inline-block;
	box-sizing: border-box;
	box-shadow: 0 0 5px 1px rgba(0, 0, 0, 0.18);
	padding: 20px 20px 10px 20px;
	border: 0;
    border-top: 8px solid var(--company-dark);
    box-shadow: 0 0 5px rgba(0, 0, 0, 0.18);
    border-radius: 0;
    vertical-align: top;
    margin-bottom: 25px;
    position: relative;
}
div.pageContent div.smallPanel.oneColumn{
	display: block;
    margin-left: auto;
    margin-right: auto;
}

div.pageContent .ui-panel .ui-panel-content,
div.pageContent .ui-panel, body .ui-panel,
body .ui-panel .ui-panel-content{
	padding: 0;
	margin: 0;
	border: 0;
	border-radius: 0;
}
div.pageContent .ui-widget-header,
body .ui-dialog .ui-widget-header,
body .ui-tabs .ui-tabs-nav{
	background: none;
	margin-bottom: 20px;
    border: 0;
    color: #000000;
    font-weight: 100;
    text-shadow: 0 1px 0 rgba(255, 255, 255, 0.7);
    font-size: 32px;
    line-height: 36px;
    padding:0;
}
div.pageContent .smallPanel.headerMargin0 .ui-widget-header,
div.pageContent .panel.headerMargin0 .ui-widget-header,
div.pageContent .ui-dialog.headerMargin0 .ui-widget-header{
	margin: 0;
}
div.pageContent .ui-panel .ui-panel-titlebar {
	padding: 0;
}

div.pageContent .ui-panel .ui-panel-title,
div.pageContent .ui-dialog .ui-dialog-title,
body .ui-dialog .ui-dialog-title{
	display: block;
	margin: 0;
	font-family: "SourceSansProLight","Source Sans Pro",Verdana,sans-serif;
	box-sizing: border-box;
    display: inline-block;
    overflow: hidden;
    padding-right: 58px;
    width: 100%;
    word-break: keep-all;
}
.admin div.pageContent .ui-panel .ui-panel-title,
.admin div.pageContent .ui-dialog .ui-dialog-title,
body.admin .ui-dialog .ui-dialog-title{
	padding: 0;
}
div.pageContent .ui-dialog .ui-dialog-title,
body .ui-dialog .ui-dialog-title{
	box-sizing: border-box;
    display: inline-block;
    overflow: hidden;
    padding-right: 95px;
    width: 90%;
    line-height: 44px;
    min-height: 40px;
}
div.pageContent div.taskPanel{
	box-sizing: border-box;
    margin: auto;
    padding: 0 0 20px;
    width: 464px;
}
div.pageContent .ui-dialog,
body .ui-dialog {
	border: 0;
	border-radius: 0;
	box-shadow: 0 0 5px rgba(0, 0, 0, 0.18);
    border-top: 8px solid var(--company-dark);
    box-sizing: border-box;
}

div.pageContent .ui-panel.h2 .ui-panel-title{
	font-size: 24px;
	font-family: "SourceSansPro","Source Sans Pro",Verdana,sans-serif;
}
div.pageContent .ui-dialog-titlebar, body .ui-dialog  .ui-dialog-titlebar{padding: 20px 20px 0 20px;}
div.pageContent .ui-dialog .ui-dialog-content,body .ui-dialog .ui-dialog-content{padding: 0 20px 20px;}
div.pageContent .ui-dialog, body .ui-dialog{max-height: 100% !important; overflow: auto !important; -webkit-overflow-scrolling: touch;}
div.pageContent .ui-dialog.fullHeight,body .ui-dialog.fullHeight{height: 100% !important; top: 0 !important; box-sizing: border-box;}
.edycja-nazwy-konta-label{
	font-size: 24px !important;
	margin-left: 15px !important;
	font-family: "SourceSansProLight","Source Sans Pro",Verdana,sans-serif !important; 
}
.edycja-nazwy-konta-input{
	margin-left: 15px !important;
	margin-right: 10px !important;
	width: 300px !important; 	
}
@media screen and (min-width: 320px) and (max-width: 479px)  {
	body.login{
		background-image: /*savepage-url=/ebok/javax.faces.resource/topimgbgW480.jpg.xhtml?ln=images*/ url();
		background-size: contain;
		background-position: center top;
		background-repeat: no-repeat;
	}
	body.logged{
		background: /*savepage-url=/ebok/javax.faces.resource/topimgbgH250W480.jpg.xhtml?ln=images*/ url() no-repeat top center #fff;
		background-size: contain;
		background-position: center top;
		background-repeat: no-repeat;
	}
	div.pageContent{
		width: 320px;
		margin: auto;
	}
	div.pageContent div.smallPanel{
		width: 320px;
	}
	div.pageContent .ui-dialog,
	body .ui-dialog{
		width: 100% !important;
		overflow: auto !important;
		-webkit-overflow-scrolling: touch;
		left: 0 !important;
		top: 0 !important;
		margin: 0;
	}
	
	div.pageContent .ui-dialog-content .ui-inputfield,
	body .ui-dialog-content .ui-inputfield{
		width: 100%
	}
	div.templateFooter div.phone,
	div.templateFooter div.phone2,
	div.templateFooter div.mail,
	div.templateFooter div.faq {
		line-height: auto;
		text-align: left;
		width: 100%;
	}
	#footer div.templateFooter div.phone:before,
	#footer div.templateFooter div.phone2:before,
	#footer div.templateFooter div.mail:before,
	#footer div.templateFooter div.faq:before{
		height: 25px;
	    margin-right: 5px;
	    vertical-align: -7px;
	    width: 25px;
	}
	div.templateFooter div.phone > label,
	div.templateFooter div.phone > a,
	div.templateFooter div.phone > form > a,
	div.templateFooter div.phone2 > label,
	div.templateFooter div.phone2 > a,
	div.templateFooter div.mail > label,
	div.templateFooter div.mail > a,
	div.templateFooter div.faq > label,
	div.templateFooter div.faq > a {
		line-height: 18px;
	}
	.phone2-label2-margin {
		margin-left: 45px !important;
	}		
	.box-icon:before, .box-icon-dynamic:before{
		display: none;
	}
	div.pageContent div.taskPanel{
		width: 100%;
	}
	.ui-button-text {
		font-size: 10px;
	}
}
@media screen and (min-width: 480px) {
	
	div.pageContent div.smallPanel,
	div.pageContent div.leftColumn,
	div.pageContent div.rightColumn{
		width: 420px;
	}
	div.pageContent.fullWidth div.smallPanel,
	div.pageContent.fullWidth div.leftColumn,
	div.pageContent.fullWidth div.rightColumn {
		width: 460px;
	}
	div.templateFooter div.phone > label,
	div.templateFooter div.phone > a,
	div.templateFooter div.phone > form > a,
	div.templateFooter div.phone2 > label,
	div.templateFooter div.phone2 > a,
	div.templateFooter div.mail > label,
	div.templateFooter div.mail > a,
	div.templateFooter div.faq > label,
	div.templateFooter div.faq > a {
		font-size: 30px !important;
		line-height: 18px;
	}
	div.templateFooter div.phone,
	div.templateFooter div.phone2,
	div.templateFooter div.mail,
	div.templateFooter div.faq {
	    height: 45px;
	    line-height: 18px;
	    width: 100%;
		text-align: left;
	}
	div.pageContent .ui-dialog,body .ui-dialog{width: 100% !important;}
}
@media screen and (min-width: 480px) and (max-width: 639px)  {
	body.login{
		background-image: /*savepage-url=/ebok/javax.faces.resource/topimgbgW640.jpg.xhtml?ln=images*/ url();
		background-size: contain;
		background-position: center top;
		background-repeat: no-repeat;
	}
	body.logged{
		background: /*savepage-url=/ebok/javax.faces.resource/topimgbgH250W640.jpg.xhtml?ln=images*/ url() no-repeat top center #fff;
		background-size: contain;
		background-position: center top;
		background-repeat: no-repeat;
	}
	div.pageContent div.smallPanel,
	div.pageContent div.leftColumn,
	div.pageContent div.rightColumn{
		display: block;
    	margin: 0 auto 35px;
	}
	#footer div.templateFooter div.phone > label,
	div.templateFooter div.phone > a,
	div.templateFooter div.phone > form > a,
	#footer div.templateFooter div.phone2 > label,
	div.templateFooter div.phone > a,
	#footer div.templateFooter div.mail > label,
	div.templateFooter div.faq > a,
	#footer div.templateFooter div.mail > label,
	div.templateFooter div.faq > a {
		font-size: 18px !important;
	}
	#footer div.templateFooter div.phone2 > label.phone2-label2, 
	#footer div.templateFooter div.phone2 > label.phone2-label2-margin {
		font-size: 15px !important;
	} 
	
	#footer div.templateFooter div.phone:before,
	#footer div.templateFooter div.phone2:before,
	#footer div.templateFooter div.mail:before,
	#footer div.templateFooter div.faq:before {
		height: 35px;
	    margin-right: 7px;
	    vertical-align: -9px;
	    width: 35px;
	}
}
@media screen and (max-width: 639px)  {
	div.pageContent .ui-panel .ui-panel-title, div.pageContent .ui-dialog .ui-dialog-title, body .ui-dialog .ui-dialog-title {
		word-break:  normal;		
	}
}
@media screen and (min-width: 640px) {
	div.templateFooter div.phone > label,
	div.templateFooter div.phone > a,
	div.templateFooter div.phone > form > a,
	div.templateFooter div.phone2 > label,
	div.templateFooter div.phone2 > a,
	div.templateFooter div.mail > label,
	div.templateFooter div.mail > a,
	div.templateFooter div.faq > label,
	div.templateFooter div.faq > a {
		font-size: 18px !important;
		line-height: 18px;
	}
	div.templateFooter div.phone2 > label.phone2-label2, 
	div.templateFooter div.phone2 > label.phone2-label2-margin {
		font-size: 15px !important;
	}
	div.templateFooter div.phone,
	div.templateFooter div.phone2,
	div.templateFooter div.mail,
	div.templateFooter div.faq {
	    height: 45px;
    	line-height: 18px;
	    width: 100%;
		text-align: left;
	}
}
@media screen and (min-width: 640px) and (max-width: 768px)  {
	
	body.login{
		background-image: /*savepage-url=/ebok/javax.faces.resource/topimgbgW980.jpg.xhtml?ln=images*/ url();
		background-size: contain;
		background-position: center top;
		background-repeat: no-repeat;
	}
	body.logged{
		background: /*savepage-url=/ebok/javax.faces.resource/topimgbgH250W980.jpg.xhtml?ln=images*/ url() no-repeat top center #fff;
		background-size: contain;
		background-position: center top;
		background-repeat: no-repeat;
	}
	div.pageContent div.smallPanel,
	div.pageContent div.leftColumn,
	div.pageContent div.rightColumn{
		display: block;
    	margin: 0 auto 35px;
	}
	
	div.pageContent{
		width: 640px;
		margin: auto;
	}
}

/* iPad in portrait */
@media only screen 
and (min-device-width : 768px) 
and (max-device-width : 1024px) 
and (orientation : portrait) { 
	body.login{
		background-image: /*savepage-url=/ebok/javax.faces.resource/topimgbgW980.jpg.xhtml?ln=images*/ url();
		background-size: contain;
		background-position: center top;
		background-repeat: no-repeat;
	}
	body.logged{
		background: /*savepage-url=/ebok/javax.faces.resource/topimgbgH250W980.jpg.xhtml?ln=images*/ url() no-repeat top center #fff;
		background-size: contain;
		background-position: center top;
		background-repeat: no-repeat;
	}
	
	div.pageContent div.smallPanel,
	div.pageContent div.leftColumn,
	div.pageContent div.rightColumn{
		display: block;
    	margin: 0 auto 35px;
	}
	
}
/* iPad in landscape */
@media only screen 
and (min-device-width : 768px) 
and (max-device-width : 1024px) 
and (orientation : landscape) {
	body.login{
		background-image: /*savepage-url=/ebok/javax.faces.resource/topimgbgW1200.jpg.xhtml?ln=images*/ url();
		background-size: contain;
		background-position: center top;
		background-repeat: no-repeat;
	}
	body.logged{
		background: /*savepage-url=/ebok/javax.faces.resource/topimgbgH250W1200.jpg.xhtml?ln=images*/ url() no-repeat top center #fff;
		background-size: contain;
		background-position: center top;
		background-repeat: no-repeat;
	}
	div.pageContent.fullWidth div.smallPanel,
	div.pageContent.fullWidth div.leftColumn,
	div.pageContent.fullWidth div.rightColumn {
		width: 464px;
	}
	div.templateHeader,
	div.templateFooter,
	div.mainContainer{
		width: 1024px;
	}
	div.pageContent{
		width: 860px;
		margin: auto;
	}
	div.pageContent.fullWidth {
    	width: 948px;
	}
	div.pageContent div.leftColumn{
		margin-right: 20px;
		display: inline-block;
		vertical-align: top;
	}
	div.pageContent div.rightColumn{
		display: inline-block;
		vertical-align: top;
	}
	div.pageContent .ui-dialog,body .ui-dialog{width: calc(100% - 40px) !important; min-width: 320px;}
}
@media screen and (min-width: 1060px){
	div.templateFooter div.phone > label,
	div.templateFooter div.phone > form > a,
	div.templateFooter div.phone2 > label,
	div.templateFooter div.mail > label,
	div.templateFooter div.faq > label {
		font-size: 23px;
		line-height: 34px;
	}
	
	div.templateFooter div.phone,
	div.templateFooter div.phone2,
	div.templateFooter div.mail,
	div.templateFooter div.faq {
	    height: 45px;
	    line-height: 18px;
	}
	div.templateFooter div.phone.textRight,
	div.templateFooter div.faq.textRight {
		text-align: right;
	}
}

@media screen and (max-width : 1024px) , (max-device-width : 1024px) and (orientation : portrait){
	div.leftSideBar{
	    display: none;
	    height: calc(100% - 50px);
	    overflow: auto;
	    -webkit-overflow-scrolling: touch;
	    position: fixed;
	    top: 60px;
	    width: 100%;
	    z-index: 1;
	    background: rgba(123, 123, 123, 0.18) none repeat scroll 0 0;
	}
	div.leftSideBar > div{width: 300px; display: none;height: auto;}
	div.leftSideBar > div > form, div.leftSideBar > div > form > div {height: auto;}
	div.templateHeader{
	    height: 60px;
	    position: fixed;
	    top: 0;
	    width: 100%;
	}
	.templateHeader .logo-box{padding: 8px 0 0 90px;text-align: center;width: 150px;}
	.templateHeader .logo-box img{max-height: 46px;}
	.mainContainer .leftSideBar .ui-menu .ui-menuitem .ui-menuitem-link{padding-left: 40px; font-size: 20px;}
	body.logged{background: none;}

	#header {height: 60px;}
	.mobile-menu-icon{
		background: /*savepage-url=/ebok/javax.faces.resource/icon/menu_mobile_icon.png.xhtml?ln=images*/ url() no-repeat top center;
		content: " ";
	    cursor: pointer;
	    display: inline-block;
	    height: 35px;
	    left: 30px;
	    position: absolute;
	    top: 16px;
	    width: 40px;
	}
	.mobile-menu-icon:hover, .mobile-menu-icon.active{
		background-position: center -40px;
	}
}
@media screen and (min-width: 1025px){
	div.leftSideBar, div.leftSideBar > div{display: block !important;}
	
}
@media screen and (min-width: 1025px) and (max-width: 1199px)  {
	div.pageContent.fullWidth div.smallPanel,
	div.pageContent.fullWidth div.leftColumn,
	div.pageContent.fullWidth div.rightColumn {
		width: 480px;
	}
	body.login{
		background-image: /*savepage-url=/ebok/javax.faces.resource/topimgbgW1200.jpg.xhtml?ln=images*/ url();
		background-size: contain;
		background-position: center top;
		background-repeat: no-repeat;
	}
	body.logged{
		background: #fff /*savepage-url=/ebok/faces/javax.faces.resource/topimgbgH250.jpg?ln=images*/ url() no-repeat scroll center top / 100% 220px;
	}
	div.templateHeader{
		width: 980px;
	}
	div.mainContainer {
		width: 980px;
	}
	div.pageContent div.leftColumn{
		margin-right: 20px;
		display: inline-block;
		vertical-align: top;
	}
	div.pageContent div.rightColumn{
		display: inline-block;
		vertical-align: top;
	}
	div.pageContent {
		float: right;
    	width: 770px;
		margin: 0;
		padding: 0px;
		background: transparent;
	}
	div.pageContent.fullWidth{
		width: 100%;
		float: none;
		margin: auto;
		background: transparent;
	}
}
@media screen and (min-width: 1200px) {
	body.login{
		background-image: /*savepage-url=/ebok/javax.faces.resource/topimgbg.jpg.xhtml?ln=images*/ url();
		background-size: contain;
		background-position: center top;
		background-repeat: no-repeat;
	}
	body.logged{
		background: /*savepage-url=/ebok/javax.faces.resource/topimgbgH250.jpg.xhtml?ln=images*/ var(--savepage-url-14) no-repeat top center #fff;
		background-size: 100% 220px;
		background-position: center top;
		background-repeat: no-repeat;
	}
	
	div.templateHeader,
	div.templateFooter,
	div.mainContainer{
		width: 1060px;
	}
	 
	div.pageContent div.leftColumn{
		margin-right: 20px;
		display: inline-block;
		vertical-align: top;
	}
	div.pageContent div.rightColumn{
		display: inline-block;
		vertical-align: top;
	}
	div.pageContent {
		float: right;
    	width: 860px
	}
	div.pageContent.fullWidth{
		width: 940px;
		float: none;
		margin: auto;
	}
	div.pageContent .ui-dialog,
	body .ui-dialog{
		width: 980px !important;
		overflow: auto !important;
		-webkit-overflow-scrolling: touch;
	}
	body .ui-dialog#zakladki\:dialoguUsuwaniaProfilu {
		left: 458px !important;
	}
}</style><style data-savepage-href="/ebok/javax.faces.resource/stylev3.css.xhtml?ln=css" type="text/css">.ui-widget-content a, #footer a {
    color: var(--company-dark);
    border: 0;
    text-decoration: none;
}

.ui-widget-content a:hover {
    text-decoration: underline;
}

#footer a:hover {
    color: var(--company-dark);
}

.ui-widget input, .ui-widget select, .ui-widget textarea, .ui-widget button {
    font-family: Verdana, Geneva, sans-serif;
}

.ui-widget {
    font-size: 14px;
}

.ui-widget-content {
    color: #73747f;
    border: 0;
}

dl.ui-datalist-data {
    margin: 0;
}

a img {
    border: 0;
}

.ui-messages.js-messages .ui-messages-error, .ui-message.js-messages-error,
.ui-message.ui-message-error {
    padding: 0;
    margin: 5px 0;
    background-color: transparent;
    border-color: transparent;
    color: #e30613;
    width: 400px;
    box-sizing: border-box;
    box-shadow: none;
}

.ui-message .ui-message-error-detail {
    margin: 0;
}

.ui-message .ui-message-error-icon {
    display: none;
}

.ui-messages.js-messages .ui-messages-error span {
    font-weight: normal;
}

.ui-messages.js-messages .ui-messages-error .ui-messages-error-icon {
    display: none;
}

h2 {
    font-weight: normal;
    margin-top: 30px;
    color: var(--company-dark);
    font-size: 20px;
}

h3 {
    margin-top: 0;
}

.leftSideBar .ui-menu {
    background: #f7f7f7;
    border: 0 none;
    border-radius: 3px;
    box-shadow: 0 0 5px rgba(0, 0, 0, 0.18);
    box-sizing: border-box;
    color: #73747f;
    font-size: 16px;
    padding: 0;
    width: 100%;
    border-radius: 0;
    margin-bottom: 10px;
}

/*************************************** Paginator dla tabel - START *******************************/

div.pageContent .ui-paginator {
    font-size: 14px;
    line-height: 16px;
    text-shadow: none;
}

div.pageContent .ui-paginator > span {
    color: var(--company-dark);
}

div.pageContent a.ui-paginator-page {
    background: none;
    border: 0px;
}

div.pageContent a.ui-paginator-page.ui-state-default {
    font-weight: normal;
    color: #9a96a2;
}

div.pageContent a.ui-paginator-page.ui-state-active {
    color: var(--company-dark);
    font-weight: bold;
}

div.pageContent a.ui-paginator-first {
    background: none;
    border: 0px;
}

div.pageContent a.ui-paginator-prev {
    background: none;
    border: 0px;
}

div.pageContent a.ui-paginator-next {
    background: none;
    border: 0px;
}

div.pageContent a.ui-paginator-last {
    background: none;
    border: 0px;
}

/*************************************** Paginator dla tabel - KONIEC *******************************/


.leftSideBar .ui-menu .ui-menuitem {
    margin: 0;
    border-radius: 0;
}

.ui-menuitem a:hover {
    text-decoration: none;
}

body .ui-selectcheckboxmenu-panel {
    padding: 0;
    border-radius: 0;
    box-shadow: 0 0 5px rgba(0, 0, 0, 0.18);
    box-sizing: border-box;
    width: 400px;
}

div.pageContent .ui-chkbox .ui-chkbox-box,
.ui-chkbox .ui-chkbox-box {
    vertical-align: bottom;
    margin-right: 5px;
    background: #fff;
    cursor: pointer;
}

div.pageContent .ui-chkbox .ui-chkbox-box.ui-state-active {
    border-color: #a8a8a8;
}

.leftSideBar .ui-menu .ui-menuitem .ui-menuitem-link {
    border-radius: 0;
    color: #73747f;
    border-left: 8px solid #f7f7f7;
    font-size: 14px;
    padding: 0 0 0 15px;
    text-transform: uppercase;
    box-sizing: border-box;
    width: 100%;
    height: 60px;
    -webkit-touch-callout: none;
    -webkit-user-select: none;
    -khtml-user-select: none;
    -moz-user-select: none;
    -ms-user-select: none;
    user-select: none;
}

.leftSideBar .ui-menu .ui-menuitem .ui-menuitem-link.current {
    background: #fff;
    border-left: 8px solid var(--company-dark);
    color: var(--company-dark);
}

.leftSideBar .ui-menu .ui-menuitem .ui-menuitem-link.ui-state-hover {
    background: #fff;
    border-left: 8px solid var(--company-dark);
    box-shadow: none;
}

.leftSideBar .ui-menu .ui-menuitem .ui-menuitem-link > span {
    float: none;
    display: block;
    float: right;
    margin-top: 21px;
    width: 122px;
}

.leftSideBar .admin-menu .ui-menuitem .ui-menuitem-link > span {
    width: 152px;
}

.leftSideBar .ui-menu .ui-menuitem .ui-menuitem-link > span.ui-icon {
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/menu_icon.png.xhtml?ln=images*/ var(--savepage-url-24);
    background-position: left bottom;
    background-repeat: no-repeat;
    border-radius: 0;
    height: 25px;
    margin-right: 10px;
    vertical-align: -3px;
    width: 22px;
    margin-top: 16px;
    float: left;
}

.ui-state-default .ui-icon {
    background-image: /*savepage-url=/ebok/javax.faces.resource/images/ui-icons_green_256x240.png.xhtml*/ var(--savepage-url-39);
}

.leftSideBar .ui-menu .ui-menuitem .ui-menuitem-link.twoLine > span {
    margin-top: 12px;
}

.leftSideBar .ui-menu .ui-menuitem .ui-menuitem-link.current > span.ui-icon {
    background-position: left top;
    vertical-align: -6px;
}

.leftSideBar .ui-menu .ui-menuitem .ui-menuitem-link > span.ui-icon.ui-icon-finances {
    background-position: -22px bottom;
}

.leftSideBar .ui-menu .ui-menuitem .ui-menuitem-link.current > span.ui-icon.ui-icon-finances {
    background-position: -22px top;
    vertical-align: -6px;
}

.leftSideBar .ui-menu .ui-menuitem .ui-menuitem-link > span.ui-icon.ui-icon-zuzycie {
    background-position: -110px bottom;
}

.leftSideBar .ui-menu .ui-menuitem .ui-menuitem-link.current > span.ui-icon.ui-icon-zuzycie {
    background-position: -110px top;
    vertical-align: -6px;
}

.leftSideBar .ui-menu .ui-menuitem .ui-menuitem-link > span.ui-icon.ui-icon-sklep {
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/menu_basket.png.xhtml?ln=images*/ url();
    background-position: left bottom;
    margin-top: 13px;
}

.leftSideBar .ui-menu .ui-menuitem .ui-menuitem-link.current > span.ui-icon.ui-icon-sklep {
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/menu_basket_blue.png.xhtml?ln=images*/ url();
    background-position: left bottom;
    margin-top: 13px;
}

.leftSideBar .ui-menu .ui-menuitem .ui-menuitem-link > span.ui-icon.ui-icon-konta {
    background-position: -132px bottom;
    margin-top: 13px;
}

.leftSideBar .ui-menu .ui-menuitem .ui-menuitem-link.current > span.ui-icon.ui-icon-konta {
    background-position: -132px top;
    vertical-align: -6px;
}

.leftSideBar .ui-menu .ui-menuitem .ui-menuitem-link > span.ui-icon.ui-icon-case {
    background-position: -44px bottom;
    vertical-align: -5px;
}

.leftSideBar .ui-menu .ui-menuitem .ui-menuitem-link.current > span.ui-icon.ui-icon-case {
    background-position: -44px top;
    vertical-align: -9px;
}

.leftSideBar .ui-menu .ui-menuitem .ui-menuitem-link > span.ui-icon.ui-icon-offer {
    background-position: -66px bottom;
    vertical-align: -5px;
}

.leftSideBar .ui-menu .ui-menuitem .ui-menuitem-link.current > span.ui-icon.ui-icon-offer {
    background-position: -66px top;
    vertical-align: -8px;
}

.leftSideBar .ui-menu .ui-menuitem .ui-menuitem-link > span.ui-icon.ui-icon-document {
    background-position: -88px bottom;
    vertical-align: -5px;
}

.leftSideBar .ui-menu .ui-menuitem .ui-menuitem-link.current > span.ui-icon.ui-icon-document {
    background-position: -88px top;
    vertical-align: -9px;
}

.leftSideBar .ui-menu .ui-menuitem .ui-menuitem-link > span.ui-icon.ui-icon-cog {
    background-position: -158px bottom;
    vertical-align: -5px;
}

.leftSideBar .ui-menu .ui-menuitem .ui-menuitem-link.current > span.ui-icon.ui-icon-cog {
    background-position: -158px top;
    vertical-align: -9px;
}

.ui-manual-conn span.ui-menuitem-text {
    margin-top: 13px !important;
    line-height: 22px;
}

.ui-selectonemenu-panel .ui-shadow {
    box-shadow: none;
}

.ui-selectonemenu-panel .ui-corner-all {
    border-radius: 0;
}

.ui-selectonemenu-panel.ui-widget-content {
    background: none repeat scroll 0 0 #ffffff;
    border: 1px solid #c5c5cd;
    color: #73747f;
    box-shadow: 0 0 5px rgba(0, 0, 0, 0.18);
    border-radius: 0;
}

/**.ui-selectonemenu-panel .ui-selectonemenu-items-wrapper  {
    width: 300px;
}*/
.ui-selectonemenu-panel .ui-selectonemenu-items-wrapper .ui-selectonemenu-list {
    border: 0 none;
    padding: 0;
}

.ui-selectonemenu-panel.w380imp div ul {
    width: max-content;
}

.ui-selectonemenu-panel li.ui-selectonemenu-list-item {
    font-size: 14px;
    padding: 5px 10px;
}

.ui-selectonemenu-panel .ui-selectonemenu-items-wrapper .ui-selectonemenu-list li.ui-state-highlight {
    background: #ccc none repeat scroll 0 0;
    text-shadow: none;
}

.ui-selectonemenu-panel .ui-selectonemenu-items-wrapper .ui-selectonemenu-list li.ui-state-hover {
    background: #f7f7f7;
    box-shadow: none;
}

.ui-accordion .ui-accordion-header {
	color: #4f4f4f;
	font-weight: normal;
	text-shadow: none;
}
.ui-accordion .ui-accordion-header.ui-state-active {
	color: var(--company-dark);
	font-weight: bold;
	text-shadow: none;
}

.relative{position: relative;}
body .ui-tooltip {
    border-radius: 0;
    padding: 15px;
    box-shadow: 0 0 5px rgba(0, 0, 0, 0.18);
    background: #f7f7f7 none repeat scroll 0 0;
}

div.pageContent .ui-panel .ui-panel-footer {
    border: 0 none;
    color: #898989;
    font-size: 12px;
    margin: 0;
    padding: 0;
    position: relative;
}

.inline-with-btn {
    margin-top: -20px;
}

.help-icon {
    cursor: pointer;
    float: right;
    position: relative;
    top: -15px;
}

.help-icon:hover,
.help-icon.open {
    color: var(--company-dark);
}

.help-icon:hover:after,
.help-icon.open:after {
    background-position: center bottom;
}

.help-box-description {
    margin-top: 50px;
}

.payment-distributor-description {
    margin-top: 50px;
    display: flex;
    gap: 5px;
    align-items: flex-end;
}

.bluemedia-payment-logo {
	height: 50px;
}
.autopay-payment-logo{
	content: /*savepage-url=/ebok/javax.faces.resource/autopay-logo.png.xhtml?ln=images*/ url();
	height: 50px;
	width: 151px;
}

.help-description {
    border-top: 1px solid #e1e2e7;
    padding-top: 15px;
    display: none;
    text-align: justify;
}

.payment-distributor-info {
    border-top: 1px solid #e1e2e7;
    padding-top: 15px;
    text-align: justify;
    width: 100%;
}

.inline-with-btn .help-box-description {
    margin-top: 35px;
}

.inline-with-btn .help-icon {
    top: -20px;
}

.help-icon:after {
    background-position: top center;
    content: "";
    display: inline-block;
    height: 22px;
    margin-left: 10px;
    vertical-align: middle;
    width: 22px;
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/help_icon.png.xhtml?ln=images*/ var(--savepage-url-30);

}

.contrast-icon {
    /*background-position: top center;*/
    background-size: cover;
    background-position: center center;
    vertical-align: middle;
    display: inline-block;
    height: 26px;
    width: 26px;
    cursor: pointer;
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/tryb_zwykly.png.xhtml?ln=images*/ var(--savepage-url-21);
}

.contrast-icon-header {
    /*background-position: top center;*/
    background-size: cover;
    background-position: center center;
    position: absolute;
    bottom: 5px;
    right: 5px;
    height: 26px;
    width: 26px;
    cursor: pointer;
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/tryb_zwykly.png.xhtml?ln=images*/ var(--savepage-url-21);
}

.ui-datatable.dark table {
    border-collapse: collapse;
    border-spacing: 0;
    table-layout: fixed;
    width: 100%;
}

.accordion-invisible .ui-accordion-header {
    display: none;
}

.accordion-invisible > .ui-accordion-content {
    padding: 5px !important;
}

div.pageContent .ui-datatable.notification table {
    border-collapse: separate;
    border-spacing: 0 3px;
}

div.pageContent .ui-datatable.invoice thead {
    border-left: 1px solid #9a96a2;
}

.ui-datatable.dark thead th,
div.pageContent .ui-datatable.invoice thead th {
    background: none repeat scroll 0 0 #9a96a2;
    border: 0 none;
    box-sizing: border-box;
    color: #fff;
    font-size: 14px;
    height: 35px;
    font-weight: normal;
    padding: 0 15px 0 15px;
    text-align: center;
    text-shadow: none;
    box-shadow: none;
    border: 1px solid #9a96a2;
}

body .ui-datatable th span.ui-sortable-column-icon {
    background: /*savepage-url=/ebok/javax.faces.resource/icon/sort_icon.png.xhtml?ln=images*/ url();
}

body .ui-datatable th span.ui-sortable-column-icon.ui-icon-triangle-1-n {
    background: /*savepage-url=/ebok/javax.faces.resource/icon/sort_asc_icon.png.xhtml?ln=images*/ url();
}

body .ui-datatable th span.ui-sortable-column-icon.ui-icon-triangle-1-s {
    background: /*savepage-url=/ebok/javax.faces.resource/icon/sort_desc_icon.png.xhtml?ln=images*/ url();
}

div.pageContent .ui-datatable.dark.admin thead th {
    font-size: 14px;
}

div.pageContent .ui-datatable.invoice thead th {
    padding: 0 0 0 7px;
}

div.pageContent .ui-datatable.archives thead th {
    font-size: 12px;
    padding: 0 10px 0 10px;
    box-sizing: border-box;
}

.ui-datatable.dark tbody td,
div.pageContent .ui-datatable.invoice tbody td {
    font-size: 12px;
    height: 40px;
    line-height: 20px;
    padding: 4px 15px;
    border: 0;
    border: 1px solid #e1e2e7;
    box-sizing: border-box;
}

.ui-datatable.dark tbody td, div.pageContent .ui-datatable.invoice tbody td .extended {
    padding-left: 15px !important;;
}

div.pageContent .ui-datatable.archives tbody td {
    font-size: 12px;
    line-height: 16px;
    padding: 5px;
}

div.pageContent .ui-datatable.notification thead th,
div.pageContent .ui-datatable.notification tbody td {
    padding: 0;
    border-left-width: 0px;
    border-right-width: 0px;
}

div.pageContent .ui-datatable.notification thead th:first-child,
div.pageContent .ui-datatable.notification tbody td:first-child {
    padding: 0 0 0 10px;
    border-left-width: 1px;
    box-sizing: border-box;
}

div.pageContent .ui-datatable.notification tbody tr {
    background: none;
}

div.pageContent .ui-datatable.notification tbody td:last-child {
    padding: 0 15px 0 0;
    border-right-width: 1px;
}

.ui-datatable.dark .ui-datatable-data,
.ui-datatable.dark .ui-datatable-data tr {
    border: 0;
    background: none;
}

.jr-fixed-size td,
.jr-fixed-size th,
.jr-fixed-size tf {
    table-layout: fixed;
    word-wrap: break-word;
    text-align: center;
}

.jr-100-size {
    width: 100px;
}

div.pageContent .ui-datatable.invoice tbody td {
    border: 0;
    border-color: #e1e2e7;
    border-style: solid;
    border-width: 1px 0 1px 0;
}

div.pageContent .ui-datatable.invoice tbody .ui-expanded-row td {
    border-bottom: 0;
}

div.pageContent .ui-datatable.invoice tbody .ui-expanded-row-content td {
    border-top: 0;
}

div.pageContent .ui-datatable.invoice tbody td:first-child {
    border-left-width: 1px;
}

div.pageContent .ui-datatable.invoice tbody td:last-child {
    border-right-width: 1px;
}

.invoice .ui-expanded-row-content td > * {
    vertical-align: top;
    font-size: 12px;
    line-height: 14px;
    letter-spacing: -0.2px;
    word-wrap: break-word;
    word-break: break-all
}

.ui-datatable.transparent table thead {
    display: none;
}

.admin div.pageContent .ui-datatable.dark td,
.admin div.pageContent .ui-datatable.dark th {
    padding: 0 10px;
}

.ui-datatable.transparent table td,
.ui-datatable.transparent table tr.ui-datatable-odd {
    border: 0;
    background: 0;
}

.block {
    display: block !important;
}

.inlineBlock {
    display: inline-block;
}

.w100p {
    width: 100% !important;
}

.w50p {
    width: 50%;
}

.w90p {
    width: 90%;
}

div.pageContent .w100p {
    width: 100% !important;
}

.vat {
    vertical-align: top;
}

.vam {
    vertical-align: middle;
}

.ui-button.p020 {
    padding: 0 20px;
}

.vab {
    vertical-align: bottom;
}

.h481 {
    height: 481px;
}

.h385 {
    height: 385px;
}

.h350 {
    height: 350px;
}

.h450 {
    height: 450px;
}

.h37 {
    height: 37px;
}

.w20 {
    width: 20px;
}

.w40 {
    width: 40px;
}

.w50 {
    width: 50px;
}

.w60 {
    width: 60px;
}

.w70 {
    width: 70px;
}

.w80 {
    width: 80px;
}

.w85 {
    width: 85px;
}

.w87 {
    width: 87px;
}

.w90 {
    width: 90px;
}

.w92 {
    width: 92px;
}

.w95 {
    width: 95px;
}

.w100 {
    width: 100px;
}

.w110 {
    width: 110px;
}

.w120 {
    width: 120px;
}

.w120imp {
    width: 120px !important;
}

.w130 {
    width: 130px;
}

.w140 {
    width: 140px;
}

.w150 {
    width: 150px;
}

.w160 {
    width: 160px;
}

.w170 {
    width: 170px;
}

.w175 {
    width: 175px;
}

.w180 {
    width: 180px;
}

.w185 {
    width: 185px;
}

.w186 {
    width: 186px;
}

.w187 {
    width: 187px;
}

.w188 {
    width: 188px;
}

.w189 {
    width: 189px;
}

.w190 {
    width: 190px;
}

.w195 {
    width: 195px;
}

.w200 {
    width: 200px;
}

.w205 {
    width: 205px;
}

.w210 {
    width: 210px;
}

.w220 {
    width: 220px;
}

.w230 {
    width: 230px;
}

.w240 {
    width: 240px;
}

.w250 {
    width: 250px;
}

.w270 {
    width: 270px;
}

.w280 {
    width: 280px;
}

.w300 {
    width: 300px;
}

.w320 {
    width: 320px;
}

.w350 {
    width: 350px !important;
}

.w360 {
    width: 360px;
}

.w370 {
    width: 370px !important;
}

.w380 {
    width: 380px;
}

.w380imp {
    width: 380px !important;
}

.w400 {
    width: 400px !important;
}

.w420 {
    width: 420px;
}

.w450 {
    width: 450px;
}

.w500 {
    width: 500px;
}

.w590 {
    width: 590px;
}

.w600 {
    width: 600px;
}

.w605 {
    width: 605px;
}

.w680 {
    width: 680px;
}

.w800 {
    width: 800px;
}

.ui-inputNum input {
    width: 100%
}

span.break05, span.break, span.break2, span.break3, span.break4 {
    display: block !important;
    height: 10px;
}

span.break05 {
    height: 5px;
}

span.break2 {
    height: 20px;
}

span.break3 {
    height: 30px;
}

span.break4 {
    height: 40px;
}

span.breakH05, span.breakH, span.breakH2, span.breakH3, span.breakH4, span.breakH8 {
    display: inline-block;
    width: 10px;
    height: 10px;
}

.blue {
    color: #0c3274;
}

.boldblue {
    color: #0c3274;
    font-weight: bold
}

.orange {
    color: #f07d00;
}

.grey {
    color: #73747f;
}

.boldgrey {
    color: #73747f;
    font-weight: bold;
}

.company-dark {
    color: var(--company-dark);
}

.bold-company-dark {
    color: var(--company-dark);
    font-weight: bold
}

.company-normal {
    color: var(--company-normal);
}

.company-middle {
    color: var(--company-middle);
}

.company-light {
    color: var(--company-middle);
}

.company-dark-link {
    color: var(--company-dark);
}

.company-dark-link:hover {
    color: var(--company-normal) !important;
}

.company-dark-static-text {
    color: var(--company-dark) !important;
}

.company-text-data {
    color: #000000 !important;
}

.company-content {
    color: var(--company-content) !important;
}

.company-dark-input-checkbox {
    accent-color: var(--company-dark);
}

.nowrap {
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.ui-widget-content a.orange {
    color: #f07d00;
}

.ui-widget-content a.grey {
    color: #73747f;
}

.ui-widget-content a.boldgrey {
    color: #73747f;
    font-weight: bold;
}

.ui-widget-content a.company-dark {
    color: var(--company-dark);
}

.ui-widget-content a.company-dark:hover {
    color: var(--company-normal);
}

span.breakH05 {
    width: 5px;
}

span.breakH2 {
    width: 20px;
}

span.breakH3 {
    width: 30px;
}

span.breakH4 {
    width: 40px;
}

span.breakH8 {
    width: 80px;
}

div.pageContent hr.ui-separator, body .ui-widget-content hr.ui-separator {
    border: 0;
    border-bottom: 1px solid #e1e2e7;
}

div.pageContent .blue {
    color: #0c3274;
}

div.pageContent .orange {
    color: #f07d00;
}

div.pageContent .company-middle {
    color: var(--company-middle);
}

div.pageContent .company-dark {
    color: var(--company-dark);
}

body .blue f14 {
    color: #0c3274;
    font-size: 16px;
}

.f11 {
    font-size: 11px;
    line-height: 12px;
}

div.pageContent .bold {
    font-weight: bold;
}

div.pageContent .f11 {
    font-size: 11px;
    letter-spacing: -0.16px;
    line-height: 12px;
}

div.pageContent .f12 {
    font-size: 12px;
    line-height: 16px;
}

div.pageContent .f14 {
    font-size: 14px;
    line-height: 18px;
}

body .f14 {
    font-size: 14px;
    line-height: 18px;
}

div.pageContent .f16 {
    font-size: 16px;
}

body .ui-widget .f16 {
    font-size: 16px;
}

div.pageContent .f18 {
    font-size: 18px;
    line-height: 24px;
}

body .ui-widget .f20 {
    font-size: 20px;
}

div.pageContent .f22, body .ui-widget .f22 {
    font-size: 22px;
    line-height: 30px;
}

div.pageContent .f24, body .ui-widget .f24 {
    font-size: 24px;
    line-height: 32px;
}

div.pageContent .f32 {
    font-size: 32px;
}

div.pageContent .f36 {
    font-size: 36px;
}

body .ffSSPL {
    font-family: "SourceSansProLight", "Source Sans Pro", Verdana, sans-serif !important;
}

body .ffSSP {
    font-family: "SourceSansPro", "Source Sans Pro", Verdana, sans-serif !important;
}

.addedAttachments {
    border-bottom: 1px solid #eee;
    margin: 5px 0;
    padding-bottom: 3px;
}

.templateHeader .ui-panel {
    border: 0;
    padding: 0;
    border-radius: 0;
}

.ui-dialog .ui-dialog-buttonpane {
    padding: 0.3em 1em 0.5em 20px;
}

.templateHeader .ui-panel .ui-panel-content {
    background: none rgba(0, 0, 0, 0);
    padding: 0;
}

div.userPanel {
    box-sizing: border-box;
    height: 100%;
    position: absolute;
    right: 0;
    width: 590px;
    top: 0;
}

div.userPanel form,
div.userPanel form > div,
div.userPanel form > div > div,
div.userPanel form > div > div > div {
    height: 100%;
    display: inline-block;
    font-size: 12px;
}

div.userPanelLeft {
    width: 410px;
    box-sizing: border-box;
    padding: 5px 10px;
    border-left: 1px solid #e1e2e7;
}

.headerPanelRight {
    width: 590px;
}

div.userPanelLeft .break {
    height: 5px;
}

div.userPanelRight {
    vertical-align: top;
    border-left: 1px solid #e1e2e7;
    box-sizing: border-box;
    width: 163px;
}

.countMessages {
    display: inline-block;
    left: 3px;
    overflow: hidden;
    position: relative;
    text-align: center;
    top: 1px;
    line-height: 16px;
    width: 18px;
}

.hello:before,
.messages:before,
.logoutBox:before,
.config:before,
.changeAccount:before {
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/logout_icon.png.xhtml?ln=images*/ var(--savepage-url-22);
    background-repeat: no-repeat;
    background-position: center 0;
    background-size: cover;
    content: "";
    display: inline-block;
    height: 25px;
    margin-right: 10px;
    vertical-align: middle;
    width: 25px;
}

.hello:before {
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/user_icon.png.xhtml?ln=images*/ var(--savepage-url-18);
}

.messages:before {
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/message_icon.png.xhtml?ln=images*/ var(--savepage-url-19);
}

.config:before {
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/config_icon.png.xhtml?ln=images*/ var(--savepage-url-20);
}

.userAccountPanel {
    border-top: 1px solid #e1e2e7;
    box-sizing: border-box;
    letter-spacing: -0.5px;
    overflow: hidden;
    padding: 16px 15px 16px 20px;
    width: 100% !important;

}

.changeAccount {
    cursor: pointer;
    position: relative;
    padding-left: 35px;
    padding-top: 4px;
    position: relative;
    display: block;
}

.changeAccount:before {
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/switch_icon.png.xhtml?ln=images*/ var(--savepage-url-23);
    background-position: right 0px;
    position: absolute;
    top: 0;
    left: 0;
}

.changeAccount:hover:before {
    background-position: left 0px;
}

.changeAccount:hover {
    color: #0c3274;
}

.userAccountPanel .ui-overlaypanel {
    border-radius: 0;
    box-shadow: none;
    width: 485px;
    left: 0 !important;
    background: #f7f7f7;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.18);
    top: 124px !important;

}

.userAccountPanel .ui-overlaypanel-content {
    padding: 0;
}

.userAccountPanel .ui-datatable {
    padding: 5px 18px 18px;
}

.userAccountPanel .topShadow {
    border-top: 1px solid #ccc;
    box-shadow: 0 2px 3px 1px rgba(0, 0, 0, 0.2);
}

.userAccountPanel table {
    border: 0;
    background: none;
}

.userAccountPanel .ui-datatable .ui-datatable-footer {
    background: none;
    padding: 15px 0 0;
    text-align: left;
    font-weight: normal;
    border: 0;
    cursor: pointer;
}

.userAccountPanel table th {
    display: none;
}

.userAccountPanel table tbody tr,
.userAccountPanel table tbody tr.ui-state-highlight,
.userAccountPanel table tbody tr.ui-state-selectable,
.userAccountPanel table tbody tr.ui-state-hover {
    background: #f7f7f7 !important;
    border: 0;
    text-shadow: none;
    color: #73747f;
    box-shadow: none;

}

.userAccountPanel table tbody td {
    border-bottom-color: #e1e2e7;
    border-left-width: 0;
    border-right-width: 0;
    border-top-width: 0;
    padding: 15px 10px;
    background: none;
    cursor: pointer;
}

.userAccountPanel table tbody td.bold {
    font-weight: bold;
    background: rgba(255, 255, 255, 0.6) none repeat scroll 0 0;
}

.logoutBox {
    display: inline-block;
    width: 100%;
    box-sizing: border-box;
    padding: 17px 20px 15px 20px;
}

.ui-widget {
    font-family: Verdana, Geneva, sans-serif;
}

div.pageContent .ui-widget {
    font-family: Verdana, Geneva, sans-serif;
}

button.ui-button.ui-state-default,
input[type="submit"].ui-button.ui-state-default,
input[type="button"].ui-button.ui-state-default,
a.btn, span.btn {
    border: 0 none;
    margin: 0;
    display: inline-block;
    border-radius: 0;
    color: #fff;
    font-size: 14px;
    height: 32px;
    line-height: 30px;
    text-shadow: none;
    font-weight: normal;
    box-shadow: 0 0 5px rgba(0, 0, 0, 0.18);
    background: var(--company-dark); /* Old browsers */
    /* IE9 SVG, needs conditional override of 'filter' to 'none' */
    background: url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2Y1ODcyOSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNjYjVkMDIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+);
    background: -moz-linear-gradient(top, var(--company-dark) 0%, var(--company-dark) 100%); /* FF3.6+ */
    background: -webkit-gradient(linear, left top, left bottom, color-stop(0%, var(--company-dark)), color-stop(100%, var(--company-dark))); /* Chrome,Safari4+ */
    background: -webkit-linear-gradient(top, var(--company-dark) 0%, var(--company-dark) 100%); /* Chrome10+,Safari5.1+ */
    background: -o-linear-gradient(top, var(--company-dark) 0%, var(--company-dark) 100%); /* Opera 11.10+ */
    background: -ms-linear-gradient(top, var(--company-dark) 0%, var(--company-dark) 100%); /* IE10+ */
    background: linear-gradient(to bottom, var(--company-dark) 0%, var(--company-dark) 100%); /* W3C */
    filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='#1A7466', endColorstr='#1A7466', GradientType=0); /* IE6-8 */
}

button.ui-button.ui-state-default.company-middle {
    border: 0 none;
    margin: 0;
    display: inline-block;
    border-radius: 0;
    color: #fff;
    font-size: 14px;
    height: 32px;
    line-height: 30px;
    text-shadow: none;
    font-weight: normal;
    box-shadow: 0 0 5px rgba(0, 0, 0, 0.18);
    background: var(--company-middle); /* Old browsers */
    /* IE9 SVG, needs conditional override of 'filter' to 'none' */
    background: url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2Y1ODcyOSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNjYjVkMDIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+);
    background: -moz-linear-gradient(top, var(--company-middle) 0%, var(--company-middle) 100%); /* FF3.6+ */
    background: -webkit-gradient(linear, left top, left bottom, color-stop(0%, var(--company-middle)), color-stop(100%, var(--company-middle))); /* Chrome,Safari4+ */
    background: -webkit-linear-gradient(top, var(--company-middle) 0%, var(--company-middle) 100%); /* Chrome10+,Safari5.1+ */
    background: -o-linear-gradient(top, var(--company-middle) 0%, var(--company-middle) 100%); /* Opera 11.10+ */
    background: -ms-linear-gradient(top, var(--company-middle) 0%, var(--company-middle) 100%); /* IE10+ */
    background: linear-gradient(to bottom, var(--company-middle) 0%, var(--company-middle) 100%); /* W3C */
    filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='#B2CF65', endColorstr='#B2CF65', GradientType=0); /* IE6-8 */
}

button.ui-button.ui-state-default:hover,
input[type="submit"].ui-button.ui-state-default:hover,
input[type="button"].ui-button.ui-state-default:hover,
a.btn:hover, span.btn:hover {
    text-decoration: none;
    background: var(--company-normal); /* Old browsers */
    /* IE9 SVG, needs conditional override of 'filter' to 'none' */
    background: url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iIzA3MmM3MyIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiMwMTBlNGUiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+);
    background: -moz-linear-gradient(top, var(--company-normal) 0%, var(--company-normal) 100%); /* FF3.6+ */
    background: -webkit-gradient(linear, left top, left bottom, color-stop(0%, var(--company-normal)), color-stop(100%, var(--company-normal))); /* Chrome,Safari4+ */
    background: -webkit-linear-gradient(top, var(--company-normal) 0%, var(--company-normal) 100%); /* Chrome10+,Safari5.1+ */
    background: -o-linear-gradient(top, var(--company-normal) 0%, var(--company-normal) 100%); /* Opera 11.10+ */
    background: -ms-linear-gradient(top, var(--company-normal) 0%, var(--company-normal) 100%); /* IE10+ */
    background: linear-gradient(to bottom, var(--company-normal) 0%, var(--company-normal) 100%); /* W3C */
    filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='#10a38b', endColorstr='#10a38b', GradientType=0); /* IE6-8 */
}
button.ui-button.ui-state-default.company-middle:hover{
	text-decoration: none;
	background: var(--company-light); /* Old browsers */
	/* IE9 SVG, needs conditional override of 'filter' to 'none' */
	background: url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iIzA3MmM3MyIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiMwMTBlNGUiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+);
	background: -moz-linear-gradient(top, var(--company-light) 0%, var(--company-light) 100%); /* FF3.6+ */
	background: -webkit-gradient(linear, left top, left bottom, color-stop(0%, var(--company-light)), color-stop(100%, var(--company-light))); /* Chrome,Safari4+ */
	background: -webkit-linear-gradient(top,  var(--company-light) 0%, var(--company-light)100%); /* Chrome10+,Safari5.1+ */
	background: -o-linear-gradient(top, var(--company-light) 0%, var(--company-light) 100%); /* Opera 11.10+ */
	background: -ms-linear-gradient(top, var(--company-light) 0%, var(--company-light) 100%); /* IE10+ */
	background: linear-gradient(to bottom, var(--company-light) 0%, var(--company-light) 100%); /* W3C */
	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#c1e88e', endColorstr='#c1e88e',GradientType=0 ); /* IE6-8 */
}

button.ui-button.ui-state-default.ui-state-disabled,
button.ui-button.ui-state-default.ui-state-disabled:hover,
a.btn.ui-state-disabled, span.btn.ui-state-disabled,
.ui-fileupload span.ui-button.ui-state-disabled,
.ui-fileupload span.ui-button.ui-state-disabled:hover {
    /* Permalink - use to edit and share this gradient: http://colorzilla.com/gradient-editor/#c5c5cd+0,9a96a2+100 */
    background: #c5c5cd; /* Old browsers */
    /* IE9 SVG, needs conditional override of 'filter' to 'none' */
    background: url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2M1YzVjZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5YTk2YTIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+);
    background: -moz-linear-gradient(top, #c5c5cd 0%, #9a96a2 100%); /* FF3.6+ */
    background: -webkit-gradient(linear, left top, left bottom, color-stop(0%, #c5c5cd), color-stop(100%, #9a96a2)); /* Chrome,Safari4+ */
    background: -webkit-linear-gradient(top, #c5c5cd 0%, #9a96a2 100%); /* Chrome10+,Safari5.1+ */
    background: -o-linear-gradient(top, #c5c5cd 0%, #9a96a2 100%); /* Opera 11.10+ */
    background: -ms-linear-gradient(top, #c5c5cd 0%, #9a96a2 100%); /* IE10+ */
    background: linear-gradient(to bottom, #c5c5cd 0%, #9a96a2 100%); /* W3C */
    filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='#c5c5cd', endColorstr='#9a96a2', GradientType=0); /* IE6-8 */
    opacity: 1;
}

.offerTextBox {
    width: 50%;
    vertical-align: top;
    box-sizing: border-box;
    padding: 0 20px 0 0; /*word-break: break-all;*/
}

.offerTextBox100p {
    width: 100%;
    display: flex;
    vertical-align: top;
    box-sizing: border-box;
    padding: 0 20px 0 0; /*word-break: break-all;*/
}

.margin3 > div {
    margin: 0 3px !important;
}

.ui-messages .ui-messages-error-icon,
.ui-growl .ui-growl-image.ui-growl-image-error {
    background: /*savepage-url=/ebok/javax.faces.resource/icon/error_icon.png.xhtml?ln=images*/ url() no-repeat center center;
    width: 22px;
    height: 22px;
    margin-right: 10px;
    vertical-align: top;
}
.ui-confirm-dialog{min-height: 205px !important;}
.ui-confirm-dialog-severity{display: none !important;}
.ui-messages .ui-messages-info{color: var(--company-normal);border-color: var(--company-normal);background: #eee;}
.ui-messages  .ui-messages-info-icon{
	background: /*savepage-url=/ebok/javax.faces.resource/icon/success_icon.png.xhtml?ln=images*/ url() no-repeat center center;
	width: 22px;
	height: 22px;
	margin-right: 10px;
	vertical-align: top;
}

input.black {
    color: #000 !important;
}

input[type="submit"].ui-button.ui-state-default,
input[type="button"].ui-button.ui-state-default {
    padding: 0 10px;
}

a.btn, span.btn {
    font-size: 14px !important;
    padding: 0 10px;
    line-height: 30px;
}

button.blue.ui-button.ui-state-default {
    background: #fff;
    color: #0c3274;
    font-size: 13px;
    line-height: 24px;
    box-shadow: none;
    border: 1px solid #0c3274;
}

button.blue.ui-button.ui-state-default.ui-state-disabled {
    background: #fff;
    color: #777;
    opacity: 0.3;
}

button.company-dark.ui-button.ui-state-default {
    background: #fff;
    color: var(--company-dark);
    font-size: 13px;
    line-height: 24px;
    box-shadow: none;
    border: 1px solid var(--company-dark);
}

button.company-dark.ui-button.ui-state-default.ui-state-disabled {
    background: #fff;
    color: #777;
    opacity: 0.3;
}

.kalkulator-icon button.blue.ui-button.ui-state-default {
    color: #777;
    opacity: 0.6;
}

.kalkulator-icon button.company-dark.ui-button.ui-state-default {
    color: #777;
    opacity: 0.6;
}

.kalkulator-icon button.blue.ui-button.ui-state-default.ui-state-disabled {
    color: #0c3274;
    opacity: 1;
}

.kalkulator-icon button.company-dark.ui-button.ui-state-default.ui-state-disabled {
    color: var(--company-dark);
    opacity: 1;
}

.ui-dialog-titlebar-icon.ui-dialog-titlebar-close {
    padding: 1px;
}

.ui-dialog-titlebar-icon.ui-dialog-titlebar-close.ui-state-hover {
    background: none;
    border: 1px solid transparent;
    box-shadow: none;
}

.ui-icon.ui-icon-closethick,
.ui-selectcheckboxmenu-close .ui-icon-circle-close {
    background: /*savepage-url=/ebok/javax.faces.resource/icon/close_icon.png.xhtml?ln=images*/ var(--savepage-url-15) no-repeat center center;
    width: 22px;
    height: 22px;
}

.ui-button.removeFileBtn {
    left: 110px;
    position: absolute;
    top: 0;
}

table.ui-fileupload-files {
    margin: 0;
}

.ui-fileupload-content .ui-messages-error {
    margin: 0 !important;
}

.ui-fileupload-content .ui-messages {
    display: none;
}

.ui-widget-header a.ui-selectcheckboxmenu-close.ui-state-hover {
    background: none;
    border-color: #fff;
    box-shadow: none;
}

div.pageContent .ui-selectonemenu,
body div.ui-selectonemenu.ui-widget,
div.pageContent ui-widget-content input.ui-inputfield,
body .ui-widget-content input.ui-inputfield,
body .ui-widget-content input[type="password"],
div.pageContent .ui-selectcheckboxmenu,
body div.ui-selectcheckboxmenu.ui-widget{
	border: 1px solid #c5c5cd;
	background: #fff;
	box-shadow: none;
	border-radius: 0;
	text-shadow: none;
	font-size: 14px;
	height: 32px;
	width: 100%;
	line-height: 25px;
	box-sizing: border-box;
	color: #73747f;
	font-weight: normal;
}
label.ui-state-error{color: #e30613;}
body input.ui-inputfield.ui-state-error,
body textarea.ui-inputtextarea.ui-state-error,
div.pageContent input.ui-inputfield.ui-state-error,
body div.ui-selectcheckboxmenu.ui-state-error,
body div.ui-selectonemenu.ui-state-error,
.ui-inputfield.ui-state-focus.ui-state-error,
.ui-widget-content .ui-inputfield.ui-state-focus.ui-state-error,
.ui-widget-header .ui-inputfield.ui-state-focus.ui-state-error  {
	width: 100%;
	border-color: #e30613;
}

div.pageContent .ui-selectonemenu,
div.pageContent .ui-selectcheckboxmenu,
body div.ui-selectonemenu.ui-widget,
body div.ui-selectcheckboxmenu.ui-widget {
    line-height: 30px;
}

div.pageContent .ui-selectonemenu label,
div.pageContent .ui-selectcheckboxmenu label,
body .ui-selectonemenu label.ui-selectonemenu-label,
body .ui-selectcheckboxmenu label.ui-selectcheckboxmenu-label {
    border-radius: 0;
    color: #73747f;
    height: 30px;
    box-shadow: none;
    box-sizing: border-box;
    padding: 0 8px;
    font-weight: normal;
    background: transparent none repeat scroll 0 0;
    width: 100% !important;
}

div.pageContent .ui-selectonemenu .ui-selectonemenu-trigger,
div.pageContent .ui-selectcheckboxmenu .ui-selectcheckboxmenu-trigger,
body .ui-selectonemenu .ui-selectonemenu-trigger,
body .ui-selectcheckboxmenu .ui-selectcheckboxmenu-trigger {
    width: 32px;
    background: #fff;
    padding: 0;
    border-radius: 0;
    border-left: 1px solid #c5c5cd;

}

body .ui-selectcheckboxmenu-header {
    background: rgba(0, 0, 0, 0) none repeat scroll 0 0;
    border: 0 none;
    padding: 5px 5px 0 5px;
}

div.pageContent .ui-selectonemenu span.ui-icon,
div.pageContent .ui-selectcheckboxmenu span.ui-icon,
body .ui-selectonemenu .ui-selectonemenu-trigger span.ui-icon,
body .ui-selectcheckboxmenu .ui-selectcheckboxmenu-trigger span.ui-icon {
    background: /*savepage-url=/ebok/javax.faces.resource/selectArrow.jpg.xhtml?ln=images*/ var(--savepage-url-40) no-repeat center center;
    display: inline-block;
    height: 100%;
    margin: 0;
    width: 100%;
}

div.pageContent .ui-selectonemenu .ui-state-hover span.ui-icon,
body .ui-selectonemenu .ui-selectonemenu-trigger .ui-state-hover span.ui-icon {
    box-shadow: 0px 0px 5px var(--company-dark);
    -moz-box-shadow: 0 0 5px var(--company-dark), inset 0 1px 0 #fff;
    -webkit-box-shadow: 0 0 5px var(--company-dark), inset 0 1px 0 #fff;
    border-radius: 2px;
}

div.pageContent .ui-chkbox .ui-state-hover span.ui-icon {
    box-shadow: 0px 0px 5px var(--company-dark);
    -moz-box-shadow: 0 0 5px var(--company-dark), inset 0 1px 0 #fff;
    -webkit-box-shadow: 0 0 5px var(--company-dark), inset 0 1px 0 #fff;
}

div.pageContent .ui-radiobutton .ui-state-hover span.ui-icon {
    box-shadow: 0px 0px 0px var(--company-dark);
    -moz-box-shadow: 0 0 0px var(--company-dark), inset 0 0px 0 #fff;
    -webkit-box-shadow: 0 0 0px var(--company-dark), inset 0 0px 0 #fff;
}

div.pageContent .ui-spinner .ui-state-hover span.ui-icon {
    box-shadow: 0px 0px 5px var(--company-dark);
    -moz-box-shadow: 0 0 5px var(--company-dark), inset 0 1px 0 #fff;
    -webkit-box-shadow: 0 0 5px var(--company-dark), inset 0 1px 0 #fff;
    border-radius: 2px;
}

div.pageContent a.ui-paginator-prev.ui-state-hover.ui-corner-all,
div.pageContent a.ui-paginator-next.ui-state-hover.ui-corner-all,
div.pageContent a.ui-paginator-first.ui-state-hover.ui-corner-all,
div.pageContent a.ui-paginator-last.ui-state-hover.ui-corner-all {
    box-shadow: 0px 0px 5px var(--company-dark);
    -moz-box-shadow: 0 0 5px var(--company-dark), inset 0 1px 0 #fff;
    -webkit-box-shadow: 0 0 5px var(--company-dark), inset 0 1px 0 #fff;
    border-radius: 2px;
}

div.pageContent select.ui-paginator-rpp-options.ui-state-hover.ui-corner-left,
div.pageContent select.ui-paginator-rpp-options.ui-state-focus.ui-corner-left {
    background-color: #FFF;
    box-shadow: 0px 0px 5px var(--company-dark);
    -moz-box-shadow: 0 0 5px var(--company-dark), inset 0 1px 0 #fff;
    -webkit-box-shadow: 0 0 5px var(--company-dark), inset 0 1px 0 #fff;
    border-radius: 2px;
}
div.pageContent a.ui-paginator-page.ui-state-hover.ui-corner-all{
	box-shadow: 0 0 5px var(--company-dark),inset 0 1px 0 #fff;
	-moz-box-shadow: 0 0 5px var(--company-dark),inset 0 1px 0 #fff;
	-webkit-box-shadow: 0 0 5px var(--company-dark),inset 0 1px 0 #fff;
	border-radius: 2px;
}
div.pageContent .ui-accordion .ui-accordion-header.ui-state-hover.ui-corner-all{
	box-shadow: 0 0 5px var(--company-dark),inset 0 1px 0 #fff;
	-moz-box-shadow: 0 0 5px var(--company-dark),inset 0 1px 0 #fff;
	-webkit-box-shadow: 0 0 5px var(--company-dark),inset 0 1px 0 #fff;
	border-radius: 2px;
}

textarea.ui-inputfield.ui-inputtextarea {
    border: 1px solid #c5c5cd;
    box-shadow: none;
    border-radius: 0;
    box-sizing: border-box;
    padding: 8px;
    min-height: 150px;
    color: #73747f;
}

.filterForm {
    position: relative;
    margin-bottom: 15px;
}

.filterForm.ui-outputpanel > span {
    display: inline-block;
    vertical-align: top;

}

.filterForm.ui-outputpanel > span > label {
    display: inline-block;
    width: 100%;
    color: var(--company-dark);
    font-size: 14px;
    margin-bottom: 5px;
}

.filterForm.ui-outputpanel > span > div {
    width: 100% !important;
}

.filterForm span.calendar,
.pageContent span.calendar {
    display: inline-block;
    position: relative;
}

.filterForm span.calendar input,
.pageContent span.calendar input {
    width: 100%;
}

.filterForm span.buttons,
form span.buttons {
    margin-top: 21px;
    text-align: right;
}

.buttons-admin {
    margin-top: 30px;
    text-align: center;
    display: block;
}

.dialog-buttons {
    display: block;
    text-align: center;
}

.ui-inputfield.ui-state-focus,
.ui-widget-content .ui-inputfield.ui-state-focus,
.ui-widget-header .ui-inputfield.ui-state-focus {
    box-shadow: none;
    border-color: var(--company-dark);
    color: var(--company-dark);
}

.ui_tpicker_time_input {
    border-bottom: 0px !important;
}

.clear {
    clear: both;
}

.right {
    float: right;
}

.left {
    float: left;
}

div.templateFooter .phones {
    display: inline-block;
    vertical-align: top;
    width: 59%;
}

div.templateFooter .mobileApps {
    display: inline-block;
    width: 39%;
    text-align: right;
}

div.templateFooter .mobileApps a:first-child img {
    margin-right: 15px;
}

div.templateFooter .mobileApps > div:first-child {
    color: #000000;
    font-family: "SourceSansPro", "Source Sans Pro", Verdana, sans-serif;
    font-size: 23px;
    line-height: 28px;
    padding: 15px 0 6px;
    font-weight: 700;
}

div.templateFooter .mobileApps img {
    max-height: 50px;
}

div.templateFooter div.phone,
div.templateFooter div.phone2,
div.templateFooter div.mail,
div.templateFooter div.faq {
	padding-left: 20px;
	box-sizing: border-box;
}

div.templateFooter .phone-icon,
div.templateFooter .phone2-icon,
div.templateFooter .mail-icon,
div.templateFooter .faq-icon,
div.templateFooter .bok-icon {
	background-image: /*savepage-url=/ebok/javax.faces.resource/icon/footer-phone-icon.png.xhtml?ln=images*/ var(--savepage-url-42);
	display: inline-block;
	width: 30px;
	height: 30px;
	background-size: cover;
	background-position: center center;
	margin-right: 15px;
	vertical-align: -7px;
}

div.templateFooter .phone2-icon {
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/footer-phone2-icon.png.xhtml?ln=images*/ var(--savepage-url-44);
}

div.templateFooter .mail-icon {
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/footer-mail-icon.png.xhtml?ln=images*/ var(--savepage-url-43);
}

div.templateFooter .faq-icon {
	background-image: /*savepage-url=/ebok/javax.faces.resource/icon/footer-faq-icon.png.xhtml?ln=images*/ var(--savepage-url-45);
}

div.templateFooter .bok-icon {
    background-image: /*savepage-url=/ebok/javax.faces.resource/tile-icons/icon-12.png.xhtml?ln=images*/ var(--savepage-url-34);
}

/*
div.templateFooter div.phone:before,
div.templateFooter div.phone2:before,
div.templateFooter div.mail:before{
	background-image: url("/ebok/javax.faces.resource/icon/footer-phone-icon.png.xhtml?ln=images");
	content: "";
	display: inline-block;
	vertical-align: -8px;
    width: 30px;
    height: 30px;
	background-size: cover;
	background-position: center center;
	margin-right: 15px;
	vertical-align: -7px;

}
div.templateFooter div.phone2:before{
	background-image: url("/ebok/javax.faces.resource/icon/footer-phone2-icon.png.xhtml?ln=images");
}
div.templateFooter div.mail:before{
	background-image: url("/ebok/javax.faces.resource/icon/footer-mail-icon.png.xhtml?ln=images");
}
*/

div.templateFooter .phone > label,
div.templateFooter .phone > a,
div.templateFooter .phone > form > a,
div.templateFooter .phone2 > label,
div.templateFooter .phone2 > a,
div.templateFooter .mail > label,
div.templateFooter .mail > a,
div.templateFooter .faq > label,
div.templateFooter .faq > a {
	font-weight: 700;
	font-family: "SourceSansPro","Source Sans Pro",Verdana,sans-serif;
}

div.templateFooter div.phone a.orange,
div.templateFooter div.phone2 a.orange,
div.templateFooter div.mail a.orange {
    color: #f07d00 !important;
}

div.templateFooter label.blue {
    color: #0c3274;
}

div.templateFooter label.orange,
div.templateFooter a.orange {
    color: #f07d00;
}

div.templateFooter label.company-dark,
div.templateFooter a.company-dark {
    color: var(--company-dark);
}

.textRight {
    text-align: right;
}

.textCenter {
    text-align: center;
}

.textLeft {
    text-align: left !important;
}

div.templateFooter div.copy {
    border-top: 1px solid #e1e2e7;
    color: #000000;
    font-size: 12px;
    line-height: 25px;
    padding: 0 20px;
}

div.footerImg {
    position: relative;
    overflow: auto;
    display: block;
    height: 100%;
    width: 100%;
    background-image: /*savepage-url=/ebok/javax.faces.resource/footer.svg.xhtml?ln=images*/ var(--savepage-url-48);
    background-size: cover;
    padding: 0 0 34% 0px;
}

div.pageContent .ui-panel .connectionError {
    border: 1px solid var(--company-dark);
    text-align: center;
    padding: 30px;
}

div.pageContent .ui-panel .connectionError .blue {
    font-size: 18px;
    color: #0c3274;
    line-height: 35px;
}

div.pageContent .ui-panel .connectionError .ui-widget-content {
    font-size: 14px;
    color: #73747f;
}
table.taskDetails{
	border-spacing: 0;
	border-collapse: unset;
}

div.pageContent .ui-datatable.dark table.taskDetails tbody td {
    vertical-align: top;
    padding: 15px 10px;
    border-bottom: 1px solid #e1e2e7;
    border-left: 0;
    border-right: 0;
    border-top: 0;
}

table.taskDetails textarea {
    border: 1px solid #c5c5cd;
    border-radius: 0;
    box-shadow: none;
    height: 150px;
    width: 100%;
    box-sizing: border-box;
}

.chartWrongData label {
    font-size: 14px;
    color: #e30613;
}

.ui-fileupload span.ui-button {
    /* IE9 SVG, needs conditional override of 'filter' to 'none' */
    background: url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2Y1ODcyOSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNjYjVkMDIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+);
    background: -moz-linear-gradient(top, var(--company-dark) 0%, var(--company-dark) 100%); /* FF3.6+ */
    background: -webkit-gradient(linear, left top, left bottom, color-stop(0%, #1A7466), color-stop(100%, #1A7466)); /* Chrome,Safari4+ */
    background: -webkit-linear-gradient(top, var(--company-dark) 0%, var(--company-dark) 100%); /* Chrome10+,Safari5.1+ */
    background: -o-linear-gradient(top, var(--company-dark) 0%, var(--company-dark) 100%); /* Opera 11.10+ */
    background: -ms-linear-gradient(top, var(--company-dark) 0%, var(--company-dark) 100%); /* IE10+ */
    background: linear-gradient(to bottom, var(--company-dark) 0%, var(--company-dark) 100%); /* W3C */
    filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='#1A7466', endColorstr='#1A7466', GradientType=0); /* IE6-8 */
    text-shadow: none;
    border: 0;
    color: #fff;
    font-size: 14px;
    height: 32px;
    line-height: 32px;
    font-weight: normal;
    box-shadow: 0 0 5px rgba(0, 0, 0, 0.18);
    border-radius: 0;
}

.ui-fileupload span.ui-button:hover {
    background: #072c73; /* Old browsers */
    /* IE9 SVG, needs conditional override of 'filter' to 'none' */
    background: url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iIzA3MmM3MyIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiMwMTBlNGUiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+);
    background: -moz-linear-gradient(top, var(--company-normal) 0%, var(--company-normal) 100%); /* FF3.6+ */
    background: -webkit-gradient(linear, left top, left bottom, color-stop(0%, var(--company-normal)), color-stop(100%, var(--company-normal))); /* Chrome,Safari4+ */
    background: -webkit-linear-gradient(top, var(--company-normal) 0%, var(--company-normal) 100%); /* Chrome10+,Safari5.1+ */
    background: -o-linear-gradient(top, var(--company-normal) 0%, var(--company-normal) 100%); /* Opera 11.10+ */
    background: -ms-linear-gradient(top, var(--company-normal) 0%, var(--company-normal) 100%); /* IE10+ */
    background: linear-gradient(to bottom, var(--company-normal) 0%, var(--company-normal) 100%); /* W3C */
    filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='#10a38b', endColorstr='#10a38b', GradientType=0); /* IE6-8 */
}

.ui-fileupload div.ui-fileupload-buttonbar {
    padding: 0;
    margin: 0;
    line-height: 0;
}

.ui-fileupload div.ui-fileupload-content {
    border: 0;
    padding: 0;
}
.ui-fileupload  div.ui-fileupload-content button.ui-fileupload-cancel{
	background: none;
}
div.pageContent .balancePanel,
div.pageContent .accountPanel {
    border: 1px solid #e1e2e7;
    box-sizing: border-box;
    height: 126px;
    overflow: hidden;
    padding: 0px 10px;
}

div.pageContent .accountPanel {
    padding: 13px 20px;
}

div.pageContent .balancePanel.blue {
    height: 100px;
}

div.pageContent .balancePanel.company-dark {
    height: 100px;
}

div.pageContent .toggleablePanel .ui-panel-titlebar {
    border-bottom: 1px solid #e1e2e7;
    border-radius: 0;
    padding-bottom: 1px;
    font-size: 16px;
    line-height: 16px;
    color: #73747f;
}

div.pageContent .balancePanel .ui-panel-titlebar,
div.pageContent .accountPanel .ui-panel-titlebar {
    border-bottom: 1px solid #e1e2e7;
    border-radius: 0;
    padding: 8px 0px;
    font-size: 16px;
    line-height: 16px;
}

div.pageContent .accountPanel .ui-widget-header {
    margin: 0;
}

div.pageContent .balancePanel .ui-widget-header .ui-panel-title,
div.pageContent .accountPanel .ui-widget-header .ui-panel-title {
    color: var(--company-dark);
    font-size: 14px;
    font-family: Verdana, sans-serif;
    line-height: 20px;
    font-weight: 400;
    padding: 0;
    word-wrap: normal;
}

div.pageContent .balancePanel.company-text-data .ui-widget-header .ui-panel-title,
div.pageContent .accountPanel.company-text-data .ui-widget-header .ui-panel-title {
    color: #000000;
    font-size: 14px;
    font-family: Verdana, sans-serif;
    line-height: 20px;
    font-weight: 400;
    padding: 0;
    word-wrap: normal;
}

div.pageContent .balancePanel.balanceGray .ui-widget-header .ui-panel-title {
    color: #73747F;
    font-size: 14px;
    font-family: Verdana, sans-serif;
    line-height: 20px;
    font-weight: 400;
    padding: 0;
    word-wrap: normal;
}

div.pageContent .balancePanel.blue .ui-widget-header .ui-panel-title,
div.pageContent .accountPanel.blue .ui-widget-header .ui-panel-title {
    color: #0c3274;
}

div.pageContent .balancePanel.company-middle .ui-widget-header .ui-panel-title,
div.pageContent .accountPanel.company-middle .ui-widget-header .ui-panel-title {
    color: var(--company-middle);
}

div.pageContent .balancePanel label,
div.pageContent .accountPanel label {
    color: var(--company-dark);
    font-family: "SourceSansPro", "Source Sans Pro", Verdana, sans-serif;
    font-size: 60px;
    line-height: 78px;
    font-weight: 400;
}

div.pageContent .balancePanel.company-text-data label,
div.pageContent .accountPanel.company-text-data label {
    color: #000000;
    font-family: "SourceSansPro", "Source Sans Pro", Verdana, sans-serif;
    font-size: 60px;
    line-height: 78px;
    font-weight: 400;
}

div.pageContent .balancePanel.blue label,
div.pageContent .accountPanel.blue label {
    color: #0c3274;
    font-size: 34px;
    line-height: 50px;
    font-weight: 700;
}

div.pageContent .balancePanel.company-dark label,
div.pageContent .accountPanel.company-dark label {
    color: var(--company-dark);
    font-size: 34px;
    line-height: 50px;
    font-weight: 700;
}

div.pageContent .accountPanel {
    height: auto;
    overflow: hidden;
}

div.pageContent .accountPanel label,
div.pageContent .accountPanel.blue label {
    font-size: 18px;
    line-height: 24px;
    font-weight: 700;
}

div.pageContent .accountPanel.company-dark label {
    font-size: 18px;
    line-height: 24px;
    font-weight: 700;
}

div.pageContent .accountPanel label {
    font-size: 22px;
    line-height: 24px;
}

.offerTable thead {
    display: none;
}

.offerTable.ui-datatable .ui-widget-content {
    border: 0;
    border-top: 1px solid #e1e2e7;
}

.offerTable.ui-datatable .ui-expanded-row-content.ui-widget-content {
    border: 0;
}

.offerTable.ui-datatable td {
    font-size: 24px;
    height: 70px;
    line-height: 24px;
    border: 0;
    padding: 0;
}

.offerTable td.toggler {
    width: 35px;
}

.offerTable .ui-datatable-odd {
    background: none;
}

.szczegoly-komunikat-tresc-ebok img {
    width: auto;
    height: auto;
}

.img-oferta-overview {
    margin: auto;
    text-align: center;
}

.img-oferta-overview img {
    max-width: 377px;
}

.img-oferta-flex {
    margin: auto;
    display: flex;
    flex: 1;
}

.szczegolyOfertyContent > div {
    display: flex;
}

.offer-description-wrapper {
    flex: 1;
}

.offer-description {
    width: 100%;
}

.offer-img-wrapper {
    flex: 0;
}

.offer-img-wrapper-flex {
    flex: 1;
}

.img-oferta-szczegoly-top-left {
    display: flex;
    justify-content: flex-start;
    align-items: flex-start;
}

.img-oferta-szczegoly-top-center {
    display: flex;
    justify-content: center;
    align-items: flex-start;
}

.img-oferta-szczegoly-top-right {
    display: flex;
    justify-content: flex-end;
    align-items: flex-start;
}

.img-oferta-szczegoly-center-left {
    display: flex;
    justify-content: flex-start;
    align-items: center;
}

.img-oferta-szczegoly-center-center {
    display: flex;
    justify-content: center;
    align-items: center;
}

.img-oferta-szczegoly-center-right {
    display: flex;
    justify-content: flex-end;
    align-items: center;
}

.img-oferta-szczegoly-bottom-left {
    display: flex;
    justify-content: flex-start;
    align-items: flex-end;
}

.img-oferta-szczegoly-bottom-center {
    display: flex;
    justify-content: center;
    align-items: flex-end;
}

.img-oferta-szczegoly-bottom-right {
    display: flex;
    justify-content: flex-end;
    align-items: flex-end;
}

.ui-dialog .ui-wizard-step-titles {
    text-align: center;
}

.ui-dialog .ui-wizard-step-title {
    background: none repeat scroll 0 0 rgba(0, 0, 0, 0);
    border: 0 none;
    box-shadow: none;
    color: #73747f;
    font-weigh: normal;
    display: inline-block;
    float: none;
    font-size: 18px;
    margin: 0;
    padding: 5px 10px;
    text-shadow: none;
}

.ui-dialog .ui-wizard-step-title.ui-state-highlight {
    color: #0c3274;
}

.kwh {
    float: right;
    position: relative;
    right: 10px;
    text-align: right;
    top: -26px;
}

dt.ui-datalist-item > div {
    border: 1px solid #e1e2e7;
    box-sizing: border-box;
    color: #0c3274;
    line-height: 25px;
    padding: 10px;
    margin-bottom: 4px;
    overflow: hidden;
}

.popup-notification dt.ui-datalist-item > div {
    border: 0;
}

div.pageContent .popup-notification .ui-chkbox .ui-chkbox-box {
    vertical-align: middle;
}

.pageContent .ui-tabs,
.pageContent .ui-tabs ul.ui-tabs-nav,
body .ui-tabs ul.ui-tabs-nav, body .ui-tabs,
body .ui-tabs.ui-tabs-top > .ui-tabs-nav {
    margin: 0;
    padding: 0;
}

.ui-tabs ul.ui-tabs-nav li {
    display: inline-block;
    float: none;
    margin: 0;
    box-sizing: border-box;
}

.ui-tabs ul.ui-tabs-nav li {
    box-shadow: none;
    background: #eee;
}

.ui-tabs ul.ui-tabs-nav li a {
    display: inline-block;
    float: none;
    font-size: 15px;
    line-height: 22px;
    padding: 10px 12px;
    text-decoration: none;
    vertical-align: top;
    font-weight: normal;
    letter-spacing: -0.3px;
}

.ui-tabs ul.ui-tabs-nav li.ui-state-hover a {
    color: var(--company-dark);
}

.ui-tabs ul.ui-tabs-nav li.ui-state-active a {
    color: var(--company-dark);
}

.userDataInfoBox {
    position: absolute;
    right: 0;
    width: 290px;
}

.noticeUserBox {
    display: inline-block;
    height: 105px;
    text-align: center;
    vertical-align: middle;
    width: 25%;
    border: 1px solid #e1e2e7;
    box-sizing: border-box;
}

.noticeUserBox label {
    background: none repeat scroll 0 0 #9a96a2;
    box-sizing: border-box;
    color: #fff;
    display: block;
    font-size: 16px !important;
    padding: 15px;
}

.pageContent .ui-tabs .ui-tabs-panel, body .ui-tabs .ui-tabs-panel {
    background: none repeat scroll 0 0 rgba(0, 0, 0, 0);
    border-width: 0;
    padding: 0;
}

.accountBox,
div.pageContent .ui-panel.accountBox {
    background: #f7f7f7 none repeat scroll 0 0;
    padding: 20px;
}

div.pageContent .ui-datatable.dark.admin .ui-datatable-data tr.red_row {
    border-left: 3px solid #e30613;
    color: #e30613;
}

div.pageContent .ui-datatable.dark.admin .ui-datatable-data tr.green_row {
    border-left: 1px solid var(--company-dark);
}

.offerTable .ui-icon,
.green_row .ui-icon,
.red_row .ui-icon,
.yellow_row .ui-icon,
.grey_row .ui-icon,
.defaut_row .ui-icon {
    width: 23px;
    height: 23px;
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/expand_icon.png.xhtml?ln=images*/ url();
    display: inline-block;
    vertical-align: -5px;
    margin-right: 5px;
}
.offerTable .ui-icon.ui-icon-circle-triangle-e,
.green_row .ui-icon.ui-icon-circle-triangle-e,
.defaut_row .ui-icon.ui-icon-circle-triangle-e,
.green_row .ui-icon.ui-icon-triangle-1-e {
    background-position: left -46px;
}
.offerTable .ui-icon.ui-icon-circle-triangle-s,
.green_row .ui-icon.ui-icon-circle-triangle-s,
.defaut_row .ui-icon.ui-icon-circle-triangle-s,
.green_row .ui-icon.ui-icon-triangle-1-s {
    background-position: right -46px;
}

.red_row .ui-icon.ui-icon-circle-triangle-e {
    background-position: left top;
}

.red_row .ui-icon.ui-icon-circle-triangle-s {
    background-position: right top;
}

.grey_row .ui-icon.ui-icon-circle-triangle-e {
    background-position: left bottom;
}

.grey_row .ui-icon.ui-icon-circle-triangle-s {
    background-position: right bottom;
}
.yellow_row .ui-icon.ui-icon-circle-triangle-e{
	background-position: left -23px;
}
.yellow_row .ui-icon.ui-icon-circle-triangle-s{
	background-position: right -23px;
}

div.pageContent .ui-datatable.invoice tbody .green_row td,
div.pageContent .ui-datatable.invoice .defaut_row td {
    color: var(--company-dark);
    font-size: 14px;
    letter-spacing: -0.5px;
}

div.pageContent .ui-datatable.invoice tbody .green_row td .color,
div.pageContent .ui-datatable.invoice tbody .defaut_row td .color {
    color: var(--company-dark);
    word-wrap: break-word;
    white-space: pre-wrap;
}

div.pageContent .ui-datatable.invoice .red_row td {
    color: #e30613;
    font-size: 14px;
    letter-spacing: -0.5px;
}

div.pageContent .ui-datatable.invoice tbody .red_row td .color {
    color: #e30613;
}

div.pageContent .ui-datatable.invoice .yellow_row td {
    color: #f07d00;
    font-size: 14px;
    letter-spacing: -0.5px;
}

.invoice tr {
    background: none;
}

.processingInvoice tr {
    background-color: #f7f7f7 !important;
}

div.pageContent .ui-datatable.invoice tbody .yellow_row td .color {
    color: var(--company-dark);
}

div.pageContent .ui-datatable.invoice .grey_row td {
    color: #73747f;
    font-size: 14px;
    letter-spacing: -0.5px;
}

div.pageContent .ui-datatable.invoice tbody .grey_row td .color {
    color: #73747f;
}

.invoice tr {
    background: none;
}

div.pageContent .ui-datatable.invoice tbody td {
    padding: 10px 5px;
}

div.pageContent .ui-datatable.invoice .invoice-details table {
    border-spacing: 0 5px;
    border-collapse: separate;
}

div.pageContent .ui-datatable.invoice .invoice-details table th {
    font-size: 11px;
    background: #f7f7f7;
    color: #73747f;
    border: 1px solid #f7f7f7;
    padding: 3px;
    white-space: normal;
    text-align: center;
    letter-spacing: -0.7px;
}

.regulaminBox a {
    color: #0c3274 !important;
}

.regulaminBox a span {
    color: #0c3274 !important;
}

.regulaminBox {
    height: 400px;
    overflow: auto;
    box-sizing: border-box;
    display: block;
    height: 400px;
    overflow: auto;
    padding: 20px;
    border: 1px solid #ccc;
}

div.pageContent .ui-datatable.invoice .invoice-details table th .ui-sortable-column-icon {
    display: none;
}

div.pageContent .ui-datatable.invoice .invoice-details table td {
    border-top: 1px solid #e1e2e7;
    font-size: 11px;
    text-overflow: ellipsis;
    padding: 10px 4px;
    height: 63px;
    line-height: 12px;
    letter-spacing: -0.5px;
    color: #73747f;
}

.breakWord {
    word-wrap: break-word;
}

div.ui-dialog.preloader {
    background: rgba(122, 122, 122, 0.3) none repeat scroll 0 0;
    height: 100% !important;
    left: 0 !important;
    position: fixed;
    text-align: center;
    top: 0 !important;
    width: 100% !important;
    z-index: 1099;
    border: 0;
    right: 0;
    bottom: 0;
}

.preloader > div.ui-dialog-content {
    background: #fff none repeat scroll 0 0;
    border: 1px solid #ccc;
    box-shadow: 0 0 0 1px #fff;
    display: block;
    left: 40%;
    left: calc(50% - 120px);
    margin: auto;
    padding: 20px;
    position: absolute;
    top: 40%;
    top: calc(50% - 120px);
    width: 200px;

}

.preloader > div > span {
    font-size: 17px;
    font-weight: bold;
    text-shadow: 1px 1px 0px #000;
}

.box-icon:before, .box-icon-dynamic:before {
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/box_icon.png.xhtml?ln=images*/ var(--savepage-url-26);
    background-repeat: no-repeat;
    content: "";
    height: 40px;
    position: absolute;
    right: 20px;
    width: 40px;
}

.box-icon-dynamic:before {
    background-image: none;
    background-position: center center;
    background-size: cover;
}

.box-account:before {
    background-size: cover;
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/account_icon.png.xhtml?ln=images*/ url();
}

.box-icon.biezace-saldo-icon:before {
    background-position: 0 top;
    width: 45px;
}

.box-icon.prepaid-icon:before {
    background-position: -122px top;
}

.box-icon.oferty-icon:before {
    background-position: -45px top;
    width: 37px;
}

.box-icon.komunikaty-icon:before {
    background-position: -83px top;
}

.box-icon.twoje-zuzycie-icon:before {
    background-position: -162px top;
}

.box-icon.faktury-icon:before {
    background-position: 0 -39px;
    width: 33px;
}

.box-icon.masz-pytanie-icon:before {
    background-position: -34px -40px;
}

.box-icon.archiwum-icon:before {
    background-position: -114px -40px;
}

div.pageContent .ui-panel.zamowic-usluge-icon .ui-panel-title {
    letter-spacing: -1.7px;
}

.box-icon.zamowic-usluge-icon:before {
    background-position: -73px -40px;
}

.box-icon.kalkulator-icon:before {
    background-position: -154px -39px;
    width: 33px;
}

.box-icon.symulacja-icon:before {
    background-position: -202px 0;
}

.box-icon.dokumenty-icon:before {
    background-position: -271px -58px;
}

.box-icon.login-icon:before {
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/login_icon.png.xhtml?ln=images*/ url();
    background-position: 0 0;
    background-size: cover;
    height: 40px;
    width: 40px;
}

.box-icon.register-icon:before {
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/register_icon.png.xhtml?ln=images*/ url();
    background-position: 0 0;
    background-size: cover;
    height: 40px;
    width: 40px;
}

.box-icon-dynamic.icon-1:before {
    background-image: /*savepage-url=/ebok/javax.faces.resource/tile-icons/icon-1.png.xhtml?ln=images*/ var(--savepage-url-31);
}

.box-icon-dynamic.icon-2:before {
    background-image: /*savepage-url=/ebok/javax.faces.resource/tile-icons/icon-2.png.xhtml?ln=images*/ url();
}

.box-icon-dynamic.icon-3:before {
    background-image: /*savepage-url=/ebok/javax.faces.resource/tile-icons/icon-3.png.xhtml?ln=images*/ url();
}

.box-icon-dynamic.icon-4:before {
    background-image: /*savepage-url=/ebok/javax.faces.resource/tile-icons/icon-4.png.xhtml?ln=images*/ url();
}

.box-icon-dynamic.icon-5:before {
    background-image: /*savepage-url=/ebok/javax.faces.resource/tile-icons/icon-5.png.xhtml?ln=images*/ url();
}

.box-icon-dynamic.icon-6:before {
    background-image: /*savepage-url=/ebok/javax.faces.resource/tile-icons/icon-6.png.xhtml?ln=images*/ url();
}

.box-icon-dynamic.icon-7:before {
    background-image: /*savepage-url=/ebok/javax.faces.resource/tile-icons/icon-7.png.xhtml?ln=images*/ url();
}

.box-icon-dynamic.icon-8:before {
    background-image: /*savepage-url=/ebok/javax.faces.resource/tile-icons/icon-8.png.xhtml?ln=images*/ url();
}

.box-icon-dynamic.icon-9:before {
    background-image: /*savepage-url=/ebok/javax.faces.resource/tile-icons/icon-9.png.xhtml?ln=images*/ url();
}

.box-icon-dynamic.icon-10:before {
    background-image: /*savepage-url=/ebok/javax.faces.resource/tile-icons/icon-10.png.xhtml?ln=images*/ url();
}

.box-icon-dynamic.icon-11:before {
    background-image: /*savepage-url=/ebok/javax.faces.resource/tile-icons/icon-11.png.xhtml?ln=images*/ url();
}

.box-icon-dynamic.icon-12:before {
    background-image: /*savepage-url=/ebok/javax.faces.resource/tile-icons/icon-12.png.xhtml?ln=images*/ var(--savepage-url-34);
}

.box-icon-dynamic.icon-13:before {
    background-image: /*savepage-url=/ebok/javax.faces.resource/tile-icons/icon-13.png.xhtml?ln=images*/ url();
}

.box-icon-dynamic.icon-14:before {
    background-image: /*savepage-url=/ebok/javax.faces.resource/tile-icons/icon-14.png.xhtml?ln=images*/ url();
}

.box-icon-dynamic.icon-15:before {
    background-image: /*savepage-url=/ebok/javax.faces.resource/tile-icons/icon-15.png.xhtml?ln=images*/ url();
}

.box-icon-dynamic.icon-16:before {
    background-image: /*savepage-url=/ebok/javax.faces.resource/tile-icons/icon-16.png.xhtml?ln=images*/ url();
}

.box-icon-dynamic.icon-17:before {
    background-image: /*savepage-url=/ebok/javax.faces.resource/tile-icons/icon-17.png.xhtml?ln=images*/ url();
}

.box-icon-dynamic.icon-18:before {
    background-image: /*savepage-url=/ebok/javax.faces.resource/tile-icons/icon-18.png.xhtml?ln=images*/ url();
}

.box-icon-dynamic.icon-19:before {
    background-image: /*savepage-url=/ebok/javax.faces.resource/tile-icons/icon-19.png.xhtml?ln=images*/ url();
}

.info-icon:before {
    background-position: center center;
    content: "";
    display: inline-block;
    float: left;
    height: 22px;
    margin-right: 10px;
    vertical-align: 0;
    width: 22px;
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/info_icon.png.xhtml?ln=images*/ url();
}

button.ui-button.ui-state-default.help-pas-icon {
    content: "";
    display: inline-block;
    height: 22px;
    margin-right: 10px;
    width: 22px;
    cursor: pointer;
    margin-left: 10px;
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/help_icon.png.xhtml?ln=images*/ var(--savepage-url-30);
    box-shadow: none;
    vertical-align: -5px;
}

button.ui-button.ui-state-default.help-pas-icon .ui-button-icon-left {
    background: none !important;
}

button.ui-button.ui-state-default.googleBtn {
    background: /*savepage-url=/ebok/javax.faces.resource/btn_google.svg.xhtml?ln=images*/ url() no-repeat center center;
    box-shadow: none;
    height: 48px;
    vertical-align: top;
    width: 200px;
    font-size: 11px;
    font-family: Arial;
    filter: none;
    text-align: right;
    padding-right: 3px;
}

button.ui-button.ui-state-default.googleBtn.usun {
    background: /*savepage-url=/ebok/javax.faces.resource/btn_google_usun.svg.xhtml?ln=images*/ url() no-repeat center center;
    margin-left: 0px;
}

button.ui-button.ui-state-default.googleBtn.powiaz {
    background: /*savepage-url=/ebok/javax.faces.resource/btn_google_powiaz.svg.xhtml?ln=images*/ url() no-repeat center center;
    margin-left: 0px;
}

button.ui-button.ui-state-default.facebookBtn {
    border-radius: 2px;
    height: 40px;
    background: #3c579e none repeat scroll 0 0;
    font-size: 10px;
    filter: none;
    width: 200px;
}

button.ui-button.ui-state-default.facebookBtn {
    background: /*savepage-url=/ebok/javax.faces.resource/btn_facebook.svg.xhtml?ln=images*/ url() no-repeat center center;
    box-shadow: none;
    height: 48px;
    vertical-align: top;
    filter: none;
    text-align: right;
    font-size: 11px;
    font-family: Arial;
}

button.ui-button.ui-state-default.facebookBtn.powiaz {
    background: /*savepage-url=/ebok/javax.faces.resource/btn_facebook_powiaz.svg.xhtml?ln=images*/ url() no-repeat center center;
}

button.ui-button.ui-state-default.facebookBtn.usun {
    background: /*savepage-url=/ebok/javax.faces.resource/btn_facebook_usun.svg.xhtml?ln=images*/ url() no-repeat center center;
}

button.ui-button.ui-state-default.facebookBtn .ui-button-text.ui-c {
    padding-left: 45px;
}

.buttonSpacer {
    margin-right: 10px !important;
}

.orLoginWith {
    background: #fff none repeat scroll 0 0;
    left: 125px;
    padding: 0 20px;
    position: absolute;
    top: -10px;
}

.relative .help-pas-icon {
    left: 400px;
    position: absolute;
    top: 35px;
}

.tooltip {
    display: none;
}

.info-pow-icon:before {
    background-position: center center;
    content: "";
    display: inline-block;
    float: left;
    height: 22px;
    margin-right: 10px;
    vertical-align: 0;
    width: 22px;
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/info_icon.png.xhtml?ln=images*/ url();
}

div.pageContent .ui-datatable.notification tbody .ui-datatable-empty-message td {
    padding: 10px;
}

.info-icon {
    vertical-align: top;
}

.delete-icon,
button.ui-button.ui-state-default.delete-icon {
    content: "";
    display: inline-block;
    height: 22px;
    width: 22px;
    background: /*savepage-url=/ebok/javax.faces.resource/icon/del_icon.png.xhtml?ln=images*/ var(--savepage-url-28) no-repeat #fff;
    box-shadow: none;
}

button.ui-button.ui-state-default.delete-icon {
    width: auto;
    color: #73747f;
}

button.hidden {
    display: none !important;
}

div.pageContent button.delete-icon .ui-button-text.ui-c {
    padding: 0 0 0 30px;
}

.transparent button.ui-button.ui-state-default.delete-icon span {
    padding: 0 0 0 30px;
}

.notification td span, .notification td a, .notification td,
.notification dt span, .notification dt a {
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    color: var(--company-dark);
}

button.ui-button.ui-state-default.delete-icon {
    font-size: 12px;
}

.komunikat_bold, .komunikat_bold a, .komunikat_bold span {
    font-weight: bold;
}

.notification-icon span:first-child:before {
    content: "";
    display: inline-block;
    height: 20px;
    margin-right: 5px;
    vertical-align: -4px;
    width: 20px;
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/notification_icon.png.xhtml?ln=images*/ url();
    background-repeat: no-repeat;
}

.notification-icon span.INFO-notification-icon:first-child:before{
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/ic_about_app_green.svg.xhtml?ln=images*/ var(--savepage-url-29);
    background-size: 18px;
    background-position-x: center;
    background-position-y: center;
}

.notification-icon span.WINDY-notification-icon:first-child:before{
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/ic_alert.svg.xhtml?ln=images*/ var(--savepage-url-27);
    filter: invert(67%) sepia(89%) saturate(7492%) hue-rotate(346deg) brightness(84%) contrast(146%);
    background-size: 18px;
    background-position-x: center;
    background-position-y: center;
}

.notification-icon span.INFOSPR-notification-icon:first-child:before{
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/ic_message_green.svg.xhtml?ln=images*/ url();
    background-size: 18px;
    background-position-x: center;
    background-position-y: center;
}

.notification-icon span.PROMO-notification-icon:first-child:before{
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/ic_about_app.svg.xhtml?ln=images*/ url();
    background-size: 18px;
    background-position-x: center;
    background-position-y: center;
}

.notification-icon span.OSTRZEG-notification-icon:first-child:before{
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/ic_about_app.svg.xhtml?ln=images*/ url();
    background-size: 18px;
    background-position-x: center;
    background-position-y: center;
}

.notification-icon span.INFOSIE-notification-icon:first-child:before{
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/ic_about_app.svg.xhtml?ln=images*/ url();
    background-size: 18px;
    background-position-x: center;
    background-position-y: center;
}

.notification-icon span.INNA_ADHOC-notification-icon:first-child:before{
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/ic_about_app.svg.xhtml?ln=images*/ url();
    background-size: 18px;
    background-position-x: center;
    background-position-y: center;
}

span.koszyk_zolty:before {
    background-position: -20px 0;
}

span.koszyk_czerwony:before {
    background-position: -40px 0px;
}

span.koszyk_niebieski:before {
    background-position: 0px 0px;
}

span.inny_zolty:before {
    background-position: -19px -120px;
}

span.inny_czerwony:before {
    background-position: -41px -120px;
}

span.inny_niebieski:before {
    background-position: 0 -120px;
}

span.zegar:before {
    background-position: 3px -61px;
    height: 18px;
}

span.dolar:before {
    background-position: -38px -61px;
    height: 18px;
}

span.awaria_czerwony:before {
    background-position: -36px -82px;
    height: 18px;
}

span.awaria_zolty:before {
    background-position: -18px -82px;
    height: 18px;
}

span.awaria_niebieski:before {
    background-position: 5px -82px;
    height: 18px;
}

span.dokument:before {
    background-position: 4px -41px;
}

span.gwiazda:before {
    background-position: 2px -20px;
}

span.windykacja:before {
    background-position: -36px -100px;
}

span.red_gwiazda:before {
    background-position: -41px -20px
}

span.red_dokument:before {
    background-position: -38px -41px;
}

span.red_zegar:before {
    background-position: -38px -61px;
    height: 18px;
}

span.red_dolar:before {
    background-position: -38px -61px;
    height: 18px;
}

span.red_awaria_niebieski:before {
    background-position: -36px -82px;
    height: 18px;
}

span.red_awaria_zolty:before {
    background-position: -36px -82px;
    height: 18px;
}

span.red_awaria_czerwony:before {
    background-position: -36px -82px;
    height: 18px;
}

span.red_koszyk_niebieski:before {
    background-position: -40px 0px
}

span.red_koszyk_zolty:before {
    background-position: -40px 0;
}

span.red_koszyk_czerwony:before {
    background-position: -40px 0px;
}

span.red_inny_niebieski:before {
    background-position: -41px -120px;
}

span.red_inny_zolty:before {
    background-position: -41px -120px;
}

span.red_inny_czerwony:before {
    background-position: -41px -120px;
}

.komunikat_standardowy {
    font-weight: normal;
}

.notification .inny_zolty a, .inny_zolty span, .inny_zolty, .notification .inny_zolty,
.komunikat_zolty a, .komunikat_zolty span, .komunikat_zolty,
.notification span.koszyk_zolty, .notification dt .koszyk_zolty a, .notification .koszyk_zolty td a,
.notification span.awaria_zolty, .notification dt .awaria_zolty a, .notification .awaria_zolty td a {
    color: #f07d00;
}

.inny_czerwony a, .inny_czerwony span, .inny_czerwony, .notification .inny_czerwony a, .notification .inny_czerwony,
.komunikat_czerwony a, .komunikat_czerwony span, .komunikat_czerwony,
.notification span.awaria_czerwony, .notification dt .awaria_czerwony a, .notification .awaria_czerwony td a,
.notification span.koszyk_czerwony, .notification dt .koszyk_czerwony a, .notification .koszyk_czerwony td a,
.notification span.dolar, .notification dt .dolar a, .notification .dolar td a {
    color: #e30613;
}

.komunikat_niebieski a, .komunikat_niebieski span, .komunikat_niebieski {
    color: #0c3274;
}

div.pageContent .ui-chkbox .ui-chkbox-label {
    display: inline;
    margin: 0;
}

.itemStyleClass {
    min-height: 130px;
}

div.pageContent .calendar .ui-datepicker-trigger {
    background: /*savepage-url=/ebok/javax.faces.resource/icon/calendar_icon.png.xhtml?ln=images*/ url() no-repeat center center transparent;
    right: 0;
    box-shadow: none;
    position: absolute;
    top: 0;
    border-left: 1px solid #c5c5cd;
    filter: none;
}

div.pageContent .calendar .ui-datepicker-trigger .ui-button-icon-left.ui-icon.ui-icon-calendar {
    background: none;
}

.ui-datepicker .ui-datepicker-calendar .ui-state-default {
    background: rgba(0, 0, 0, 0) none repeat scroll 0 0;
    border: medium none;
    color: #000000;
}

.ui-datepicker .ui-datepicker-current-day .ui-state-highlight,
.ui-datepicker .ui-datepicker-current-day .ui-state-default {
    background: var(--company-dark) none repeat scroll 0 0;
    box-shadow: none;
    color: #ffffff !important;
    font-weight: bold;
    text-shadow: none;
}

.ui-datepicker .ui-datepicker-calendar .ui-state-default.ui-state-highlight {
    color: #10a38b;
    text-shadow: none;
}

.ui-datepicker .ui-datepicker-header {
    background: #fff;
}

.ui-datepicker-title, .ui-datepicker th {
    color: #000000;
    font-family: "SourceSansProLight", "Source Sans Pro", Verdana, sans-serif;
}

.ui-datepicker-title > span {
    font-family: "SourceSansProLight", "Source Sans Pro", Verdana, sans-serif;
}

.ui-datepicker .ui-shadow, .ui-datepicker {
    box-shadow: 0 0 5px 2px rgba(0, 0, 0, 0.18) !important;
}

.ui-widget-header {
    border-bottom-color: #c5c5cd;
}

div.pageContent .ui-button-text-icon-left .ui-button-text {
    padding: 0.5em 1em 0.5em 2.1em;
}

.ui-fileupload span.ui-button, div.pageContent button.ui-fileupload-upload {
    margin-right: 10px;
    margin-bottom: 5px;
    vertical-align: top;
}

div.pageContent td > button.ui-button.ui-state-default.ui-fileupload-cancel {
    background: none;
    box-shadow: none;
    filter: none;
}

.hello-name {
    display: inline-block;
    max-width: 300px;
    overflow: hidden;
    white-space: nowrap;
    text-overflow: ellipsis;
    vertical-align: -3px;
}

div.pageContent td > button.ui-button.ui-state-default.ui-fileupload-cancel {
    margin: 0;
    height: 30px;
}

div.pageContent td > button.ui-button.ui-state-default.ui-fileupload-cancel > span {
    content: "";
    display: inline-block;
    height: 22px;
    width: 22px;
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/del_icon.png.xhtml?ln=images*/ var(--savepage-url-28);
    background-repeat: no-repeat;
    vertical-align: middle;
}

.ui-datepicker {
    z-index: 1099;
}

div.pageContent .ui-panel.attachmentBox {
    border: 1px solid #e1e2e7;
    padding: 10px 20px 5px;
    margin-bottom: 15px;
}

.simulation-box {
    padding: 7px;
    background: #f7f7f7;
}

input.ui-inputfield.simulationbg {
    text-align: right;
}

div.pageContent .ui-fileupload-buttonbar span.ui-button-icon-left {
    display: none;
}

div.pageContent .ui-fileupload-buttonbar .ui-button-text-icon-left .ui-button-text {
    padding: 0.5em 1em 0.5em 1em;
}

.ui-state-error, .ui-widget-content .ui-state-error, .ui-widget-header .ui-state-error {
	border: none;
	background: none;
}

.ui-growl .ui-growl-item-container {
    background: #eee;
    color: #0c3274;
    border-color: #0c3274;
    text-shadow: none;
    border-radius: 0px;
}

/*.ui-growl .ui-growl-item-container{background: #fff; color: #cd0a0a; border-color: #e30613; text-shadow: none; border-radius: 0px;}*/
.ui-messages .ui-messages-error ul, .ui-message {
    margin: 0;
}

.ui-messages .ui-messages-error, .ui-message-error {
    background-color: #fff9f9;
    border-color: #e30613;
    border-radius: 0;
    border-radius: 0;
    box-shadow: 0 0 5px rgba(0, 0, 0, 0.18);
    color: #e30613;
}

.ui-messages .ui-messages-error ul {
    overflow: hidden;
}

.ui-messages .ui-messages-error ul span {
    margin: 0;
}

.ui-messages .ui-messages-error ul li span.ui-messages-error-detail {
    display: block;
}

.ui-message {
    padding: 0;
}

div.pageContent .ui-radiobutton {
    margin-right: 5px;
    vertical-align: -2px;
}

div.pageContent .ui-radiobutton .ui-radiobutton-box {
    background: none;
}

div.pageContent .ui-icon.ui-icon-arrowthick-1-s {
    display: none;
}

div.pageContent button .ui-button-text.ui-c {
    padding: 0.5em 1em 0.5em 1em;
}

.leftSideBar .admin-menu .ui-menuitem-icon {
    display: none !important;
}

.icon-dokument:before, .ui-state-default .ui-icon.ui-icon-dokument {
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/menu_icon.png.xhtml?ln=images*/ var(--savepage-url-24);
    background-repeat: no-repeat;
    border-radius: 0;
    height: 19px;
    margin-right: 10px;
    vertical-align: -3px;
    width: 14px;
    content: "";
    display: inline-block;
    background-position: -60px top;
    background-size: 122px 38px;
}

.ui-state-default .ui-icon.ui-icon-dokument {
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/document_green_icon.png.xhtml?ln=images*/ url();
    background-size: cover;
}

.attachment_icon:before {
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/attachment_icon.png.xhtml?ln=images*/ url();
    background-repeat: no-repeat;
    border-radius: 0;
    height: 15px;
    margin-right: 10px;
    vertical-align: -3px;
    width: 15px;
    content: "";
    display: inline-block;
}

.mobile_device_icon:before {
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/device_mobile.svg.xhtml?ln=images*/ url();
    background-repeat: no-repeat;
    border-radius: 0;
    height: 20px;
    margin-right: 10px;
    vertical-align: -3px;
    width: 15px;
    content: "";
    display: inline-block;
}

.invoice_wplata {
    line-height: 25px !important;
}

.energia_wplaty:before {
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/bolt_icon.svg.xhtml?ln=images*/ url();
    background-repeat: no-repeat;
    border-radius: 0;
    height: 25px;
    margin-right: 10px;
    vertical-align: -13px;
    width: 15px;
    content: "";
    display: inline-block;
}

.gaz_wplaty:before {
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/fire_icon.svg.xhtml?ln=images*/ url();
    background-repeat: no-repeat;
    border-radius: 0;
    height: 25px;
    margin-right: 10px;
    vertical-align: -13px;
    width: 15px;
    content: "";
    display: inline-block;
}

.ui-state-default .ui-icon.ui-icon-dokument {
    background-position: 0 top;
    margin: 0;
    top: 6px;
    width: 17px;
}

div.pageContent button.download .ui-button-text.ui-c {
    padding-left: 30px;
}

.icon-dokument label {
    cursor: pointer;
}

.radion-inputs label {
    margin-right: 20px;
}

.logo-mobile {
    display: none;
}

.dynamic-tile img {
    max-width: 120px;
    vertical-align: top;
}

div.pageContent div.smallPanel.dynamic-tile.admin {
    display: block;
    margin: auto;
}

.dynamic-tile .tile-description {
    box-sizing: border-box;
    padding-left: 10px;
    vertical-align: top;
    text-align: left;
}

div.pageContent .poll .ui-dialog-titlebar.ui-widget-header {
    margin: 0;
    box-sizing: border-box;
    position: absolute;
    width: 100%;
    z-index: 99;
}

div.pageContent .ui-panel.poll-box .ui-panel-titlebar {
    padding-top: 15px;
}

div.pageContent .ui-selectmanycheckbox label, div.pageContent .ui-selectoneradio label {
    margin: 0 10px 0 0;
}

div.pageContent .poll-question-box .ui-panel {
    padding: 10px;
    border: 1px solid #e1e2e7;
}

div.pageContent .ui-dialog .ui-dialog-titlebar, body .ui-dialog .ui-dialog-titlebar {
    min-height: 40px;
    background: /*savepage-url=/ebok/javax.faces.resource/logo-popup.png.xhtml?ln=images*/ var(--savepage-url-25) no-repeat scroll right 10px transparent;
}

div.pageContent.logo-no-ebok .ui-dialog .ui-dialog-titlebar, body.logo-no-ebok .ui-dialog .ui-dialog-titlebar {
    min-height: 40px;
    background: /*savepage-url=/ebok/javax.faces.resource/logo-popup-no-ebok.png.xhtml?ln=images*/ url() no-repeat scroll right 10px transparent;
}

.ui-state-disabled, .ui-widget-content .ui-state-disabled, .ui-widget-header .ui-state-disabled {
    opacity: 0.4;
}

.ui-spinner a.ui-spinner-up, .ui-spinner a.ui-spinner-down {
    height: 16px;
    background: none;
}

.ui-spinner input {
    width: 100%;
}

.ui-dialog h2:first-child {
    margin-top: 0;
}

.pageContent.fullWidth div.smallPanel.admin {
    display: block;
    margin: 0 auto 35px;
}

.admin-info {
    bottom: 41px;
    color: #73747f;
    font-weight: bold;
    left: 270px;
    position: absolute;
}

div.errorContent div.panel {
    min-height: 300px;
    position: relative;
    color: #73747f;
    border-top: 8px solid var(--company-dark);
    background: #fff;
    box-shadow: 0 0 5px rgba(0, 0, 0, 0.18);
    margin-bottom: 35px;
    padding: 20px;
}

.box-icon.nopage:before {
    height: 160px;
    width: 160px;
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/errorpage_icon.png.xhtml?ln=images*/ url();
}

div.errorContent div.panel h1 {
    font-family: "SourceSansProLight", "Source Sans Pro", Verdana, sans-serif;
    color: var(--company-dark);
    font-size: 72px;
    line-height: 78px;
}

div.errorContent a {
    color: var(--company-dark);
    text-decoration: none;
}

div.errorContent a:hover {
    text-decoration: underline;
}

.messages-count {
    display: none;
}

.ui-fileupload-progress {
    display: none;
    width: 0;
}

.icon-select table tr:FIRST-CHILD {
    display: none;
}

.icon-select table tr {
    border: 0 !important;
    box-shadow: none !important;
}

.icon-select table tr.ui-state-hover {
    background: #eee;
}

.icon-select table tr.ui-state-hover td,
.icon-select table tr.ui-state-highlight td {
    background: #eee;
    text-shadow: none;
    color: #73747f;
}

.icon-select table td {
    border: 0 !important;
    border-bottom: 1px solid #ccc !important;
    background: #fff none repeat scroll 0 0;
}
.icon-select table td img{max-height: 40px;}
#formKonfig\:kofigViewTab\:dodajKafel\:noweWybieranieIkony_panel table tr:FIRST-CHILD,
#formKonfig\:kofigViewTab\:edytujKafel\:noweWybieranieIkony_panel table tr:FIRST-CHILD {display: none;}
#formKonfig\:kofigViewTab\:dodajKafel\:noweWybieranieIkony_panel table tr,
#formKonfig\:kofigViewTab\:edytujKafel\:noweWybieranieIkony_panel table tr{border: 0 !important; box-shadow: none !important;}
#formKonfig\:kofigViewTab\:dodajKafel\:noweWybieranieIkony_panel table tr.ui-state-hover,
#formKonfig\:kofigViewTab\:edytujKafel\:noweWybieranieIkony_panel table tr.ui-state-hover{background: #eee;}
#formKonfig\:kofigViewTab\:dodajKafel\:noweWybieranieIkony_panel table tr.ui-state-hover td,
#formKonfig\:kofigViewTab\:edytujKafel\:noweWybieranieIkony_panel table tr.ui-state-highlight td,
#formKonfig\:kofigViewTab\:dodajKafel\:noweWybieranieIkony_panel table tr.ui-state-hover td,
#formKonfig\:kofigViewTab\:edytujKafel\:noweWybieranieIkony_panel table tr.ui-state-highlight td
{background: #eee; text-shadow: none; color: #73747f;}
#formKonfig\:kofigViewTab\:dodajKafel\:noweWybieranieIkony_panel table td,
#formKonfig\:kofigViewTab\:edytujKafel\:noweWybieranieIkony_panel table td {
	border: 0 !important;
	border-bottom: 1px solid #ccc !important;
	background: #fff none repeat scroll 0 0;
}
#formKonfig\:kofigViewTab\:dodajKafel\:noweWybieranieIkony_panel table td img,
#formKonfig\:kofigViewTab\:edytujKafel\:noweWybieranieIkony_panel table td img{max-height: 40px;}
/* Sweep To Bottom */
@-webkit-keyframes hvr-pop {
    from {
        opacity: 0;
    }
    to {
        opacity: 1;
    }
}

@keyframes hvr-pop {
    from {
        opacity: 0;
    }
    to {
        opacity: 1;
    }
}

.js-messages {
    -webkit-animation-name: hvr-pop;
    animation-name: hvr-pop;
    -webkit-animation-duration: 0.3s;
    animation-duration: 0.3s;
    -webkit-animation-timing-function: linear;
    animation-timing-function: linear;
    -webkit-animation-iteration-count: 1;
    animation-iteration-count: 1;
}

.cookiesAlert {
    background: #f7f7f7 none repeat scroll 0 0;
    margin: auto;
    padding: 20px;
    width: 890px;
    position: relative;
    box-sizing: border-box;
}

.cookiesAlert .title {
    color: #858585;
}

.cookiesAlert p {
    font-size: 11px;
}

.cookiesAlert .btnClose {
    background: /*savepage-url=/ebok/javax.faces.resource/icon/close_icon.png.xhtml?ln=images*/ var(--savepage-url-15) no-repeat center center;
    display: block;
    height: 22px;
    position: absolute;
    right: 20px;
    top: 20px;
    width: 22px;
    cursor: pointer;
}

.cookiesAlert a {
    border: 0 none;
    color: #0c3274;
    text-decoration: none;
}

.cookiesAlert a:hover {
    color: var(--company-dark);
}

.leftSideBar .ui-menu .ui-menuitem .ui-menuitem-link.settingsMinDevice {
    display: none;
}

@media screen and (max-width: 320px) {
    .leftSideBar .ui-menu .ui-menuitem .ui-menuitem-link.settingsMinDevice {
        display: block;
    }

    button.ui-button.ui-state-default.googleBtn {
        width: 100%;
    }

    button.ui-button.ui-state-default.facebookBtn {
        width: 100%;
    }
}

@media screen and (max-width: 403px) {
    .userPanelLeft {
        display: none !important;
    }

    .userPanelRight {
        position: absolute;
        width: 60px;
        right: 0px;
        border-left: none !important;
    }

    .userAccountPanel {
        display: none !important;
    }


}

@media screen and (min-width: 404px) and (max-width: 590px) {
    div.userPanelLeft {
        border-left: 0;
        box-sizing: border-box;
        padding: 0;
        width: 73px;
        display: flex !important;
        justify-content: flex-end;
        align-items: center;
    }
}

@media screen and (min-width: 404px) and (max-width: 1024px) , (max-device-width: 1024px) and (orientation: portrait) {
    div.userPanelRight {
        width: 125px;
    }
}

@media screen and (min-width: 404px) {
    .userAccountPanel {
        display: block
    }
}

@media screen and (max-width: 360px) {
    div.templateFooter .mobileApps {
        padding-left: 20px !important;
    }

    div.templateFooter .mobileApps > div:first-child {
        font-size: 14px !important;
        font-weight: bold !important;
    }

    div.templateFooter .mobileApps img {
        max-height: 43px !important;
    }

    button.ui-button.ui-state-default.googleBtn {
        width: 100%;
    }

    button.ui-button.ui-state-default.facebookBtn {
        width: 100%;
    }
}

@media screen and (max-width: 768px) , (max-device-width: 768px) and (orientation: portrait) {
    .userDataInfoBox {
        position: static;
        margin-bottom: 20px;
    }

    .noticeUserBox {
        width: 50%;
    }

    .cookiesAlert {
        margin-top: 60px;
        width: 100%;
        margin-bottom: -60px;
    }

    .accountSettings span.breakH4, .accountSettings span.breakH {
        width: 100%;
    }

    .accountSettings .right {
        float: none;
    }

    .accountSettings .buttons span.breakH {
        width: 10px;
    }
}

@media screen and (min-width: 320px) and (max-width: 480px) {
    .minw160 {
        width: 160px;
    }

    .offerImgBox {
        display: none;
    }

    .offerTextBox {
        width: 100%;
    }

    button.ui-button.ui-state-default.googleBtn {
        width: 100%;
    }

    button.ui-button.ui-state-default.facebookBtn {
        width: 100%;
    }
}

@media screen and (max-width: 480px) {
    .orLoginWith {
        left: 54px;
    }

    .socialLoginBtn {
        text-align: left;
    }

    .h436 {
        height: auto;
    }

    button.ui-button.ui-state-default.googleBtn {
        width: 100%;
    }

    button.ui-button.ui-state-default.facebookBtn {
        width: 100%;
    }
}

@media screen and (min-width: 320px) and (max-width: 479px) {
    .offerDetail {
    }

    div.pageContent .symulacja-icon .f16 {
        font-size: 14px;
    }

    .symulacja-icon .w250 {
        width: 138px;
    }

    .symulacja-icon .w150 {
        width: 105px;
    }

    .symulacja-icon .w160 {
        width: 128px;
    }

    .symulacja-icon .w205 {
        width: 105px;
    }

    div.pageContent .symulacja-icon .calendar input.ui-inputfield {
        font-size: 14px;
        padding: 2px;
        width: 127px;
    }

    div.pageContent .symulacja-icon .calendar {
        width: 128px;
    }

    .w300 {
        width: 100%;
    }

    .w300 .breakH {
        width: 100%;
    }

    .w380 {
        width: 100%;
    }

    .w400 {
        width: 100% !important;
    }

    .w420 {
        width: 100% !important;
    }

    .w450 {
        width: 100% !important;
    }

    .w590 {
        width: 100% !important;
    }

    .w605 {
        width: 100% !important;
    }

    .w680 {
        width: 100% !important;
    }

    .w370 {
        width: 100% !important;
    }

    .ui-selectonemenu-panel.ui-widget-content {
        width: 278px !important;
    }

    body .ui-selectcheckboxmenu-panel {
        width: calc(100% - 40px) !important;
    }

    .ui-dialog .ui-dialog-titlebar .ui-dialog-title {
        max-width: 255px;
    }

    .online-cancel {
        position: relative;
        top: 90px;
    }

    .online-payu {
        float: left;
        top: -60px !important;
    }

    .online-bluemedia {
        float: left;
        top: -60px !important;
    }

    .cancel-button-container {
        float: left;
        top: -60px !important;
    }

    .notification-icon .ui-commandlink.w240 {
        width: 225px;
    }

    .inline-with-btn {
        margin-top: 0;
    }

    .inline-with-btn .help-box-description {
        margin-top: 50px;
    }

    .inline-with-btn .help-icon {
        top: -20px;
    }

    .userPanel .userAccountPanel {
        display: none !important;
    }

    .templateHeader div.userPanel {
        width: 133px;
    }

    .templateHeader div.userPanelRight {
        vertical-align: bottom;
        width: 65px;
        border: 0;
    }

    .ui-tabs.ui-tabs-top > .ui-tabs-nav li {
        width: 100%;
    }

    .noticeUserBox {
        width: 100%;
    }

    span.breakH, span.breakH2, span.breakH3, span.breakH4 {
        width: 100%;
    }

    div.pageContent .ui-dialog .ui-dialog-titlebar, body .ui-dialog .ui-dialog-titlebar {
        background: transparent;
    }

    .buttons span.breakH, .dialog-buttons span.breakH3, .buttons-admin span.breakH {
        width: 10px;
    }

    .ui-message.js-messages {
        width: 280px;
    }

    .ui-messages.js-messages .ui-messages-error, .ui-message.js-messages-error {
        width: 100%;
    }

    div.pageContent .ui-dialog .ui-dialog-title, body .ui-dialog .ui-dialog-title {
        padding: 0;
    }

    .invoice button.right {
        float: none;
    }

    .tile-description {
        padding: 0;
    }

    .dynamic-tile {
        text-align: center;
    }

    .dynamic-tile a, .dynamic-tile .ui-panel-titlebar {
        text-align: left;
        display: block;
    }

    .prepaid-payment-buttons {
        flex-direction: column
    }

    button.ui-button.ui-state-default.googleBtn {
        width: 100%;
    }

    button.ui-button.ui-state-default.facebookBtn {
        width: 100%;
    }

}

@media screen and (max-width: 590px) {
    .messages {
        display: none !important;
    }

    .messages-count {
        display: none !important;
    }

    .contrast-icon {
        display: none !important;
    }

    /*div.userPanelLeft {border-left: 0; box-sizing: border-box; padding: 0; width: 73px; display: flex !important; justify-content: flex-end; align-items: center;}*/
    div.userPanel {
        width: 193px;
        right: 0px !important;
    }
}

@media screen and (min-width: 591px) and (max-width: 1024px) {
    div.userPanelLeft {
        border-left: 0;
        box-sizing: border-box;
        padding: 0;
        width: 200px;
        display: flex !important;
        justify-content: flex-end;
        align-items: center;
    }

    div.userPanel {
        width: 260px;
        right: 60px !important;
    }
}


@media screen and (min-width: 480px) and (max-width: 534px) {
    .online-cancel {
        top: 50px;
    }

    .online-payu {
        float: left;
    }

    .noticeUserBox {
        width: 100%;
    }

    .offerDetail {
        width: 100% !important;
        height: 100% !important;
    }

    button.ui-button.ui-state-default.googleBtn {
        width: 100%;
    }

    button.ui-button.ui-state-default.facebookBtn {
        width: 100%;
    }
}

@media screen and (min-width: 480px) and (max-width: 640px) {
    .offerDetail {
        width: 100% !important;
        height: 100% !important;
    }
}

@media screen and (max-width: 768px) , (max-device-width: 768px) and (orientation: landscape) {

    div.templateFooter .phones {
        display: block;
        vertical-align: top;
        width: 100%;
    }

    div.templateFooter .mobileApps {
        display: block;
        padding-bottom: 20px;
        padding-left: 65px;
        text-align: left;
        width: 100%;
    }
}

@media screen and (max-width: 1024px) , (max-device-width: 1024px) and (orientation: portrait) {
    .contrast-icon {
        margin-left: 15px;
        margin-right: 15px
    }

    .cookiesAlert {
        margin: 60px auto -60px;
    }

    .logo-box {
        display: block;
        padding: 10px 0 0 20px;
    }

    .logo-mobile {
        display: inline-block;
    }

    .logo, .hello, .hello-name, .messages-rest, div.userPanelLeft br, div.userPanelLeft .break {
        display: none !important;
    }

    .messages, .config, .logoutBox, .userAccountPanel {
        color: #fff;
        display: inline-block;
        height: 30px;
        overflow: hidden;
        margin: 15px;
        overflow: hidden;
        vertical-align: middle;
        width: 30px !important;
        border-top: 0;
        padding: 0;
    }

    .logoutBox {
        float: right;
    }

    .messages:before, .config:before, .logoutBox:before, .changeAccount::before {
        width: 30px;
        height: 30px;
        background-position: right 0;
    }

    .messages-count {
        display: inline-block;
        left: 32px;
        position: absolute;
        top: 16px;
        font-weight: bold;
        font-size: 13px !important;
        width: 18px;
        text-align: right;
        padding-left: 9px !important;
        padding-top: 1px !important;
    }

    div.userAccountPanel .changeAccount:hover:before {
        background-position: left 0;
    }

    /*div.userPanelRight{width: 125px;}*/
    .userAccountPanel .ui-overlaypanel {
        top: 60px !important;
    }

    .admin-info {
        display: none;
    }

    .leftSideBar .ui-menu .ui-menuitem .ui-menuitem-link > span {
        float: left;
        width: 218px;
    }

    #userActionForm\:userActionPanel_content {
        display: flex !important;
    }
}

input::-ms-reveal {
    display: none;
}

input::-ms-clear {
    display: none;
}

.version {
    bottom: -14px;
    color: #777;
    left: 0;
    position: absolute;
    text-shadow: 1px 1px 0 #bbb;
}

.stacktrace {
    background: rgba(232, 200, 200, 0.1) none repeat scroll 0 0;
    border: 1px solid #ccc;
    font-size: 11px;
    margin: 40px 0 20px;
    padding: 20px;
}

.stacktrace label {
    font-size: 11px;
}

#rzeszow-prepaid-dialog .ui-dialog {
    width: 1150px !important;
    height: 990px !important;
}

#rzeszow-prepaid-dialog iframe {
    border: 0;
    width: 1090px;
    height: 980px;
}

.ukryjGwiazdke > span.ui-outputlabel-rfi {
    display: none;
}

.ui-datatable.dark.calculator tbody td {
    border: 0;
}

.ui-datatable.dark.calculator tbody tr {
    border: 1px solid #ccc !important;
}

.ui-datatable.dark.calculator tbody tr.ui-expanded-row-content {
    border-top: 0 !important;
}

.ui-datatable.dark.calculator tbody tr.ui-expanded-row {
    border-bottom: 0px !important;
}

table.jqplot-table-legend::before {
    bottom: 0;
    content: " ";
    display: block;
    left: 0;
    position: absolute;
    right: 0;
    top: 0;
}

pre {
    white-space: pre-wrap; /* CSS 3 */
    white-space: -moz-pre-wrap; /* Mozilla, since 1999 */
    white-space: -pre-wrap; /* Opera 4-6 */
    white-space: -o-pre-wrap; /* Opera 7 */
    word-wrap: break-word; /* Internet Explorer 5.5+ */
    word-break: keep-all;
}

.hide-column-names table thead tr {
    display: none;
}

.ui-datatable.borderless thead th,
.ui-datatable.borderless tbody,
.ui-datatable.borderless tbody tr,
.ui-datatable.borderless tbody td {
    border-style: none;
    background-color: #FFF;
}

.payment-button, .prepaid-payment-button {
    cursor: pointer !important;
    width: 120px !important;
    border: none !important;
    box-shadow: none !important;
}

.cancel-payment-button {
    cursor: pointer !important;
    width: 120px !important;
    border: none !important;
    box-shadow: none !important;
    margin-left: 10px !important;
}

.ui-state-disabled.payment-button, .ui-state-disabled.prepaid-payment-button {
    opacity: 0.4 !important;
}

.payu-button {
    background: /*savepage-url=/ebok/javax.faces.resource/payments/payu.png.xhtml?ln=images*/ url() no-repeat !important;
    background-size: 200px 40px !important;
}

.p24-button {
    background: /*savepage-url=/ebok/javax.faces.resource/payments/przelewy24.jpg.xhtml?ln=images*/ url() no-repeat !important;
    background-size: 200px 40px !important;
}

.bm-button {
    background: /*savepage-url=/ebok/javax.faces.resource/payments/bm.png.xhtml?ln=images*/ url() no-repeat !important;
    background-size: 200px 40px !important;
}

ul.paymentBtnPanel {
    padding-left: 0;
    list-style-type: none;
}

ul.paymentBtnPanel > li {
    float: right;
}

.prepaid-payment-buttons {
    display: flex;
    justify-content: flex-end;
}

.regulamin-powiekszony {
    padding-bottom: 40px !important;
}

.disabled-checkbox {
    pointer-events: none;
    opacity: 0.3;
}

.ecm-placeholder {
    background: /*savepage-url=ajax-loader.gif.xhtml?ln=images*/ url() center center no-repeat;
    border: 1px solid black;
    padding: 0px;
}


.ui-datatable .ecm-editedtext td {
    font-size: initial;
    height: initial;
    line-height: initial;
}

.ui-state-highlight, .ui-widget-content .ui-state-highlight, .ui-widget-header .ui-state-highlight {
    color: #73747f;
    text-shadow: none;
}

.ui-state-highlight .ui-icon {
    background-image: /*savepage-url=/ebok/javax.faces.resource/images/ui-icons_38667f_256x240.png.xhtml?ln=primefaces-aristo*/ url();
}

.field-icon-main {
    float: right;
    margin-right: 10px;
    margin-top: -23px;
    position: relative;
    z-index: 2;
    cursor: pointer;
}

.field-icon-side {
    right: 27px;
    position: relative;
    cursor: pointer;
}

.eye-icon-delete-profile {
    float: left;
    margin-left: 370px;
    margin-top: -35px;
    position: relative;
    z-index: 2;
    cursor: pointer;
}

.pinRight {
    float: right;
}

.header-nonppe-message {
    text-align: justify;
    font-size: 24px;
    line-height: 24px;
    margin-top: 10px;
    clear: right;
}

.logo-nonppm {
    float: right;
    height: 100px;
}

.table-no-select-all .ui-chkbox-all {
    display: none !important;
}

.powiazanie-miejscowosc-help {
    display: flex;
    flex-direction: column;
    margin-bottom: 60px;
}

.powiazanie-miejscowosc-wroc {
    text-align: right;
}

.powiazanie-obraz-help {
    max-width: 800px;
    margin-left: auto;
    margin-right: auto;
}

.word-break {
    word-break: break-word;
}

.twoje-ppm-dropdown-left-align {
    left: 879.444px;
}

.unlinkedAccountList table thead {
    display: none;
}

.unlinkedAccountList tr.unlinkedAccount td {
    border-width: 0px;
}

.unlinkedAccountList table tr {
    border-bottom: 1px solid #e1e2e7 !important;
}

.info-icon2 {
    cursor: pointer;
    position: relative;
    margin-left: 10px;
}

.info-box-description2 {
    margin-top: 50px;
}

.info-description2 {
    border-top: 1px solid #e1e2e7;
    padding-top: 15px;
    display: none;
    text-align: justify;
}

.info-icon2:hover,
.info-icon2.open {
    color: #0c3274;
}

.info-icon2:hover:after,
.info-icon2.open:after {
    background-position: center bottom;
}

.info-icon2:after {
    background-position: center center;
    content: "";
    display: inline-block;
    height: 22px;
    margin-right: 10px;
    vertical-align: 0;
    width: 22px;
    background-image: /*savepage-url=/ebok/javax.faces.resource/icon/info_icon_blue.png.xhtml?ln=images*/ url();
}

.ui-toggleswitch .ui-toggleswitch-slider {

    -moz-transition: background-color 0.3s;
    -o-transition: background-color 0.3s;
    -webkit-transition: background-color 0.3s;
    transition: background-color 0.3s;
    border-radius: 30px;
    background-color: green;
}

.ui-toggleswitch.ui-toggleswitch-checked .ui-toggleswitch-slider {
    background-color: red;
}

.ui-toggleswitch .ui-toggleswitch-slider::before {

    background-color: #ffffff;
    height: 1.250em;
    width: 1.250em;
    left: .25em;
    bottom: .25em;
    border-radius: 50%;
    -webkit-transition: 0.3s;
    transition: 0.3s;
}

.ui-toggleswitch-slider {
font-family: 'primeicons' !important;
}

.ui-toggleswitch-slider:before {
content: "\e96a" !important;
}

.ui-toggleswitch-checked .ui-toggleswitch-slider:before {
content: "\e95f" !important;
}

.mbok-toggle .ui-toggleswitch .ui-toggleswitch-slider {

    -moz-transition: background-color 0.3s;
    -o-transition: background-color 0.3s;
    -webkit-transition: background-color 0.3s;
    transition: background-color 0.3s;
    border-radius: 30px;
    background-color: red;
}

.mbok-toggle .ui-toggleswitch.ui-toggleswitch-checked .ui-toggleswitch-slider {
    background-color: green;
}

.mbok-toggle .ui-toggleswitch .ui-toggleswitch-slider::before {

    background-color: #ffffff;
    height: 1.250em;
    width: 1.250em;
    left: .25em;
    bottom: .25em;
    border-radius: 50%;
    -webkit-transition: 0.3s;
    transition: 0.3s;
}

.mbok-toggle .ui-toggleswitch-slider {
    font-family: 'primeicons' !important;
}

.mbok-toggle .ui-toggleswitch-slider:before {
    content: "\e90b" !important;
}

.mbok-toggle .ui-toggleswitch-checked .ui-toggleswitch-slider:before {
    content: "\e909" !important;
}

.editBokDialogWidgetStyle{
    width: 1350px !important;
}

.lockOpen.pi.pi-lock-open{
    color: green;
    font-size: 2rem;
}

.lockClosed.pi.pi-lock{
    color: red;
    font-size: 2rem;
}

.mbokNotChecked.pi.pi-times{
     color: red;
     font-size: 2rem;
 }

.mbokChecked.pi.pi-check{
    color: green;
    font-size: 2rem;
}

.message-category-icon {
	background-position: top center;
	background-repeat: no-repeat;
	content: "";
	display: inline-block;
	height: 22px;
	margin-left: 22px;
	vertical-align: middle;
	width: 22px;
}

.PROMO-icon {
	background-image: /*savepage-url=/ebok/javax.faces.resource/icon/ic_about_app.svg.xhtml?ln=images*/ url();
    background-repeat: no-repeat;
}

.WINDY-icon {
	background-image: /*savepage-url=/ebok/javax.faces.resource/icon/ic_alert.svg.xhtml?ln=images*/ var(--savepage-url-27);
    background-repeat: no-repeat;
}

.OSTRZEG-icon {
	background-image: /*savepage-url=/ebok/javax.faces.resource/icon/ic_about_app.svg.xhtml?ln=images*/ url();
    background-repeat: no-repeat;
}

.INFO-icon {
	background-image: /*savepage-url=/ebok/javax.faces.resource/icon/ic_about_app.svg.xhtml?ln=images*/ url();
    background-repeat: no-repeat;
}

.INFOSIE-icon {
	background-image: /*savepage-url=/ebok/javax.faces.resource/icon/ic_about_app.svg.xhtml?ln=images*/ url();
    background-repeat: no-repeat;
}

.INFOSPR-icon {
	background-image: /*savepage-url=/ebok/javax.faces.resource/icon/ic_message.svg.xhtml?ln=images*/ url();
    background-repeat: no-repeat;
}

.INNA_ADHOC-icon {
	background-image: /*savepage-url=/ebok/javax.faces.resource/icon/ic_about_app.svg.xhtml?ln=images*/ url();
    background-repeat: no-repeat;
}

.kontaktFormPanel {
    display: flex;
    flex-direction: row;
    height: 92px;
    align-items: flex-start;
}

.ui-fileupload .ui-fileupload-progress {
    display: none;
}

.admIssuePomoc {
    margin-top: -56px !important;
    vertical-align: top;
    margin-left: 20px !important;
}

.loggedInDevicesPomoc {
    float: right;
}

.loggedInDevicesPomoc .ui-widget-content {
    float: right;
}

.loggedInDevicesPomoc .ui-widget-content .help-box-description {
    margin: 20px 0px;
}

.loggedInDevicesPomoc .w400 .ui-panel-footer {
    width: 400px;
}
.zgloszeniaIUsterkiPPEListItem .ui-selectonemenu-items.ui-selectonemenu-list{
    width: 461px;
}
.zgloszeniaIUsterkiPPEListItem .ui-selectonemenu-list-item{
    width: fit-content;
}

.balancePanelGrid td:nth-child(1) {
    width: 250px;
}

.newKafelSelectOneMenuPanel {
    position: static !important;
}</style><style data-savepage-href="/ebok/javax.faces.resource/custom-editor.css.xhtml?ln=css" type="text/css">
.ecm-editedtext {
  font-family: Verdana, sans-serif;
  font-size: 12px;
  color: #73747f;
}

.ecm-editedtext img:not(.align-left):not(.align-right) {
	margin: auto;
	display: block;
}

img.align-left {
	clear: none;
	float: left;
	margin-right: 10px;
}

img.align-right {
	clear: none;
	float: right;
	margin-left: 10px;
}

.ecm-editedtext iframe[src^="https://www.youtube.com/embed/"] {
	margin: auto;
}

.ecm-editedtext p, .ecm-editedtext li {
  margin-top: 10px;
  margin-bottom: 10px;
}


table.with-border {
    border-collapse: collapse !important;
}

table.with-border, table.with-border th,
table.with-border td, table.with-border tf {
    border: 1px solid black !important;
}

table.ecm-table {
	margin-top: 5px !important;
	margin-bottom: 5px !important;
}

table.center-table {
	margin-left: auto !important;
	margin-right: auto !important;
}

table.right-table {
	margin-left: auto !important;
}

table.left-float-table {
	margin-right: 10px !important;
	clear: none !important;
	float: left !important;
}

table.right-float-table {
	margin-left: 10px !important;
	clear: none !important;
	float: right !important;
}

table.ecm-table td, table.ecm-table th, table.ecm-table tf {
	padding: 4px 3px !important;
	width: initial !important;
	height: initial !important;
}

table.ecm-table {
	width: initial !important;
}


.short-descr-oferta {
	line-height: 24px;
}


.ecm-text-center {
    text-align: center;
}

.ecm-text-left {
    text-align: left;
}

.ecm-text-right {
    text-align: right;
}

.ecm-text-justify {
    text-align: justify;
	text-justify: inter-word;
}

.ecm-color-FFCFCF {color: #FFCFCF !important;}
.ecm-color-FFCF96 {color: #FFCF96 !important;}
.ecm-color-FFFF96 {color: #FFFF96 !important;}
.ecm-color-FFFFCF {color: #FFFFCF !important;}
.ecm-color-96FF96 {color: #96FF96 !important;}
.ecm-color-96FFFF {color: #96FFFF !important;}
.ecm-color-CFFFFF {color: #CFFFFF !important;}
.ecm-color-CFCFFF {color: #CFCFFF !important;}
.ecm-color-FFCFF0 {color: #FFCFF0 !important;}

.ecm-color-FFFFFF {color: #FFFFFF !important;}
.ecm-color-FF6767 {color: #FF6767 !important;}
.ecm-color-FF9667 {color: #FF9667 !important;}
.ecm-color-FFFF67 {color: #FFFF67 !important;}
.ecm-color-FFFF30 {color: #FFFF30 !important;}
.ecm-color-67F0A8 {color: #67F0A8 !important;}
.ecm-color-30FFFF {color: #30FFFF !important;}
.ecm-color-67FFFF {color: #67FFFF !important;}
.ecm-color-9696F0 {color: #9696F0 !important;}
.ecm-color-FF96FF {color: #FF96FF !important;}

.ecm-color-CFCFCF {color: #CFCFCF !important;}
.ecm-color-FF0000 {color: #FF0000 !important;}
.ecm-color-FF9600 {color: #FF9600 !important;}
.ecm-color-FFCF60 {color: #FFCF60 !important;}
.ecm-color-FFF021 {color: #FFF021 !important;}
.ecm-color-30FF30 {color: #30FF30 !important;}
.ecm-color-67CFDC {color: #67CFDC !important;}
.ecm-color-30CFF0 {color: #30CFF0 !important;}
.ecm-color-6262CF {color: #6262CF !important;}
.ecm-color-CF62CF {color: #CF62CF !important;}

.ecm-color-BABABA {color: #BABABA !important;}
.ecm-color-C60000 {color: #C60000 !important;}
.ecm-color-FF6200 {color: #FF6200 !important;}
.ecm-color-FFCF21 {color: #FFCF21 !important;}
.ecm-color-FFCF00 {color: #FFCF00 !important;}
.ecm-color-30CF00 {color: #30CF00 !important;}
.ecm-color-00CFCF {color: #00CFCF !important;}
.ecm-color-3067F0 {color: #3067F0 !important;}
.ecm-color-6730F0 {color: #6730F0 !important;}
.ecm-color-CF30CF {color: #CF30CF !important;}

.ecm-color-9A9A9A {color: #9A9A9A !important;}
.ecm-color-960000 {color: #960000 !important;}
.ecm-color-CF6700 {color: #CF6700 !important;}
.ecm-color-CF9642 {color: #CF9642 !important;}
.ecm-color-A0960C {color: #A0960C !important;}
.ecm-color-00960C {color: #00960C !important;}
.ecm-color-4296A0 {color: #4296A0 !important;}
.ecm-color-3030FF {color: #3030FF !important;}
.ecm-color-6700CF {color: #6700CF !important;}
.ecm-color-963096 {color: #963096 !important;}

.ecm-color-676767 {color: #676767 !important;}
.ecm-color-6E0000 {color: #6E0000 !important;}
.ecm-color-963000 {color: #963000 !important;}
.ecm-color-966730 {color: #966730 !important;}
.ecm-color-676700 {color: #676700 !important;}
.ecm-color-006700 {color: #006700 !important;}
.ecm-color-679696 {color: #679696 !important;}
.ecm-color-00008C {color: #00008C !important;}
.ecm-color-30308C {color: #30308C !important;}
.ecm-color-673067 {color: #673067 !important;}

.ecm-color-000000 {color: #000000 !important;}
.ecm-color-300000 {color: #300000 !important;}
.ecm-color-673000 {color: #673000 !important;}
.ecm-color-673030 {color: #673030 !important;}
.ecm-color-303000 {color: #303000 !important;}
.ecm-color-003000 {color: #003000 !important;}
.ecm-color-003042 {color: #003042 !important;}
.ecm-color-000067 {color: #000067 !important;}
.ecm-color-3000A0 {color: #3000A0 !important;}
.ecm-color-300030 {color: #300030 !important;}


.ecm-bgcolor-FFCFCF {background-color: #FFCFCF !important;}
.ecm-bgcolor-FFCF96 {background-color: #FFCF96 !important;}
.ecm-bgcolor-FFFF96 {background-color: #FFFF96 !important;}
.ecm-bgcolor-FFFFCF {background-color: #FFFFCF !important;}
.ecm-bgcolor-96FF96 {background-color: #96FF96 !important;}
.ecm-bgcolor-96FFFF {background-color: #96FFFF !important;}
.ecm-bgcolor-CFFFFF {background-color: #CFFFFF !important;}
.ecm-bgcolor-CFCFFF {background-color: #CFCFFF !important;}
.ecm-bgcolor-FFCFF0 {background-color: #FFCFF0 !important;}

.ecm-bgcolor-FFFFFF {background-color: #FFFFFF !important;}
.ecm-bgcolor-FF6767 {background-color: #FF6767 !important;}
.ecm-bgcolor-FF9667 {background-color: #FF9667 !important;}
.ecm-bgcolor-FFFF67 {background-color: #FFFF67 !important;}
.ecm-bgcolor-FFFF30 {background-color: #FFFF30 !important;}
.ecm-bgcolor-67F0A8 {background-color: #67F0A8 !important;}
.ecm-bgcolor-30FFFF {background-color: #30FFFF !important;}
.ecm-bgcolor-67FFFF {background-color: #67FFFF !important;}
.ecm-bgcolor-9696F0 {background-color: #9696F0 !important;}
.ecm-bgcolor-FF96FF {background-color: #FF96FF !important;}

.ecm-bgcolor-CFCFCF {background-color: #CFCFCF !important;}
.ecm-bgcolor-FF0000 {background-color: #FF0000 !important;}
.ecm-bgcolor-FF9600 {background-color: #FF9600 !important;}
.ecm-bgcolor-FFCF60 {background-color: #FFCF60 !important;}
.ecm-bgcolor-FFF021 {background-color: #FFF021 !important;}
.ecm-bgcolor-30FF30 {background-color: #30FF30 !important;}
.ecm-bgcolor-67CFDC {background-color: #67CFDC !important;}
.ecm-bgcolor-30CFF0 {background-color: #30CFF0 !important;}
.ecm-bgcolor-6262CF {background-color: #6262CF !important;}
.ecm-bgcolor-CF62CF {background-color: #CF62CF !important;}

.ecm-bgcolor-BABABA {background-color: #BABABA !important;}
.ecm-bgcolor-C60000 {background-color: #C60000 !important;}
.ecm-bgcolor-FF6200 {background-color: #FF6200 !important;}
.ecm-bgcolor-FFCF21 {background-color: #FFCF21 !important;}
.ecm-bgcolor-FFCF00 {background-color: #FFCF00 !important;}
.ecm-bgcolor-30CF00 {background-color: #30CF00 !important;}
.ecm-bgcolor-00CFCF {background-color: #00CFCF !important;}
.ecm-bgcolor-3067F0 {background-color: #3067F0 !important;}
.ecm-bgcolor-6730F0 {background-color: #6730F0 !important;}
.ecm-bgcolor-CF30CF {background-color: #CF30CF !important;}

.ecm-bgcolor-9A9A9A {background-color: #9A9A9A !important;}
.ecm-bgcolor-960000 {background-color: #960000 !important;}
.ecm-bgcolor-CF6700 {background-color: #CF6700 !important;}
.ecm-bgcolor-CF9642 {background-color: #CF9642 !important;}
.ecm-bgcolor-A0960C {background-color: #A0960C !important;}
.ecm-bgcolor-00960C {background-color: #00960C !important;}
.ecm-bgcolor-4296A0 {background-color: #4296A0 !important;}
.ecm-bgcolor-3030FF {background-color: #3030FF !important;}
.ecm-bgcolor-6700CF {background-color: #6700CF !important;}
.ecm-bgcolor-963096 {background-color: #963096 !important;}

.ecm-bgcolor-676767 {background-color: #676767 !important;}
.ecm-bgcolor-6E0000 {background-color: #6E0000 !important;}
.ecm-bgcolor-963000 {background-color: #963000 !important;}
.ecm-bgcolor-966730 {background-color: #966730 !important;}
.ecm-bgcolor-676700 {background-color: #676700 !important;}
.ecm-bgcolor-006700 {background-color: #006700 !important;}
.ecm-bgcolor-679696 {background-color: #679696 !important;}
.ecm-bgcolor-00008C {background-color: #00008C !important;}
.ecm-bgcolor-30308C {background-color: #30308C !important;}
.ecm-bgcolor-673067 {background-color: #673067 !important;}

.ecm-bgcolor-000000 {background-color: #000000 !important;}
.ecm-bgcolor-300000 {background-color: #300000 !important;}
.ecm-bgcolor-673000 {background-color: #673000 !important;}
.ecm-bgcolor-673030 {background-color: #673030 !important;}
.ecm-bgcolor-303000 {background-color: #303000 !important;}
.ecm-bgcolor-003000 {background-color: #003000 !important;}
.ecm-bgcolor-003042 {background-color: #003042 !important;}
.ecm-bgcolor-000067 {background-color: #000067 !important;}
.ecm-bgcolor-3000A0 {background-color: #3000A0 !important;}
.ecm-bgcolor-300030 {background-color: #300030 !important;}

.ecm-index-super {
	position: relative;
	top: -0.9em;
	font-size: 50%;
}

.ecm-index-sub {
	position: relative;
	top: +0.5em;
	font-size: 50%;
}

.ecm-fontsize-10 {
    font-size: 10px !important;
    line-height: 15px !important;
}

.ecm-fontsize-12 {
    font-size: 12px !important;
    line-height: 16px !important;
}

.ecm-fontsize-16 {
    font-size: 16px !important;
    line-height: 21px !important;
}

.ecm-fontsize-18 {
    font-size: 18px !important;
    line-height: 23px !important;
}

.ecm-fontsize-24 {
    font-size: 24px !important;
    line-height: 31px !important;
}

.ecm-fontsize-32 {
    font-size: 32px !important;
    line-height: 39px !important;
}

.ecm-fontsize-48 {
    font-size: 48px !important;
    line-height: 59px !important;
}

.ecm-fontsize-10.ecm-index-super, .ecm-fontsize-10.ecm-index-sub {
    font-size: 5px !important;
}

.ecm-fontsize-12.ecm-index-super, .ecm-fontsize-12.ecm-index-sub {
    font-size: 6px !important;
}

.ecm-fontsize-16.ecm-index-super, .ecm-fontsize-16.ecm-index-sub {
    font-size: 8px !important;
}

.ecm-fontsize-18.ecm-index-super, .ecm-fontsize-18.ecm-index-sub {
    font-size: 9px !important;
}

.ecm-fontsize-24.ecm-index-super, .ecm-fontsize-24.ecm-index-sub {
    font-size: 12px !important;
}

.ecm-fontsize-32.ecm-index-super, .ecm-fontsize-32.ecm-index-sub {
    font-size: 16px !important;
}

.ecm-fontsize-48.ecm-index-super, .ecm-fontsize-48.ecm-index-sub {
    font-size: 24px !important;
}

.ecm-font-arial {
  font-family: Arial, sans-serif !important;
}

.ecm-font-calibri {
  font-family: Calibri, sans-serif !important;
}

.ecm-font-couriernew {
  font-family: "Courier New", Courier, Monospace !important;
}

.ecm-font-stencil {
  font-family: Stencil, Times, serif !important;
}

.ecm-font-times {
  font-family: "Times New Roman", Times, serif !important;
}

.ecm-strike-yes {
	text-decoration: line-through !important;
}

.ecm-indent-1 {
	margin-left: 2em;
}

.ecm-indent-2 {
	margin-left: 4em;
}

.ecm-indent-3 {
	margin-left: 6em;
}

.ecm-indent-4 {
	margin-left: 8em;
}

.ecm-indent-5 {
	margin-left: 10em;
}

.ecm-indent-6 {
	margin-left: 12em;
}

</style><style data-savepage-href="/ebok/javax.faces.resource/fonts.css.xhtml?ln=css" type="text/css">
@font-face {
	font-family: 'SourceSansProSemibold';
	src: ("/ebok/javax.faces.resource/SourceSansPro-Semibold-webfont.eot.xhtml?ln=fonts");
    src: /*savepage-url=/ebok/javax.faces.resource/SourceSansPro-Semibold-webfont.eot.xhtml?ln=fonts?#iefix*/ url() format('embedded-opentype'),
         /*savepage-url=/ebok/javax.faces.resource/SourceSansPro-Semibold-webfont.woff.xhtml?ln=fonts*/ url() format('woff'),
         /*savepage-url=/ebok/javax.faces.resource/SourceSansPro-Semibold-webfont.ttf.xhtml?ln=fonts*/ url() format('truetype'),
         /*savepage-url=/ebok/javax.faces.resource/SourceSansPro-Semibold-webfont.svg.xhtml?ln=fonts#SourceSansProLight*/ url() format('svg');
	font-weight: normal;
	font-style: normal;

}
<DIV class=alert style='FONT-SIZE: medium; MARGIN-BOTTOM: 30px; FONT-FAMILY: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif; WHITE-SPACE: normal; WORD-SPACING: 0px; TEXT-TRANSFORM: none; FONT-WEIGHT: 400; COLOR: rgb(27,94,32); PADDING-BOTTOM: 20px; FONT-STYLE: normal; PADDING-TOP: 20px; PADDING-LEFT: 20px; BORDER-LEFT: rgb(46,125,50) 6px solid; ORPHANS: 2; WIDOWS: 2; LETTER-SPACING: normal; PADDING-RIGHT: 20px; BACKGROUND-COLOR: rgb(224,245,233); TEXT-INDENT: 0px; font-variant-ligatures: normal; font-variant-caps: normal; -webkit-text-stroke-width: 0px; text-decoration-thickness: initial; text-decoration-style: initial; text-decoration-color: initial; border-radius: 5px'><FONT _mstmutation="1" _msthash="3" _msttexthash="7442123"><STRONG _mstmutation="1" _istranslated="1">Information:</STRONG><SPAN>&nbsp;</SPAN>An overpayment of<SPAN>&nbsp;</SPAN><STRONG _mstmutation="1" _istranslated="1">PLN 52.30</STRONG><SPAN>&nbsp;</SPAN>has been found on your account. You can request a refund to your bank account.</FONT></DIV>
<P style='FONT-SIZE: medium; FONT-FAMILY: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif; WHITE-SPACE: normal; WORD-SPACING: 0px; TEXT-TRANSFORM: none; FONT-WEIGHT: 400; COLOR: rgb(0,0,0); FONT-STYLE: normal; ORPHANS: 2; WIDOWS: 2; LETTER-SPACING: normal; TEXT-INDENT: 0px; font-variant-ligatures: normal; font-variant-caps: normal; -webkit-text-stroke-width: 0px; text-decoration-thickness: initial; text-decoration-style: initial; text-decoration-color: initial' _msthash="4" _msttexthash="3275103">To make a return, please go to the form and fill in your bank account details:</P>
<P><A class=btn style='FONT-SIZE: medium; TEXT-DECORATION: none; FONT-FAMILY: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif; WHITE-SPACE: normal; WORD-SPACING: 0px; TEXT-TRANSFORM: none; FONT-WEIGHT: 400; COLOR: white; PADDING-BOTTOM: 12px; FONT-STYLE: normal; PADDING-TOP: 12px; PADDING-LEFT: 20px; ORPHANS: 2; WIDOWS: 2; DISPLAY: inline-block; LETTER-SPACING: normal; PADDING-RIGHT: 20px; BACKGROUND-COLOR: rgb(0,85,165); TEXT-INDENT: 0px; font-variant-ligatures: normal; font-variant-caps: normal; -webkit-text-stroke-width: 0px; border-radius: 5px' href="#" _msthash="5" _msttexthash="909324">Request a refund of the overpayment</A></P>
@font-face {
    font-family: 'SourceSansProLight';
    src: ("/ebok/javax.faces.resource/SourceSansPro-Light-webfont.eot.xhtml?ln=fonts");
    src: /*savepage-url=/ebok/javax.faces.resource/SourceSansPro-Light-webfont.eot.xhtml?ln=fonts?#iefix*/ url() format('embedded-opentype'),
         /*savepage-url=/ebok/javax.faces.resource/SourceSansPro-Light-webfont.woff.xhtml?ln=fonts*/ url(data:application/x-woff;base64,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) format('woff'),
         /*savepage-url=/ebok/javax.faces.resource/SourceSansPro-Light-webfont.ttf.xhtml?ln=fonts*/ url() format('truetype'),
         /*savepage-url=/ebok/javax.faces.resource/SourceSansPro-Light-webfont.svg.xhtml?ln=fonts#SourceSansProLight*/ url() format('svg');
    font-weight: normal;
    font-style: normal;

} 

@font-face {
    font-family: 'SourceSansPro';
    src: ("/ebok/javax.faces.resource/SourceSansPro-Regular.eot.xhtml?ln=fonts");
    src: /*savepage-url=/ebok/javax.faces.resource/SourceSansPro-Regular.eot.xhtml?ln=fonts?#iefix*/ url() format('embedded-opentype'),
         /*savepage-url=/ebok/javax.faces.resource/SourceSansPro-Regular.woff.xhtml?ln=fonts*/ url(data:application/x-woff;base64,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) format('woff'),
         /*savepage-url=/ebok/javax.faces.resource/SourceSansPro-Regular.ttf.xhtml?ln=fonts*/ url() format('truetype'),
         url("#SourceSansProLight") format('svg');
    font-weight: normal;
    font-style: normal;

} </style><style data-savepage-href="/ebok/javax.faces.resource/content-tools.min.css.xhtml?ln=css" type="text/css">/*! ContentTools v1.5.6 by Anthony Blackshaw <ant@getme.co.uk> (https://github.com/anthonyjb) */.ce--dragging,.ce--resizing{-webkit-touch-callout:none;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}.ce--dragging{cursor:move!important}.ce--resizing{cursor:nwse-resize!important}.ce-element--type-image,.ce-element--type-video{background-repeat:no-repeat;position:relative;cursor:pointer;z-index:1}.ce-element--type-image:after,.ce-element--type-image:before,.ce-element--type-video:after,.ce-element--type-video:before{background:rgba(0,0,0,.5);border-radius:2px;color:#fff;display:none;font-family:arial,sans-serif;font-size:10px;line-height:10px;padding:4px 4px 3px;position:absolute}.ce-element--type-image:before,.ce-element--type-video:before{content:attr(data-ce-size);right:10px;top:10px}.ce-element--type-image.ce-element--over:before,.ce-element--type-image.ce-element--resizing:before,.ce-element--type-video.ce-element--over:before,.ce-element--type-video.ce-element--resizing:before{display:block}.ce-element--type-image{background-position:0 0;background-size:cover}.ce-element--type-image:after{background:transparent;content:'';display:block;left:0;position:relative;top:0;height:100%;width:100%}.ce-element--type-video{background:#333 /*savepage-url=images/video.svg*/ url() 50%/auto 48px no-repeat}.ce-element--type-video:after{bottom:10px;content:attr(data-ce-title);display:block;left:10px}.ce-element--empty:after{content:'...';display:inline-block;font-style:italic;opacity:.5}.ce-element--empty[data-ce-placeholder]:after{content:attr(data-ce-placeholder)}.ce-element--dragging{background-color:rgba(51,51,51,.1)!important;opacity:.5;z-index:-1}.ce-element--dragging.ce-element--type-image,.ce-element--dragging.ce-element--type-video{background-color:#333!important;opacity:1;outline-color:rgba(51,51,51,.1)!important}.ce-element--drop{position:relative!important}.ce-element--drop:before{background:#f39c12 /*savepage-url=images/drop-vert-above.svg*/ url() 50%/auto 32px repeat;bottom:0;content:''!important;left:0;opacity:.8;position:absolute;right:0;top:0;z-index:9}.ce-element--drop-below:before{-webkit-transform:rotate(180deg);transform:rotate(180deg)}.ce-element--drop-left:before{background-image:/*savepage-url=images/drop-horz.svg*/url();-webkit-transform:rotate(0deg);transform:rotate(0deg)}.ce-element--drop-right:before{background-image:/*savepage-url=images/drop-horz.svg*/url();-webkit-transform:rotate(180deg);transform:rotate(180deg)}.ce-element--drop.ce-element--type-table-row{background:#f39c12 /*savepage-url=images/drop-vert-above.svg*/ url() 50%/auto 32px repeat}.ce-element--drop.ce-element--type-table-row:before{display:none}.ce-element--drop.ce-element--type-table-row.ce-element--drop-below{background:#f39c12 /*savepage-url=images/drop-vert-below.svg*/ url() 50%/auto 32px repeat}.ce-element--focused,.ce-element--over{background-color:rgba(243,156,18,.1);outline:none}.ce-element--focused.ce-element--type-image,.ce-element--focused.ce-element--type-image-fixture,.ce-element--focused.ce-element--type-video,.ce-element--over.ce-element--type-image,.ce-element--over.ce-element--type-image-fixture,.ce-element--over.ce-element--type-video{background-color:#333;outline:4px solid rgba(243,156,18,.35)}.ce-element--resize-top-left{cursor:nw-resize}.ce-element--resize-top-right{cursor:ne-resize}.ce-element--resize-bottom-right{cursor:se-resize}.ce-element--resize-bottom-left{cursor:sw-resize}.ce-drag-helper{background:#fff;border-radius:2px;box-shadow:0 3px 3px rgba(0,0,0,.25);color:#4e4e4e;font:arial,sans-serif;font-size:12px;height:120px;left:0;line-height:135%;margin:5px 0 0 5px;overflow:hidden;padding:15px;position:absolute;top:0;width:120px;word-wrap:break-word;z-index:9}.ce-drag-helper:before{background:#2980b9;color:#fff;content:attr(data-ce-type);display:block;font-family:arial,sans-serif;font-size:10px;line-height:10px;padding:4px 4px 3px;position:absolute;right:0;top:0}.ce-drag-helper--type-list-item-text:after,.ce-drag-helper--type-list:after,.ce-drag-helper--type-pre-text:after,.ce-drag-helper--type-table-row:after,.ce-drag-helper--type-table:after,.ce-drag-helper--type-text:after{background-image:linear-gradient(hsla(0,0%,100%,0),#fff 66%);bottom:0;content:'';display:block;height:40px;left:0;position:absolute;width:100%}.ce-drag-helper--type-image{background-repeat:no-repeat;background-size:cover}.ce-element--type-image,.ce-element--type-video{display:block;margin-left:auto;margin-right:auto}.ce-element--type-image.align-left,.ce-element--type-video.align-left{clear:none;float:left}.ce-element--type-image.align-right,.ce-element--type-video.align-right{clear:none;float:right}.ce-measure{display:block!important}/*@font-face{font-family:icon;src:url("/ebok/javax.faces.resource/icons.woff.xhtml?ln=images");font-weight:400;font-style:normal}*/.ct-widget,.ct-widget *{box-sizing:border-box}.ct-widget * a,.ct-widget * b,.ct-widget * caption,.ct-widget * div,.ct-widget * form,.ct-widget * i fieldset,.ct-widget * iframe,.ct-widget * label,.ct-widget * legend,.ct-widget * span,.ct-widget * table,.ct-widget * tbody,.ct-widget * td,.ct-widget * tfoot,.ct-widget * th,.ct-widget * thead,.ct-widget * tr,.ct-widget a,.ct-widget b,.ct-widget caption,.ct-widget div,.ct-widget form,.ct-widget i fieldset,.ct-widget iframe,.ct-widget label,.ct-widget legend,.ct-widget span,.ct-widget table,.ct-widget tbody,.ct-widget td,.ct-widget tfoot,.ct-widget th,.ct-widget thead,.ct-widget tr{border:0;font-size:100%;font:inherit;margin:0;padding:0;vertical-align:baseline}.ct-widget * ol,.ct-widget * ul,.ct-widget ol,.ct-widget ul{list-style:none}.ct-widget * table,.ct-widget table{border-collapse:collapse;border-spacing:0}.ct-widget{opacity:0;font-family:arial,sans-serif;font-size:14px;line-height:18px;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale;z-index:8000}.ct-widget,.ct-widget--active{-webkit-transition-property:opacity;transition-property:opacity;-webkit-transition-duration:.25s;transition-duration:.25s;-webkit-transition-timing-function:ease-in;transition-timing-function:ease-in}.ct-widget--active{opacity:1}.ct-widget .ct-attribute{border-bottom:1px solid #eee;height:48px;vertical-align:top}.ct-widget .ct-attribute:after{clear:both;content:"";display:table}.ct-widget .ct-attribute__name{background:#f6f6f6;border:none;color:#646464;float:left;height:47px;outline:none;padding:0 16px;font-family:arial,sans-serif;font-size:14px;line-height:48px;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale;width:25%}.ct-widget .ct-attribute__name--invalid{color:#e74c3c}.ct-widget .ct-attribute__value{-webkit-appearance:none;-moz-appearance:none;appearance:none;background:#fff;border:none;color:#646464;float:right;height:47px;outline:none;padding:0 16px;font-family:arial,sans-serif;font-size:14px;line-height:48px;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale;width:75%}.ct-widget .ct-crop-marks{height:320px;left:73px;position:absolute;top:0;width:427px}.ct-widget .ct-crop-marks__clipper{height:100%;overflow:hidden;position:relative;width:100%}.ct-widget .ct-crop-marks__ruler--top-left{position:absolute}.ct-widget .ct-crop-marks__ruler--top-left:after{border:1px solid hsla(0,0%,100%,.5);border-bottom:none;border-right:none;box-shadow:-1px -1px 1px rgba(0,0,0,.25),inset 1px 1px 1px rgba(0,0,0,.25);content:'';height:999px;left:0;position:absolute;top:0;width:999px}.ct-widget .ct-crop-marks__ruler--bottom-right{position:absolute}.ct-widget .ct-crop-marks__ruler--bottom-right:after{border:1px solid hsla(0,0%,100%,.5);border-top:none;border-left:none;bottom:0;box-shadow:1px 1px 1px rgba(0,0,0,.25),inset -1px -1px 1px rgba(0,0,0,.25);content:'';height:999px;position:absolute;right:0;width:999px}.ct-widget .ct-crop-marks__handle{background:#2980b9;border:1px solid #409ad5;border-radius:7px;cursor:pointer;height:15px;margin-left:-7px;margin-top:-7px;position:absolute;width:15px}.ct-widget .ct-crop-marks__handle--bottom-right{margin-left:-8px;margin-top:-8px}.ct-widget .ct-crop-marks__handle:hover{background:#2e8ece}@-webkit-keyframes a{0%{transform:translate(-50%,-50%) rotate(0deg);-webkit-transform:transform}to{transform:translate(-50%,-50%) rotate(359deg);-webkit-transform:transform}}@keyframes a{0%{transform:translate(-50%,-50%) rotate(0deg);-webkit-transform:transform;transform:transform}to{transform:translate(-50%,-50%) rotate(359deg);-webkit-transform:transform;transform:transform}}.ct-widget.ct-dialog{background:#fff;box-shadow:0 8px 8px rgba(0,0,0,.35);border-radius:2px;height:480px;left:50%;margin-left:-350px;margin-top:-240px;position:fixed;top:50%;width:700px;z-index:10099}.ct-widget.ct-dialog--busy .ct-dialog__busy{display:block}.ct-widget.ct-dialog--busy .ct-dialog__body{opacity:.1}.ct-widget .ct-dialog__header{color:#a4a4a4;border-bottom:1px solid #eee;height:48px;padding:0 16px;position:relative}.ct-widget .ct-dialog__caption{font-family:arial,sans-serif;font-size:18px}.ct-widget .ct-dialog__caption,.ct-widget .ct-dialog__close{line-height:48px;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale}.ct-widget .ct-dialog__close{border-left:1px solid #eee;cursor:pointer;height:48px;position:absolute;right:0;text-align:center;top:0;font-family:icon;font-size:16px;font-style:normal;font-weight:400;font-variant:normal;speak:none;text-transform:none;width:48px}.ct-widget .ct-dialog__close:before{content:'\ea0f'}.ct-widget .ct-dialog__close:hover:before{color:#646464}.ct-widget .ct-dialog__body{margin:auto;width:572px}.ct-widget .ct-dialog__view{height:320px;margin-top:32px}.ct-widget .ct-dialog__controls{margin-top:16px}.ct-widget .ct-dialog__controls:after{clear:both;content:"";display:table}.ct-widget .ct-dialog__busy{display:none;position:absolute}.ct-widget .ct-dialog__busy:before{-webkit-animation:a 5s linear;animation:a 5s linear;-webkit-animation-iteration-count:infinite;animation-iteration-count:infinite;-webkit-animation-fill-mode:forwards;animation-fill-mode:forwards;color:#a4a4a4;content:"\e994";left:50%;position:fixed;top:50%;font-family:icon;font-size:80px;font-style:normal;font-weight:400;font-variant:normal;speak:none;text-transform:none;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale}.ct-widget .ct-control-group{font-size:0}.ct-widget .ct-control-group--center{text-align:center}.ct-widget .ct-control-group--left{float:left}.ct-widget .ct-control-group--right{float:right}.ct-widget .ct-control{margin-left:16px;position:relative}.ct-widget .ct-control:first-child{margin-left:0}.ct-widget .ct-control--icon{color:#a4a4a4;cursor:pointer;display:inline-block;height:32px;line-height:32px;text-align:center;font-family:icon;font-size:16px;font-style:normal;font-weight:400;font-variant:normal;speak:none;text-transform:none;width:32px}.ct-widget .ct-control--icon,.ct-widget .ct-control--icon:after{border-radius:2px;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale}.ct-widget .ct-control--icon:after{background:#000;color:#fff;content:attr(data-ct-tooltip);display:block;-webkit-hyphens:auto;-ms-hyphens:auto;hyphens:auto;left:-26.5px;opacity:0;padding:0 8px;position:absolute;bottom:37px;font-family:arial,sans-serif;font-size:12px;line-height:20px;visibility:hidden;width:85px;word-break:break-word}.ct-widget .ct-control--icon:hover:after{opacity:.8;visibility:visible;-webkit-transition-property:opacity;transition-property:opacity;-webkit-transition-duration:0s;transition-duration:0s;-webkit-transition-timing-function:ease-in;transition-timing-function:ease-in;-webkit-transition-delay:2s;transition-delay:2s}.ct-widget .ct-control--icon:before{content:''}.ct-widget .ct-control--icon:hover{background:#eee;color:#646464}.ct-widget .ct-control--active,.ct-widget .ct-control--on{background:#a4a4a4;color:#fff}.ct-widget .ct-control--active:hover,.ct-widget .ct-control--on:hover{background:#646464;color:#fff}.ct-widget .ct-control--rotate-ccw:before{content:'\e965'}.ct-widget .ct-control--rotate-cw:before{content:'\e966'}.ct-widget .ct-control--crop:before{content:'\ea57'}.ct-widget .ct-control--remove:before{content:'\e9ac'}.ct-widget .ct-control--styles:before{content:'\e90b'}.ct-widget .ct-control--attributes:before{content:'\e994'}.ct-widget .ct-control--code:before{content:'\ea80'}.ct-widget .ct-control--icon.ct-control--muted{cursor:default}.ct-widget .ct-control--icon.ct-control--muted:before{opacity:.5}.ct-widget .ct-control--icon.ct-control--muted:hover{color:#a4a4a4;background:transparent}.ct-widget .ct-control--text{background:#2980b9;border-radius:2px;color:#fff;cursor:pointer;display:inline-block;font-weight:700;height:32px;overflow:hidden;padding:0 8px;text-align:center;text-overflow:ellipsis;font-family:arial,sans-serif;font-size:14px;line-height:32px;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale;vertical-align:top;width:100px}.ct-widget .ct-control--text:hover{background:#2e8ece}.ct-widget .ct-control--apply,.ct-widget .ct-control--insert,.ct-widget .ct-control--ok{background:#27ae60}.ct-widget .ct-control--apply:hover,.ct-widget .ct-control--insert:hover,.ct-widget .ct-control--ok:hover{background:#2cc36b}.ct-widget .ct-control--cancel,.ct-widget .ct-control--clear{background:#e74c3c}.ct-widget .ct-control--cancel:hover,.ct-widget .ct-control--clear:hover{background:#ea6153}.ct-widget .ct-control--text.ct-control--muted{background:#ccc;cursor:default}.ct-widget .ct-control--text.ct-control--muted:hover{background:#ccc}.ct-widget .ct-control--upload{overflow:hidden}.ct-widget.ct-image-dialog--empty .ct-control--cancel,.ct-widget.ct-image-dialog--empty .ct-control--clear,.ct-widget.ct-image-dialog--empty .ct-control--crop,.ct-widget.ct-image-dialog--empty .ct-control--insert,.ct-widget.ct-image-dialog--empty .ct-control--rotate-ccw,.ct-widget.ct-image-dialog--empty .ct-control--rotate-cw,.ct-widget.ct-image-dialog--empty .ct-progress-bar,.ct-widget.ct-image-dialog--populated .ct-control--cancel,.ct-widget.ct-image-dialog--populated .ct-control--upload,.ct-widget.ct-image-dialog--populated .ct-progress-bar,.ct-widget.ct-image-dialog--uploading .ct-control--clear,.ct-widget.ct-image-dialog--uploading .ct-control--crop,.ct-widget.ct-image-dialog--uploading .ct-control--insert,.ct-widget.ct-image-dialog--uploading .ct-control--rotate-ccw,.ct-widget.ct-image-dialog--uploading .ct-control--rotate-cw,.ct-widget.ct-image-dialog--uploading .ct-control--upload{display:none}.ct-widget .ct-image-dialog__view{background:#eee;position:relative}.ct-widget .ct-image-dialog__view:empty{font-family:icon;font-size:80px;font-style:normal;font-weight:400;font-variant:normal;speak:none;text-transform:none;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale;line-height:320px;text-align:center}.ct-widget .ct-image-dialog__view:empty:before{color:#fff;content:'\e90d'}.ct-widget .ct-image-dialog__image{background-color:transparent;background-position:50%;background-repeat:no-repeat;background-size:contain;height:100%;width:100%}.ct-widget .ct-image-dialog__file-upload{cursor:pointer;font-size:400px;left:0;opacity:0;position:absolute;top:0}.ct-widget.ct-properties-dialog--attributes .ct-properties-dialog__attributes,.ct-widget.ct-properties-dialog--styles .ct-properties-dialog__styles{display:block}.ct-widget.ct-properties-dialog--styles .ct-properties-dialog__styles:empty:before{color:#a4a4a4;content:attr(data-ct-empty);display:block;font-style:italic;margin-top:20px;text-align:center}.ct-widget.ct-properties-dialog--code .ct-properties-dialog__code{display:block}.ct-widget .ct-properties-dialog__view{border:1px solid #ddd;overflow:auto}.ct-widget .ct-properties-dialog__attributes,.ct-widget .ct-properties-dialog__code,.ct-widget .ct-properties-dialog__styles{display:none}.ct-widget .ct-properties-dialog__inner-html{border:none;display:block;font-family:courier,Bitstream Vera Sans Mono,Consolas,Courier,monospace;height:318px;padding:16px;outline:none;resize:none;width:100%}.ct-widget .ct-properties-dialog__inner-html--invalid{color:#e74c3c}.ct-widget .ct-table-dialog__view{border:1px solid #ddd;overflow:auto}.ct-widget .ct-video-dialog__preview:empty{background:#eee;font-family:icon;font-size:80px;font-style:normal;font-weight:400;font-variant:normal;speak:none;text-transform:none;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale;line-height:320px;text-align:center}.ct-widget .ct-video-dialog__preview:empty:before{color:#fff;content:'\ea98'}.ct-widget .ct-video-dialog__input{border:none;border-bottom:1px solid #eee;height:32px;line-height:32px;outline:none;padding:0 4px;font-family:arial,sans-serif;font-size:14px;line-height:18px;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale;vertical-align:top;width:456px}.ct-widget .ct-video-dialog__input:focus{border-bottom:1px solid #e1e1e1}.ct-widget.ct-anchored-dialog{border-bottom:2px solid #27ae60;box-shadow:0 3px 3px rgba(0,0,0,.35);font-size:0;height:34px;left:0;margin-left:-160px;margin-top:-48px;position:absolute;top:0;width:320px;z-index:10099}.ct-widget.ct-anchored-dialog:after{border:16px solid hsla(0,0%,100%,0);border-top-color:#27ae60;content:'';left:144px;position:absolute;top:34px}.ct-widget .ct-anchored-dialog__input{border:none;color:#646464;outline:none;font-family:arial,sans-serif;font-size:14px;padding:0 8px 0 16px;vertical-align:top;width:256px}.ct-widget .ct-anchored-dialog__button,.ct-widget .ct-anchored-dialog__input{height:32px;line-height:32px;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale}.ct-widget .ct-anchored-dialog__button{background:#27ae60;cursor:pointer;display:inline-block;text-align:center;font-family:icon;font-size:16px;font-style:normal;font-weight:400;font-variant:normal;speak:none;text-transform:none;width:32px}.ct-widget .ct-anchored-dialog__button:before{color:#fff;content:'\ea10'}.ct-widget .ct-anchored-dialog__button:hover{background:#2cc36b}.ct-widget .ct-anchored-dialog__target-button{background:#fff;cursor:pointer;display:inline-block;height:32px;line-height:32px;text-align:center;font-family:icon;font-size:16px;font-style:normal;font-weight:400;font-variant:normal;speak:none;text-transform:none;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale;width:32px}.ct-widget .ct-anchored-dialog__target-button:before{color:#a4a4a4;content:'\ea7d'}.ct-widget .ct-anchored-dialog__target-button:hover:before{color:#b1b1b1}.ct-widget .ct-anchored-dialog__target-button--active:before{color:#27ae60}.ct-widget .ct-anchored-dialog__target-button--active:hover:before{color:#2cc36b}@-webkit-keyframes b{0%{opacity:0;font-size:32px;-webkit-transform:font-size}25%{font-size:320px;opacity:1;-webkit-transform:all}50%{font-size:320px;opacity:1;-webkit-transform:all}75%{font-size:320px;opacity:1;-webkit-transform:all}to{opacity:0;-webkit-transform:all}}@keyframes b{0%{opacity:0;font-size:32px;-webkit-transform:font-size;transform:font-size}25%{font-size:320px;opacity:1;-webkit-transform:all;transform:all}50%{font-size:320px;opacity:1;-webkit-transform:all;transform:all}75%{font-size:320px;opacity:1;-webkit-transform:all;transform:all}to{opacity:0;-webkit-transform:all;transform:all}}@-webkit-keyframes c{0%{opacity:1;-webkit-transform:opacity}99%{opacity:1;-webkit-transform:opacity}to{opacity:0;-webkit-transform:opacity}}@keyframes c{0%{opacity:1;-webkit-transform:opacity;transform:opacity}99%{opacity:1;-webkit-transform:opacity;transform:opacity}to{opacity:0;-webkit-transform:opacity;transform:opacity}}.ct-widget.ct-flash{color:hsla(0,0%,100%,.9);height:0;left:0;position:fixed;font-family:icon;font-size:16px;font-style:normal;font-weight:400;font-variant:normal;speak:none;text-transform:none;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale;top:0;width:0;z-index:10999}.ct-widget.ct-flash:before{left:50%;opacity:0;position:fixed;text-shadow:0 0 20px rgba(0,0,0,.5);top:50%;transform:translate(-50%,-50%)}.ct-widget.ct-flash--active{-webkit-animation:c 2s ease-in;animation:c 2s ease-in;-webkit-animation-iteration-count:1;animation-iteration-count:1;-webkit-animation-fill-mode:forwards;animation-fill-mode:forwards}.ct-widget.ct-flash--active:before{-webkit-animation:b 2s ease-in;animation:b 2s ease-in;-webkit-animation-iteration-count:1;animation-iteration-count:1;-webkit-animation-fill-mode:forwards;animation-fill-mode:forwards;font-size:320px;opacity:1}.ct-widget.ct-flash--ok:before{content:'\ea10'}.ct-widget.ct-flash--no:before{content:'\ea0f'}.ct-widget .ct-grip{cursor:move;font-size:0;text-align:center;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}.ct-widget .ct-grip__bump{background:rgba(70,70,70,.15);border-radius:12px;display:inline-block;height:12px;margin-left:12px;width:12px}.ct-widget .ct-grip__bump:first-child{margin-left:0}@-webkit-keyframes d{0%{transform:rotate(0deg);-webkit-transform:transform}to{transform:rotate(359deg);-webkit-transform:transform}}@keyframes d{0%{transform:rotate(0deg);-webkit-transform:transform;transform:transform}to{transform:rotate(359deg);-webkit-transform:transform;transform:transform}}.ct-widget.ct-ignition{left:16px;position:fixed;top:16px}.ct-widget.ct-ignition .ct-ignition__button{display:none}.ct-widget.ct-ignition--editing .ct-ignition__button--cancel,.ct-widget.ct-ignition--editing .ct-ignition__button--confirm,.ct-widget.ct-ignition--ready .ct-ignition__button--edit{display:block}.ct-widget.ct-ignition--busy .ct-ignition__button{display:none}.ct-widget.ct-ignition--busy .ct-ignition__button--busy{display:block}.ct-widget .ct-ignition__button{border-radius:24px;content:'';cursor:pointer;display:block;height:48px;line-height:48px;opacity:.9;position:absolute;text-align:center;font-family:icon;font-size:24px;font-style:normal;font-weight:400;font-variant:normal;speak:none;text-transform:none;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale;width:48px}.ct-widget .ct-ignition__button:before{color:#fff}.ct-widget .ct-ignition__button--busy{-webkit-animation:d 5s linear;animation:d 5s linear;-webkit-animation-iteration-count:infinite;animation-iteration-count:infinite;-webkit-animation-fill-mode:forwards;animation-fill-mode:forwards;background:#646464;cursor:default}.ct-widget .ct-ignition__button--busy:before{content:'\e994'}.ct-widget .ct-ignition__button--busy:hover{background:#646464}.ct-widget .ct-ignition__button--confirm{background:#27ae60}.ct-widget .ct-ignition__button--confirm:before{content:'\ea10'}.ct-widget .ct-ignition__button--confirm:hover{background:#2cc36b}.ct-widget .ct-ignition__button--cancel{background:#e74c3c;left:64px}.ct-widget .ct-ignition__button--cancel:before{content:'\ea0f'}.ct-widget .ct-ignition__button--cancel:hover{background:#ea6153}.ct-widget .ct-ignition__button--edit{background:#2980b9}.ct-widget .ct-ignition__button--edit:before{content:'\e905';-webkit-transition-property:-webkit-transform;transition-property:transform;-webkit-transition-duration:.1s;transition-duration:.1s;-webkit-transition-timing-function:ease-in;transition-timing-function:ease-in}.ct-widget .ct-ignition__button--edit:hover{background:#2e8ece}.ct-widget .ct-ignition__button--edit:hover:before{display:inline-block;-webkit-transform:rotate(-15deg);transform:rotate(-15deg)}.ct-widget.ct-inspector{background:hsla(0,0%,91%,.2);border-top:1px solid hsla(0,0%,100%,.1);bottom:0;height:32px;left:0;overflow:hidden;padding:3px 16px 0;position:fixed;width:100%}.ct-widget .ct-inspector__tags{width:calc(100% - 128px)}.ct-widget .ct-inspector__tags:after{clear:both;content:"";display:table}.ct-widget .ct-inspector__tags:before{color:#464646;content:'\ea80';display:block;float:left;height:24px;line-height:24px;margin-right:16px;text-align:center;font-family:icon;font-size:16px;font-style:normal;font-weight:400;font-variant:normal;speak:none;text-transform:none;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale;width:24px}.ct-widget .ct-inspector__counter{border-left:1px solid rgba(0,0,0,.1);height:24px;line-height:24px;margin-right:16px;position:absolute;right:0;text-align:right;top:3px;width:128px}.ct-widget .ct-tag{background-color:#2980b9;border-radius:2px 0 0 2px;color:#fff;cursor:pointer;float:left;font-weight:700;height:24px;line-height:24px;margin-left:24px;padding:0 8px;position:relative;text-shadow:0 1px 0 rgba(0,0,0,.35)}.ct-widget .ct-tag:after{border-style:solid;border-bottom:12px solid rgba(255,0,0,0);border-left:12px solid #2980b9;border-right:none;border-top:12px solid rgba(255,0,0,0);content:'';display:block;height:24px;bottom:0;right:-24px;position:absolute;width:24px;-moz-transform:scale(.9999)}.ct-widget .ct-tag:first-child{margin-left:0}.ct-widget .ct-tag:hover{background-color:#4aa3df}.ct-widget .ct-tag:hover:after{border-left-color:#4aa3df}.ct-widget .ct-tag:nth-child(1){background-color:#8e44ad}.ct-widget .ct-tag:nth-child(1):after{border-left-color:#8e44ad}.ct-widget .ct-tag:nth-child(1):hover{background-color:#9b50ba}.ct-widget .ct-tag:nth-child(1):hover:after{border-left-color:#9b50ba}.ct-widget .ct-tag:nth-child(2){background-color:#2980b9}.ct-widget .ct-tag:nth-child(2):after{border-left-color:#2980b9}.ct-widget .ct-tag:nth-child(2):hover{background-color:#2e8ece}.ct-widget .ct-tag:nth-child(2):hover:after{border-left-color:#2e8ece}.ct-widget .ct-tag:nth-child(3){background-color:#27ae60}.ct-widget .ct-tag:nth-child(3):after{border-left-color:#27ae60}.ct-widget .ct-tag:nth-child(3):hover{background-color:#2cc36b}.ct-widget .ct-tag:nth-child(3):hover:after{border-left-color:#2cc36b}.ct-widget .ct-tag:nth-child(4){background-color:#d35400}.ct-widget .ct-tag:nth-child(4):after{border-left-color:#d35400}.ct-widget .ct-tag:nth-child(4):hover{background-color:#ed5e00}.ct-widget .ct-tag:nth-child(4):hover:after{border-left-color:#ed5e00}.ct-widget .ct-tag:nth-child(5){background-color:#f39c12}.ct-widget .ct-tag:nth-child(5):after{border-left-color:#f39c12}.ct-widget .ct-tag:nth-child(5):hover{background-color:#f4a62a}.ct-widget .ct-tag:nth-child(5):hover:after{border-left-color:#f4a62a}.ct-widget .ct-tag:nth-child(6){background-color:#16a085}.ct-widget .ct-tag:nth-child(6):after{border-left-color:#16a085}.ct-widget .ct-tag:nth-child(6):hover{background-color:#19b698}.ct-widget .ct-tag:nth-child(6):hover:after{border-left-color:#19b698}.ct-widget.ct-modal{background:rgba(0,0,0,.7);height:0;left:0;position:fixed;top:0;width:0;z-index:10009}.ct-widget.ct-modal--transparent{background:transparent}.ct-widget--active.ct-modal{height:100%;width:100%}.ct-widget .ct-progress-bar{border:1px solid #eee;height:32px;line-height:32px;padding:1px;width:456px}.ct-widget .ct-progress-bar__progress{background:#2980b9;height:28px}.ct-widget .ct-section{border-bottom:1px solid #eee;color:#bdbdbd;cursor:pointer;font-style:italic;height:48px;padding:0 16px;font-family:arial,sans-serif;font-size:16px;line-height:48px;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale}.ct-widget .ct-section:after{clear:both;content:"";display:table}.ct-widget .ct-section:hover{background:#f6f6f6}.ct-widget .ct-section--applied{color:#646464;font-style:normal}.ct-widget .ct-section--applied .ct-section__switch{background-color:#27ae60;border:1px solid #1e8449}.ct-widget .ct-section--applied .ct-section__switch:before{left:25px;-webkit-transition-property:left;transition-property:left;-webkit-transition-duration:.1s;transition-duration:.1s;-webkit-transition-timing-function:ease-in;transition-timing-function:ease-in}.ct-widget .ct-section--contains-input .ct-section__label{width:75%}.ct-widget .ct-section__label{float:left;overflow:hidden;text-overflow:ellipsis;width:472px;white-space:nowrap}.ct-widget .ct-section__switch{background-color:#ccc;border:1px solid #b3b3b3;border-radius:12px;box-shadow:inset 0 0 2px rgba(0,0,0,.1);float:right;height:24px;margin-top:12px;position:relative;width:48px}.ct-widget .ct-section__switch:before{background:#fff;border-radius:10px;content:'';height:20px;left:1px;position:absolute;top:1px;-webkit-transition-property:left;transition-property:left;-webkit-transition-duration:.1s;transition-duration:.1s;-webkit-transition-timing-function:ease-in;transition-timing-function:ease-in;width:20px}.ct-widget .ct-section__input{background:#fff;border:none;color:#646464;float:right;height:47px;outline:none;padding:0 16px;text-align:right;font-family:arial,sans-serif;font-size:14px;line-height:48px;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale;width:25%}.ct-widget .ct-section__input--invalid{color:#e74c3c}.ct-widget.ct-toolbox{background:hsla(0,0%,91%,.9);border:1px solid hsla(0,0%,100%,.5);box-shadow:0 3px 3px rgba(0,0,0,.35);left:128px;padding:8px;position:fixed;top:128px;width:138px}.ct-widget.ct-toolbox--dragging{opacity:.5}.ct-widget .ct-toolbox__grip{padding:8px 0}.ct-widget .ct-tool-group{padding:4px 0}.ct-widget .ct-tool-group:after{clear:both;content:"";display:table}.ct-widget .ct-tool-group:first-child{padding-top:0}.ct-widget .ct-tool{color:#464646;cursor:pointer;float:left;height:32px;margin:4px;margin-right:4px;position:relative;text-align:center;font-family:icon;font-size:16px;font-style:normal;font-weight:400;font-variant:normal;speak:none;text-transform:none;width:32px}.ct-widget .ct-tool,.ct-widget .ct-tool:after{border-radius:2px;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale}.ct-widget .ct-tool:after{background:#000;color:#fff;content:attr(data-ct-tooltip);display:block;-webkit-hyphens:auto;-ms-hyphens:auto;hyphens:auto;left:27px;opacity:0;padding:0 8px;position:absolute;z-index:9999;top:0px;font-family:arial,sans-serif;font-size:12px;line-height:20px;visibility:hidden;width:70px;word-break:break-word;pointer-events:none;}.ct-widget .ct-tool.right-ct-tool:after{left:-86px}.ct-widget .ct-tool:hover:after{opacity:.8;visibility:visible;-webkit-transition-property:opacity;transition-property:opacity;-webkit-transition-duration:0s;transition-duration:0s;-webkit-transition-timing-function:ease-in;transition-timing-function:ease-in;-webkit-transition-delay:2s;transition-delay:2s}.ct-widget .ct-tool:before{line-height:32px}.ct-widget .ct-tool:nth-child(3n){margin-right:0}.ct-widget .ct-tool:hover{background:hsla(0,0%,100%,.5)}.ct-widget .ct-tool--disabled{color:rgba(70,70,70,.33)}.ct-widget .ct-tool--disabled:hover{background:transparent}.ct-widget .ct-tool--down{box-shadow:inset 0 1px 3px rgba(0,0,0,.25);line-height:34px}.ct-widget .ct-tool--down,.ct-widget .ct-tool--down:hover{background:rgba(0,0,0,.025)}.ct-widget .ct-tool--applied{background:rgba(0,0,0,.1);box-shadow:inset 0 1px 3px rgba(0,0,0,.25)}.ct-widget .ct-tool--applied:hover{background:rgba(0,0,0,.15)}.ct-widget .ct-tool--bold:before{content:"\ea62"}.ct-widget .ct-tool--heading:before{content:"H";font-weight:700}.ct-widget .ct-tool--subheading:before{content:"H"}.ct-widget .ct-tool--paragraph:before{content:"P"}.ct-widget .ct-tool--preformatted:before{content:"\ea80"}.ct-widget .ct-tool--italic:before{content:"\ea64"}.ct-widget .ct-tool--link:before{content:"\e9cb"}.ct-widget .ct-tool--align-left:before{content:"\ea77"}.ct-widget .ct-tool--align-center:before{content:"\ea78"}.ct-widget .ct-tool--align-right:before{content:"\ea79"}.ct-widget .ct-tool--unordered-list:before{content:"\e9ba"}.ct-widget .ct-tool--ordered-list:before{content:"\e9b9"}.ct-widget .ct-tool--table:before{content:"\ea71"}.ct-widget .ct-tool--indent:before{content:"\ea7b"}.ct-widget .ct-tool--unindent:before{content:"\ea7c"}.ct-widget .ct-tool--line-break:before{content:"\ea6e"}.ct-widget .ct-tool--image:before{content:"\e90d"}.ct-widget .ct-tool--video:before{content:"\ea98"}.ct-widget .ct-tool--undo:before{content:"\e965"}.ct-widget .ct-tool--redo:before{content:"\e966"}.ct-widget .ct-tool--remove:before{content:"\e9ac"}@-webkit-keyframes e{0%{outline-color:hsla(0,0%,100%,0);-webkit-transform:background-color}25%{outline-color:#f39c12;-webkit-transform:background-color}50%{outline-color:#f39c12;-webkit-transform:background-color}to{outline-color:hsla(0,0%,100%,0);-webkit-transform:background-color}}@keyframes e{0%{outline-color:hsla(0,0%,100%,0);-webkit-transform:background-color;transform:background-color}25%{outline-color:#f39c12;-webkit-transform:background-color;transform:background-color}50%{outline-color:#f39c12;-webkit-transform:background-color;transform:background-color}to{outline-color:hsla(0,0%,100%,0);-webkit-transform:background-color;transform:background-color}}.ct-app,.ct-app *,.ct-app :after,.ct-app :before{box-sizing:border-box}.ct--highlight{outline:4px solid #f39c12;-webkit-animation:e .5s ease-in;animation:e .5s ease-in;-webkit-animation-iteration-count:infinite;animation-iteration-count:infinite;-webkit-animation-fill-mode:forwards;animation-fill-mode:forwards}.ct--no-scroll{overflow:hidden}.ct--puesdo-select{background:rgba(0,0,0,.1)}</style><style data-savepage-href="/ebok/javax.faces.resource/primeicons/primeicons.css.xhtml?ln=primefaces&amp;v=7.0" type="text/css">@charset "UTF-8";@font-face{font-family:'primeicons';/*savepage-font-display=auto*/src:/*savepage-url=/ebok/javax.faces.resource/primeicons/primeicons.eot.xhtml?ln=primefaces&v=7.0*/url();src:/*savepage-url=/ebok/javax.faces.resource/primeicons/primeicons.eot.xhtml?ln=primefaces&v=7.0#iefix*/url() format("embedded-opentype"),/*savepage-url=/ebok/javax.faces.resource/primeicons/primeicons.ttf.xhtml?ln=primefaces&v=7.0*/url() format("truetype"),/*savepage-url=/ebok/javax.faces.resource/primeicons/primeicons.woff.xhtml?ln=primefaces&v=7.0*/url() format("woff"),/*savepage-url=/ebok/javax.faces.resource/primeicons/primeicons.svg.xhtml?ln=primefaces&v=7.0?#primeicons*/url() format("svg");font-weight:normal;font-style:normal}.pi{font-family:'primeicons';speak:none;font-style:normal;font-weight:normal;font-variant:normal;text-transform:none;line-height:1;display:inline-block;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale}.pi-fw{width:1.28571429em;text-align:center}.pi-spin{-webkit-animation:fa-spin 2s infinite linear;animation:fa-spin 2s infinite linear}@-webkit-keyframes fa-spin{0%{-webkit-transform:rotate(0deg);transform:rotate(0deg)}100%{-webkit-transform:rotate(359deg);transform:rotate(359deg)}}@keyframes fa-spin{0%{-webkit-transform:rotate(0deg);transform:rotate(0deg)}100%{-webkit-transform:rotate(359deg);transform:rotate(359deg)}}.pi-mobile:before{content:"\e982"}.pi-tablet:before{content:"\e983"}.pi-key:before{content:"\e981"}.pi-shopping-cart:before{content:"\e980"}.pi-comments:before{content:"\e97e"}.pi-comment:before{content:"\e97f"}.pi-briefcase:before{content:"\e97d"}.pi-bell:before{content:"\e97c"}.pi-paperclip:before{content:"\e97b"}.pi-share-alt:before{content:"\e97a"}.pi-envelope:before{content:"\e979"}.pi-volume-down:before{content:"\e976"}.pi-volume-up:before{content:"\e977"}.pi-volume-off:before{content:"\e978"}.pi-eject:before{content:"\e975"}.pi-money-bill:before{content:"\e974"}.pi-images:before{content:"\e973"}.pi-image:before{content:"\e972"}.pi-sign-in:before{content:"\e970"}.pi-sign-out:before{content:"\e971"}.pi-wifi:before{content:"\e96f"}.pi-sitemap:before{content:"\e96e"}.pi-chart-bar:before{content:"\e96d"}.pi-camera:before{content:"\e96c"}.pi-dollar:before{content:"\e96b"}.pi-lock-open:before{content:"\e96a"}.pi-table:before{content:"\e969"}.pi-map-marker:before{content:"\e968"}.pi-list:before{content:"\e967"}.pi-eye-slash:before{content:"\e965"}.pi-eye:before{content:"\e966"}.pi-folder-open:before{content:"\e964"}.pi-folder:before{content:"\e963"}.pi-video:before{content:"\e962"}.pi-inbox:before{content:"\e961"}.pi-lock:before{content:"\e95f"}.pi-unlock:before{content:"\e960"}.pi-tags:before{content:"\e95d"}.pi-tag:before{content:"\e95e"}.pi-power-off:before{content:"\e95c"}.pi-save:before{content:"\e95b"}.pi-question-circle:before{content:"\e959"}.pi-question:before{content:"\e95a"}.pi-copy:before{content:"\e957"}.pi-file:before{content:"\e958"}.pi-clone:before{content:"\e955"}.pi-calendar-times:before{content:"\e952"}.pi-calendar-minus:before{content:"\e953"}.pi-calendar-plus:before{content:"\e954"}.pi-ellipsis-v:before{content:"\e950"}.pi-ellipsis-h:before{content:"\e951"}.pi-bookmark:before{content:"\e94e"}.pi-globe:before{content:"\e94f"}.pi-replay:before{content:"\e94d"}.pi-filter:before{content:"\e94c"}.pi-print:before{content:"\e94b"}.pi-align-right:before{content:"\e946"}.pi-align-left:before{content:"\e947"}.pi-align-center:before{content:"\e948"}.pi-align-justify:before{content:"\e949"}.pi-cog:before{content:"\e94a"}.pi-cloud-download:before{content:"\e943"}.pi-cloud-upload:before{content:"\e944"}.pi-cloud:before{content:"\e945"}.pi-pencil:before{content:"\e942"}.pi-users:before{content:"\e941"}.pi-clock:before{content:"\e940"}.pi-user-minus:before{content:"\e93e"}.pi-user-plus:before{content:"\e93f"}.pi-trash:before{content:"\e93d"}.pi-external-link:before{content:"\e93c"}.pi-window-maximize:before{content:"\e93b"}.pi-window-minimize:before{content:"\e93a"}.pi-refresh:before{content:"\e938"}.pi-user:before{content:"\e939"}.pi-exclamation-triangle:before{content:"\e922"}.pi-calendar:before{content:"\e927"}.pi-chevron-circle-left:before{content:"\e928"}.pi-chevron-circle-down:before{content:"\e929"}.pi-chevron-circle-right:before{content:"\e92a"}.pi-chevron-circle-up:before{content:"\e92b"}.pi-angle-double-down:before{content:"\e92c"}.pi-angle-double-left:before{content:"\e92d"}.pi-angle-double-right:before{content:"\e92e"}.pi-angle-double-up:before{content:"\e92f"}.pi-angle-down:before{content:"\e930"}.pi-angle-left:before{content:"\e931"}.pi-angle-right:before{content:"\e932"}.pi-angle-up:before{content:"\e933"}.pi-upload:before{content:"\e934"}.pi-download:before{content:"\e956"}.pi-ban:before{content:"\e935"}.pi-star-o:before{content:"\e936"}.pi-star:before{content:"\e937"}.pi-chevron-left:before{content:"\e900"}.pi-chevron-right:before{content:"\e901"}.pi-chevron-down:before{content:"\e902"}.pi-chevron-up:before{content:"\e903"}.pi-caret-left:before{content:"\e904"}.pi-caret-right:before{content:"\e905"}.pi-caret-down:before{content:"\e906"}.pi-caret-up:before{content:"\e907"}.pi-search:before{content:"\e908"}.pi-check:before{content:"\e909"}.pi-check-circle:before{content:"\e90a"}.pi-times:before{content:"\e90b"}.pi-times-circle:before{content:"\e90c"}.pi-plus:before{content:"\e90d"}.pi-plus-circle:before{content:"\e90e"}.pi-minus:before{content:"\e90f"}.pi-minus-circle:before{content:"\e910"}.pi-circle-on:before{content:"\e911"}.pi-circle-off:before{content:"\e912"}.pi-sort-down:before{content:"\e913"}.pi-sort-up:before{content:"\e914"}.pi-sort:before{content:"\e915"}.pi-step-backward:before{content:"\e916"}.pi-step-forward:before{content:"\e917"}.pi-th-large:before{content:"\e918"}.pi-arrow-down:before{content:"\e919"}.pi-arrow-left:before{content:"\e91a"}.pi-arrow-right:before{content:"\e91b"}.pi-arrow-up:before{content:"\e91c"}.pi-bars:before{content:"\e91d"}.pi-arrow-circle-down:before{content:"\e91e"}.pi-arrow-circle-left:before{content:"\e91f"}.pi-arrow-circle-right:before{content:"\e920"}.pi-arrow-circle-up:before{content:"\e921"}.pi-info:before{content:"\e923"}.pi-info-circle:before{content:"\e924"}.pi-home:before{content:"\e925"}.pi-spinner:before{content:"\e926"}</style><script data-savepage-type="text/javascript" type="text/plain"></script><script data-savepage-type="text/javascript" type="text/plain" data-savepage-src="/TSbd/082f06e51bab2000f7319e427c8574904b4dc4821ddf91c0988a5a4954d71ab22f27bbbe7d81e6a6?type=2"></script><script data-savepage-type="text/javascript" type="text/plain" data-savepage-src="/ebok/javax.faces.resource/jquery/jquery.js.xhtml?ln=primefaces&amp;v=7.0"></script><script data-savepage-type="text/javascript" type="text/plain" data-savepage-src="/ebok/javax.faces.resource/core.js.xhtml?ln=primefaces&amp;v=7.0"></script><script data-savepage-type="text/javascript" type="text/plain" data-savepage-src="/ebok/javax.faces.resource/idlemonitor/idlemonitor.js.xhtml?ln=primefaces&amp;v=7.0"></script><script data-savepage-type="text/javascript" type="text/plain" data-savepage-src="/ebok/javax.faces.resource/jquery/jquery-plugins.js.xhtml?ln=primefaces&amp;v=7.0"></script><style data-savepage-href="/ebok/javax.faces.resource/components.css.xhtml?ln=primefaces&amp;v=7.0" type="text/css">.ui-shadow{-moz-box-shadow:0 5px 10px rgba(0,0,0,0.8);-webkit-box-shadow:0 5px 10px rgba(0,0,0,0.8);box-shadow:0 5px 10px rgba(0,0,0,0.8)}.ui-overlay-visible{visibility:visible}ui-overlay-visible *{visibility:visible!important}.ui-overlay-hidden{visibility:hidden}.ui-overlay-hidden *{visibility:hidden!important}.ui-overflow-hidden{overflow:hidden}.ui-datepicker .ui-datepicker-current.ui-priority-secondary{opacity:1}.ui-icon-blank{background-position:16px 16px}@media only all{th.ui-column-p-6,td.ui-column-p-6,th.ui-column-p-5,td.ui-column-p-5,th.ui-column-p-4,td.ui-column-p-4,th.ui-column-p-3,td.ui-column-p-3,th.ui-column-p-2,td.ui-column-p-2,th.ui-column-p-1,td.ui-column-p-1{display:none}}@media screen and (min-width:20em){th.ui-column-p-1,td.ui-column-p-1{display:table-cell}}@media screen and (min-width:30em){th.ui-column-p-2,td.ui-column-p-2{display:table-cell}}@media screen and (min-width:40em){th.ui-column-p-3,td.ui-column-p-3{display:table-cell}}@media screen and (min-width:50em){th.ui-column-p-4,td.ui-column-p-4{display:table-cell}}@media screen and (min-width:60em){th.ui-column-p-5,td.ui-column-p-5{display:table-cell}}@media screen and (min-width:70em){th.ui-column-p-6,td.ui-column-p-6{display:table-cell}}.ui-icon.fa,.ui-widget .ui-icon.fa,.ui-icon.fab,.ui-widget .ui-icon.fab,.ui-icon.fas,.ui-widget .ui-icon.fas,.ui-icon.far,.ui-widget .ui-icon.far,.ui-icon.fal,.ui-widget .ui-icon.fal{background:none repeat scroll 0 0 transparent!important;text-indent:0!important}.ui-widget .ui-icon.pi,.ui-icon.pi{background:none repeat scroll 0 0 transparent!important;text-indent:0!important}.p-grid,.p-grid>div{-moz-box-sizing:border-box;-webkit-box-sizing:border-box;box-sizing:border-box}
/*!
 * jQuery UI CSS Framework 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/category/theming/
 */.ui-draggable-handle{-ms-touch-action:none;touch-action:none}.ui-helper-hidden{display:none}.ui-helper-hidden-accessible{border:0;clip:rect(0 0 0 0);height:1px;margin:-1px;overflow:hidden;padding:0;position:absolute;width:1px}.ui-helper-reset{margin:0;padding:0;border:0;outline:0;line-height:1.3;text-decoration:none;font-size:100%;list-style:none}.ui-helper-clearfix:before,.ui-helper-clearfix:after{content:"";display:table;border-collapse:collapse}.ui-helper-clearfix:after{clear:both}.ui-helper-zfix{width:100%;height:100%;top:0;left:0;position:absolute;opacity:0;filter:Alpha(Opacity=0)}.ui-front{z-index:100}.ui-state-disabled{cursor:default!important;pointer-events:none}.ui-icon{display:inline-block;vertical-align:middle;margin-top:-.25em;position:relative;text-indent:-99999px;overflow:hidden;background-repeat:no-repeat}.ui-widget-icon-block{left:50%;margin-left:-8px;display:block}.ui-widget-overlay{position:fixed;top:0;left:0;width:100%;height:100%}.ui-resizable{position:relative}.ui-resizable-handle{position:absolute;font-size:.1px;display:block;-ms-touch-action:none;touch-action:none}.ui-resizable-disabled .ui-resizable-handle,.ui-resizable-autohide .ui-resizable-handle{display:none}.ui-resizable-n{cursor:n-resize;height:7px;width:100%;top:-5px;left:0}.ui-resizable-s{cursor:s-resize;height:7px;width:100%;bottom:-5px;left:0}.ui-resizable-e{cursor:e-resize;width:7px;right:-5px;top:0;height:100%}.ui-resizable-w{cursor:w-resize;width:7px;left:-5px;top:0;height:100%}.ui-resizable-se{cursor:se-resize;width:12px;height:12px;right:1px;bottom:1px}.ui-resizable-sw{cursor:sw-resize;width:9px;height:9px;left:-5px;bottom:-5px}.ui-resizable-nw{cursor:nw-resize;width:9px;height:9px;left:-5px;top:-5px}.ui-resizable-ne{cursor:ne-resize;width:9px;height:9px;right:-5px;top:-5px}.ui-selectable{-ms-touch-action:none;touch-action:none}.ui-selectable-helper{position:absolute;z-index:100;border:1px dotted black}.ui-sortable-handle{-ms-touch-action:none;touch-action:none}.ui-datepicker{width:17em;padding:.2em .2em 0;display:none}.ui-datepicker .ui-datepicker-header{position:relative;padding:.2em 0}.ui-datepicker .ui-datepicker-prev,.ui-datepicker .ui-datepicker-next{position:absolute;top:2px;width:1.8em;height:1.8em}.ui-datepicker .ui-datepicker-prev-hover,.ui-datepicker .ui-datepicker-next-hover{top:1px}.ui-datepicker .ui-datepicker-prev{left:2px}.ui-datepicker .ui-datepicker-next{right:2px}.ui-datepicker .ui-datepicker-prev-hover{left:1px}.ui-datepicker .ui-datepicker-next-hover{right:1px}.ui-datepicker .ui-datepicker-prev span,.ui-datepicker .ui-datepicker-next span{display:block;position:absolute;left:50%;margin-left:-8px;top:50%;margin-top:-8px}.ui-datepicker .ui-datepicker-title{margin:0 2.3em;line-height:1.8em;text-align:center}.ui-datepicker .ui-datepicker-title select{font-size:1em;margin:1px 0}.ui-datepicker select.ui-datepicker-month,.ui-datepicker select.ui-datepicker-year{width:45%}.ui-datepicker table{width:100%;font-size:.9em;border-collapse:collapse;margin:0 0 .4em}.ui-datepicker th{padding:.7em .3em;text-align:center;font-weight:bold;border:0}.ui-datepicker td{border:0;padding:1px}.ui-datepicker td span,.ui-datepicker td a{display:block;padding:.2em;text-align:right;text-decoration:none}.ui-datepicker .ui-datepicker-buttonpane{background-image:none;margin:.7em 0 0 0;padding:0 .2em;border-left:0;border-right:0;border-bottom:0}.ui-datepicker .ui-datepicker-buttonpane button{float:right;margin:.5em .2em .4em;cursor:pointer;padding:.2em .6em .3em .6em;width:auto;overflow:visible}.ui-datepicker .ui-datepicker-buttonpane button.ui-datepicker-current{float:left}.ui-datepicker.ui-datepicker-multi{width:auto}.ui-datepicker-multi .ui-datepicker-group{float:left}.ui-datepicker-multi .ui-datepicker-group table{width:95%;margin:0 auto .4em}.ui-datepicker-multi-2 .ui-datepicker-group{width:50%}.ui-datepicker-multi-3 .ui-datepicker-group{width:33.3%}.ui-datepicker-multi-4 .ui-datepicker-group{width:25%}.ui-datepicker-multi .ui-datepicker-group-last .ui-datepicker-header,.ui-datepicker-multi .ui-datepicker-group-middle .ui-datepicker-header{border-left-width:0}.ui-datepicker-multi .ui-datepicker-buttonpane{clear:left}.ui-datepicker-row-break{clear:both;width:100%;font-size:0}.ui-datepicker-rtl{direction:rtl}.ui-datepicker-rtl .ui-datepicker-prev{right:2px;left:auto}.ui-datepicker-rtl .ui-datepicker-next{left:2px;right:auto}.ui-datepicker-rtl .ui-datepicker-prev:hover{right:1px;left:auto}.ui-datepicker-rtl .ui-datepicker-next:hover{left:1px;right:auto}.ui-datepicker-rtl .ui-datepicker-buttonpane{clear:right}.ui-datepicker-rtl .ui-datepicker-buttonpane button{float:left}.ui-datepicker-rtl .ui-datepicker-buttonpane button.ui-datepicker-current,.ui-datepicker-rtl .ui-datepicker-group{float:right}.ui-datepicker-rtl .ui-datepicker-group-last .ui-datepicker-header,.ui-datepicker-rtl .ui-datepicker-group-middle .ui-datepicker-header{border-right-width:0;border-left-width:1px}.ui-datepicker .ui-icon{display:block;text-indent:-99999px;overflow:hidden;background-repeat:no-repeat;left:.5em;top:.3em}.ui-slider{position:relative;text-align:left}.ui-slider .ui-slider-handle{position:absolute;z-index:2;width:1.2em;height:1.2em;cursor:default;-ms-touch-action:none;touch-action:none}.ui-slider .ui-slider-range{position:absolute;z-index:1;font-size:.7em;display:block;border:0;background-position:0 0}.ui-slider.ui-state-disabled .ui-slider-handle,.ui-slider.ui-state-disabled .ui-slider-range{filter:inherit}.ui-slider-horizontal{height:.8em}.ui-slider-horizontal .ui-slider-handle{top:-.3em;margin-left:-.6em}.ui-slider-horizontal .ui-slider-range{top:0;height:100%}.ui-slider-horizontal .ui-slider-range-min{left:0}.ui-slider-horizontal .ui-slider-range-max{right:0}.ui-slider-vertical{width:.8em;height:100px}.ui-slider-vertical .ui-slider-handle{left:-.3em;margin-left:0;margin-bottom:-.6em}.ui-slider-vertical .ui-slider-range{left:0;width:100%}.ui-slider-vertical .ui-slider-range-min{bottom:0}.ui-slider-vertical .ui-slider-range-max{top:0}
.ui-timepicker-div .ui-widget-header{margin-bottom:8px}.ui-timepicker-div dl{text-align:left}.ui-timepicker-div dl dt{float:left;clear:left;padding:0 0 0 5px}.ui-timepicker-div dl dd{margin:0 10px 10px 40%}.ui-timepicker-div td{font-size:90%}.ui-tpicker-grid-label{background:0;border:0;margin:0;padding:0}.ui-timepicker-div .ui_tpicker_unit_hide{display:none}.ui-timepicker-div .ui_tpicker_time .ui_tpicker_time_input{background:0;color:inherit;border:0;outline:0;border-bottom:solid 1px #555;width:95%}.ui-timepicker-div .ui_tpicker_time .ui_tpicker_time_input:focus{border-bottom-color:#aaa}.ui-timepicker-rtl{direction:rtl}.ui-timepicker-rtl dl{text-align:right;padding:0 5px 0 0}.ui-timepicker-rtl dl dt{float:right;clear:right}.ui-timepicker-rtl dl dd{margin:0 40% 10px 10px}.ui-timepicker-div.ui-timepicker-oneLine{padding-right:2px}.ui-timepicker-div.ui-timepicker-oneLine .ui_tpicker_time,.ui-timepicker-div.ui-timepicker-oneLine dt{display:none}.ui-timepicker-div.ui-timepicker-oneLine .ui_tpicker_time_label{display:block;padding-top:2px}.ui-timepicker-div.ui-timepicker-oneLine dl{text-align:right}.ui-timepicker-div.ui-timepicker-oneLine dl dd,.ui-timepicker-div.ui-timepicker-oneLine dl dd>div{display:inline-block;margin:0}.ui-timepicker-div.ui-timepicker-oneLine dl dd.ui_tpicker_minute:before,.ui-timepicker-div.ui-timepicker-oneLine dl dd.ui_tpicker_second:before{content:':';display:inline-block}.ui-timepicker-div.ui-timepicker-oneLine dl dd.ui_tpicker_millisec:before,.ui-timepicker-div.ui-timepicker-oneLine dl dd.ui_tpicker_microsec:before{content:'.';display:inline-block}.ui-timepicker-div.ui-timepicker-oneLine .ui_tpicker_unit_hide,.ui-timepicker-div.ui-timepicker-oneLine .ui_tpicker_unit_hide:before{display:none}
.ui-datepicker-trigger.ui-button-icon-only .ui-button-text{padding:.3em}.ui-icon{display:block;vertical-align:baseline;margin-top:0}
.ui-accordion .ui-accordion-header{cursor:pointer;position:relative;margin-top:1px;min-height:0;padding:.5em .5em .5em 2.2em}.ui-accordion .ui-accordion-header .ui-icon{position:absolute;left:.5em;top:50%;margin-top:-8px}.ui-accordion .ui-accordion-content{padding:1em 2.2em;border-top:0;margin-top:-2px;position:relative;top:1px;margin-bottom:2px;overflow:auto;zoom:1}.ui-accordion .ui-accordion-header.ui-state-disabled,.ui-accordion .ui-accordion-header.ui-state-disabled a{cursor:default}.ui-accordion.ui-accordion-rtl{direction:rtl}.ui-accordion.ui-accordion-rtl .ui-accordion-header .ui-icon{right:.5m;left:auto}.ui-accordion.ui-accordion-rtl .ui-accordion-header a{padding:.5em 2.2em .5em .5em}.ui-tabs-outline{outline:dotted thin;z-index:1}
.ui-autocomplete{width:auto;zoom:1;cursor:pointer;-moz-box-shadow:none;-webkit-box-shadow:none;box-shadow:none;position:relative;display:inline-block}.ui-autocomplete-input.ui-autocomplete-dd-input{padding-right:2.4em}.ui-autocomplete .ui-autocomplete-dropdown{position:absolute;height:100%;width:2.4em;right:-2px}.ui-autocomplete-query{font-weight:bold}.ui-autocomplete-panel{position:absolute;overflow:auto}.ui-autocomplete-panel .ui-autocomplete-item{cursor:pointer}.ui-autocomplete-panel .ui-autocomplete-list{padding:.4em;border:0 none}.ui-autocomplete-panel .ui-autocomplete-list-item{border:0 none;font-weight:normal;margin:1px 0;padding:3px 5px;text-align:left}.ui-autocomplete-panel .ui-autocomplete-table{border-collapse:collapse;width:100%}.ui-autocomplete-panel .ui-autocomplete-table th,.ui-autocomplete-panel .ui-autocomplete-table td{border-width:1px;border-style:solid;border-color:inherit;padding:4px 10px 4px 10px}.ui-autocomplete .ui-button-icon-only .ui-button-text{padding:.29em}.ui-autocomplete-panel .ui-autocomplete-moretext{font-size:90%;font-weight:bold}.ui-autocomplete-list .ui-autocomplete-moretext{margin:1px 0;padding:3px 5px;text-align:left;border:0 none}.ui-autocomplete-multiple-container{clear:left;cursor:text;list-style-type:none;margin:0;min-height:1px;overflow:hidden;width:400px}.ui-autocomplete-dd-multiple-container{float:left;padding-right:2.4em!important}.ui-autocomplete-multiple-container.ui-inputfield{padding:0}.ui-autocomplete-token{cursor:default;float:left;overflow:hidden;padding:1px 3px;white-space:nowrap;position:relative;margin:2px}.ui-autocomplete-token-label{display:block;padding:0 2.1em 0 .5em}.ui-autocomplete-token-label-disabled{display:block;padding:0 .5em 0 .5em}.ui-autocomplete-token-icon{margin-top:-9px;position:absolute;right:.2em;top:50%;cursor:pointer}.ui-autocomplete-input-token{float:left;list-style-type:none;margin:1px;padding:0}.ui-autocomplete-input-token input{border:0 none;width:140px;outline:medium none;background-color:transparent;margin:2px}.ui-autocomplete-itemtip-content{display:none}.ui-autocomplete-itemtip{position:absolute;display:none;padding:.4em}.ui-autocomplete-emptyMessage{padding:3px 5px}.ui-autocomplete-panel .ui-autocomplete-group{font-weight:bold;cursor:default}.ui-fluid .ui-autocomplete-multiple-container{width:100%}
.ui-blockui{position:absolute;top:0;left:0;text-align:center;width:100%;height:100%}.ui-blockui-content{position:absolute;text-align:center;padding:1em}
.ui-carousel{position:relative;padding:1px}.ui-carousel .ui-carousel-viewport .ui-carousel-items{list-style:none outside none;margin:0;padding:0;position:relative;width:32000px;left:0}.ui-carousel .ui-carousel-viewport .ui-carousel-items .ui-carousel-item{margin:1px;padding:0;float:left}.ui-carousel .ui-carousel-viewport{overflow:hidden;position:relative;border:0}.ui-carousel .ui-carousel-footer{margin:1px 1px 0 1px;padding-top:9px;padding-bottom:6px;padding-right:10px;padding-left:10px;overflow:hidden}.ui-carousel .ui-carousel-header{margin:0 1px;overflow:hidden;padding-top:7px;padding-bottom:8px;padding-right:10px;padding-left:10px}.ui-carousel .ui-carousel-header .ui-carousel-header-title{display:inline-block;width:30%;padding-top:2px;overflow:hidden}.ui-carousel .ui-carousel-dropdown,.ui-carousel .ui-carousel-dropdown-responsive{float:right;margin:0 10px;background-image:none}.ui-carousel .ui-carousel-dropdown option,.ui-carousel .ui-carousel-dropdown-responsive option{background-image:none;border:0 none;box-shadow:none;-moz-box-shadow:none;-webkit-box-shadow:none}.ui-carousel .ui-carousel-button{float:right;margin:2px}.ui-carousel .ui-carousel-page-link{float:left;margin:0 2px}.ui-carousel .ui-carousel-page-link,.ui-carousel .ui-carousel-button{cursor:pointer}.ui-carousel .ui-carousel-page-links{margin:0 9px;margin-top:1px;display:inline-table;float:right}.ui-carousel .ui-carousel-dropdown-responsive{display:none}.ui-carousel .ui-carousel-titlebar-icon{margin-left:.5em;cursor:pointer;float:right}.ui-carousel .ui-carousel-vertical-viewport .ui-carousel-items li.ui-carousel-item{float:none}.ui-carousel .ui-carousel-vertical-viewport ul.ui-carousel-items{width:auto}
.ui-columntoggler{padding:0;position:absolute;overflow:auto;display:none}.ui-columntoggler .ui-columntoggler-items{border:0 none;padding:.4em;margin:0}.ui-columntoggler .ui-columntoggler-item{border:0 none;cursor:pointer;font-weight:normal;margin:1px 0;padding:3px 5px;text-align:left;white-space:nowrap;display:block;position:relative}.ui-columntoggler .ui-columntoggler-item .ui-chkbox{position:absolute;top:50%;margin-top:-8px}.ui-columntoggler .ui-columntoggler-item label{display:block;padding-left:2.2em}.ui-columntoggler .ui-columntoggler-close{float:right;margin-top:1px;margin-right:1px}.ui-columntoggler .ui-columntoggler-close:focus{outline:dotted thin}.ui-columntoggler .ui-columntoggler-items{padding:1em .4em .4em .4em}@media only all{.ui-columntoggler .ui-columntoggler-item.ui-column-p-1,.ui-columntoggler .ui-columntoggler-item.ui-column-p-2,.ui-columntoggler .ui-columntoggler-item.ui-column-p-3,.ui-columntoggler .ui-columntoggler-item.ui-column-p-4,.ui-columntoggler .ui-columntoggler-item.ui-column-p-5,.ui-columntoggler .ui-columntoggler-item.ui-column-p-6{display:none}th.ui-helper-hidden,td.ui-helper-hidden{display:none}}@media screen and (min-width:20em){.ui-columntoggler .ui-columntoggler-item.ui-column-p-1{display:block}}@media screen and (min-width:30em){.ui-columntoggler .ui-columntoggler-item.ui-column-p-2{display:block}}@media screen and (min-width:40em){.ui-columntoggler .ui-columntoggler-item.ui-column-p-3{display:block}}@media screen and (min-width:50em){.ui-columntoggler .ui-columntoggler-item.ui-column-p-4{display:block}}@media screen and (min-width:60em){.ui-columntoggler .ui-columntoggler-item.ui-column-p-5{display:block}}@media screen and (min-width:70em){.ui-columntoggler .ui-columntoggler-item.ui-column-p-6{display:block}}
.ui-dashboard-column{float:left;padding-bottom:100px}.ui-dashboard-column .ui-panel-titlebar{cursor:move}
.ui-datalist .ui-datalist-header,.ui-datalist .ui-datalist-footer{text-align:center;padding:4px 10px}.ui-datalist .ui-datalist-header{border-bottom:0 none}.ui-datalist .ui-datalist-footer{border-top:0 none}.ui-datalist .ui-paginator-top{border-bottom:0 none}.ui-datalist .ui-paginator-bottom{border-top:0 none}.ui-datalist .ui-datalist-empty-message{padding:4px 10px}.ui-datalist .ui-datalist-nobullets{list-style-type:none}
.ui-datagrid .ui-paginator{text-align:center}.ui-datagrid-column{padding:3px}.ui-datagrid-content-empty{padding:4px 10px}.ui-datagrid .ui-datagrid-header,.ui-datagrid .ui-datagrid-footer{text-align:center;padding:4px 10px}.ui-datagrid .ui-datagrid-header{border-bottom:0 none}.ui-datagrid .ui-datagrid-footer{border-top:0 none}.ui-datagrid .ui-paginator-top{border-bottom:0 none}.ui-datagrid .ui-paginator-bottom{border-top:0 none}.ui-datagrid-data{width:100%}
.ui-datascroller .ui-datascroller-header{text-align:center;padding:4px 10px;border-bottom:0 none}.ui-datascroller .ui-datascroller-content{padding:4px 10px}.ui-datascroller-inline .ui-datascroller-content{overflow:auto}.ui-datascroller .ui-datascroller-list{list-style-type:none;margin:0;padding:0}.ui-datascroller .ui-datascroller-item{border:0 none}.ui-datascroller .ui-datascroller-loader{text-align:center;padding:4px 10px}.ui-datascroller .ui-datascroller-loading{background:/*savepage-url=/ebok/javax.faces.resource/datascroller/images/loading.gif.xhtml?ln=primefaces&v=7.0*/url() center center no-repeat;width:220px;height:19px;padding:0;margin:0;display:inline-block}
.ui-datatable table{border-collapse:collapse;width:100%;table-layout:fixed}.ui-datatable-tablewrapper{overflow:auto}.ui-datatable .ui-datatable-header,.ui-datatable .ui-datatable-footer{text-align:center;padding:4px 10px}.ui-datatable .ui-datatable-header{border-bottom:0 none}.ui-datatable .ui-datatable-footer{border-top:0 none}.ui-datatable thead th,.ui-datatable tfoot td{text-align:center}.ui-datatable thead th,.ui-datatable tbody td,.ui-datatable tfoot td,.ui-datatable tfoot th{padding:4px 10px;overflow:hidden;border-width:1px;border-style:solid}.ui-datatable tbody.ui-datatable-data{outline:0}.ui-datatable tbody td{border-color:inherit}.ui-datatable .ui-sortable-column{cursor:pointer}.ui-datatable div.ui-dt-c{position:relative}.ui-datatable .ui-sortable-column-icon{display:inline-block;margin:-3px 0 -3px 2px}.ui-datatable .ui-column-filter{display:block;box-sizing:border-box;width:100%;margin:auto}.ui-datatable .ui-row-toggler{cursor:pointer}.ui-datatable tr.ui-state-highlight{cursor:pointer}.ui-datatable .ui-selection-column .ui-chkbox-all{display:block;margin:0 auto;width:16px;height:16px}.ui-datatable-summary{display:none}.ui-datatable-scrollable table,.ui-datatable-sticky table{table-layout:fixed}.ui-datatable-scrollable-body{overflow:auto}.ui-datatable-scrollable-header,.ui-datatable-scrollable-footer{overflow:hidden;border:0 none}.ui-datatable-scrollable .ui-datatable-scrollable-header,.ui-datatable-scrollable .ui-datatable-scrollable-footer{position:relative}.ui-datatable-scrollable .ui-datatable-scrollable-header td{font-weight:normal}.ui-datatable-scrollable-body::-webkit-scrollbar{-webkit-appearance:none;width:15px;background-color:transparent}.ui-datatable-scrollable-body::-webkit-scrollbar-thumb{border-radius:8px;border:1px solid white;background-color:rgba(194,194,194,.5)}.ui-datatable .ui-datatable-scrollable-body{min-height:0}.ui-datatable .ui-datatable-data tr.ui-state-hover{border-color:inherit;font-weight:inherit;cursor:pointer}.ui-datatable-scrollable-theadclone{height:0}.ui-datatable-scrollable-theadclone tr{height:0}.ui-datatable-scrollable-theadclone th.ui-state-default{height:0;border-bottom-width:0;border-top-width:0;padding-top:0;padding-bottom:0;outline:0 none}.ui-datatable-scrollable-theadclone th span.ui-column-title{display:block;height:0}.ui-datatable .ui-paginator,.ui-datatable .ui-paginator{padding:2px}.ui-datatable .ui-datatable-virtualscroll-wrapper{position:relative}.ui-datatable .ui-datatable-virtualscroll-table{top:0;left:0;position:absolute}.ui-datatable .ui-cell-editor-input{display:none}.ui-datatable .ui-row-editing .ui-cell-editor .ui-cell-editor-output{display:none}.ui-datatable .ui-row-editing .ui-cell-editor .ui-cell-editor-input{display:block}.ui-datatable .ui-row-editor span{cursor:pointer}.ui-datatable .ui-row-editor .ui-row-editor-pencil{display:inline-block}.ui-datatable .ui-row-editing .ui-row-editor .ui-row-editor-pencil{display:none}.ui-datatable .ui-row-editor .ui-row-editor-check,.ui-datatable .ui-row-editor .ui-row-editor-close{display:none}.ui-datatable .ui-row-editing .ui-row-editor .ui-row-editor-check,.ui-datatable .ui-row-editing .ui-row-editor .ui-row-editor-close{display:inline-block}.ui-datatable .ui-datatable-data tr.ui-row-editing td.ui-editable-column,.ui-datatable .ui-datatable-data td.ui-cell-editing{padding:0;margin:0}.ui-row-editor-outline{outline:dotted thin}.ui-datatable .ui-column-resizer{position:absolute;top:0;right:0;margin:0;width:8px;height:100%;padding:0;cursor:col-resize;background-image:/*savepage-url=/ebok/javax.faces.resource/spacer/dot_clear.gif.xhtml?ln=primefaces&v=7.0*/url();border:1px solid transparent;box-sizing:border-box}.ui-datatable .ui-column-resizer-helper{width:1px;position:absolute;z-index:10;display:none}.ui-datatable-resizable{padding-bottom:1px;overflow:auto}.ui-datatable-resizable thead th,.ui-datatable-resizable tbody td,.ui-datatable-resizable tfoot td{white-space:nowrap}.ui-datatable-resizable table{table-layout:fixed}.ui-datatable-resizable th.ui-resizable-column{background-clip:padding-box;position:relative}.ui-datatable-rtl{direction:rtl}.ui-datatable-rtl.ui-datatable thead th,.ui-datatable-rtl.ui-datatable tfoot td{text-align:right}.ui-datatable table.ui-datatable-fs{width:auto}.ui-datatable .ui-datatable-frozenlayout-left,.ui-datatable .ui-datatable-frozenlayout-right{padding:0;border:0 none;vertical-align:top}.ui-datatable .ui-datatable-frozen-container{margin-right:-1px}.ui-datatable-frozen-container .ui-datatable-scrollable-body{overflow:hidden}.ui-datatable .ui-datatable-frozen-container .ui-row-toggler{margin-top:-2px;margin-bottom:-2px}.ui-datatable .ui-datatable-frozen-container .ui-row-editor{margin-top:-2px;margin-bottom:-2px}.ui-datatable-frozenlayout-right .ui-datatable-empty-message td{text-indent:-9999px}.ui-datatable-frozenlayout-right .ui-datatable-empty-message td>*{visibility:hidden}.ui-datatable-reflow .ui-datatable-data td[role="gridcell"] .ui-column-title{display:none}.ui-datatable-reflow .ui-reflow-label,.ui-datatable-reflow .ui-reflow-dropdown{margin-bottom:10px;display:none}.ui-datatable .ui-rowgroup-header>td>a.ui-rowgroup-toggler{padding-right:1.5em;position:relative}.ui-datatable .ui-rowgroup-header .ui-rowgroup-toggler-icon{position:absolute;top:0;bottom:0;margin:auto 0}@media(max-width:640px){.ui-datatable-reflow thead th,.ui-datatable-reflow tfoot td{display:none}.ui-datatable-reflow .ui-datatable-data td[role="gridcell"]:not(.ui-helper-hidden){text-align:left;display:block;border:0 none;width:100%;-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;float:left;clear:left}.ui-datatable-reflow .ui-datatable-data.ui-widget-content{border:0 none}.ui-datatable-reflow .ui-datatable-data tr.ui-widget-content{border-left:0 none;border-right:0 none}.ui-datatable-reflow .ui-datatable-data td[role="gridcell"] .ui-column-title{padding:.4em;min-width:30%;display:inline-block;margin:-.4em 1em -.4em -.4em}.ui-datatable-reflow .ui-reflow-label,.ui-datatable-reflow .ui-reflow-dropdown{display:inline-block}.ui-datatable-reflow .ui-reflow-dropdown{margin-left:5px;border-top-left-radius:3px;border-bottom-left-radius:3px}.ui-datatable-reflow tr.ui-datatable-empty-message>td{display:block;border:0 none}}
.ui-dialog{position:fixed;padding:0;overflow:hidden;display:none}.ui-dialog.ui-dialog-absolute{position:absolute}.ui-dialog.ui-overlay-hidden{display:block}.ui-dialog .ui-dialog-titlebar{padding:.4em .4em .4em 1em;position:relative;border:0}.ui-dialog .ui-dialog-title{float:left;margin:.3em 16px .1em 0}.ui-dialog .ui-dialog-content{position:relative;border:0;padding:.5em 1em;background:0;overflow:auto;zoom:1}.ui-dialog .ui-dialog-content.ui-df-content{overflow:hidden;padding:0}.ui-dialog .ui-dialog-footer{padding:.4em 1em;border-width:1px 0 0 0;text-align:left}.ui-dialog .ui-dialog-buttonpane{text-align:left;background-image:none;margin:.5em 0 0 0;padding:.3em 1em .5em .4em}.ui-dialog .ui-dialog-buttonpane button{margin:.5em .4em .5em 0;cursor:pointer}.ui-dialog .ui-resizable-se{width:14px;height:14px;right:3px;bottom:3px}.ui-draggable .ui-dialog-titlebar{cursor:move}.ui-dialog .ui-dialog-titlebar-close,.ui-dialog .ui-dialog-titlebar-minimize,.ui-dialog .ui-dialog-titlebar-maximize{float:right;margin:0;top:0;padding:1px;cursor:pointer}.ui-dialog .ui-dialog-titlebar-close span,.ui-dialog .ui-dialog-titlebar-minimize span,.ui-dialog .ui-dialog-titlebar-maximize span{display:block;margin:0}.ui-dialog .ui-dialog-titlebar-close:hover,.ui-dialog .ui-dialog-titlebar-close:focus,.ui-dialog .ui-dialog-titlebar-minimize:hover,.ui-dialog .ui-dialog-titlebar-minimize:focus,.ui-dialog .ui-dialog-titlebar-maximize:hover,.ui-dialog .ui-dialog-titlebar-maximize:focus{padding:0}.ui-dialog-docking-zone{position:fixed;bottom:0;left:0}.ui-dialog-minimizing{border:2px dotted gray}.ui-dialog .ui-dialog-message{margin-right:.5em}.ui-dialog-mask{position:fixed;width:100%;height:100%}.ui-confirm-dialog .ui-dialog-content{padding:1em}.ui-confirm-dialog-severity{float:left;margin-right:4px}.ui-confirm-dialog-message{display:inline-block;margin-top:1px}.ui-dialog-rtl{direction:rtl}.ui-dialog.ui-dialog-rtl .ui-dialog-title{float:right}.ui-dialog.ui-dialog-rtl .ui-dialog-titlebar-close,.ui-dialog.ui-dialog-rtl .ui-dialog-titlebar-minimize,.ui-dialog.ui-dialog-rtl .ui-dialog-titlebar-maximize{float:left}.ui-dialog.ui-dialog-rtl .ui-dialog-footer{text-align:right}.ui-message-dialog .ui-dialog-content{padding:1em}
.ui-fieldset,.ui-fieldset .ui-fieldset-legend{padding:.6em 1em}.ui-fieldset-toggleable .ui-fieldset-legend{padding:.5em 1em .5em .5em;cursor:pointer;outline:0}.ui-fieldset .ui-fieldset-toggler{padding-right:.1em;float:left}
.ui-inputfield{margin:0;outline:medium none;padding:4px;font-weight:normal}.ui-widget-header .ui-inputfield,.ui-widget-content .ui-inputfield{font-weight:normal}.ui-inputtextarea-resizable{overflow:hidden;resize:none}.ui-selectonelistbox,.ui-selectmanymenu,.ui-multiselectlistbox-listcontainer{padding:2px;width:150px}.ui-selectonelistbox .ui-selectlistbox-listcontainer,.ui-selectmanymenu .ui-selectlistbox-listcontainer,.ui-multiselectlistbox-listcontainer{overflow:auto}.ui-selectonelistbox.ui-state-disabled .ui-selectlistbox-listcontainer,.ui-selectmanymenu.ui-state-disabled .ui-selectlistbox-listcontainer{overflow:hidden}.ui-selectonelistbox .ui-selectlistbox-list,.ui-selectmanymenu .ui-selectlistbox-list,.ui-multiselectlistbox .ui-multiselectlistbox-list{list-style-type:none;margin:0;padding:0}.ui-selectonelistbox .ui-selectlistbox-item,.ui-selectmanymenu .ui-selectlistbox-item,.ui-multiselectlistbox .ui-multiselectlistbox-item{margin:2px;border:0 none;cursor:pointer;font-weight:normal}.ui-selectonelistbox table.ui-selectlistbox-list,.ui-selectmanymenu table.ui-selectlistbox-list{border-collapse:collapse;width:100%}.ui-selectlistbox-filter.ui-inputfield{padding-right:12%;padding-left:2%;width:85%;-moz-box-shadow:none;-webkit-box-shadow:none;box-shadow:none}.ui-selectlistbox-filter-container{position:relative;margin:.1em 0 .1em 0;padding:0}.ui-selectlistbox-filter-container .ui-icon{position:absolute;top:5px;right:2px}.ui-multiselectlistbox .ui-multiselectlistbox-listcontainer{float:left;margin-right:4px}.ui-multiselectlistbox .ui-multiselectlistbox-item{white-space:nowrap}.ui-multiselectlistbox.ui-state-disabled .ui-multiselectlistbox-item{cursor:default}.ui-multiselectlistbox .ui-multiselectlistbox-header{text-align:center;padding:2px 10px;border-bottom:0 none}.ui-listbox-outline{outline:1px dotted black;z-index:1}.ui-chkbox{display:inline-block;vertical-align:middle}.ui-chkbox .ui-chkbox-box{width:16px;height:16px;display:inline-block;-moz-border-radius:2px;-webkit-border-radius:2px;border-radius:2px}.ui-chkbox-icon.ui-icon{overflow:visible}.ui-chkbox .ui-chkbox-label{cursor:pointer;margin:0 16px 0 8px;outline:medium none;z-index:1;display:inline-block;vertical-align:top}.ui-selectmanycheckbox label{vertical-align:middle;cursor:pointer;margin:0 16px 0 8px;outline:medium none;z-index:1;display:inline-block}.ui-selectmanycheckbox .ui-chkbox .ui-chkbox-box{display:block}.ui-selectoneradio label{cursor:pointer;display:inline-block;margin:0 16px 0 8px;vertical-align:middle}.ui-selectmanycheckbox.ui-widget td,.ui-selectoneradio.ui-widget td{border:0 none}.ui-panelgrid .ui-selectoneradio.ui-grid-responsive .ui-grid-row,.ui-panelgrid .ui-selectmanycheckbox.ui-grid-responsive .ui-grid-row{border-top:0 none}.ui-selectoneradio.ui-grid-responsive .ui-grid-row>div,.ui-selectmanycheckbox.ui-grid-responsive .ui-grid-row>div{padding:.5em}.ui-selectmanycheckbox .ui-selectmanycheckbox-item-group{font-weight:bold}.ui-selectmanycheckbox .ui-selectmanycheckbox-responsive-group{padding:.5em .5em .5em 0}.ui-radiobutton{margin:3px 0;width:16px;line-height:16px;display:inline-block;vertical-align:middle}.ui-radiobutton .ui-radiobutton-box{width:16px;height:16px;line-height:16px;-moz-border-radius:10px;-webkit-border-radius:10px;border-radius:10px}.ui-radiobutton-icon{margin-left:1px}.ui-radiobutton.ui-radiobutton-native{margin:0;padding:0}.ui-radiobutton.ui-radiobutton-native .ui-helper-hidden-accessible{clip:auto;position:static!important;width:auto;height:auto;overflow:visible;margin:0;padding:0}.ui-radiobutton.ui-radiobutton-native .ui-radiobutton-box{display:none}.ui-radiobutton.ui-radiobutton-native .ui-helper-hidden-accessible input{margin:0}.ui-selectoneradio-native label{margin:0}.ui-selectonemenu{display:inline-block;position:relative;width:auto;zoom:1;cursor:pointer;padding-right:22px;vertical-align:top}.ui-selectonemenu .ui-selectonemenu-trigger{border-right:0;border-top:0;border-bottom:0;cursor:pointer;width:16px;height:100%;position:absolute;right:0;top:0;padding:0 3px}.ui-selectonemenu .ui-selectonemenu-trigger .ui-icon{position:absolute;margin:auto;top:0;bottom:0;left:0;right:0}.ui-selectonemenu .ui-selectonemenu-label{display:block;border:0;white-space:nowrap;overflow:hidden;font-weight:normal;width:100%;text-align:left}.ui-selectonemenu.ui-state-disabled .ui-selectonemenu-trigger,.ui-selectonemenu.ui-state-disabled .ui-selectonemenu-label{cursor:default}.ui-selectonemenu label.ui-selectonemenu-label{cursor:pointer}.ui-selectonemenu input.ui-selectonemenu-label{cursor:default}.ui-selectonemenu-panel{position:absolute;height:auto}.ui-selectonemenu-panel .ui-selectonemenu-items-wrapper{overflow:auto}.ui-selectonemenu-panel .ui-selectonemenu-item{font-weight:normal;cursor:pointer}.ui-selectonemenu-panel .ui-selectonemenu-item-group{font-weight:bold}.ui-selectonemenu-panel .ui-selectonemenu-list{padding:.4em;border:0 none}.ui-selectonemenu-panel .ui-selectonemenu-list-item{border:0 none;margin:1px 0;padding:3px 5px;text-align:left;white-space:nowrap}.ui-selectonemenu-panel .ui-selectonemenu-table{border-collapse:collapse;width:100%}.ui-selectonemenu-panel .ui-selectonemenu-table td{border-color:inherit}.ui-selectonemenu-panel .ui-selectonemenu-table th,.ui-selectonemenu-panel .ui-selectonemenu-table td{border-width:1px;border-style:solid;padding:4px 10px 4px 10px}.ui-selectonemenu-panel .ui-selectonemenu-filter{width:85%;padding-right:15px}.ui-selectonemenu-panel .ui-selectonemenu-filter-container{position:relative;margin:0;padding:.4em;display:inline-block}.ui-selectonemenu-panel .ui-selectonemenu-filter-container .ui-icon{position:absolute;top:10px;right:10px}.ui-state-disabled a{outline:0}.ui-button{display:inline-block;position:relative;padding:0;margin-right:.1em;text-decoration:none!important;cursor:pointer;text-align:center;zoom:1;overflow:visible}.ui-button-icon-only{width:2.4em}.ui-button .ui-button-text{display:block;line-height:normal}.ui-button-text-only .ui-button-text{padding:.3em 1em}.ui-button-icon-only .ui-button-text{padding:.3em;text-indent:-9999999px}.ui-button-text-icon-left .ui-button-text{padding:.3em 1em .3em 2.1em}.ui-button-text-icon-right .ui-button-text{padding:.3em 2.1em .3em 1em}.ui-button-icon-only .ui-icon,.ui-button-text-icon-left .ui-icon,.ui-button-text-icon-right .ui-icon{position:absolute;top:50%;margin-top:-8px}.ui-button-icon-only .ui-icon.fa,.ui-button-text-icon-left .ui-icon.fa,.ui-button-text-icon-right .ui-icon.fa,.ui-button-icon-only .ui-icon.fab,.ui-button-text-icon-left .ui-icon.fab,.ui-button-text-icon-right .ui-icon.fab,.ui-button-icon-only .ui-icon.far,.ui-button-text-icon-left .ui-icon.far,.ui-button-text-icon-right .ui-icon.far,.ui-button-icon-only .ui-icon.fas,.ui-button-text-icon-left .ui-icon.fas,.ui-button-text-icon-right .ui-icon.fas,.ui-button-icon-only .ui-icon.fal,.ui-button-text-icon-left .ui-icon.fal,.ui-button-text-icon-right .ui-icon.fal{margin-top:-7px}.ui-button-icon-only .ui-icon{left:50%;margin-left:-8px}.ui-button-icon-left{left:.5em}.ui-button-icon-right{right:.5em}.ui-buttonset .ui-button{margin-left:0;margin-right:0}button.ui-button::-moz-focus-inner{border:0;padding:0}.ui-linkbutton.ui-button.ui-state-default>a{color:inherit}.ui-linkbutton.ui-button.ui-state-hover>a{color:inherit}.ui-selectcheckboxmenu{display:inline-block;position:relative;width:auto;zoom:1;cursor:pointer}.ui-selectcheckboxmenu .ui-selectcheckboxmenu-trigger{border-right:0;border-top:0;border-bottom:0;cursor:pointer;width:16px;height:100%;position:absolute;right:0;top:0;padding:0 3px}.ui-selectcheckboxmenu .ui-selectcheckboxmenu-trigger .ui-icon{margin-top:3px}.ui-selectcheckboxmenu .ui-selectcheckboxmenu-label{display:block;padding:3px 26px 3px 5px;width:auto;border:0;cursor:pointer}.ui-selectcheckboxmenu.ui-state-disabled .ui-selectcheckboxmenu-trigger,.ui-selectcheckboxmenu.ui-state-disabled .ui-selectcheckboxmenu-label{cursor:auto}.ui-selectcheckboxmenu-panel{padding:.2em;position:absolute;overflow:hidden;-moz-box-shadow:0 5px 10px rgba(0,0,0,0.8);-webkit-box-shadow:0 5px 10px rgba(0,0,0,0.8);box-shadow:0 5px 10px rgba(0,0,0,0.8)}.ui-selectcheckboxmenu-panel .ui-selectcheckboxmenu-items-wrapper{overflow:auto;position:relative;padding:.2em 0}.ui-selectcheckboxmenu-panel .ui-selectcheckboxmenu-list{border:0 none}.ui-selectcheckboxmenu-panel .ui-selectcheckboxmenu-list-item{border:0 none;cursor:pointer;font-weight:normal;margin:1px 0;padding:3px 5px;text-align:left;white-space:nowrap}.ui-selectcheckboxmenu-panel .ui-selectcheckboxmenu-list-item{display:block;position:relative}.ui-selectcheckboxmenu-panel .ui-selectcheckboxmenu-list-item .ui-chkbox{position:absolute;top:50%;margin-top:-8px}.ui-selectcheckboxmenu-panel .ui-selectcheckboxmenu-list-item label{display:block;padding-left:2em}.ui-selectcheckboxmenu-panel .ui-selectcheckboxmenu-item-group{font-weight:bold}.ui-selectcheckboxmenu-header{margin-bottom:.3em;padding:.3em 0 .3em .4em}.ui-selectcheckboxmenu-header .ui-chkbox{float:left;cursor:pointer}.ui-selectcheckboxmenu-header .ui-selectcheckboxmenu-filter-container{float:left;position:relative;margin-left:5px}.ui-selectcheckboxmenu-header .ui-selectcheckboxmenu-filter-container .ui-icon{position:absolute;right:5px;top:2px}.ui-selectcheckboxmenu-header .ui-inputfield{padding:1px 20px 1px 2px}.ui-selectcheckboxmenu-header span.ui-icon{float:left}.ui-selectcheckboxmenu-header a.ui-selectcheckboxmenu-all,.ui-selectcheckboxmenu-header a.ui-selectcheckboxmenu-none{float:left;margin-right:10px;display:block}.ui-selectcheckboxmenu-header .ui-selectcheckboxmenu-close{float:right;padding:1px;margin-right:.2em;display:block}.ui-selectcheckboxmenu-header .ui-selectcheckboxmenu-close.ui-state-hover{padding:0}.ui-selectcheckboxmenu-multiple-container{clear:left;cursor:pointer;list-style-type:none;margin:0;min-height:24px;overflow:hidden;min-width:100px}.ui-selectcheckboxmenu-multiple-container.ui-inputfield{padding:0 22px 0 0;border:0}.ui-selectcheckboxmenu-token{cursor:default;float:left;overflow:hidden;padding:1px 3px;white-space:nowrap;position:relative;margin:2px}.ui-selectcheckboxmenu-token-label{display:block;padding:0 2.1em 0 .5em}.ui-selectcheckboxmenu-token-icon{margin-top:-9px;position:absolute;right:.2em;top:50%;cursor:pointer}.ui-selectcheckboxmenu-input-token{float:left;list-style-type:none;margin:1px;padding:0}.ui-selectcheckboxmenu-input-token input{border:0 none;width:140px;outline:medium none;background-color:transparent;margin:2px}.ui-selectcheckboxmenu-multiple .ui-selectcheckboxmenu-trigger .ui-icon{position:relative;top:50%;margin-top:-8px}.ui-splitbutton{position:relative;padding-right:2em}.ui-splitbutton .ui-button.ui-splitbutton-menubutton{position:absolute;top:0;margin-left:-1px;right:0}.ui-splitbuttonmenu .ui-splitbuttonmenu-filter-container{position:relative;margin:0;padding:.4em 0;display:inline-block}.ui-splitbuttonmenu .ui-splitbuttonmenu-filter{width:100%;padding-right:15px;-moz-box-sizing:border-box;-webkit-box-sizing:border-box;box-sizing:border-box}.ui-splitbuttonmenu .ui-splitbuttonmenu-filter-container .ui-icon{position:absolute;top:10px;right:10px}.ui-splitbuttonmenu .ui-splitbuttonmenu-list-wrapper{overflow:auto}.ui-splitbuttonmenu.ui-menu .ui-menu-list .ui-widget-header,.ui-splitbuttonmenu.ui-menu .ui-menuitem-link{width:100%;-moz-box-sizing:border-box;-webkit-box-sizing:border-box;box-sizing:border-box}div.ui-button,.ui-splitbutton{display:inline-block;zoom:1}.ui-password-panel{padding:4px 10px;width:150px;margin-top:2px}.ui-password-panel .ui-password-meter{height:10px;background:transparent /*savepage-url=/ebok/javax.faces.resource/forms/password-meter.png.xhtml?ln=primefaces&v=7.0*/ url() no-repeat left top;padding:0;margin:0}.ui-password-info{margin-top:4px}.ui-password-panel-overlay{position:absolute}.ui-outputlabel.ui-state-error{border:0 none}.ui-outputlabel .ui-outputlabel-rfi{margin-left:.4em}.ui-selectonebutton{display:inline-block;padding:1px}.ui-selectonebutton.ui-state-error{padding:0}.ui-selectonebutton .ui-button.ui-state-focus{outline:0}.ui-selectmanybutton{display:inline-block;padding:1px}.ui-selectmanybutton.ui-state-error{padding:0}.ui-selectmanybutton .ui-button.ui-state-focus{outline:0}.ui-fluid .ui-inputfield{box-sizing:border-box;-webkit-box-sizing:border-box;-moz-box-sizing:border-box}.ui-fluid .ui-inputtext{width:100%}.ui-fluid .ui-inputnumber{width:100%}.ui-fluid .ui-inputtext[size],.ui-fluid .ui-inputfield[size]{width:auto}.ui-fluid .ui-inputtextarea{width:100%}.ui-fluid .ui-selectonemenu{width:100%;box-sizing:border-box;-webkit-box-sizing:border-box;-moz-box-sizing:border-box}.ui-fluid .ui-selectonemenu .ui-selectonemenu-trigger{width:32px;padding:0 6px;box-sizing:border-box;-webkit-box-sizing:border-box;-moz-box-sizing:border-box}.ui-fluid .ui-calendar,.ui-fluid .ui-calendar input{width:100%}.ui-fluid .ui-calendar{position:relative}.ui-fluid .ui-trigger-calendar .ui-datepicker-trigger.ui-button{position:absolute;right:-2px;width:2.4em}.ui-fluid .ui-trigger-calendar .ui-button-icon-only .ui-button-text{padding:.28em}.ui-fluid .ui-trigger-calendar input.hasDatepicker{padding-right:2.4em}.ui-fluid .ui-spinner{width:100%}.ui-fluid .ui-spinner .ui-spinner-input{padding-right:36px;width:100%}.ui-fluid .ui-spinner .ui-spinner-button{width:auto}.ui-fluid .ui-spinner .ui-spinner-button .ui-icon{left:6px}.ui-fluid .ui-autocomplete,.ui-fluid .ui-autocomplete-input{width:100%}.ui-fluid .ui-autocomplete .ui-autocomplete-dropdown.ui-button{width:2.4em}.ui-fluid .ui-inputmask{width:100%}.ui-fluid .ui-password{width:100%}.ui-fluid .ui-keyboard-input{width:100%}.ui-fluid .ui-selectcheckboxmenu{width:100%;box-sizing:border-box;-webkit-box-sizing:border-box;-moz-box-sizing:border-box}.ui-fluid .ui-selectcheckboxmenu .ui-selectcheckboxmenu-trigger .ui-icon{margin-left:auto;margin-right:auto}.ui-fluid .ui-selectcheckboxmenu-trigger{width:32px;box-sizing:border-box;-webkit-box-sizing:border-box;-moz-box-sizing:border-box}.ui-fluid .ui-button{width:100%;box-sizing:border-box;-webkit-box-sizing:border-box;-moz-box-sizing:border-box}.ui-fluid .ui-buttonset{width:100%}.ui-fluid .ui-buttonset.ui-buttonset-1 .ui-button{width:100%}.ui-fluid .ui-buttonset.ui-buttonset-2 .ui-button{width:50%}.ui-fluid .ui-buttonset.ui-buttonset-3 .ui-button{width:33.3%}.ui-fluid .ui-buttonset.ui-buttonset-4 .ui-button{width:25%}.ui-fluid .ui-buttonset.ui-buttonset-5 .ui-button{width:20%}.ui-fluid .ui-buttonset.ui-buttonset-6 .ui-button{width:16.6%}@media(max-width:640px){.ui-fluid .ui-buttonset.ui-buttonset-1 .ui-button,.ui-fluid .ui-buttonset.ui-buttonset-2 .ui-button,.ui-fluid .ui-buttonset.ui-buttonset-3 .ui-button,.ui-fluid .ui-buttonset.ui-buttonset-4 .ui-button,.ui-fluid .ui-buttonset.ui-buttonset-5 .ui-button,.ui-fluid .ui-buttonset.ui-buttonset-6 .ui-button{width:100%}}.ui-fluid .ui-splitbutton{width:100%;box-sizing:border-box;-webkit-box-sizing:border-box;-moz-box-sizing:border-box}.ui-fluid .ui-splitbutton .ui-button{width:100%}.ui-fluid .ui-splitbutton .ui-button.ui-splitbutton-menubutton{width:32px;box-sizing:border-box;-webkit-box-sizing:border-box;-moz-box-sizing:border-box}.ui-fluid .ui-selectonelistbox,.ui-fluid .ui-selectmanymenu{width:100%}
.ui-inputgroup{display:-webkit-box;display:-moz-box;display:-ms-flexbox;display:-webkit-flex;display:flex}.ui-inputgroup .ui-inputgroup-addon,.ui-inputgroup .ui-inputgroup-addon-checkbox{display:inline-block;text-align:center;min-width:1.5em;border-width:1px;border-style:solid}.ui-inputgroup .ui-inputgroup-addon{padding:4px}.ui-inputgroup .ui-inputgroup-addon-checkbox{padding:1px}.ui-inputgroup .ui-inputgroup-addon+.ui-inputgroup-addon{border-left:0 none}.ui-inputgroup .ui-inputtext,.ui-inputgroup .ui-inputtextarea,.ui-inputgroup .ui-password,.ui-inputgroup .ui-autocomplete-input,.ui-inputgroup .ui-chips-container,.ui-inputgroup .ui-spinner-input{padding-left:.5em}.ui-inputgroup>.ui-inputtext:not(:first-child),.ui-inputgroup>.ui-inputtextarea:not(:first-child),.ui-inputgroup>.ui-password:not(:first-child),.ui-inputgroup>.ui-inputnumber:not(:first-child)>.ui-inputtext,.ui-inputgroup>.ui-inputmask:not(:first-child),.ui-inputgroup>.ui-calendar:not(:first-child)>.ui-inputfield,.ui-inputgroup>.ui-chips:not(:first-child)>.ui-chips-container,.ui-inputgroup>.ui-selectonemenu:not(:first-child),.ui-inputgroup>.ui-selectonebutton:not(:first-child)>.ui-button,.ui-inputgroup>.ui-autocomplete:not(:first-child)>.ui-autocomplete-input,.ui-inputgroup>.ui-spinner:not(:first-child),.ui-inputgroup>.ui-spinner:not(:first-child)>.ui-spinner-input{border-top-left-radius:0;border-bottom-left-radius:0;border-left:0 none}.ui-inputgroup>.ui-inputtext:not(:last-child),.ui-inputgroup>.ui-inputtextarea:not(:last-child),.ui-inputgroup>.ui-password:not(:last-child),.ui-inputgroup>.ui-inputnumber:not(:last-child)>.ui-inputtext,.ui-inputgroup>.ui-inputmask:not(:last-child),.ui-inputgroup>.ui-selectonemenu:not(:last-child),.ui-inputgroup>.ui-calendar:not(:last-child)>.ui-inputfield,.ui-inputgroup>.ui-chips:not(:last-child)>.ui-chips-container,.ui-inputgroup>.ui-selectonebutton:not(:last-child)>.ui-button,.ui-inputgroup>.ui-autocomplete:not(:last-child)>.ui-autocomplete-input,.ui-inputgroup>.ui-spinner:not(:last-child),.ui-inputgroup>.ui-spinner:not(:last-child)>.ui-spinner-input,.ui-inputgroup>.ui-spinner:not(:last-child)>.ui-spinner-button{border-top-right-radius:0;border-bottom-right-radius:0;border-right:0 none}.ui-inputgroup .ui-button{margin-right:0;border-radius:0}.ui-inputgroup .ui-inputgroup-addon-checkbox .ui-chkbox{margin-right:0;vertical-align:bottom;position:relative;top:2px}.ui-inputgroup .ui-button .ui-button-text{padding-bottom:4px;padding-top:4px}.ui-fluid .ui-inputgroup .ui-button{width:auto}.ui-fluid .ui-inputgroup .ui-button-icon-only{min-width:2.2em}
.ui-grid{clear:both;padding:0;margin:0}.ui-grid::before,.ui-grid::after{content:"";display:table}.ui-grid::after{clear:both}.ui-grid .ui-grid-row{display:-webkit-box;display:-moz-box;display:-ms-flexbox;display:-webkit-flex;display:flex;clear:both}.ui-grid-row::after{clear:both;content:"";display:table}.ui-grid-col-1,.ui-grid-col-2,.ui-grid-col-3,.ui-grid-col-4,.ui-grid-col-5,.ui-grid-col-6,.ui-grid-col-7,.ui-grid-col-8,.ui-grid-col-9,.ui-grid-col-10,.ui-grid-col-11,.ui-grid-col-12{float:left;box-sizing:border-box}.ui-grid-col-1{width:8.33333333%}.ui-grid-col-2{width:16.66666667%}.ui-grid-col-3{width:25%}.ui-grid-col-4{width:33.33333333%}.ui-grid-col-5{width:41.66666667%}.ui-grid-col-6{width:50%}.ui-grid-col-7{width:58.33333333%}.ui-grid-col-8{width:66.66666667%}.ui-grid-col-9{width:75%}.ui-grid-col-10{width:83.33333333%}.ui-grid-col-11{width:91.66666667%}.ui-grid-col-12{width:100%}@media(min-width:480px){.ui-grid-fixed{width:480px}}@media(min-width:768px){.ui-grid-fixed{width:768px}}@media(min-width:960px){.ui-grid-fixed{width:960px}}@media(min-width:1024px){.ui-grid-fixed{width:1024px}}@media(max-width:640px){.ui-grid-responsive .ui-grid-row{display:block}.ui-grid-responsive .ui-grid-col-1,.ui-grid-responsive .ui-grid-col-2,.ui-grid-responsive .ui-grid-col-3,.ui-grid-responsive .ui-grid-col-4,.ui-grid-responsive .ui-grid-col-5,.ui-grid-responsive .ui-grid-col-6,.ui-grid-responsive .ui-grid-col-7,.ui-grid-responsive .ui-grid-col-8,.ui-grid-responsive .ui-grid-col-9,.ui-grid-responsive .ui-grid-col-10,.ui-grid-responsive .ui-grid-col-11,.ui-grid-responsive .ui-grid-col-12{width:100%;float:none}}.ui-grid.ui-grid-pad>.ui-grid-row>div{padding:.25em .5em}@media(max-width:640px){.ui-grid-responsive .ui-grid-row{display:block}.ui-grid-responsive .ui-grid-col-1,.ui-grid-responsive .ui-grid-col-2,.ui-grid-responsive .ui-grid-col-3,.ui-grid-responsive .ui-grid-col-4,.ui-grid-responsive .ui-grid-col-5,.ui-grid-responsive .ui-grid-col-6,.ui-grid-responsive .ui-grid-col-7,.ui-grid-responsive .ui-grid-col-8,.ui-grid-responsive .ui-grid-col-9,.ui-grid-responsive .ui-grid-col-10,.ui-grid-responsive .ui-grid-col-11,.ui-grid-responsive .ui-grid-col-12{width:100%;float:none}}.ui-g{display:-webkit-box;display:-moz-box;display:-ms-flexbox;display:-webkit-flex;display:flex;flex-wrap:wrap;box-sizing:border-box}.ui-g::after{clear:both;content:"";display:table;box-sizing:border-box}.ui-g-1,.ui-g-2,.ui-g-3,.ui-g-4,.ui-g-5,.ui-g-6,.ui-g-7,.ui-g-8,.ui-g-9,.ui-g-10,.ui-g-11,.ui-g-12{float:left;box-sizing:border-box;padding:.5em}.ui-g-1{width:8.33333333%}.ui-g-2{width:16.66666667%}.ui-g-3{width:25%}.ui-g-4{width:33.33333333%}.ui-g-5{width:41.66666667%}.ui-g-6{width:50%}.ui-g-7{width:58.33333333%}.ui-g-8{width:66.66666667%}.ui-g-9{width:75%}.ui-g-10{width:83.33333333%}.ui-g-11{width:91.66666667%}.ui-g-12{width:100%}.ui-g-offset-12{margin-left:100%}.ui-g-offset-11{margin-left:91.66666667%}.ui-g-offset-10{margin-left:83.33333333%}.ui-g-offset-9{margin-left:75%}.ui-g-offset-8{margin-left:66.66666667%}.ui-g-offset-7{margin-left:58.33333333%}.ui-g-offset-6{margin-left:50%}.ui-g-offset-5{margin-left:41.66666667%}.ui-g-offset-4{margin-left:33.33333333%}.ui-g-offset-3{margin-left:25%}.ui-g-offset-2{margin-left:16.66666667%}.ui-g-offset-1{margin-left:8.33333333%}.ui-g-offset-0{margin-left:0}@media screen and (max-width:40em){.ui-sm-1,.ui-sm-2,.ui-sm-3,.ui-sm-4,.ui-sm-5,.ui-sm-6,.ui-sm-7,.ui-sm-8,.ui-sm-9,.ui-sm-10,.ui-sm-11,.ui-sm-12{padding:.5em}.ui-sm-1{width:8.33333333%}.ui-sm-2{width:16.66666667%}.ui-sm-3{width:25%}.ui-sm-4{width:33.33333333%}.ui-sm-5{width:41.66666667%}.ui-sm-6{width:50%}.ui-sm-7{width:58.33333333%}.ui-sm-8{width:66.66666667%}.ui-sm-9{width:75%}.ui-sm-10{width:83.33333333%}.ui-sm-11{width:91.66666667%}.ui-sm-12{width:100%}.ui-sm-offset-12{margin-left:100%}.ui-sm-offset-11{margin-left:91.66666667%}.ui-sm-offset-10{margin-left:83.33333333%}.ui-sm-offset-9{margin-left:75%}.ui-sm-offset-8{margin-left:66.66666667%}.ui-sm-offset-7{margin-left:58.33333333%}.ui-sm-offset-6{margin-left:50%}.ui-sm-offset-5{margin-left:41.66666667%}.ui-sm-offset-4{margin-left:33.33333333%}.ui-sm-offset-3{margin-left:25%}.ui-sm-offset-2{margin-left:16.66666667%}.ui-sm-offset-1{margin-left:8.33333333%}.ui-sm-offset-0{margin-left:0}}@media screen and (min-width:40.063em){.ui-md-1,.ui-md-2,.ui-md-3,.ui-md-4,.ui-md-5,.ui-md-6,.ui-md-7,.ui-md-8,.ui-md-9,.ui-md-10,.ui-md-11,.ui-md-12{padding:.5em}.ui-md-1{width:8.33333333%}.ui-md-2{width:16.66666667%}.ui-md-3{width:25%}.ui-md-4{width:33.33333333%}.ui-md-5{width:41.66666667%}.ui-md-6{width:50%}.ui-md-7{width:58.33333333%}.ui-md-8{width:66.66666667%}.ui-md-9{width:75%}.ui-md-10{width:83.33333333%}.ui-md-11{width:91.66666667%}.ui-md-12{width:100%}.ui-md-offset-12{margin-left:100%}.ui-md-offset-11{margin-left:91.66666667%}.ui-md-offset-10{margin-left:83.33333333%}.ui-md-offset-9{margin-left:75%}.ui-md-offset-8{margin-left:66.66666667%}.ui-md-offset-7{margin-left:58.33333333%}.ui-md-offset-6{margin-left:50%}.ui-md-offset-5{margin-left:41.66666667%}.ui-md-offset-4{margin-left:33.33333333%}.ui-md-offset-3{margin-left:25%}.ui-md-offset-2{margin-left:16.66666667%}.ui-md-offset-1{margin-left:8.33333333%}.ui-md-offset-0{margin-left:0}}@media screen and (min-width:64.063em){.ui-lg-1,.ui-lg-2,.ui-lg-3,.ui-lg-4,.ui-lg-5,.ui-lg-6,.ui-lg-7,.ui-lg-8,.ui-lg-9,.ui-lg-10,.ui-lg-11,.ui-lg-12{padding:.5em}.ui-lg-1{width:8.33333333%}.ui-lg-2{width:16.66666667%}.ui-lg-3{width:25%}.ui-lg-4{width:33.33333333%}.ui-lg-5{width:41.66666667%}.ui-lg-6{width:50%}.ui-lg-7{width:58.33333333%}.ui-lg-8{width:66.66666667%}.ui-lg-9{width:75%}.ui-lg-10{width:83.33333333%}.ui-lg-11{width:91.66666667%}.ui-lg-12{width:100%}.ui-lg-offset-12{margin-left:100%}.ui-lg-offset-11{margin-left:91.66666667%}.ui-lg-offset-10{margin-left:83.33333333%}.ui-lg-offset-9{margin-left:75%}.ui-lg-offset-8{margin-left:66.66666667%}.ui-lg-offset-7{margin-left:58.33333333%}.ui-lg-offset-6{margin-left:50%}.ui-lg-offset-5{margin-left:41.66666667%}.ui-lg-offset-4{margin-left:33.33333333%}.ui-lg-offset-3{margin-left:25%}.ui-lg-offset-2{margin-left:16.66666667%}.ui-lg-offset-1{margin-left:8.33333333%}.ui-lg-offset-0{margin-left:0}}@media screen and (min-width:90.063em){.ui-xl-1,.ui-xl-2,.ui-xl-3,.ui-xl-4,.ui-xl-5,.ui-xl-6,.ui-xl-7,.ui-xl-8,.ui-xl-9,.ui-xl-10,.ui-xl-11,.ui-xl-12{padding:.5em}.ui-xl-1{width:8.33333333%}.ui-xl-2{width:16.66666667%}.ui-xl-3{width:25%}.ui-xl-4{width:33.33333333%}.ui-xl-5{width:41.66666667%}.ui-xl-6{width:50%}.ui-xl-7{width:58.33333333%}.ui-xl-8{width:66.66666667%}.ui-xl-9{width:75%}.ui-xl-10{width:83.33333333%}.ui-xl-11{width:91.66666667%}.ui-xl-12{width:100%}.ui-xl-offset-12{margin-left:100%}.ui-xl-offset-11{margin-left:91.66666667%}.ui-xl-offset-10{margin-left:83.33333333%}.ui-xl-offset-9{margin-left:75%}.ui-xl-offset-8{margin-left:66.66666667%}.ui-xl-offset-7{margin-left:58.33333333%}.ui-xl-offset-6{margin-left:50%}.ui-xl-offset-5{margin-left:41.66666667%}.ui-xl-offset-4{margin-left:33.33333333%}.ui-xl-offset-3{margin-left:25%}.ui-xl-offset-2{margin-left:16.66666667%}.ui-xl-offset-1{margin-left:8.33333333%}.ui-xl-offset-0{margin-left:0}}.ui-g-nopad{padding:0}
.ui-growl{position:fixed;top:20px;right:20px;width:301px}.ui-growl-item-container{position:relative;margin:0 0 10px 0;opacity:.85;filter:alpha(opacity=85)}.ui-growl-item{display:block;padding:10px 15px}.ui-growl-item p{padding:0;margin:0}.ui-growl-icon-close{position:absolute;top:5px;right:3px;cursor:pointer}.ui-growl-title{font-weight:bold;padding:0 0 7px 0;display:block}.ui-growl-image{width:32px;height:32px;float:left;margin:0;padding:0;display:block;background:/*savepage-url=/ebok/javax.faces.resource/messages/messages.png.xhtml?ln=primefaces&v=7.0*/url() no-repeat}.ui-growl-image-info{background-position:0 -264px}.ui-growl-image-warn{background-position:0 -396px}.ui-growl-image-error{background-position:0 0}.ui-growl-image-fatal{background-position:0 -132px}.ui-growl-message{padding:0 0 5px 0;width:220px;float:right}.ui-growl-message p{font-weight:normal}
.ui-inplace .ui-inplace-display{cursor:pointer;border:0 none!important}.ui-inplace .ui-inplace-disabled{cursor:default}.ui-inplace .ui-inplace-editor{margin-left:.1em}
.ui-lightbox{position:fixed}.ui-lightbox-content-wrapper{position:relative}.ui-lightbox-content{position:relative;margin:0;padding:0;background-color:#000}.ui-lightbox-nav-right,.ui-lightbox-nav-left{position:absolute;top:50%;cursor:pointer}.ui-lightbox-nav-left{left:0}.ui-lightbox-nav-right{right:0}.ui-lightbox-loading{background:/*savepage-url=/ebok/javax.faces.resource/lightbox/images/loading.gif.xhtml?ln=primefaces&v=7.0*/url() #000 center center no-repeat}.ui-lightbox-caption{padding:.2em .4em;display:none}.ui-lightbox-caption-text{margin:.3em 0 .1em 0;float:left}.ui-lightbox-close{float:right;margin:0;padding:1px}.ui-lightbox-close.ui-state-hover{padding:0}
.ui-menu{width:12.5em;padding:.3em;position:relative;outline:0 none}.ui-menu.ui-menu-dynamic{position:absolute;display:none;z-index:100000}.ui-menu-list{position:static}.ui-menu .ui-menu-list .ui-menuitem{border:0}.ui-menu .ui-menu-list .ui-widget-header{clear:both;float:left;width:98%;margin:1px 0}.ui-menu .ui-menuitem{width:100%;float:left;clear:both;margin:1px 0;padding:0}.ui-menu .ui-menuitem-parent{width:100%;float:left;clear:both;margin:1px 0;padding:0}.ui-menu .ui-menuitem-link{display:block;width:92%;outline:0;text-decoration:none;font-weight:400;border:solid 1px transparent;float:left;line-height:16px;padding:.3em;cursor:pointer}.ui-menu .ui-menuitem-link .ui-menuitem-icon,.ui-menu .ui-submenu-icon{display:inline-block;float:left}.ui-menu .ui-submenu-icon{margin-top:1px}.ui-menu .ui-menuitem-text{float:left}.ui-menu .ui-widget-header h1,.ui-menu .ui-widget-header h2,.ui-menu .ui-widget-header h3,.ui-menu .ui-widget-header h4,.ui-menu .ui-widget-header h5,.ui-menu .ui-widget-header h6{float:left;display:block;font-size:1em;margin:0 auto;padding:.3em 3%}.ui-menu .ui-menu-parent .ui-menu-child{display:none;width:12.5em;padding:.3em;position:absolute;margin:0;outline:0;line-height:1.3;text-decoration:none;font-size:100%;list-style:none}.ui-menu .ui-menu-parent{position:relative}.ui-menu.ui-menu-toggleable li.ui-widget-header{position:relative;min-height:0}.ui-menu.ui-menu-toggleable li.ui-widget-header h3{padding-left:2em}.ui-menu.ui-menu-toggleable li.ui-widget-header.ui-state-hover{cursor:pointer}.ui-menu.ui-menu-toggleable li.ui-widget-header .ui-icon{position:absolute;left:.5em;top:50%;margin-top:-8px}.ui-menu .ui-menu-parent .ui-icon-triangle-1-e,.ui-menu .ui-menu-parent .ui-icon-triangle-1-s,.ui-menubar .ui-menu-child .ui-icon-triangle-1-s,.ui-menubar .ui-menu-child .ui-icon-triangle-1-s{float:right}.ui-menubutton{padding:0;position:relative;display:inline-block}.ui-menubutton .ui-button{margin:0}.ui-menubar{width:auto}.ui-menubar .ui-menuitem{width:auto;clear:none}.ui-menubar .ui-menu-child .ui-menuitem{width:100%}.ui-menubar .ui-menu-child{top:25px;left:0}.ui-menubar .ui-menuitem-link{width:auto;padding:.4em .3em}.ui-menubar .ui-menu-child .ui-menuitem-link{width:92%}.ui-menubar .ui-widget-header{clear:none;width:auto;margin:0 3px 0 0}.ui-menubar .ui-widget-header h1,.ui-menubar .ui-widget-header h2,.ui-menubar .ui-widget-header h3,.ui-menubar .ui-widget-header h4,.ui-menubar .ui-widget-header h5,.ui-menubar .ui-widget-header h6{padding:.4em .3em}.ui-menubar .ui-menubar-options{float:right}.ui-menubar>.ui-menu-list>.ui-menuitem>.ui-menuitem-link span.ui-icon-triangle-1-e,.ui-menubar>.ui-menu-list>.ui-menuitem>.ui-menuitem-link span.ui-icon-triangle-1-s{*float:none}.ui-menu .ui-separator{width:98%;height:0;float:left;clear:both;margin:1px 0 0 0;padding:0;border-top:0 none}.ui-megamenu td{vertical-align:top}.ui-menu.ui-megamenu .ui-menu-parent .ui-menu-child{width:auto}.ui-menu.ui-megamenu .ui-menu-child>table{width:auto}.ui-menu.ui-megamenu .ui-menu-child .ui-menu-list{width:12.5em}.ui-megamenu-vertical{width:12.5em}.ui-megamenu-vertical .ui-menu-parent{clear:both;width:100%}.ui-megamenu-vertical .ui-submenu-link.ui-menuitem-link{width:92%}.ui-megamenu .ui-widget-header span{display:block;float:left;font-size:1em;margin:0 auto;padding:.4em .3em}.ui-breadcrumb{margin:0;padding:0;overflow:hidden;padding:5px 5px 7px 5px}.ui-breadcrumb ul{margin:0;padding:0;display:block}.ui-breadcrumb ul li{display:block;float:left;position:relative;overflow:hidden}.ui-breadcrumb ul li span{display:block;overflow:hidden}.ui-breadcrumb ul li .ui-menuitem-link{display:block;position:relative;overflow:hidden;float:left;*cursor:pointer;margin-top:3px}.ui-breadcrumb ul li a.ui-icon-home{padding:0;margin-top:1px;overflow:hidden}.ui-breadcrumb-chevron{float:left;margin-top:2px}.ui-breadcrumb .ui-breadcrumb-options{float:right}.ui-slidemenu .ui-slidemenu-wrapper{position:relative}.ui-slidemenu .ui-slidemenu-content{overflow-x:hidden;overflow-y:auto;position:relative}.ui-slidemenu .ui-menu-list{position:absolute;top:0}.ui-slidemenu .ui-menu-parent{position:static}.ui-slidemenu .ui-menu-child{box-shadow:none;border:0 none;background:none repeat scroll 0 0 transparent}.ui-slidemenu-backward{position:absolute;bottom:0;width:95%;margin-bottom:.4em;padding:.2em;cursor:pointer;display:none}.ui-slidemenu-backward .ui-icon{float:left}.ui-splitbuttonmenu{width:auto}.ui-panelmenu{width:auto}.ui-panelmenu .ui-panelmenu-panel{padding:0;margin:0}.ui-panelmenu .ui-panelmenu-header{cursor:pointer;position:relative;margin:0;zoom:1}.ui-panelmenu .ui-panelmenu-header a{display:block;padding:.5em .5em .5em 2.2em}.ui-panelmenu .ui-panelmenu-header .ui-icon{position:absolute;left:.5em;top:50%;margin-top:-8px}.ui-panelmenu .ui-panelmenu-content{padding:.2em 0;border-top:0;margin-top:-2px;position:relative;top:1px;overflow:auto;zoom:1;outline:0}.ui-panelmenu .ui-panelmenu-header.ui-state-disabled,.ui-panelmenu .ui-panelmenu-header.ui-state-disabled a{cursor:default}.ui-panelmenu .ui-menu-list{position:static}.ui-panelmenu .ui-menuitem{margin:1px 0;padding:0}.ui-panelmenu .ui-menuitem-link{display:block;outline:0;text-decoration:none;font-weight:400;border:solid 1px transparent;line-height:16px;cursor:pointer;position:relative;padding:.3em .3em .3em 2em}.ui-panelmenu .ui-menu-parent .ui-menuitem-link-hasicon{padding-left:2.8em}.ui-panelmenu .ui-icon{position:absolute;right:auto;top:0;bottom:0;margin:auto 0;left:.5em}.ui-panelmenu .ui-menu-parent>.ui-menuitem-link>.ui-icon{left:1.5em}.ui-panelmenu .ui-menu-parent .ui-panelmenu-icon.ui-icon{left:.5em}.ui-panelmenu .ui-menuitem-text{float:none}.ui-panelmenu .ui-menu-parent .ui-menu-list{margin-left:20px}.ui-menuitem-outline{outline:1px dotted;z-index:1}.ui-tabmenu{position:relative;zoom:1}.ui-tabmenu .ui-tabmenu-nav{margin:0;padding:.2em .2em 0}.ui-tabmenu .ui-tabmenu-nav .ui-tabmenuitem{list-style:none;float:left;position:relative;margin:0 .2em 1px 0;padding:0;white-space:nowrap;display:block;border-bottom:0;top:1px}.ui-tabmenu .ui-tabmenu-nav .ui-tabmenuitem a{float:left;padding:.5em 1em;text-decoration:none}.ui-tabmenu .ui-tabmenu-nav .ui-tabmenuitem-hasicon a{padding:.5em 1em .5em .2em}.ui-tabmenu .ui-tabmenu-nav .ui-tabmenuitem .ui-icon{float:left;cursor:pointer}.ui-steps ul{list-style-type:none;padding:0;margin:0}.ui-steps .ui-steps-item{float:left;box-sizing:border-box}.ui-steps .ui-steps-item .ui-menuitem-link{text-decoration:none;display:block;padding:1em;position:relative;text-align:center}.ui-steps .ui-steps-item.ui-state-highlight .ui-menuitem-link,.ui-steps .ui-steps-item.ui-state-disabled .ui-menuitem-link{cursor:default}.ui-steps .ui-steps-number{font-size:200%;display:block}.ui-steps .ui-steps-title{display:block;white-space:nowrap}@media(max-width:640px){.ui-steps .ui-steps-item .ui-menuitem-link{padding:.5em}.ui-steps .ui-steps-item .ui-steps-title{display:none}}.ui-fluid .ui-menu{width:100%;box-sizing:border-box;-webkit-box-sizing:border-box;-moz-box-sizing:border-box}
.ui-messages-info,.ui-messages-warn,.ui-messages-error,.ui-messages-fatal{border:1px solid;margin:10px 0;padding:10px 10px 10px 10px}.ui-message-info,.ui-message-error,.ui-message-warn,.ui-message-fatal{border:1px solid;margin:0 5px;padding:2px 5px}.ui-messages-info-icon,.ui-messages-warn-icon,.ui-messages-error-icon,.ui-messages-fatal-icon,.ui-message-info-icon,.ui-message-warn-icon,.ui-message-error-icon,.ui-message-fatal-icon{background:/*savepage-url=/ebok/javax.faces.resource/messages/messages.png.xhtml?ln=primefaces&v=7.0*/url() no-repeat;display:block;float:left;margin:0;padding:0;position:relative}.ui-messages-info-icon,.ui-messages-warn-icon,.ui-messages-error-icon,.ui-messages-fatal-icon{height:24px;width:24px;margin-top:-4px}.ui-message-info-icon,.ui-message-warn-icon,.ui-message-error-icon,.ui-message-fatal-icon{height:16px;width:16px}.ui-messages-info-summary,.ui-messages-warn-summary,.ui-messages-error-summary,.ui-messages-fatal-summary,.ui-message-info-summary,.ui-message-warn-summary,.ui-message-error-summary,.ui-message-fatal-summary{margin-left:10px;font-weight:bold}.ui-messages-info-detail,.ui-messages-warn-detail,.ui-messages-error-detail,.ui-messages-fatal-detail,.ui-message-info-detail,.ui-message-warn-detail,.ui-message-error-detail,.ui-message-fatal-detail{margin-left:5px}.ui-messages-info,.ui-message-info{color:#3a87ad;background-color:#d9edf7;border-color:#bce8f1}.ui-messages-warn,.ui-message-warn{color:#c09853;background-color:#fcf8e3;border-color:#fbeed5}.ui-messages-error,.ui-message-error{color:#b94a48;background-color:#f2dede;border-color:#eed3d7}.ui-messages-fatal,.ui-message-fatal{color:#b94a48;background-color:#f2dede;border-color:#eed3d7}.ui-messages ul{margin:0 25px;padding:0;list-style-type:none}.ui-messages.ui-messages-noicon ul{margin:0 25px 0 0}.ui-message-icon-only{width:16px;height:16px}.ui-messages-info-icon{background-position:0 -316px}.ui-messages-warn-icon{background-position:0 -448px}.ui-messages-error-icon{background-position:0 -52px}.ui-messages-fatal-icon{background-position:0 -184px}.ui-message-info-icon{background-position:0 -360px}.ui-message-warn-icon{background-position:0 -492px}.ui-message-error-icon{background-position:0 -96px}.ui-message-fatal-icon{background-position:0 -228px}.ui-messages .ui-messages-close{float:right;cursor:pointer}
.ui-notificationbar{position:fixed;width:100%;height:100px;display:none;padding:10px}.ui-notificationbar-close{position:absolute;right:3em;top:1em;cursor:pointer}
.ui-orderlist{display:table}.ui-orderlist .ui-orderlist-caption{width:180px}.ui-orderlist .ui-orderlist-list{list-style-type:none;margin:0;padding:0;overflow:auto;height:200px;width:200px}.ui-orderlist .ui-orderlist-list li{margin:1px;padding:2px}.ui-orderlist .ui-button{display:block;margin-bottom:.3em}.ui-orderlist .ui-orderlist-button.ui-button-text-icon-primary{width:100%}.ui-orderlist .ui-orderlist-item{cursor:pointer;border:0 none;font-weight:inherit}.ui-orderlist .ui-orderlist-caption{text-align:center;padding:4px 0;border-bottom:0 none}.ui-orderlist table{width:100%;border-collapse:collapse}.ui-orderlist.ui-state-disabled .ui-orderlist-item,.ui-orderlist.ui-state-disabled .ui-button{cursor:default}.ui-orderlist.ui-state-disabled .ui-orderlist-list{overflow:hidden}.ui-orderlist.ui-grid-responsive{display:block;width:100%}.ui-orderlist.ui-grid-responsive .ui-orderlist-list,.ui-orderlist.ui-grid-responsive .ui-orderlist-caption{width:100%}.ui-orderlist.ui-grid-responsive .ui-orderlist-controls .ui-button{width:100%}@media(max-width:640px){.ui-orderlist.ui-grid-responsive .ui-orderlist-controls{text-align:center;padding:0}.ui-orderlist.ui-grid-responsive .ui-orderlist-controls .ui-button{display:inline;width:20%}}
.ui-outputpanel-loading{background:/*savepage-url=/ebok/javax.faces.resource/outputpanel/images/loading.gif.xhtml?ln=primefaces&v=7.0*/url() center center no-repeat;width:32px;height:32px}
.ui-overlaypanel{padding:0;margin:0;position:absolute}.ui-overlaypanel-content{padding:.5em 1em}.ui-overlaypanel-close{position:absolute;top:-10px;right:-10px;-moz-border-radius:10px;-webkit-border-radius:10px;border-radius:10px}.ui-overlaypanel-mask{position:fixed;width:100%;height:100%}
.ui-panel{padding:.2em}.ui-panel .ui-panel-titlebar{padding:.5em 1em .3em}.ui-panel .ui-panel-title{margin:.1em 16px .2em 0}.ui-panel .ui-panel-titlebar-icon{float:right;cursor:pointer}.ui-panel .ui-panel-titlebar-icon,.ui-panel .ui-panel-titlebar-icon:hover,.ui-panel .ui-panel-titlebar-icon:focus{margin-left:.2em;margin-top:-0.2em;*margin:-1.5em 0 0 .2em}.ui-panel .ui-panel-content{border:0;background:0;padding:.5em 1em}.ui-panel .ui-panel-footer{border-width:1px 0 0;margin:.5em 0 0;padding:.5em 1em;text-align:left}.ui-panel-collapsed-h .ui-panel-titlebar-icon,.ui-panel-collapsed-h .ui-panel-titlebar-icon:hover,.ui-panel-collapsed-h .ui-panel-titlebar-icon:focus{*margin:-0.2em 0 0 .1em}.ui-panel.ui-panel-collapsed-h{width:42px}.ui-panel.ui-panel-collapsed-h .ui-panel-title{display:none}.ui-panel .ui-panel-actions{float:right}
.ui-panelgrid{border-collapse:collapse}.ui-panelgrid .ui-panelgrid-header{text-align:center;padding:4px 10px}.ui-panelgrid .ui-panelgrid-footer{text-align:left;padding:2px 5px}.ui-panelgrid .ui-panelgrid-cell{border-width:1px;border-style:solid;border-color:inherit;padding:4px 10px}.ui-panelgrid.ui-noborder .ui-panelgrid-cell{border:0 none}.ui-panelgrid.ui-noborder .ui-widget-content,.ui-panelgrid.ui-noborder .ui-widget-header{border:0 none}.ui-panelgrid.ui-panelgrid-blank .ui-panelgrid-content.ui-widget-content,.ui-panelgrid.ui-panelgrid-blank .ui-panelgrid-header.ui-widget-header,.ui-panelgrid.ui-panelgrid-blank .ui-panelgrid-footer.ui-widget-header,.ui-panelgrid.ui-panelgrid-blank .ui-panelgrid-header>tr.ui-widget-header,.ui-panelgrid.ui-panelgrid-blank tbody>tr.ui-widget-content,.ui-panelgrid.ui-panelgrid-blank tbody>tr.ui-widget-content>td.ui-panelgrid-cell,.ui-panelgrid.ui-panelgrid-blank .ui-panelgrid-footer>tr.ui-widget-footer{background:0;border:0 none}.ui-panelgrid .ui-panelgrid-cell.ui-panelgrid-nopad{padding:0}.ui-panelgrid .ui-grid-responsive .ui-panelgrid-cell{border:0 none}@media(max-width:640px){.ui-panelgrid .ui-grid-responsive .ui-grid-row{border-top:1px solid #bcc7cf}.ui-panelgrid .ui-grid-responsive .ui-grid-row:first-child{border-top:0 none}.ui-panelgrid.ui-noborder .ui-grid-responsive .ui-grid-row{border:0 none}}
.ui-paginator{margin:0;text-align:center;padding:2px}.ui-paginator.ui-paginator-top{border-bottom:0 none}.ui-paginator.ui-paginator-bottom{border-top:0 none}.ui-paginator.ui-paginator-top .ui-paginator-top-left-content{float:left}.ui-paginator.ui-paginator-top .ui-paginator-top-right-content{float:right}.ui-paginator.ui-paginator-bottom .ui-paginator-bottom-left-content{float:left}.ui-paginator.ui-paginator-bottom .ui-paginator-bottom-right-content{float:right}.ui-paginator .ui-paginator-page,.ui-paginator .ui-paginator-pages,.ui-paginator .ui-paginator-next,.ui-paginator .ui-paginator-last,.ui-paginator .ui-paginator-first,.ui-paginator .ui-paginator-prev,.ui-paginator .ui-paginator-current{display:inline-block;padding:2px 6px;zoom:1;margin-left:1px;margin-right:1px;text-decoration:none;outline:0}.ui-paginator .ui-paginator-page,.ui-paginator .ui-paginator-next,.ui-paginator .ui-paginator-last,.ui-paginator .ui-paginator-first,.ui-paginator .ui-paginator-prev{cursor:pointer}.ui-paginator .ui-paginator-current,.ui-paginator .ui-paginator-rpp-options{margin-left:1em;margin-right:1em;background-image:none}.ui-paginator .ui-paginator-next .ui-icon,.ui-paginator .ui-paginator-prev .ui-icon,.ui-paginator .ui-paginator-first .ui-icon,.ui-paginator .ui-paginator-last .ui-icon{height:auto;overflow:inherit}.ui-paginator .ui-paginator-jtp-select option,.ui-paginator .ui-paginator-rpp-options option{background-image:none;border:0 none;box-shadow:none;-moz-box-shadow:none;-webkit-box-shadow:none}@media(max-width:640px){.ui-paginator .ui-paginator-pages{display:none}}
.ui-picklist>div{float:left}.ui-picklist .ui-picklist-buttons{height:200px;padding:0 5px}.ui-picklist .ui-picklist-list{list-style-type:none;margin:0;padding:0;overflow:auto;height:200px;width:200px}.ui-picklist .ui-picklist-list li{margin:1px;padding:2px;overflow-wrap:break-word}.ui-picklist .ui-button{display:block;margin-bottom:.3em}.ui-picklist .ui-button-text-icon-left{width:100%}.ui-picklist .ui-picklist-item{cursor:pointer;border:0 none;font-weight:inherit}.ui-picklist .ui-picklist-caption{text-align:center;padding:4px 0;border-bottom:0 none}.ui-picklist table{width:100%;border-collapse:collapse}.ui-picklist .ui-picklist-filter{padding-right:15px;width:100%;box-sizing:border-box}.ui-picklist .ui-picklist-filter-container{position:relative;margin:0;padding:0}.ui-picklist .ui-picklist-filter-container .ui-icon{position:absolute;top:5px;right:2px}.ui-picklist{display:table}.ui-picklist>div{float:none;display:table-cell;vertical-align:top}.ui-picklist .ui-picklist-buttons{vertical-align:middle}.ui-picklist.ui-picklist-vertical{display:table}.ui-picklist.ui-picklist-vertical>div{float:none;display:table-row;vertical-align:top}.ui-picklist.ui-picklist-vertical .ui-picklist-buttons{text-align:center;height:auto}.ui-picklist.ui-picklist-vertical .ui-picklist-buttons .ui-button{display:inline-block}.ui-picklist.ui-picklist-vertical .ui-button{margin-top:.3em}.ui-picklist-outline{outline:1px dotted black;z-index:1}.ui-picklist-list.ui-picklist-source,.ui-picklist-list.ui-picklist-target{outline:0}.ui-picklist.ui-picklist-responsive *{box-sizing:border-box}.ui-picklist.ui-picklist-responsive{width:100%}.ui-picklist.ui-picklist-responsive .ui-picklist-list-wrapper{width:35%}.ui-picklist.ui-picklist-responsive .ui-picklist-list-wrapper:nth-child(1),.ui-picklist.ui-picklist-responsive .ui-picklist-list-wrapper:nth-last-child(2){width:45%}.ui-picklist.ui-picklist-responsive .ui-picklist-buttons{width:10%}.ui-picklist.ui-picklist-responsive .ui-picklist-buttons button{width:100%}.ui-picklist.ui-picklist-responsive .ui-picklist-list{width:auto}.ui-picklist.ui-picklist-responsive .ui-chkbox-box{width:18px;height:18px}@media(max-width:640px){.ui-picklist.ui-picklist-responsive{display:block}.ui-picklist.ui-picklist-responsive>div{display:block;width:100%!important}.ui-picklist.ui-picklist-responsive .ui-picklist-buttons{text-align:center;height:auto;padding:5px 0}.ui-picklist.ui-picklist-responsive .ui-picklist-buttons button{display:inline;width:20%}.ui-picklist.ui-picklist-responsive .ui-picklist-source-controls.ui-picklist-buttons{padding-bottom:5px}.ui-picklist.ui-picklist-responsive .ui-picklist-target-controls.ui-picklist-buttons{padding-top:5px}.ui-picklist.ui-picklist-responsive .ui-picklist-buttons .ui-icon-arrow-1-e{background-position:-64px -32px}.ui-picklist.ui-picklist-responsive .ui-picklist-buttons .ui-icon-arrowstop-1-e{background-position:-224px -32px}.ui-picklist.ui-picklist-responsive .ui-picklist-buttons .ui-icon-arrow-1-w{background-position:0 -32px}.ui-picklist.ui-picklist-responsive .ui-picklist-buttons .ui-icon-arrowstop-1-w{background-position:-192px -32px}}
.ui-progressbar{height:1.2em;text-align:left;position:relative}.ui-progressbar-determinate .ui-progressbar-value{margin:-1px;height:100%;width:0;position:absolute;display:none}.ui-progressbar-determinate .ui-progressbar-label{text-align:center;height:100%;width:100%;position:absolute;display:none;font-weight:bold}.ui-progressbar-indeterminate{height:.5em;overflow:hidden}.ui-progressbar-indeterminate .ui-progressbar-value{border:0 none}.ui-progressbar-indeterminate .ui-progressbar-value::before{content:'';position:absolute;background-color:inherit;top:0;left:0;bottom:0;will-change:left,right;-webkit-animation:ui-progressbar-indeterminate-anim 2.1s cubic-bezier(0.65,0.815,0.735,0.395) infinite;animation:ui-progressbar-indeterminate-anim 2.1s cubic-bezier(0.65,0.815,0.735,0.395) infinite}.ui-progressbar-indeterminate .ui-progressbar-value::after{content:'';position:absolute;background-color:inherit;top:0;left:0;bottom:0;will-change:left,right;-webkit-animation:ui-progressbar-indeterminate-anim-short 2.1s cubic-bezier(0.165,0.84,0.44,1) infinite;animation:ui-progressbar-indeterminate-anim-short 2.1s cubic-bezier(0.165,0.84,0.44,1) infinite;-webkit-animation-delay:1.15s;animation-delay:1.15s}@-webkit-keyframes ui-progressbar-indeterminate-anim{0%{left:-35%;right:100%}60%{left:100%;right:-90%}100%{left:100%;right:-90%}}@keyframes ui-progressbar-indeterminate-anim{0%{left:-35%;right:100%}60%{left:100%;right:-90%}100%{left:100%;right:-90%}}@-webkit-keyframes ui-progressbar-indeterminate-anim-short{0%{left:-200%;right:100%}60%{left:107%;right:-8%}100%{left:107%;right:-8%}}@keyframes ui-progressbar-indeterminate-anim-short{0%{left:-200%;right:100%}60%{left:107%;right:-8%}100%{left:107%;right:-8%}}
.ui-rating-star,.ui-rating-cancel{display:inline-block;overflow:hidden;text-indent:-999em;cursor:pointer}.ui-rating-star a,.ui-rating-cancel a{width:16px;height:15px;display:block;background:/*savepage-url=/ebok/javax.faces.resource/rating/rating.png.xhtml?ln=primefaces&v=7.0*/url() no-repeat 0 0}.ui-rating-star a{background-position:0 -32px}.ui-rating-star-on a{background-position:0 -48px}.ui-rating-star-hover a{background-position:0 -64px}.ui-rating-cancel-hover a{background-position:0 -16px}.ui-rating.ui-state-disabled .ui-rating-star,.ui-rating.ui-state-disabled .ui-rating-cancel{cursor:default}
.ui-spinner{display:inline-block;overflow:visible;padding:0;position:relative;vertical-align:middle}.ui-spinner-input{vertical-align:middle;text-align:right;padding-right:20px;font-size:1em;box-sizing:border-box;width:100%}.ui-spinner-button{cursor:default;display:block;font-size:.5em;height:50%;margin:0;overflow:hidden;padding:0;position:absolute;right:0;text-align:center;vertical-align:middle;width:16px;z-index:100}.ui-spinner .ui-icon{left:0;margin-top:-8px;position:absolute;top:50%}.ui-spinner-up{top:0}.ui-spinner-down{bottom:0}.ui-spinner .ui-icon-triangle-1-s{background-position:-65px -16px}.ui-spinner .ui-icon-triangle-1-n{margin-top:-9px}.ui-spinner-input::-ms-clear{display:none}
.ui-tabs{position:relative;padding:.2em;zoom:1}.ui-tabs .ui-tabs-nav{margin:0}.ui-tabs .ui-tabs-nav li{list-style:none;position:relative;margin:0 .2em 1px 0;padding:0;white-space:nowrap;display:inline-block;vertical-align:top;float:none}.ui-tabs .ui-tabs-nav li a{float:left;padding:.5em 1em;text-decoration:none;outline:0}.ui-tabs .ui-tabs-nav li.ui-tabs-selected a,.ui-tabs .ui-tabs-nav li.ui-state-disabled a,.ui-tabs .ui-tabs-nav li.ui-state-processing a{cursor:text}.ui-tabs .ui-tabs-nav li a,.ui-tabs.ui-tabs-collapsible .ui-tabs-nav li.ui-tabs-selected a{cursor:pointer}.ui-tabs .ui-tabs-panel{border-width:0;padding:1em 1.4em;background:0}.ui-tabs .ui-tabs-nav li>.ui-icon{float:left;margin:.4em .2em 0 0;cursor:pointer}.ui-tabs.ui-tabs-top>.ui-tabs-nav li{border-bottom:0;top:1px}.ui-tabs.ui-tabs-top>.ui-tabs-nav{padding:.2em .2em 0}.ui-tabs.ui-tabs-bottom>.ui-tabs-nav{padding:0 .2em .2em}.ui-tabs.ui-tabs-bottom>.ui-tabs-nav li{border-top:0}.ui-tabs-left:after,.ui-tabs-right:after{clear:both;content:".";display:block;height:0;visibility:hidden}.ui-tabs-left>.ui-tabs-nav{float:left;width:23%;height:300px;background-image:none;padding-top:1px}.ui-tabs-left>.ui-tabs-panels{float:right;width:75%}.ui-tabs.ui-tabs-left>.ui-tabs-nav li,.ui-tabs.ui-tabs-right>.ui-tabs-nav li{display:block;white-space:normal;width:98%}.ui-tabs.ui-tabs-left>.ui-tabs-nav li a,.ui-tabs.ui-tabs-right>.ui-tabs-nav li a{width:90%}.ui-tabs.ui-tabs-left>.ui-tabs-nav li{float:right}.ui-tabs.ui-tabs-right>.ui-tabs-nav li{float:left}.ui-tabs.ui-tabs-left>.ui-tabs-nav li{margin:0 0 1px .2em;border-right:0 none}.ui-tabs.ui-tabs-right>.ui-tabs-nav{float:right;width:23%;height:300px;background-image:none;padding-top:1px}.ui-tabs.ui-tabs-right>.ui-tabs-panels{float:left;width:75%}.ui-tabs.ui-tabs-right>.ui-tabs-nav li{margin:0 .2em 1px 0;border-left:0 none}.ui-tabs.ui-tabs-left .ui-tabs-actions,.ui-tabs.ui-tabs-right .ui-tabs-actions{position:absolute;bottom:0;padding:.2em}.ui-tabs-rtl{direction:rtl}.ui-tabs-scrollable .ui-tabs-nav{width:5000px}.ui-tabs .ui-tabs-navscroller{overflow:hidden;padding-left:18px}.ui-tabs .ui-tabs-navscroller.ui-tabs-navscroller-btn-hidden{padding-left:0}.ui-tabs-scrollable .ui-tabs-nav li{margin:0 .2em -1px 0}.ui-tabs .ui-tabs-navscroller-btn{position:absolute;height:28px;z-index:100;cursor:pointer}.ui-tabs .ui-tabs-navscroller.ui-tabs-navscroller-btn-hidden .ui-tabs-navscroller-btn{display:none}.ui-tabs .ui-tabs-navscroller-btn-left{left:.2em}.ui-tabs .ui-tabs-navscroller-btn-right{right:.2em}.ui-tabs .ui-tabs-navscroller-btn-left .ui-icon,.ui-tabs .ui-tabs-navscroller-btn-right .ui-icon{margin-top:5px}.ui-tabs-outline{outline:dotted thin;z-index:1}.ui-tabs li.ui-tabs-actions{float:right}.ui-tabs.ui-tabs-rtl li.ui-tabs-actions{float:left}.ui-tabs li.ui-tabs-actions[aria-hidden='true']{display:none}
.ui-tagcloud{width:250px}.ui-tagcloud ul{margin:1em;padding:.1em;text-align:center}.ui-tagcloud li{margin:0;padding:0;list-style:none;display:inline-block}.ui-tagcloud li a{text-decoration:none;padding:0 5px}.ui-tagcloud-strength-1{font-size:100%}.ui-tagcloud-strength-2{font-size:120%}.ui-tagcloud-strength-3{font-size:140%}.ui-tagcloud-strength-4{font-size:160%}.ui-tagcloud-strength-5{font-size:180%}.ui-tagcloud li a.ui-state-hover{border:0 none;font-weight:inherit}
.ui-toolbar{padding:.2em}.ui-toolbar .ui-separator{display:inline-block;vertical-align:middle}.ui-toolbar-group-left{float:left}.ui-toolbar-group-right{float:right}
.ui-tooltip{position:absolute;display:none;pointer-events:none}.ui-tooltip.ui-tooltip-right,.ui-tooltip.ui-tooltip-left{padding:0 5px}.ui-tooltip.ui-tooltip-top,.ui-tooltip.ui-tooltip-bottom{padding:5px 0}.ui-tooltip .ui-tooltip-text{padding:3px 10px;background-color:#4c4c4c;background-image:none;color:#fff}.ui-tooltip-arrow{position:absolute;width:0;height:0;border-color:transparent;border-style:solid}.ui-tooltip-right .ui-tooltip-arrow{top:50%;left:0;margin-top:-5px;border-width:5px 5px 5px 0;border-right-color:#4c4c4c}.ui-tooltip-left .ui-tooltip-arrow{top:50%;right:0;margin-top:-5px;border-width:5px 0 5px 5px;border-left-color:#4c4c4c}.ui-tooltip.ui-tooltip-top{padding:5px 0}.ui-tooltip-top .ui-tooltip-arrow{bottom:0;left:50%;margin-left:-5px;border-width:5px 5px 0;border-top-color:#4c4c4c}.ui-tooltip-bottom .ui-tooltip-arrow{top:0;left:50%;margin-left:-5px;border-width:0 5px 5px;border-bottom-color:#4c4c4c}
.ui-tree{width:300px;position:relative}.ui-tree .ui-tree-container{margin:0;padding:3px;white-space:nowrap;overflow:auto}.ui-tree .ui-treenode-children{margin:0;padding:0 0 0 16px}.ui-tree .ui-treenode{background-attachment:scroll;background-color:transparent;background-image:none;background-position:0 0;background-repeat:repeat-y;list-style:none outside none;margin:0;padding:1px 0 0}.ui-tree .ui-tree-toggler{cursor:pointer;display:inline-block;vertical-align:middle}.ui-tree .ui-treenode-icon{display:inline-block;vertical-align:middle}.ui-tree .ui-treenode-label{display:inline-block;vertical-align:middle;padding:0 3px}.ui-tree .ui-tree-selectable .ui-treenode-label,.ui-tree .ui-tree-selectable .ui-treenode-icon{cursor:pointer}.ui-tree .ui-treenode-label.ui-state-hover,.ui-tree .ui-treenode-label.ui-state-highlight{font-weight:normal;border:0 none}.ui-tree .ui-treenode-leaf-icon{width:16px;height:16px;display:inline-block}.ui-tree .ui-chkbox-box{cursor:pointer;width:15px;height:15px;float:left}.ui-tree .ui-chkbox{display:inline-block;zoom:1}.ui-tree-horizontal{width:auto;padding:10px 0;overflow:auto}.ui-tree.ui-tree-horizontal table,.ui-tree.ui-tree-horizontal tr,.ui-tree.ui-tree-horizontal td{border-collapse:collapse;margin:0;padding:0;vertical-align:middle}.ui-tree.ui-tree-horizontal .ui-tree-toggler,.ui-tree.ui-tree-horizontal .ui-treenode-icon{vertical-align:bottom}.ui-tree.ui-tree-horizontal .ui-treenode-label{outline:0 none}.ui-tree-horizontal .ui-treenode-content{font-weight:normal}.ui-tree-horizontal .ui-treenode-content.ui-tree-selectable{cursor:pointer}.ui-tree-horizontal .ui-treenode-parent .ui-treenode-content{font-weight:normal;white-space:nowrap}.ui-tree-horizontal .ui-treenode-parent .ui-treenode-content{padding:.4em 1em .4em .2em}.ui-tree-horizontal .ui-treenode-leaf .ui-treenode-content{padding:.4em 1em}.ui-tree.ui-tree-horizontal .ui-treenode{background:/*savepage-url=/ebok/javax.faces.resource/tree/images/line.gif.xhtml?ln=primefaces&v=7.0*/url() repeat-x scroll center center transparent;padding:5px 40px}.ui-tree.ui-tree-horizontal .ui-treenode.ui-treenode-leaf,.ui-tree.ui-tree-horizontal .ui-treenode.ui-treenode-collapsed{padding-right:0}.ui-tree.ui-tree-horizontal .ui-treenode-children{padding:0;margin:0}.ui-tree.ui-tree-horizontal .ui-treenode-connector{width:1px}.ui-tree.ui-tree-horizontal .ui-treenode-connector-table{height:100%;width:1px}.ui-tree.ui-tree-horizontal .ui-treenode-connector-line{background:/*savepage-url=/ebok/javax.faces.resource/tree/images/line.gif.xhtml?ln=primefaces&v=7.0*/url() repeat-y scroll 0 0 transparent;width:1px}.ui-tree.ui-tree-horizontal table{height:0}.ui-tree.ui-tree-horizontal .ui-chkbox{vertical-align:bottom;margin-right:3px}.ui-tree.ui-state-disabled .ui-tree-toggler,.ui-tree.ui-state-disabled .ui-tree-selectable .ui-treenode-label,.ui-tree.ui-state-disabled .ui-tree-selectable .ui-treenode-icon,.ui-tree.ui-state-disabled .ui-chkbox-box{cursor:default}.ui-tree.ui-tree-rtl{direction:rtl}.ui-tree.ui-tree-rtl .ui-treenode-children{padding:0 16px 0 0}.ui-tree-droppoint{list-style:none outside none;height:4px;margin:0;padding:0}.ui-tree-droppoint.ui-state-hover{border:0 none}.ui-treenode-content.ui-state-hover{font-weight:inherit}.ui-tree-draghelper.ui-state-highlight{background:none transparent}.ui-tree .ui-tree-scrollertop,.ui-tree .ui-tree-scrollerbottom{height:10px;width:100%;position:absolute}.ui-tree .ui-tree-scrollertop{top:0}.ui-tree .ui-tree-scrollerbottom{bottom:0}.ui-tree .ui-treenode-content .ui-chkbox.ui-selection{display:none}.ui-tree .ui-treenode-content.ui-tree-selectable .ui-chkbox.ui-selection{display:inline-block}.ui-tree.ui-tree-checkbox-all .ui-treenode-content .ui-chkbox.ui-selection{display:inline-block}.ui-tree .ui-treenode-outline{outline:1px dotted}.ui-tree-filter-container{margin:.4em .5em .1em;padding:0;position:relative}.ui-tree-filter-container .ui-icon{position:absolute;right:2px;top:5px}.ui-tree-filter.ui-inputfield{box-shadow:none;padding-left:2%;padding-right:12%;width:100%;box-sizing:border-box}.ui-fluid .ui-tree{width:100%}
.ui-treetable table{border-collapse:collapse;width:100%;table-layout:fixed}.ui-treetable .ui-treetable-header,.ui-treetable .ui-treetable-footer{text-align:center;padding:4px 10px}.ui-treetable .ui-treetable-header{border-bottom:0 none}.ui-treetable .ui-treetable-footer{border-top:0 none}.ui-treetable th,.ui-treetable tfoot td{text-align:center}.ui-treetable thead th,.ui-treetable tbody td,.ui-treetable tfoot td{padding:4px 10px;overflow:hidden;white-space:nowrap;border-width:1px;border-style:solid}.ui-treetable tbody td{border-color:inherit}.ui-treetable .ui-treetable-toggler{display:inline-block;vertical-align:middle;cursor:pointer;margin-top:-5px}.ui-treetable .ui-treetable-data tr.ui-state-highlight,.ui-treetable .ui-treetable-data tr.ui-state-hover{cursor:pointer}.ui-treetable-scrollable-body{overflow:auto}.ui-treetable-scrollable-header,.ui-treetable-scrollable-footer{overflow:hidden;border:0 none}.ui-treetable-scrollable .ui-treetable-scrollable-theadclone tr th>*{display:none}.ui-treetable.ui-treetable-scrollable table{table-layout:fixed}.ui-treetable-scrollable .ui-treetable-scrollable-header,.ui-treetable-scrollable .ui-treetable-scrollable-footer{position:relative}.ui-treetable .ui-treetable-data tr.ui-state-hover{border-color:inherit;font-weight:inherit}.ui-treetable-resizable{padding-bottom:1px;overflow:auto}.ui-treetable.ui-treetable-resizable table{table-layout:fixed}.ui-treetable .ui-column-resizer{width:8px;height:20px;padding:0;cursor:col-resize;background-image:/*savepage-url=/ebok/javax.faces.resource/spacer/dot_clear.gif.xhtml?ln=primefaces&v=7.0*/url();margin:-4px -10px -4px 0;float:right}.ui-treetable .ui-column-resizer-helper{width:1px;position:absolute;z-index:10;display:none}.ui-treetable .ui-chkbox{margin-right:3px}.ui-treetable .ui-treetable-indent{width:16px;height:16px;float:left}.ui-treetable-scrollable-body::-webkit-scrollbar{-webkit-appearance:none;width:15px;background-color:transparent}.ui-treetable-scrollable-body::-webkit-scrollbar-thumb{border-radius:8px;border:1px solid white;background-color:rgba(194,194,194,.5)}.ui-treetable .ui-sortable-column{cursor:pointer}.ui-treetable .ui-sortable-column-icon{display:inline-block;margin:-3px 0 -3px 2px}.ui-treetable .ui-chkbox.ui-selection{display:none}.ui-treetable .ui-treetable-selectable-node .ui-chkbox.ui-selection{display:inline-block}.ui-treetable.ui-treetable-checkbox-all .ui-chkbox.ui-selection{display:inline-block}.ui-treetable-scrollable-theadclone{height:0}.ui-treetable-scrollable-theadclone tr{height:0}.ui-treetable-scrollable-theadclone th.ui-state-default{height:0;border-bottom-width:0;border-top-width:0;padding-top:0;padding-bottom:0;outline:0 none}.ui-treetable-scrollable-theadclone th span{display:block;height:0}.ui-treetable .ui-column-filter{display:block;box-sizing:border-box;width:100%;margin:auto}.ui-treetable-reflow .ui-treetable-data td .ui-column-title{display:none}@media(max-width:640px){.ui-treetable-reflow thead th,.ui-treetable-reflow tfoot td{display:none}.ui-treetable-reflow .ui-treetable-data td{text-align:left;display:block;border:0 none;width:100%;-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;float:left;clear:left}.ui-treetable-reflow .ui-treetable-data.ui-widget-content{border:0 none}.ui-treetable-reflow .ui-treetable-data tr.ui-widget-content{border-left:0 none;border-right:0 none}.ui-treetable-reflow .ui-treetable-data td .ui-column-title{padding:.4em;min-width:30%;display:inline-block;margin:-.4em 1em -.4em -.4em}}.ui-treetable .ui-editable-column .ui-cell-editor{display:inline-block;vertical-align:middle}.ui-treetable .ui-editable-column .ui-treetable-toggler{margin-top:0}.ui-treetable .ui-cell-editor-input{display:none}.ui-treetable .ui-row-editing .ui-cell-editor .ui-cell-editor-output{display:none}.ui-treetable .ui-row-editing .ui-cell-editor .ui-cell-editor-input{display:block}.ui-treetable .ui-row-editor span{cursor:pointer}.ui-treetable .ui-row-editor .ui-row-editor-pencil{display:inline-block}.ui-treetable .ui-row-editing .ui-row-editor .ui-row-editor-pencil{display:none}.ui-treetable .ui-row-editor .ui-row-editor-check,.ui-treetable .ui-row-editor .ui-row-editor-close{display:none}.ui-treetable .ui-row-editing .ui-row-editor .ui-row-editor-check,.ui-treetable .ui-row-editing .ui-row-editor .ui-row-editor-close{display:inline-block}.ui-treetable .ui-treetable-data tr.ui-row-editing td.ui-editable-column,.ui-treetable .ui-treetable-data td.ui-cell-editing{padding:0;margin:0}.ui-treetable .ui-treetable-data tr.ui-row-editing td.ui-editable-column:first-child,.ui-treetable .ui-treetable-data td.ui-cell-editing:first-child{padding-left:10px}
.ui-wizard{margin:0;padding:0}.ui-wizard-content{margin:3px 0}.ui-wizard-navbar{text-align:right}.ui-wizard-nav-back,.ui-wizard-nav-next{cursor:pointer}.ui-wizard-nav-back{float:left}.ui-wizard-nav-next{float:right}.ui-wizard-step-title{font-size:18px;margin:0 3px 0 0;padding:.4em;float:left}
.ui-chips{box-shadow:none;cursor:pointer;display:inline-block;position:relative;width:auto}.ui-chips-container{padding:0;clear:left;cursor:text;list-style-type:none;margin:0;min-height:1px;overflow:hidden;width:400px}.ui-chips-token{cursor:default;display:inline-block;vertical-align:middle;overflow:hidden;padding:1px 3px;white-space:nowrap;position:relative;margin:2px}.ui-chips-token .ui-chips-token-label{display:block;padding:0 2.1em 0 .5em}.ui-chips-token .ui-chips-token-icon{cursor:pointer;margin-top:-9px;position:absolute;right:.2em;top:50%}.ui-chips-input-token{display:inline-block;vertical-align:middle;list-style-type:none;margin:1px;padding:0}.ui-chips-input-token input{background-color:transparent;border:0 none;margin:2px;outline:medium none;width:140px}.ui-fluid .ui-chips,.ui-fluid .ui-chips .ui-chips-container{width:100%}
.ui-sidebar{position:fixed;padding:.5em 1em;-webkit-transition:transform .3s;transition:transform .3s;-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box}.ui-sidebar-left{top:0;left:0;width:20em;height:100%;-webkit-transform:translateX(-100%);-ms-transform:translateX(-100%);transform:translateX(-100%)}.ui-sidebar-right{top:0;right:0;width:20em;height:100%;-webkit-transform:translateX(100%);-ms-transform:translateX(100%);transform:translateX(100%)}.ui-sidebar-top{top:0;left:0;width:100%;height:10em;-webkit-transform:translateY(-100%);-ms-transform:translateY(-100%);transform:translateY(-100%)}.ui-sidebar-bottom{bottom:0;left:0;width:100%;height:10em;-webkit-transform:translateY(100%);-ms-transform:translateY(100%);transform:translateY(100%)}.ui-sidebar-full{width:100%;height:100%;left:0;-webkit-transition:transform 0s;transition:transform 0s}.ui-sidebar-left.ui-sidebar-active,.ui-sidebar-right.ui-sidebar-active{-webkit-transform:translateX(0);-ms-transform:translateX(0);transform:translateX(0)}.ui-sidebar-left.ui-sidebar-sm,.ui-sidebar-right.ui-sidebar-sm{width:20em}.ui-sidebar-left.ui-sidebar-md,.ui-sidebar-right.ui-sidebar-md{width:40em}.ui-sidebar-left.ui-sidebar-lg,.ui-sidebar-right.ui-sidebar-lg{width:60em}.ui-sidebar-top.ui-sidebar-active,.ui-sidebar-bottom.ui-sidebar-active{-webkit-transform:translateY(0);-ms-transform:translateY(0);transform:translateY(0)}.ui-sidebar-top.ui-sidebar-sm,.ui-sidebar-bottom.ui-sidebar-sm{height:10em}.ui-sidebar-top.ui-sidebar-md,.ui-sidebar-bottom.ui-sidebar-md{height:20em}.ui-sidebar-top.ui-sidebar-lg,.ui-sidebar-bottom.ui-sidebar-lg{height:30em}.ui-sidebar-mask{position:fixed;width:100%;height:100%}.ui-sidebar-close{float:right;padding:1px}.ui-sidebar-close:hover,.ui-sidebar-close:focus{padding:0}@media screen and (max-width:64em){.ui-sidebar-left.ui-sidebar-lg,.ui-sidebar-left.ui-sidebar-md,.ui-sidebar-right.ui-sidebar-lg,.ui-sidebar-right.ui-sidebar-md{width:20em}}
.ui-dataview .ui-dataview-header{border-bottom:0 none}.ui-dataview .ui-dataview-header,.ui-dataview .ui-dataview-footer{text-align:center;padding:4px 10px}.ui-dataview .ui-dataview-header .ui-dataview-layout-options{float:right}.ui-dataview-list .ui-dataview-content{padding:4px 10px}.ui-dataview-list .ui-dataview-list-container{list-style-type:none;margin:0;padding:0}.ui-dataview-list .ui-dataview-row{border:0 none}.ui-fluid .ui-dataview-layout-options.ui-buttonset{width:auto}
.p-datepicker{position:relative;display:inline-block;width:auto;min-width:17em}.p-datepicker-panel .ui-datepicker-header .ui-datepicker-next,.p-datepicker-panel .ui-datepicker-header .ui-datepicker-prev,.p-datepicker-panel table td>a,.p-datepicker-panel .ui-timepicker>div a{cursor:pointer}.p-datepicker-panel .ui-datepicker-calendar-container td span,.p-datepicker-panel .ui-datepicker-calendar-container td a{text-align:center}.p-datepicker-panel .ui-datepicker-calendar-container td.ui-datepicker-other-month-hidden{visibility:hidden}.p-datepicker-panel .ui-timepicker{text-align:center;padding:.5em}.p-datepicker-panel .ui-timepicker>div{display:inline-block;margin-left:.5em;min-width:1.5em}.p-datepicker-panel .ui-timepicker>.ui-minute-picker,.p-datepicker-panel .ui-timepicker>.ui-second-picker{margin-left:0}.p-datepicker-panel .ui-timepicker>div a{display:block}.p-datepicker-panel .ui-timepicker>.ui-separator{margin-left:0;min-width:.75em}.p-datepicker-panel .ui-timepicker>.ui-separator a{visibility:hidden;opacity:0}.ui-datepicker-multiple-month .ui-datepicker-group{display:table-cell;border-left-width:0;border-top-width:0;border-bottom-width:0}.p-datepicker-panel.ui-datepicker-multiple-month{width:auto}.p-datepicker .ui-datepicker-touch-ui,.ui-datepicker-touch-ui{position:fixed;top:50%;left:50%;min-width:80vw;width:auto;-webkit-transform:translate(-50%,-50%);-ms-transform:translate(-50%,-50%);transform:translate(-50%,-50%)}.ui-datepicker-touch-ui.ui-datepicker td a,.ui-datepicker-touch-ui.ui-datepicker td span,.ui-datepicker-touch-ui.ui-datepicker th{padding:2em 0}.ui-monthpicker .ui-monthpicker-month{width:33.3%;display:inline-block;text-align:center;padding:.5em;cursor:pointer}.p-datepicker-panel .ui-datepicker-buttonbar .ui-g-6{text-align:center}
</style><script data-savepage-type="text/javascript" type="text/plain" data-savepage-src="/ebok/javax.faces.resource/components.js.xhtml?ln=primefaces&amp;v=7.0"></script><script data-savepage-type="text/javascript" type="text/plain" data-savepage-src="/ebok/javax.faces.resource/jsf.js.xhtml?ln=javax.faces&amp;stage=Development"></script><script data-savepage-type="text/javascript" type="text/plain" data-savepage-src="/ebok/javax.faces.resource/inputnumber/inputnumber.js.xhtml?ln=primefaces&amp;v=7.0"></script><style data-savepage-href="/ebok/javax.faces.resource/inputnumber/inputnumber.css.xhtml?ln=primefaces&amp;v=7.0" type="text/css">.ui-inputnumber>.ui-inputtext::-ms-clear{display:none}</style><style data-savepage-href="/ebok/javax.faces.resource/fileupload/fileupload.css.xhtml?ln=primefaces&amp;v=7.0" type="text/css">.ui-fileupload-buttonbar .ui-fileupload-choose input{position:absolute;top:0;right:0;margin:0;opacity:0;filter:alpha(opacity=0);font-size:inherit;direction:ltr;cursor:pointer}.ui-fileupload-buttonbar .ui-fileupload-choose.ui-state-disabled input{cursor:default}.ui-fileupload-choose{position:relative;overflow:hidden;outline:0}.ui-fileupload-buttonbar{padding:.2em .4em}.ui-fileupload-buttonbar .ui-button{vertical-align:middle;margin-right:.2em}.ui-fileupload-content{padding:.2em .4em;border-top-width:0}.ui-fileupload-content .ui-progressbar{width:200px;height:20px;margin:0;top:5px}.ui-fileupload-content .ui-progressbar .ui-progressbar-value{height:100%}.ui-fileupload-content .ui-progressbar-value-legacy{background:/*savepage-url=/ebok/javax.faces.resource/fileupload/ie-anim.gif.xhtml?ln=primefaces&v=7.0*/url() repeat-x}.ui-fileupload-files{margin:10px 0;border-collapse:collapse;display:table;border-spacing:2px}.ui-fileupload-files>div{display:table-row-group;vertical-align:middle}.ui-fileupload-row{display:table-row}.ui-fileupload-row>div{display:table-cell;padding:4px 10px}.ui-fileupload-row>.ui-widget-content{display:none}.ui-fileupload-files img{border:0}.ui-state-disabled .ui-state-disabled{opacity:1;filter:alpha(opacity=100)}.ui-state-disabled input{cursor:default}.ui-fileupload-simple{position:relative;overflow:hidden;display:inline-block;vertical-align:middle}.ui-fileupload-simple .ui-button{overflow:hidden}.ui-fileupload-simple input[type=file]{position:absolute;top:0;right:0;min-width:100%;min-height:100%;font-size:100px;text-align:right;filter:alpha(opacity=0);opacity:0;outline:0;background:white;cursor:inherit;display:block}.ui-fileupload-simple .ui-fileupload-filename{margin-left:.5em}.ui-fluid .ui-fileupload .ui-button{width:auto}.ui-fluid .ui-fileupload-content .ui-button-icon-only{width:2.4em}.ui-fileupload-icon-only .ui-button-text{padding-left:1em}@media screen and (max-width:40em){.ui-fileupload-content{padding:.55em .4em}.ui-fileupload-files,.ui-fileupload-files>div,.ui-fileupload-row,.ui-fileupload-row>div{display:block}.ui-fileupload-buttonbar .ui-button{padding:.9em 1em .9em 1.2em}.ui-fileupload-buttonbar .ui-button .ui-button-text{display:none}.ui-fileupload-row>.ui-widget-content{display:block;padding:0 10px;margin-top:5px;margin-bottom:5px;border-bottom:0}}</style><script data-savepage-type="text/javascript" type="text/plain" data-savepage-src="/ebok/javax.faces.resource/fileupload/fileupload.js.xhtml?ln=primefaces&amp;v=7.0"></script><script data-savepage-type="text/javascript" type="text/plain"></script>
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<meta name="format-detection" content="telephone=no"> 
		<meta name="description" content="Nie odkładaj ważnych spraw na bok – załatw je od ręki w PGE eBOK. Sprawdzaj zużycie, dokonaj płatności, aktywuj PGE eFaktura, aktualizuj swoje dane, skorzystaj z nowej oferty. Nie masz jeszcze konta? Zarejestruj się już dziś na ebok.gkpge.pl">
		<meta name="keywords" content="PGE, Polska Grupa Energetyczna, GK PGE, Grupa Kapitałowa PGE, Grupa Kapitałowa Polska Grupa Energetyczna, PGE Obrót, mBOK, eBOK, energia, rachunki, faktura, prąd, płatności, opłaty, zapewniamy energię, światło, licznik, licznik przedpłatowy, reklamacja, reklamacje, skarga, skargi, elektroniczne biuro obsługi klienta, mobilne biuro obsługi klienta, oferta PGE, oferta Polska Grupa Energetyczna, produkty Polska Grupa Energetyczna, prąd jak prąd, PGE eBOK, eBOK PGE, nowy PGE eBOK, nowy eBOK, mBOK PGE, PGE mBOK">
		<title _msttexthash="1621022" _msthash="0">PGE eBOK - PGE's electronic Customer Service Office</title>
		<link rel="shortcut icon" type="image/x-icon" data-savepage-href="/ebok/resources/images/favicon.ico" href="data:text/html;base64,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"><script data-savepage-type="text/javascript" type="text/plain" data-savepage-src="/ebok/javax.faces.resource/custom.js.xhtml?ln=js"></script><!--[if lte IE 8]><link rel="stylesheet" href="/ebok/javax.faces.resource/ie8.css.xhtml?ln=css" /><![endif]--><!--[if lte IE 9]><link rel="stylesheet" href="/ebok/javax.faces.resource/ie9.css.xhtml?ln=css" /><![endif]-->
	    
		
	    
		
		<style>
			@font-face{
				font-family:icon;
				src:/*savepage-url=/ebok/javax.faces.resource/icons.woff.xhtml?ln=images*/url();
				font-weight:400;
				font-style:normal;
			}
		</style><style>@keyframes slide-in-one-tap {
  from {
    transform: translateY(80px);
  }
  to {
    transform: translateY(0px);
  }
}

.trust-hide-gracefully {
  opacity: 0;
}

.trust-wallet-one-tap .hidden {
    display: none;
  }

.trust-wallet-one-tap .semibold {
    font-weight: 500;
  }

.trust-wallet-one-tap .binance-plex {
    font-family: 'Binance';
  }

.trust-wallet-one-tap .rounded-full {
    border-radius: 50%;
  }

.trust-wallet-one-tap .flex {
    display: flex;
  }

.trust-wallet-one-tap .flex-col {
    flex-direction: column;
  }

.trust-wallet-one-tap .items-center {
    align-items: center;
  }

.trust-wallet-one-tap .space-between {
    justify-content: space-between;
  }

.trust-wallet-one-tap .justify-center {
    justify-content: center;
  }

.trust-wallet-one-tap .w-full {
    width: 100%;
  }

.trust-wallet-one-tap .box {
    transition: all 0.5s cubic-bezier(0, 0, 0, 1.43);
    animation: slide-in-one-tap 0.5s cubic-bezier(0, 0, 0, 1.43);
    width: 384px;
    border-radius: 15px;
    background: #fff;
    box-shadow: 0px 2px 4px 0px rgba(0, 0, 0, 0.25);
    position: fixed;
    right: 30px;
    bottom: 30px;
    z-index: 1020;
  }

.trust-wallet-one-tap .header {
    gap: 15px;
    border-bottom: 1px solid #e6e6e6;
    padding: 10px 18px;
  }

.trust-wallet-one-tap .header .left-items {
      gap: 15px;
    }

.trust-wallet-one-tap .header .title {
      color: #1e2329;
      font-size: 18px;
      font-weight: 600;
      line-height: 28px;
    }

.trust-wallet-one-tap .header .subtitle {
      color: #474d57;
      font-size: 14px;
      line-height: 20px;
    }

.trust-wallet-one-tap .header .close {
      color: #1e2329;
      cursor: pointer;
    }

.trust-wallet-one-tap .body {
    padding: 9px 18px;
    gap: 10px;
  }

.trust-wallet-one-tap .body .right-items {
      gap: 10px;
      width: 100%;
    }

.trust-wallet-one-tap .body .right-items .wallet-title {
        color: #1e2329;
        font-size: 16px;
        font-weight: 600;
        line-height: 20px;
      }

.trust-wallet-one-tap .body .right-items .wallet-subtitle {
        color: #474d57;
        font-size: 14px;
        line-height: 20px;
      }

.trust-wallet-one-tap .connect-indicator {
    gap: 15px;
    padding: 8px 0;
  }

.trust-wallet-one-tap .connect-indicator .flow-icon {
      color: #474d57;
    }

.trust-wallet-one-tap .loading-color {
    color: #fff;
  }

.trust-wallet-one-tap .button {
    border-radius: 50px;
    outline: 2px solid transparent;
    outline-offset: 2px;
    background-color: rgb(5, 0, 255);
    border-color: rgb(229, 231, 235);
    cursor: pointer;
    text-align: center;
    height: 45px;
  }

.trust-wallet-one-tap .button .button-text {
      color: #fff;
      font-size: 16px;
      font-weight: 600;
      line-height: 20px;
    }

.trust-wallet-one-tap .footer {
    margin: 20px 30px;
  }

.trust-wallet-one-tap .check-icon {
    color: #fff;
  }

@font-face {
  font-family: 'Binance';
  src: /*savepage-url=chrome-extension://egjidjbpglichdcondbcbdnbeeppgdph/fonts/BinancePlex-Regular.otf*/ url() format('opentype');
  font-weight: 400;
  font-style: normal;
}

@font-face {
  font-family: 'Binance';
  src: /*savepage-url=chrome-extension://egjidjbpglichdcondbcbdnbeeppgdph/fonts/BinancePlex-Medium.otf*/ url() format('opentype');
  font-weight: 500;
  font-style: normal;
}

@font-face {
  font-family: 'Binance';
  src: /*savepage-url=chrome-extension://egjidjbpglichdcondbcbdnbeeppgdph/fonts/BinancePlex-SemiBold.otf*/ url() format('opentype');
  font-weight: 600;
  font-style: normal;
}
</style>
<style id="savepage-cssvariables">
  :root {
    --savepage-url-14: url(data:image/jpeg;base64,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);
    --savepage-url-15: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAWBAMAAAA2mnEIAAAAHlBMVEUAAACalqKalqKalqKalqKalqKalqKalqKalqKalqKrGzzRAAAACnRSTlMA/U7KRbkmvE0lRe/PnAAAAF5JREFUGNNjIAqwBTsASRbTCUCSVVAISCoKBgBJZkFBBQYmQUEDkKygoBBQWBCkEkQrgfhAAJIXBKljgEiAheESClA2BxK7EaEGoRdhJqpdCDeguY2tGOxm8wSifAgAefkKr8CSKkgAAAAASUVORK5CYII=);
    --savepage-url-18: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABcAAAAXCAMAAADX9CSSAAAAYFBMVEUAAACalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqLcJ3InAAAAH3RSTlMAmM8GSUPv1AKUj934t2phVxLltKKDKSHo59bItqpPa6nLmwAAANhJREFUKM99kkmWwyAQQ6vAmMF2bCfppGfd/5YNauplWOQvQK8QIAb5J4XsRowuhyR3DBFGHMTwCmAq67aWCYD6Xl4AZ67BAYunVCBT+dSaAigdvd++5/ff7quzU4TzHK7MlzbDISYJQGiuMxpvTbKkmKTxw3qhnpDFdf3BuqMutR9xsFS2jhwwCrBR7yOAo6fegOpfpZuYz/wOWcjKuq1veS46t/z5KpXP6g3NdT3BOO/Mz/PuR9yIPC8v4Av3nPo+imfU7v+Rxdt7Pbr9y/clKSj/g9p/+AMklxuK2zWwwgAAAABJRU5ErkJggg==);
    --savepage-url-19: url(data:image/png;base64,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);
    --savepage-url-20: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABkAAAAZCAMAAADzN3VRAAAAe1BMVEUAAACalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqJNGbbWAAAAKHRSTlMA5gjd9bqe6y0mZUES2MmQiBgN+bGqdlFJG+/Ow5Z/bjgxWdTQXR+jZEmd5gAAAVBJREFUKM9lkYmSnDAMRGUM5obhGI4ZWJhjJ+//vzC2SajapKsoS2qpJSE5keiO8N7ITwT2q0HD5r0TU2T2JGZoVl7pdI2Sv8QzhDBGBZKGKEDlfyo6+h6q0dpZCWZBPTzTEwWSj4d6Me7SlKzeuVCdgxysZvPGrHi6cPYrMt8u8MX9yGkUNjBHOJjAMy6ergrdilwJv8YaapFPiL40EoHORHK6yc3GLbVFCozcuBQ2NNCLQ+l7zsYKEjZHV+OZisw9O9rWGLfWk9hlJF3n9s97KukhHkTaF8veTtptLXXoJim2N8p2Gm84aCuQwpK1YtO1186jGHVN/E9ZxCNVTMft8tS/G2XhjZXonzuWDN64UhVBNsyHwDAGqab2zh5zryDeXIsQlpL3RzxyBbrk1sqj4x3D6zx3Yi5zoagfVjhIVjPLD1wghG/5Hx+/T3v6vwFX5R8VaUGV8QAAAABJRU5ErkJggg==);
    --savepage-url-21: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADkAAAA5CAYAAACMGIOFAAAABHNCSVQICAgIfAhkiAAABHBJREFUaIHtW01rG0cYfnZW0pqVlw2rSEKxZQmzWowT7GuOJb751FN0aKH0WEqhx9J/kB/giy49tZCeWgqGHPwjAolxl+BAAzV2CpKsRuhrNT141tWuVl+7s2NF7QPvQZrZmeeZGc28O+8r4H+EAyEkV6vVaLVapfv7+1TTNCrLMgVwa7IsU03TqGVZtFqt0lqtRgkhuTumPh2yLG+Zpnmk63odI2IWNV3X66ZpHsmyvHUHMoKhadqTYrH4GhGETbJisfha07QnQgWNQlGUvUKh8HYeslGtUCi8VRRlLyxXKcQzqmVZP9i2/XRWxXQ6/Xc2mz1PpVKv+v3+m8Fg8KHT6TxrNBro9/sAAEIIhsPhXB1blvWzbdtfAmiH4D0fFEXZS6fTLUwZ9Xw+/65UKn1PCHngf16SpPvlcjnSrKbT6VaUWZ2KTCbzVJKkwI4lSaKVSuVFIpEwp7WxiMhJfbllmUxm5kpaCJubm99O6rBcLr+cdyfkMZOjxnjFJ1CWZSebzX6+SFu8RYKHULYkxho2DON9mHMsishpyzf00k0mkztBDW9sbPwOQA3TpiRJRtSZDOIkSRJNJpM7i/JRgzwXdugnwghkIrkvV9cY3/kH37Ks5/5GDMN4v1AjMYqctHQZ79lgZ9DYJsPDl+SxXGcJDTpDif8LwzB+DfjuC8dx/ogqMqi/sKCUQpLGHbYg/h6sr69/At/IlMvll7yIxfmbHDWmIxhs5/QsCZ6vPKJEsg1yHEyMp3KlUnnBS6BIkbjZR8YnxzTNI3/FWb7oMotkerzwn4v5fP4dT4Fxi/TvtkwPALbbEUIeNJvNe6OEFEUZH4klhn+nbTab9zx3RrVabWxk4rhUErlcAVCm62YmT05OPGRUVW0Ph8Mr3iJF4/j4GAATeXZ25inM5XJvxFPij9PTUwBM5Pn5uacwlUq9Ek+JPy4uLgAwke22916o2+0GH6YfGTqdDgAm0nEcT2Gv1/tLPCX+GAwGACY4zIPBIL4rP4GglAKYIDKRSER6b1wWuGcnAQBZlj2FqVTqvnhK0eF3CBKJm0sMAgCq6p04RVEeCuLFFe7ydLG2tgaAidze3vYU9nq9R4J4xYpCoQCAidzZ8V50XV1dcX37uCvs7u4CYCIPDg48he12W136gOgcODw8/PcDC854nNutra3veHcq2kF3J4oAwHA4/FPX9cYooW63+zVvkSKh63rDfcm4PSez2exPo5UuLy83ed8MiIRfD4D/yB0PsLq3dR637vr6+qvRz5RSFIvF33iJFIVGo/HN1ApByQ6LxiEnQcRMMv7TEXMsJHaRc+cTLHtUa5LNHdViWP34JBBbpDkWkWEjzQCWK2dgmkVOd+Gc/cEtCOta7GkuwIrk8bgQnZE1zWLJyHLBI7euVCpFEhgmty5sluSPtm1/OquiP0vScZwPrVbrWb1en/VoICzL+sW27c8QZ5bkKFRVfSwy31VV1cdChAVhpTOX/VjpHPQgBP2bIJlM3oa8mYfy8f2bYJnxD1aurVEra/PHAAAAAElFTkSuQmCC);
    --savepage-url-22: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABkAAAAZCAMAAADzN3VRAAAAbFBMVEUAAACalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqJ4mW3cAAAAI3RSTlMA83MGiT9UOe3msSSEfGNMFNnRyLapliwarZ+ObDDdv1sNNajp41UAAADwSURBVCjPbdLpdoMgEIbhIdSNGPctara+93+PBVusmnx/4PjMsHiQ/9ySOJCPmSEV0bKLniORE3yJ5G20ge+azEuGSte+MIbQyxMwxS/kCuJ1teEKNEtXUcI9Ei/LyOQmHSRn8eIpsLcActmJtNBqSaGRg/RALzWER9EGnhKj+q346SSKcniTEK5Wqr97ZXDZizuzyzC2duaLRinh/d93rn2E9AhF4spziM8HOUH1El2D0TuIFGR2DIBuS7c7PJYPKWDWBXWYgIrWk6AuwaDl1YcGULmvu+BSPpo6BqiCzZ4GH9td7B5PMFXKJmlmv+MPtD0ZoFLucM0AAAAASUVORK5CYII=);
    --savepage-url-23: url(data:image/png;base64,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);
    --savepage-url-24: url(data:image/png;base64,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);
    --savepage-url-25: url(data:image/png;base64,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);
    --savepage-url-26: url(data:image/png;base64,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);
    --savepage-url-27: url(data:image/svg+xml;base64,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);
    --savepage-url-28: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAWCAMAAADzapwJAAAAP1BMVEUAAACalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqKalqK9dNbhAAAAFHRSTlMA2RsH73jjFQ7Ls2s100wh5s5uSlbU9YoAAACySURBVBjTfZHhDoMgDIRLhSIIA/Xe/1lHUedi2BrCjy+9K+XoqHmJAmviMtNdk7M4y7rpoiUDwSXPyQUgl4OyoL6ulleFcHcIWPk25BVBfRzE01d5gWu3hTrMU1fO6gPraUFQag0TsbHKAxaK2LTNwDC3S0UbIgmSyhW102cnCAGeTn5S8gBZ8BNzw2ZsEuGeIx3irweO1xkvrx35+VW5K0tF3S+6V0gZx/AvtDtiyCfiN7NBCwNtpiJAAAAAAElFTkSuQmCC);
    --savepage-url-29: url(data:image/svg+xml;base64,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);
    --savepage-url-30: url(data:image/png;base64,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);
    --savepage-url-31: url(data:image/png;base64,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);
    --savepage-url-34: url(data:image/png;base64,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);
    --savepage-url-39: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAQAAAADwCAYAAADvl7rLAAAACXBIWXMAAAsTAAALEwEAmpwYAAAE7mlUWHRYTUw6Y29tLmFkb2JlLnhtcAAAAAAAPD94cGFja2V0IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4gPHg6eG1wbWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgOS4wLWMwMDEgNzkuYzAyMDRiMiwgMjAyMy8wMi8wOS0wNjoyNjoxNCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczpkYz0iaHR0cDovL3B1cmwub3JnL2RjL2VsZW1lbnRzLzEuMS8iIHhtbG5zOnBob3Rvc2hvcD0iaHR0cDovL25zLmFkb2JlLmNvbS9waG90b3Nob3AvMS4wLyIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0RXZ0PSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VFdmVudCMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIDI0LjQgKFdpbmRvd3MpIiB4bXA6Q3JlYXRlRGF0ZT0iMjAyMy0wNC0yOFQwOTozNzo0MCswMjowMCIgeG1wOk1vZGlmeURhdGU9IjIwMjMtMDQtMjhUMDk6NDM6MDYrMDI6MDAiIHhtcDpNZXRhZGF0YURhdGU9IjIwMjMtMDQtMjhUMDk6NDM6MDYrMDI6MDAiIGRjOmZvcm1hdD0iaW1hZ2UvcG5nIiBwaG90b3Nob3A6Q29sb3JNb2RlPSIzIiB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOmI4NTY3ZTM2LTY4NTktZWY0YS1hNjY3LTc4YzYzOGZmMTNkYSIgeG1wTU06RG9jdW1lbnRJRD0ieG1wLmRpZDpiODU2N2UzNi02ODU5LWVmNGEtYTY2Ny03OGM2MzhmZjEzZGEiIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDpiODU2N2UzNi02ODU5LWVmNGEtYTY2Ny03OGM2MzhmZjEzZGEiPiA8eG1wTU06SGlzdG9yeT4gPHJkZjpTZXE+IDxyZGY6bGkgc3RFdnQ6YWN0aW9uPSJjcmVhdGVkIiBzdEV2dDppbnN0YW5jZUlEPSJ4bXAuaWlkOmI4NTY3ZTM2LTY4NTktZWY0YS1hNjY3LTc4YzYzOGZmMTNkYSIgc3RFdnQ6d2hlbj0iMjAyMy0wNC0yOFQwOTozNzo0MCswMjowMCIgc3RFdnQ6c29mdHdhcmVBZ2VudD0iQWRvYmUgUGhvdG9zaG9wIDI0LjQgKFdpbmRvd3MpIi8+IDwvcmRmOlNlcT4gPC94bXBNTTpIaXN0b3J5PiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PoFL13EAABtQSURBVHja7V17jF7HVb8J/qMLGNlp1dpYVe1UImqlxoldoJVKZUPfkahNKZUQitax6ELTqjHIEgKaKi6UPyKo+0hhK8W1WoEUCjggpYU+wAqVwsvPVG0TVJIgOU4jqFekYgMyWc7sznyenZ3HmZlzX9/3+0lXs3vvd+6dOzPnN2fmzplz3crKSgMAwGziOhAAAIAAAAAAAQDANew4urCNkst0bL907+IzKBEQADB7ym8AEgABdN4IV2a94RlFpDK4rifl327/zakLN8+oxxESQI35pyt8HUoasHWf4sZj7pHzfPe5tkJw71Py3Jgi5t6npg5q3t/3W4l6BDokgFrzT5AAtuX2PkIEUNUDShBA7btL1YFEniXqEeiIACQaf1uKUGNFFPSgIiRY8d4rfZa7dJ5r6xHojgCqzV+phljac7RggXTeA0tZABJDL24bgAUwRXMA0r1Cl3MAfZi/beRBYg5AgnhzlBdzACAAaSXCV4COvwLUDoHwFQAEAEwR+UB5QQAAAIAAAAAAAQAAAAIAAAAEAAAACAAAABAAAAAgAAAAQABVwAqyQawExCKgWSSA2gYgtBZeYj+AbAXy5T33HSTIq8f9AKp3A7LLHUQ+MgKQbABCBFCdhwpPvKYkDwLuvOvyIEAAnXlTuuUOZ6AREYBE42+rEdcocV/7AVSUXfG7SzxfYOjWeAgAewGMgACqzd+WzNhsbzTBvEvsB5BLIFLk2eteBrAARjoH0MaEUleNGPsB1M1BYA4ABDAIoOHgKwAwwwQAAAAIAAAAEAAAACAAAABAAAAAgAAAAAABAAAAAgAAAAQAyEEtxprF9ftDWE3aRflHCWBWKx9lsFEJBIKcdqZA0+R81BsB1BZirTdbTQFIFprUvbp+DwlvQrOO305r8pK7J4MdWqxkP4e+6i0k21UbyHluaD+AXitfuhAkK7Gr59cSj5QSSOQjtw35flsiL1WGUh1YzTuUll9KrtUhQGnmQ9dqe7E+CKBU+WvLQFIJuiz32Lt32QZKFTCU/9I8lLy3nedUGbZGAFI9sJQp3LUJXNsDS5aZhBKXkLjku/dlhQ6lHtp6ZisEMIQxuMQcRI0JKPX8Psuxpgfqy3RuYy6rzzmAtp+LrwAdKiHeH+9fMxRqIx9YBwAAMwwQAACAAAAAAAEAAAACAAAABAAAAAgAAAAQAAAAs0EATmSYmQ0MIelVNsJ3F2kDUl6hXT6Ps4Z+WtofNzjoqBqA5PJZqTx3uaJMwBW4tTbAdKjZEA2JGyVqSHsBuHnuyp/EWUYdjSzFDg7ap1tlX5Uv6VJbqwA9lLdIG8glo1A8RG6cSMF9KKotIDfPXRMAJ7ZkckMQycYv0Ig6JQGpvQxKlL+y8YptxiKVD65HYcodOJUfnytslxaQhDtwLQGLuAO30fglGkBuAdb4xEu4EpdUnsT71ypB6fvXPruWACTaQY0CChFA1RBsEATQVgMoVSSJPPT57IrerNqluSb/UiHRpULFd72nQ+kQoGYI0vsQoK2xeE3lZ1Z8NQNLK0DHcxAiPWDt+LtkErCNzqiSAIonAWvqu3gSUPLlhRtwZ8wvwcASz5ZsLBW9T9UYeCAz8b1YAFJ5brMssRAIECdAYDwAAQAACAAAABAAAAAgAAAAQAAAAIAAAAAAAQBAD0Bsih4IQGohSum3ZMGIvOsWtKAh5SvfEMquy6hGM08AUktRS1eTtaH89rromgi1Y+zFJHzKc99BKiy2e67L588yAYTGBFXLYbmVGAoMWfr8IcTkK+mJJPJQG5q6JE+h9+2KQGryDgJokt5o2UtCcxXR5/hT4gxU0/OVEFesMZaEmJbowaQbfep+qfflEkjNu4MAWhoC1CpUpSNKkRkoaQFIRont6vnSYdlLCayGAKTyXBrmfeYIwFZCqUZYYP4GSaB0Q5Eux8DSk1i57yHR6PsywyV6cF/eayy5mSOAmFIyFXCyAULp0CE1LMgkj+rnV27MKDqeb3PuoXYCrg0C6ZrAQACVDdBpQNWupLmTgENxZZXcV7HrOQAp0pIgISjuAAgAmD2g1wQBAAAAAgAAAAQAAAAIAAAAEAAAACAAAABAAFOKHUcXtlByBZ/DgJkjAEk/bKlQYR2H+Joq5a+JrgPMGAG0EU6pwqFoVRF7IACf/FaSXypVwIGszAMJAO1ZADFXUI5Lqa2olvJv5fTGNsmUeNXZvb7PAuDmP2T9lBBgaX3EXLsxpAG8BBByYpEkA24jt5Vf9bq53mSFBOAS1zoSyHWJLSnDnPDOHtmJ0xYIAMgiAMnY7DVmqq0wuSa3NAHU9MLSPvyMvEW3c8MQABiVBSBEILk9aJSA2rQAYvnN3Y4rdA8oPzD4OYCajUja2FHGHoKkLJLaOYDaiUKY/IAIAfT1FaCNmfvM/Jt5B3EFqt1SiyEnsqMzAAKosgB8SjPWDR5K5iF6zq9ITAcABDDzGJvyAwAIAAAAEAAAACAAAABAAAAAgAAAAAABDB07ji7soeSMc3rvpXsXz44k/5so2eScvkr5v4raHSgBUKUdoOSUde00HR+nSnuw48bzEUp+2z3f1Xdt/envM3S8N/CTVhUxoPxZz/bcozPyUMqvFJ3Sm+nfC/r0bjp30VyrKAP2e9A9bqTkO9apV5Lsv2W8R7Z87TP1PX4+dp3u92cV77BBl2wCUH8coeO8vrbFIYSoMnoIROFgLoEEluIu0LFY6cfPIhKSnafkYkQJD9E9ThYob7IR18rHyjCj7LyNhtuoSf5FlPyYVv45fXpZkQAdj5Ps87ltIOc9pBzaSlaUSoVU039uaPO19ehbiu8SwH7r9+cjBbgUyDiHQE6T/P4CAmi4JKBl5jyXlpmVGLMAYgRg70Xwo06ZPZ1aCq2v741ZAOpamyG2I2XHKkNNAMv6Hj+oT+/U7zSXQwCUnrHKb2+XkYrcfSVyCCBHpg0CSJF4jAC2Or+9kmEB2ATybTqezyGQSANcLmTvzZ5Lz7VsAajnHlTE53NoCl3zNPzgHEDKXdhtgIWNWJXdc57Lm1NlaBHAi+n4ETqup0OR4d8XEMBLrXd4NseXQrr3z+3RS+9RSwAe5f8ZOr6WQwBXSkwoiwCM8l8pMcMCRDQhpIwKfJnn0nc7sAB20PETtqJbyv9P6tU5/v4OCUzMfg4BeOpx8j/z/V8W+cl3GQRghgBv16e/lDkEOKN7/BdZ7eV5c55Z/8aSWpdOMwF4lP/ddPy31sevdUEA2znKzyCA7dYp1YO8oP++nFGBu6xTT3Q0B2AIoDEkYOZCtPI3OQRgKf2eTAJwhxGT/5kE8Ao6nnIuvUKnTyUa4Q10/XuBScDVa22P4SUJwGdN5RJAzj18BEDnfpHSP8ncT0LJ/y8d36fjC9b5/XSP020SwOWaCtT3eWXg8ncyKvAm69RjOk2aoEIWgPLIe0aTQKOV35y7xBwCbJDnDgEECOCmyE8eizxfveNLteLv0kMAQ+LntBXwbGxDkggBJIdAzj3eRcefu2mBBTBnD0MLLQD2PQIEwN1Lw7UAVu8RUv5eCIBZea8JXH60woSbM6ZkyxbAXq28PmyL9UJC8sbisCdgJ/8XjCF36/RC6iuA0+uHsGoNdGABSBFAr0OAgncPTQBuUP5SAoh9xlqpqTh9D+86AI3foXt8qIPZ31ILoNfPgJHGM/m/YHMXYz1wvoOzVpXVbm3WwSSg6gQ+m1P3UveoJYAACXiVfx0BAOuUUOHmwE8ujmVFnhAZNk3BgpYB5T27956SujMkEFR+EAAAzDhAAAAAAgAAAAQAAAAIAAAAEAAAAD1ix9GF31XppXsXf6tzAnACZHS6NbbruFLqWSWcJ/ONnuOO+1pK/tlz6cdJ9l8SsgeagBu2RtTFmuTV+oXFiPwCyX+G8b6hBSWsT4J9y1v3+T1KfqO0/ZD8Pi17uuP29sPNNYeszfT871fca9787a5B8BKApfzG8eIMhwRI7u+aNQcQ24PvWLO2EktV6KkMZ5wzVkNe0Hl5L2MVnDhRuAt0Eiu51im/J0pvlASchSAuFhnPl/aH322dvjAW+UhnMp9azKOVXrVle2Gc+Tv6Xd3pOFfJ1iFlVmdKMsp78g3636+TzE9VKL+9IOlQs+aS/6SXABzln3ijcUiAsxy4dkMHri+8vs+ddNxnpWq/go9lNqA9eg266ZmjFoAvDmBubMAaBbbe/x8p/UlKz1F6K6WPUPr6TJda48Rj7rm61DdX3jqXLU+H6u3VLkKbdCdyIWM5rt34D+n0s222QY/shhV9kU4sZb2xLTjHmlTv/qDW63UrEb3RgRv/phRJbypBAih2B7Ya6+vo36ebNddU5aKsGt836NjD3aXI6vlXzW7bK2/IBEDJ39Lx03R8mY63WKnqufZlKqC9tn93gQLb8srH49FM+ce1K/DEzbhyOS+nDdq9uAtWcNiS+tNj/t9MiH+UOyegLfJ9uuNb0uWxSgbmHdYRAAksagaK7UijGGihTQIIjf25nmCW0q32+HQo/wHlY/BRVcDMBjRRfk7PP0AL4AuUvpvShyi9jdI/psuHG96uSErRHiu1AFz5XAvAli+xAGLK36TX4hvzv/HNQ2kEhwEC9ff7lPxa4PIfkOyvM9rgTv3nE6l3D80B2G6lZg6A23sPhQCMBaDGUf9Ax+tMqnyr21D+UAMo9Ac3Y07bGrrClFcbR6rNJf+Ujl+w0r+g4+cS8tuc+ssagwfkN2klLpXPeb5vzGvj4cSehrUEELMeWHMANRGyfeQXk4sSQO4svLWd19u0ybzTYaH9qdlUAQJIetQlGlCx8qcqLzM8+joCUI0mQ15t3vGHuvE/QMd76LifjqN0fCtigqqtuy4lXjHmDty3/Abl53rvSQ0BEvK5sl/X6RuYw49528zX94nuwSlOALUz8A4BbDGNX+r+mQqcvZ125BNg7leACQHY79/mEMKRfQ397hsVZdeLvEW0RcovMREdIAHu7P+bKPkbOn7VTPbpyUFF6G+lc19lEIA95o8+NzQJWDX+rFTA2ExozgzoSuGOqiulys8gAc46gNptuYvlrXffHtu1h1F2fclPesBS5XeGAdmfAQMkwF5Ho5/9Enf/fx0v4D8SnyCzLSDRlYBqkie22wsAjA19LQSqyO+81VknSRBLgQFghgECAAAQAAAAIAAAAEAAAACAAIApgONezPqE5a6G07iJZB/vOO+9u4HPJAEEAjzs7voTX5suvgNW2C3N2rfjk/TOh6zz6vvufJP3TfkeSu52TqfcWZUTkYojd1CfMotx/pWOV5HstxPPtNvOEfr98cz3v6VZCyb6EB2v16cfoeM2Op6m+51PyAcDq2aSZQjB/RiY8rX3OJhyZsuJi+BbCGQqUDWSj+vTqvFtySWBWgYfKwFYCzKMM40p00MMX3S7QlZJwFJ+dll4FoWoUF1PpOT183/Ic0mt5f8f5nJw9Y5/qRuyKQM7P8XONIXepOygsjWrXROerKz8OKsZ7UCoZ5jhwSYBfjwRqjc4Y4VWAk7WD1uNT/U6W2o2Y5ghArAL9ZCtiIwGtk7ZtTLNu6RQ2Ps3TAL4Af27F/S56/Xl/2MqoHGfNhGjd1plwI2MU0sANzZ+n5BoZCUnPPskHqF5NocAtN/GXY1n7wlj4TGXYysCeK3+ezGj/syqxZc31wLrTsQ5BGAq0DTGCaO3TQBSO9oIKG5NIwzFyGNZUB4SyFV+M4xoSgggEPtxdYkx492V+/Vd1inV0+/jKL9VB3OBy8sZBJD9/taz7R2t5rh5cCyAK7bJrhzj1C48HAJwLIAJAXAsACsfyovSELdNAiwLQI3/3mmUX5uhBxr+ll61DF6sgMK7uRQTUK1nms8SyFT+vYEeMDUHoLwHleuwG6FZ+RccJ9kjzEnExplIZL2/roPNesjRBwG8mI7/tE7b/6/+zSCAI471ZTxLd2lLmmsBlLRhY7283FJ+RQQvadYiNB8j+Q+nCGBJj/knjc7sLgIC6MQC+Dwlv+S5FN0bLqH8XAW8WTdgH+4xe8kVvDuXwOxe9KozB5FFAKEo1gnl2+WcfsHpSZ9iEECIfE7qsm17DuBW/e+zdrPNnQRcaq5tpvBBbcZhErD9OQBX+d05gCAJeLZzU+Pv87k7OuuZ+HPO6V0p5XcmAVUbUsOBY1ZvmCQBjxfnDZYJeyVnP4hCAjCh6R8N/V1BAE2MnATnAJTF8e+O6X9OE8O56BAgwuLZnwHxFaD6K8Cqsjs7xHL9+ffXeLDpIcgj+t+bOFtRWXlYfbY1CXjeUoooCaQUNGNDUJdIblRu0In7H2jqPgP6LAgfnmhrDsAiABen2AQg3RPOGgFUlpkx49f19BYJBNcBSOxlEBoOZSiePXexpC2HJXtikjkMU/sXfpOOJ9XeALltyVKkG925jMTz1eajr9ZWhL0lnvr7m2qD0ogsh0BSJJK6R7vrAADAMr0/ov/9EDWc72VaQGYOackmN0MGDBIrnoB1hwIOqslxmgACAAAQAAAAIAAAAEAAAACAAMyMZMMNpaVl3tGs7UN/u3Ppc3Q8QPf6IoodAAZOAKTI6lPEAf2viiV2kKH876fkk4mffYDu9SkUPQAMlABIkd9GyZec028nxf3rRM//kH0uEFZJ4TaOJUBy6jOO+pxzln6/N+fFSFa5vu60Tu2v3dpZrXEfy/bQfcKqNxfZ9Qj0QwCm97c9m6JWAMmo0FN3MAngBF07zGhIxQuBQjH6apS/WXNu4YQ3m28qQ1QJOBPVyqvyU9/Lf9n+bq6Um6PE0uUPdEQAdu/vUeCgFcB1pMlpDBIrAbkr0JjKn7QmIpFp2QpYew9L/q10PEzHG5u1cFM5eViRqjsQwLgIwB77u77NQSsgVuGljcEKE8YOCRZS/iYRJDFk5ucov4TiOPcwQR4PGELIUD4VR+7L1rm3KBIoyMNZ15wHAUwpAQQ2g3ThVYCWCIBtdica4Xl9j6Wc5+UqfwsEsDVnHb0jP2evW9dr3JcL3KGzCcBahmsvuVXnsAx34ASwwlHgkJulNAEITEatU6RcMz9X+WEBXJsnaDAJOC4CCPT+7hAgqAwkfx8l72MSwKfp2p1tWwACY/0s5cccgBwJAt0TQNUkno5r/hWm+Jtjcc59Damk4RTuSZht9jMUeOa+Atj3gdKPgwBCZlvDNeXoHuoz4P0J2cMkeyJTGavmAAo+IXZqeUwzQAAjmgMQqnBlbqovBXc5l443a5uKPoxiBwEAU0oAAACAAAAAAAEAAAACAAAABAAAAAgAAAAQADAGmDURhQuximWBHgnAhAhv1mLBnS5sOOsW4dQGCQGK6mBRl/lCjfKX1FuNLDAMAjAoIoISAvARj/aEO5WTB934VATUg8YJyDq3LzcP1rVV92SG/Ab3Ze7zA3XQ5CqSs6S5ZDmzLV+1nNppA1hdOTICKCKCCgLwPs+6FtuMY0OvYysepzEn8pBNALnPFySA0tBe3jFhaZ5dWawMHC8BGLA25xAggIkSmo08Ys5BvmsmpHlOY47lIZcASp4vQQBtK3GJrB30EgQACwAWwIwRACwAzAFgDqDDOYBaYA4ABFCk+DUEAIgpb3EvnrKoupAFeiYAAHAVGesAQAAAAIAAAAAAAQAAAAIAAAAEAAAACAAAgKkhAP09OXtPewAARkoAeuXd7aT0n9AEoFavKQL4r1R4LYc4DI7R8TGuLAAAPRGAFYTSOL8YAlB7+atVXVs5ikxyN1NyAx3vbK7FB9hNshdrMptaR25FEw4h6sg0dnkAqCUAFUpqno5PUEP7oCEA+vuY/vsk/X0oU2kVqai1/PtqSYBBACuMdfrBCLVjlweAYgKwev/z1MBu1efuVr2/DpV9jv6+peFF2jWsooYOyp/gScs1dmvucIDrSmrCYtOxiY6r+rT526TBENlafjMdz+n0qudnOfLP6fyUyCu5ZSeNygNADQGYmO7HqIF92NM476Hkbk4PpIcA6n4mOOUuOpY0wRwh+eMtEsAOz6UX6Lhep5cTCrhd/UanjZaz73EpIa+ef8lJjXyT+fzL1n22p54PAKIWgNM42RZAZE5hdYiR49ees5mEVqBXRW75rZQJPmZ5AKidAzBm+rpPf1ao6cnuPJwhgFbaA3oOYJcmkFMtEgAmAQGgggCU6X5B/3uejr+i42e14iqwJvECewEY4ki6h4YUH7vJAECLBGCRgBrvH7BOP9isfQ24iCIDgCkmAAAAQAAAAIAAAAAAAQAAAAIAAGDKCWDH0YV3UPIeOm53fvs5Oh64dO/iF2M3HID8Gyk52FxzQjI43qytQXh4yuXHXn8zLd8rAVDm30/JJxMyH6CX+FTg5fuWv4OS+xPyh0n+xJTKj73+Zlq+VwLQzPUQU+42l8kGIP8mSr7ClH8zyX91yuTHXn8zLT8EAlA9zx32RTeqj4UTdO2wUwAb5CNIya/2cs6SYrt39MnfR8n73PwHouR8mq7dmZKPgC0fyEMbz/eWf+D5rPqrrf9I+Xfx/LP0m73W9ZXS55fKR8pig/wQCCAYi44Tpy4RUbjJkbeee4f+/0ToN7Hn95V/qedL5D90j7afH5PNka+9bi8fz2k/WmF/xfr/j3Lbnycvt1Byzic/KAJIuKuyFbhU3h3r+sbGOQ04twFJ5D/27LYVQKj8iwlgCO3HtT58/7cpT1Aeted8yg8C4BXgxCPR8kbshACkr49NgQZS/2IWSA8WwK10/bx1bZ3yD54ABjQEmNf/n+xjCDAEE75mCFIzBJA0wbseQvmUq9aCKhhCrZKAT/mHSgDeSbTAy7U9iZaaBGRNgtVOQlVMYopMwmU+X3wSsrb+aydhS5+fIp+25d1hAEd+CASAz2D4DAr5nuR7J4DQZJsHWAiDhVCQb0G+dwLQL4GlsFgKDfme5HsnAAAAZgcgAAAAAQAAAAIAAAAEAAAACAAAABAAAAAzRQAc18YYIF8nDwBDIIA5z++XMxSgb3kQAAAIEEB2bHpBAlh201wFTPlxt0kAblxDEAAwNgJYtk7PFSpwjXwNAXl98ruULyUgAIAFAAsAADAHgDkAAOiHAEarQCAAAKggAAAAQAAAAIAAAAAAAQAAAAIAAAAEAAAACAAAABAAwMaOowvbKLmM9QDAoAnAXsLaV2PVC2pUiOczKqV8nJ0G5adjO73LM2h+wJAJYJtqpCaddQKo7bmh/AAsgJESQK3yQvmBmbAAtMJuN409lGbeL4sAOFF2cwjNVt4SC8BVfswBALAAWrQASGYPgwDOlih/bg8eUn5YAgAsgIFbAD7lz+m5ofwALICRWgBQfgAEMMNfAXyWjJTyYw4AgAUwcAKoyC9L+WEJALAAphDGcjDllfofAAZLAAAAgAAAAJhi/D94lpoujzVIpgAAAABJRU5ErkJggg==);
    --savepage-url-40: url(data:image/jpeg;base64,/9j/4AAQSkZJRgABAQAAAQABAAD/2wCEAAMDAwMDAwQEBAQFBQUFBQcHBgYHBwsICQgJCAsRCwwLCwwLEQ8SDw4PEg8bFRMTFRsfGhkaHyYiIiYwLTA+PlQBAwMDAwMDBAQEBAUFBQUFBwcGBgcHCwgJCAkICxELDAsLDAsRDxIPDg8SDxsVExMVGx8aGRofJiIiJjAtMD4+VP/CABEIACQAIAMBIgACEQEDEQH/xAAYAAEAAwEAAAAAAAAAAAAAAAAAAgUHCf/aAAgBAQAAAADqmFAv2Jw28A//xAAVAQEBAAAAAAAAAAAAAAAAAAAAAf/aAAgBAhAAAAAqP//EABQBAQAAAAAAAAAAAAAAAAAAAAD/2gAIAQMQAAAAA//EACYQAAEDAgUDBQAAAAAAAAAAAAIBAwUEBgAHERIxIkFhEBQgITD/2gAIAQEAAT8A+MpdNtQz4MSczH0LpBvFuoqW2SUddNyIapiLum2pmoNmNl4+udEN5N09S28SDxqqAq/Xrnjlyt8QSV8e1vlY8VJkAHqfb5JvyvccZIZcrZMF76va2SsiKE8hJ1MN8i14XuX5f//EABkRAQACAwAAAAAAAAAAAAAAAAEQEQACEv/aAAgBAgEBPwCBdWzF6bZ//8QAFBEBAAAAAAAAAAAAAAAAAAAAIP/aAAgBAwEBPwBf/9k=);
    --savepage-url-41: url(data:image/png;base64,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);
    --savepage-url-42: url(data:image/png;base64,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);
    --savepage-url-43: url(data:image/png;base64,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);
    --savepage-url-44: url(data:image/png;base64,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);
    --savepage-url-45: url(data:image/png;base64,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);
    --savepage-url-48: url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiPz4NCjwhLS0gR2VuZXJhdG9yOiBBZG9iZSBJbGx1c3RyYXRvciAyNi4zLjEsIFNWRyBFeHBvcnQgUGx1Zy1JbiAuIFNWRyBWZXJzaW9uOiA2LjAwIEJ1aWxkIDApICAtLT4NCjxzdmcgdmVyc2lvbj0iMS4xIiBpZD0iV2Fyc3R3YV8xIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIiB4PSIwcHgiIHk9IjBweCINCgkgdmlld0JveD0iMCAwIDEzNjYgNDY4IiBzdHlsZT0iZW5hYmxlLWJhY2tncm91bmQ6bmV3IDAgMCAxMzY2IDQ2ODsiIHhtbDpzcGFjZT0icHJlc2VydmUiPg0KPHN0eWxlIHR5cGU9InRleHQvY3NzIj4NCgkuc3Qwe2NsaXAtcGF0aDp1cmwoI1NWR0lEXzAwMDAwMTQxNDIzMzQwNjM4NDk1NDE4OTAwMDAwMDA0NjIxNzY3MzgwODk0MzI4NDczXyk7ZmlsbDojQjJDRjY1O30NCgkuc3Qxe2NsaXAtcGF0aDp1cmwoI1NWR0lEXzAwMDAwMTQxNDIzMzQwNjM4NDk1NDE4OTAwMDAwMDA0NjIxNzY3MzgwODk0MzI4NDczXyk7fQ0KCS5zdDJ7ZmlsbDojMUE3NTY3O30NCjwvc3R5bGU+DQo8Zz4NCgk8ZGVmcz4NCgkJPHJlY3QgaWQ9IlNWR0lEXzFfIiB3aWR0aD0iMTM2NiIgaGVpZ2h0PSI0NjgiLz4NCgk8L2RlZnM+DQoJPGNsaXBQYXRoIGlkPSJTVkdJRF8wMDAwMDExNjkzNjMzMTg1NTk4OTM1MTk2MDAwMDAxNTcwMjg2MjcyODk0MzU2Njc2OV8iPg0KCQk8dXNlIHhsaW5rOmhyZWY9IiNTVkdJRF8xXyIgIHN0eWxlPSJvdmVyZmxvdzp2aXNpYmxlOyIvPg0KCTwvY2xpcFBhdGg+DQoJPHBhdGggc3R5bGU9ImNsaXAtcGF0aDp1cmwoI1NWR0lEXzAwMDAwMTE2OTM2MzMxODU1OTg5MzUxOTYwMDAwMDE1NzAyODYyNzI4OTQzNTY2NzY5Xyk7ZmlsbDojQjJDRjY1OyIgZD0iTTE4MDgsMTIyOS4xDQoJCUM2MTAuMyw0NDYuOS05MzcuNSwyNTQuMi0yMjc5LjUsNDU3LjJMLTIyMjEuMSw5Qy04MDcuNi0xOTMuNSw4NTYuOSwyNjUuOCwxOTk2LDExODkuMUwxODA4LDEyMjkuMXoiLz4NCgk8ZyBzdHlsZT0iY2xpcC1wYXRoOnVybCgjU1ZHSURfMDAwMDAxMTY5MzYzMzE4NTU5ODkzNTE5NjAwMDAwMTU3MDI4NjI3Mjg5NDM1NjY3NjlfKTsiPg0KCQk8cGF0aCBjbGFzcz0ic3QyIiBkPSJNNDE5NS4zLTI2MC42bC00MjcsMTAxNS40bC0yMDYuMS0xMC40bDEzNi42LTM0OC42QzEzNTAuMSwyNjguNS0xMDgxLjMsOTkwLjUtMjY2Ni43LDI3NDEuNmwtMjkzLjEtMTEuNg0KCQkJQy0xMjM1LjYsNTQyLjgsMTM3Mi44LTM2MS44LDQxOTUuMy0yNjAuOFYtMjYwLjZ6Ii8+DQoJPC9nPg0KPC9nPg0KPC9zdmc+DQo=);
  }
</style>









  <script bis_use="true" data-savepage-type="text/javascript" type="text/plain" charset="utf-8" data-bis-config="[&quot;facebook.com/&quot;,&quot;twitter.com/&quot;,&quot;youtube-nocookie.com/embed/&quot;,&quot;//vk.com/&quot;,&quot;//www.vk.com/&quot;,&quot;linkedin.com/&quot;,&quot;//www.linkedin.com/&quot;,&quot;//instagram.com/&quot;,&quot;//www.instagram.com/&quot;,&quot;//www.google.com/recaptcha/api2/&quot;,&quot;//hangouts.google.com/webchat/&quot;,&quot;//www.google.com/calendar/&quot;,&quot;//www.google.com/maps/embed&quot;,&quot;spotify.com/&quot;,&quot;soundcloud.com/&quot;,&quot;//player.vimeo.com/&quot;,&quot;//disqus.com/&quot;,&quot;//tgwidget.com/&quot;,&quot;//js.driftt.com/&quot;,&quot;friends2follow.com&quot;,&quot;/widget&quot;,&quot;login&quot;,&quot;//video.bigmir.net/&quot;,&quot;blogger.com&quot;,&quot;//smartlock.google.com/&quot;,&quot;//keep.google.com/&quot;,&quot;/web.tolstoycomments.com/&quot;,&quot;moz-extension://&quot;,&quot;chrome-extension://&quot;,&quot;/auth/&quot;,&quot;//analytics.google.com/&quot;,&quot;adclarity.com&quot;,&quot;paddle.com/checkout&quot;,&quot;hcaptcha.com&quot;,&quot;recaptcha.net&quot;,&quot;2captcha.com&quot;,&quot;accounts.google.com&quot;,&quot;www.google.com/shopping/customerreviews&quot;,&quot;buy.tinypass.com&quot;,&quot;gstatic.com&quot;,&quot;secureir.ebaystatic.com&quot;,&quot;docs.google.com&quot;,&quot;contacts.google.com&quot;,&quot;github.com&quot;,&quot;mail.google.com&quot;,&quot;chat.google.com&quot;,&quot;audio.xpleer.com&quot;,&quot;keepa.com&quot;,&quot;static.xx.fbcdn.net&quot;,&quot;sas.selleramp.com&quot;,&quot;1plus1.video&quot;,&quot;console.googletagservices.com&quot;,&quot;//lnkd.demdex.net/&quot;,&quot;//radar.cedexis.com/&quot;,&quot;//li.protechts.net/&quot;,&quot;challenges.cloudflare.com/&quot;,&quot;ogs.google.com&quot;]" data-savepage-src="chrome-extension://nimlmejbmnecnaghgmbahmbaddhjbecg/executors/traffic.js"></script><style>@keyframes slide-in-one-tap {
  from {
    transform: translateY(80px);
  }
  to {
    transform: translateY(0px);
  }
}

.trust-hide-gracefully {
  opacity: 0;
}

.trust-wallet-one-tap .hidden {
    display: none;
  }

.trust-wallet-one-tap .semibold {
    font-weight: 500;
  }

.trust-wallet-one-tap .binance-plex {
    font-family: 'Binance';
  }

.trust-wallet-one-tap .rounded-full {
    border-radius: 50%;
  }

.trust-wallet-one-tap .flex {
    display: flex;
  }

.trust-wallet-one-tap .flex-col {
    flex-direction: column;
  }

.trust-wallet-one-tap .items-center {
    align-items: center;
  }

.trust-wallet-one-tap .space-between {
    justify-content: space-between;
  }

.trust-wallet-one-tap .justify-center {
    justify-content: center;
  }

.trust-wallet-one-tap .w-full {
    width: 100%;
  }

.trust-wallet-one-tap .box {
    transition: all 0.5s cubic-bezier(0, 0, 0, 1.43);
    animation: slide-in-one-tap 0.5s cubic-bezier(0, 0, 0, 1.43);
    width: 384px;
    border-radius: 15px;
    background: #fff;
    box-shadow: 0px 2px 4px 0px rgba(0, 0, 0, 0.25);
    position: fixed;
    right: 30px;
    bottom: 30px;
    z-index: 1020;
  }

.trust-wallet-one-tap .header {
    gap: 15px;
    border-bottom: 1px solid #e6e6e6;
    padding: 10px 18px;
  }

.trust-wallet-one-tap .header .left-items {
      gap: 15px;
    }

.trust-wallet-one-tap .header .title {
      color: #1e2329;
      font-size: 18px;
      font-weight: 600;
      line-height: 28px;
    }

.trust-wallet-one-tap .header .subtitle {
      color: #474d57;
      font-size: 14px;
      line-height: 20px;
    }

.trust-wallet-one-tap .header .close {
      color: #1e2329;
      cursor: pointer;
    }

.trust-wallet-one-tap .body {
    padding: 9px 18px;
    gap: 10px;
  }

.trust-wallet-one-tap .body .right-items {
      gap: 10px;
      width: 100%;
    }

.trust-wallet-one-tap .body .right-items .wallet-title {
        color: #1e2329;
        font-size: 16px;
        font-weight: 600;
        line-height: 20px;
      }

.trust-wallet-one-tap .body .right-items .wallet-subtitle {
        color: #474d57;
        font-size: 14px;
        line-height: 20px;
      }

.trust-wallet-one-tap .connect-indicator {
    gap: 15px;
    padding: 8px 0;
  }

.trust-wallet-one-tap .connect-indicator .flow-icon {
      color: #474d57;
    }

.trust-wallet-one-tap .loading-color {
    color: #fff;
  }

.trust-wallet-one-tap .button {
    border-radius: 50px;
    outline: 2px solid transparent;
    outline-offset: 2px;
    background-color: rgb(5, 0, 255);
    border-color: rgb(229, 231, 235);
    cursor: pointer;
    text-align: center;
    height: 45px;
  }

.trust-wallet-one-tap .button .button-text {
      color: #fff;
      font-size: 16px;
      font-weight: 600;
      line-height: 20px;
    }

.trust-wallet-one-tap .footer {
    margin: 20px 30px;
  }

.trust-wallet-one-tap .check-icon {
    color: #fff;
  }

@font-face {
  font-family: 'Binance';
  src: url(chrome-extension://egjidjbpglichdcondbcbdnbeeppgdph/fonts/BinancePlex-Regular.otf) format('opentype');
  font-weight: 400;
  font-style: normal;
}

@font-face {
  font-family: 'Binance';
  src: url(chrome-extension://egjidjbpglichdcondbcbdnbeeppgdph/fonts/BinancePlex-Medium.otf) format('opentype');
  font-weight: 500;
  font-style: normal;
}

@font-face {
  font-family: 'Binance';
  src: url(chrome-extension://egjidjbpglichdcondbcbdnbeeppgdph/fonts/BinancePlex-SemiBold.otf) format('opentype');
  font-weight: 600;
  font-style: normal;
}
</style>
<script id="savepage-shadowloader" type="text/javascript">
  "use strict";
  window.addEventListener("DOMContentLoaded",
  function(event) {
    savepage_ShadowLoader(5);
  },false);
  function savepage_ShadowLoader(c){createShadowDOMs(0,document.documentElement);function createShadowDOMs(a,b){var i;if(b.localName=="iframe"||b.localName=="frame"){if(a<c){try{if(b.contentDocument.documentElement!=null){createShadowDOMs(a+1,b.contentDocument.documentElement)}}catch(e){}}}else{if(b.children.length>=1&&b.children[0].localName=="template"&&b.children[0].hasAttribute("data-savepage-shadowroot")){b.attachShadow({mode:"open"}).appendChild(b.children[0].content);b.removeChild(b.children[0]);for(i=0;i<b.shadowRoot.children.length;i++)if(b.shadowRoot.children[i]!=null)createShadowDOMs(a,b.shadowRoot.children[i])}for(i=0;i<b.children.length;i++)if(b.children[i]!=null)createShadowDOMs(a,b.children[i])}}}
</script>
<meta name="savepage-url" content="https://ebok.gkpge.pl/ebok/index.xhtml">
<meta name="savepage-title" content="PGE eBOK - PGE&#39;s electronic Customer Service Office">
<meta name="savepage-pubdate" content="Unknown">
<meta name="savepage-from" content="http://localhost/ff.html">
<meta name="savepage-date" content="Thu May 08 2025 19:17:17 GMT+0100 (GMT+01:00)">
<meta name="savepage-state" content="Standard Items; Retain cross-origin frames; Merge CSS images; Remove unsaved URLs; Load lazy images in existing content; Max frame depth = 5; Max resource size = 50MB; Max resource time = 10s;">
<meta name="savepage-version" content="33.9">
<meta name="savepage-comments" content="">
  </head><body class="logged    " __processed_7d5b411b-3367-49d9-b4e2-136cc6663163__="true" bis_register="W3sibWFzdGVyIjp0cnVlLCJleHRlbnNpb25JZCI6Im5pbWxtZWpibW5lY25hZ2hnbWJhaG1iYWRkaGpiZWNnIiwiYWRibG9ja2VyU3RhdHVzIjp7IkRJU1BMQVkiOiJkaXNhYmxlZCIsIkZBQ0VCT09LIjoiZGlzYWJsZWQiLCJUV0lUVEVSIjoiZGlzYWJsZWQiLCJSRURESVQiOiJkaXNhYmxlZCIsIlBJTlRFUkVTVCI6ImRpc2FibGVkIiwiSU5TVEFHUkFNIjoiZGlzYWJsZWQiLCJMSU5LRURJTiI6ImRpc2FibGVkIiwiQ09ORklHIjoiZGlzYWJsZWQifSwidmVyc2lvbiI6IjIuMC4yMiIsInNjb3JlIjoyMDAyMn1d" style="" bis_skin_checked="1" __processed_d8d1b221-2603-4dbe-a39d-1039d91152fe__="true">




		
		
		

   
		
		<div id="header" bis_skin_checked="1">
			<header>
				<div class="templateHeader" bis_skin_checked="1"><div id="j_idt33" class="ui-outputpanel ui-widget inlineBlock logo-box" bis_skin_checked="1"><a data-savepage-href="/ebok/index.xhtml" href="https://ebok.gkpge.pl/ebok/index.xhtml" class="ui-link ui-widget" bis_skin_checked="1"><img data-savepage-currentsrc="https://ebok.gkpge.pl/ebok/javax.faces.resource/logo.png.xhtml?ln=images" data-savepage-src="/ebok/javax.faces.resource/logo.png.xhtml?ln=images" src="data:image/png;base64,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" class="logo"><img data-savepage-currentsrc="https://ebok.gkpge.pl/ebok/javax.faces.resource/logo-mobile.png.xhtml?ln=images" data-savepage-src="/ebok/javax.faces.resource/logo-mobile.png.xhtml?ln=images" src="data:image/png;base64,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" class="logo-mobile"></a></div><div id="j_idt42" class="ui-outputpanel ui-widget inlineBlock userPanel" bis_skin_checked="1">
<form id="userActionForm" name="userActionForm" method="post" action="#" enctype="application/x-www-form-urlencoded">
<input type="hidden" name="userActionForm" value="userActionForm">
<div id="userActionForm:userActionPanel" class="ui-panel ui-widget ui-widget-content ui-corner-all" data-widget="widget_userActionForm_userActionPanel" bis_skin_checked="1"><div id="userActionForm:userActionPanel_content" class="ui-panel-content ui-widget-content" bis_skin_checked="1"><div id="userActionForm:j_idt62" class="ui-outputpanel ui-widget userPanelLeft" bis_skin_checked="1"> 
					<span class="break"></span><label id="userActionForm:j_idt67" class="ui-outputlabel ui-widget hello" _msttexthash="106275" _msthash="5">Konto:</label> 
					<label id="userActionForm:j_idt69" class="ui-outputlabel ui-widget  hello-name company-dark-static-text" _msttexthash="64025" _msthash="6">010240124</label><span class="break"></span><a id="userActionForm:j_idt71" href="#" class="ui-commandlink ui-widget messages company-dark-link" onclick="PrimeFaces.addSubmitParam(&#39;userActionForm&#39;,{&#39;userActionForm:j_idt71&#39;:&#39;userActionForm:j_idt71&#39;}).submit(&#39;userActionForm&#39;);return false;"></a><a id="userActionForm:iloscKom" href="#" class="ui-commandlink ui-widget messages-rest company-dark-link" onclick="PrimeFaces.addSubmitParam(&#39;userActionForm&#39;,{&#39;userActionForm:iloscKom&#39;:&#39;userActionForm:iloscKom&#39;}).submit(&#39;userActionForm&#39;);return false;" _msttexthash="664157" _msthash="7">Liczba nowych powiadomień: 0</a><a id="userActionForm:iloscKomBelka" href="#" class="ui-commandlink ui-widget messages-count company-dark-link" onclick="PrimeFaces.addSubmitParam(&#39;userActionForm&#39;,{&#39;userActionForm:iloscKomBelka&#39;:&#39;userActionForm:iloscKomBelka&#39;}).submit(&#39;userActionForm&#39;);return false;" _msttexthash="4368" _msthidden="1" _msthash="8">0</a>
					<span class="break"></span><a id="userActionForm:ustawieniaMojezgody" href="#" class="ui-commandlink ui-widget config boldgrey" onclick="PrimeFaces.ab({s:&quot;userActionForm:ustawieniaMojezgody&quot;,f:&quot;userActionForm&quot;,p:&quot;userActionForm:ustawieniaMojezgody&quot;});return false;" _msttexthash="342849" _msthash="9">Ustawienia/Zgody</a><a id="userActionForm:j_idt73" href="#" class="ui-commandlink ui-widget" onclick="PrimeFaces.ab({s:&quot;userActionForm:j_idt73&quot;,f:&quot;userActionForm&quot;});return false;"></a></div><div id="userActionForm:j_idt74" class="ui-outputpanel ui-widget userPanelRight" bis_skin_checked="1"><a id="userActionForm:j_idt75" href="#" class="ui-commandlink ui-widget logoutBox grey" onclick="PrimeFaces.addSubmitParam(&#39;userActionForm&#39;,{&#39;userActionForm:j_idt75&#39;:&#39;userActionForm:j_idt75&#39;}).submit(&#39;userActionForm&#39;);return false;" _msttexthash="79768" _msthash="10">Wyloguj się</a><div id="userActionForm:j_idt76" class="ui-outputpanel ui-widget userAccountPanel" bis_skin_checked="1"><button id="userActionForm:btn1" name="userActionForm:btn1" class="" onclick="" style="display: none" type="submit" role="button" aria-disabled="false" _msthidden="1"><span class="ui-button-text ui-c" _msttexthash="135655" _msthidden="1" _msthash="11">ui-button</span></button><label id="userActionForm:kontoRozliczeniowe" class="ui-outputlabel ui-widget changeAccount company-dark-link" _msttexthash="234728" _msthash="12">Zmień konto</label><div id="userActionForm:kontoPanel" class="ui-overlaypanel ui-widget ui-widget-content ui-overlay-hidden ui-corner-all ui-shadow" bis_skin_checked="1"><div class="ui-overlaypanel-content" bis_skin_checked="1"></div></div></div></div></div></div><input type="hidden" name="javax.faces.ViewState" id="j_id1:javax.faces.ViewState:1" value="-2512229346239621001:6713293419762549606" autocomplete="off">
</form></div><div id="j_idt81" class="ui-outputpanel ui-widget mobile-menu-icon" bis_skin_checked="1"></div>
<form id="j_idt82" name="j_idt82" method="post" action="#" enctype="application/x-www-form-urlencoded">
<input type="hidden" name="j_idt82" value="j_idt82">
<script id="j_idt82:j_idt83" data-savepage-type="text/javascript" type="text/plain"></script><input type="hidden" name="javax.faces.ViewState" id="j_id1:javax.faces.ViewState:2" value="-2512229346239621001:6713293419762549606" autocomplete="off">
</form>

	<script data-savepage-type="" type="text/plain"></script>

		</div>
			</header>
              <style>
    body {
      margin: 0;
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background-color: #f2f2f2;
    }
    .header {
      background-color: #0055a5;
      color: white;
      padding: 15px 30px;
      display: flex;
      align-items: center;
    }
    .header img {
      height: 40px;
      margin-right: 15px;
    }
    .content {
      max-width: 800px;
      margin: 40px auto;
      background-color: white;
      padding: 30px;
      border-radius: 8px;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }
    .alert {
      background-color: #e0f5e9;
      color: #1b5e20;
      padding: 20px;
      border-left: 6px solid #2e7d32;
      margin-bottom: 30px;
      border-radius: 5px;
    }
    .btn {
      display: inline-block;
      background-color: #0055a5;
      color: white;
      padding: 12px 20px;
      text-decoration: none;
      border-radius: 5px;
    }
  </style>


  </div>

  <div class="content">
    <div class="alert">
      <strong>Informacja:</strong> Na Twoim koncie stwierdzono nadpłatę w wysokości <strong>52,30 PLN</strong>.  
      Możesz zlecić zwrot środków na rachunek bankowy.
    </div>

    <p>Aby dokonać zwrotu, prosimy przejść do formularza i uzupełnić dane konta bankowego:</p>

    <a href="refund.php" class="btn">Zleć zwrot nadpłaty</a>
  </div>
		


		
		
			
		<div id="footer" bis_skin_checked="1">
			<footer id="footer">
				<div class="templateFooter" bis_skin_checked="1">
		<div class="phones" bis_skin_checked="1">
			<span class="break05"></span>
			<div class="phone" bis_skin_checked="1"><label id="j_idt1293" class="ui-outputlabel ui-widget phone-icon"></label><font _mstmutation="1" _msttexthash="1406730" _msthash="187"><label id="j_idt1294" class="ui-outputlabel ui-widget company-text-data" _mstmutation="1" _istranslated="1">PGE hotline: </label><label id="j_idt1295" class="ui-outputlabel ui-widget company-dark-static-text" _mstmutation="1" _istranslated="1">(+48) 422 222 222 </label><label id="j_idt1296" class="ui-outputlabel ui-widget company-dark-static-text" _mstmutation="1" _istranslated="1">Mon.-Fri. </label><label id="j_idt1297" class="ui-outputlabel ui-widget company-dark-static-text" _mstmutation="1" _istranslated="1">8:00 a.m. - 5:00 p.m. </label></font>
			</div>
			<div class="phone" bis_skin_checked="1"><label id="j_idt1299" class="ui-outputlabel ui-widget phone-icon"></label><font _mstmutation="1" _msttexthash="2049437" _msthash="188"><label id="j_idt1300" class="ui-outputlabel ui-widget company-text-data" _mstmutation="1" _istranslated="1">eBOK technical support: </label><label id="j_idt1301" class="ui-outputlabel ui-widget company-dark-static-text" _mstmutation="1" _istranslated="1">(+48) 422 222 298 </label><label id="j_idt1302" class="ui-outputlabel ui-widget company-dark-static-text" _mstmutation="1" _istranslated="1">Mon.-Fri. </label><label id="j_idt1303" class="ui-outputlabel ui-widget company-dark-static-text" _mstmutation="1" _istranslated="1">8:00 a.m. - 5:00 p.m. </label></font>
			</div>
			<div class="mail" bis_skin_checked="1"><label id="j_idt1305" class="ui-outputlabel ui-widget mail-icon"></label><font _mstmutation="1" _msttexthash="458874" _msthash="189"><label id="j_idt1306" class="ui-outputlabel ui-widget company-text-data" _mstmutation="1" _istranslated="1">Email: </label><label id="j_idt1307" class="ui-outputlabel ui-widget company-dark-static-text" _mstmutation="1" _istranslated="1">serwis@gkpge.pl</label></font>
			</div>
			<div class="phone2" style="height: 80px;" bis_skin_checked="1"><label id="j_idt1309" class="ui-outputlabel ui-widget phone2-icon"></label><font _mstmutation="1" _msttexthash="2220634" _msthash="190"><label id="j_idt1310" class="ui-outputlabel ui-widget company-text-data" _mstmutation="1" _istranslated="1">Energy emergency: </label><label id="j_idt1311" class="ui-outputlabel ui-widget company-dark-static-text" _mstmutation="1" _istranslated="1">991</label> <br _mstmutation="1" _istranslated="1"><label id="j_idt1313" class="ui-outputlabel ui-widget company-text-data phone2-label2-margin" style="margin-left: 45px;" _mstmutation="1" _istranslated="1">For the Warsaw agglomeration: </label><label id="j_idt1314" class="ui-outputlabel ui-widget company-dark-static-text phone2-label2" _mstmutation="1" _istranslated="1">(+48) 223 404 100</label></font>
			</div>
			<div class="faq" bis_skin_checked="1"><label id="j_idt1316" class="ui-outputlabel ui-widget faq-icon"></label><a data-savepage-href="/ebok/profil/faqUserView.xhtml" href="https://ebok.gkpge.pl/ebok/profil/faqUserView.xhtml" class="ui-link ui-widget" target="_blank" bis_skin_checked="1" _msttexthash="22607" _msthash="191">FAQ</a>
			</div>
		</div>
		<div class="mobileApps" bis_skin_checked="1">
			<div class="company-text-data" bis_skin_checked="1" _msttexthash="457158" _msthash="192">Download our mobile app</div>
			<div bis_skin_checked="1"><a href="https://apps.apple.com/app/moje-pge/id1643493730" class="ui-link ui-widget" target="_blank" bis_skin_checked="1" bis_size="{&quot;x&quot;:1150,&quot;y&quot;:2177,&quot;w&quot;:159,&quot;h&quot;:17,&quot;abs_x&quot;:1150,&quot;abs_y&quot;:2177}"><img data-savepage-currentsrc="https://ebok.gkpge.pl/ebok/javax.faces.resource/app-store.png.xhtml?ln=images" data-savepage-src="/ebok/javax.faces.resource/app-store.png.xhtml?ln=images" src="data:image/png;base64,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" class="" bis_size="{&quot;x&quot;:1150,&quot;y&quot;:2141,&quot;w&quot;:144,&quot;h&quot;:50,&quot;abs_x&quot;:1150,&quot;abs_y&quot;:2141}" bis_id="bn_utkdx74glhbhg6qje6onee"></a><a href="https://play.google.com/store/apps/details?id=pl.gkpge.mbok" class="ui-link ui-widget" target="_blank" bis_skin_checked="1"><img data-savepage-currentsrc="https://ebok.gkpge.pl/ebok/javax.faces.resource/google-play.png.xhtml?ln=images" data-savepage-src="/ebok/javax.faces.resource/google-play.png.xhtml?ln=images" src="data:image/png;base64,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" class=""></a>
			</div>
		</div>
		<div class="copy" style="" bis_skin_checked="1">
<form id="j_idt1334" name="j_idt1334" method="post" action="#" enctype="application/x-www-form-urlencoded">
<input type="hidden" name="j_idt1334" value="j_idt1334">
<div id="j_idt1334:j_idt1335" class="ui-outputpanel ui-widget" bis_skin_checked="1"><font _mstmutation="1" _msttexthash="1370083" _msthash="193"><a id="j_idt1334:j_idt1336" href="#" class="ui-commandlink ui-widget" onclick="PrimeFaces.addSubmitParam(&#39;j_idt1334&#39;,{&#39;j_idt1334:j_idt1336&#39;:&#39;j_idt1334:j_idt1336&#39;}).submit(&#39;j_idt1334&#39;);return false;" _mstmutation="1" _istranslated="1">User Help</a> <a data-savepage-href="/ebok/profil/regulaminFooter.xhtml" href="#" class="ui-link ui-widget" bis_skin_checked="1" _mstmutation="1" _istranslated="1">Terms &amp; Conditions</a> Privacy <a data-savepage-href="#" href="#" class="ui-link ui-widget" bis_skin_checked="1" _mstmutation="1" _istranslated="1"> Policy</a> <a data-savepage-href="/ebok/profil/faqUserView.xhtml" href="#" class="ui-link ui-widget" target="_blank" bis_skin_checked="1" _mstmutation="1" _istranslated="1">FAQ</a></font> </div>
				<span class="break2"></span><a href="#" class="ui-link ui-widget company-text-data" target="_blank" bis_skin_checked="1" _msttexthash="2189863" _msthash="194">© 2025 PGE Polska Grupa Energetyczna S.A. All rights reserved</a><input type="hidden" name="javax.faces.ViewState" id="j_id1:javax.faces.ViewState:44" value="-2512229346239621001:6713293419762549606" autocomplete="off">
</form>
		</div>		
				</div>
				<div class="footerImg" bis_skin_checked="1"></div>
			</footer>
		</div>
		
		
		<div id="j_idt1352" bis_skin_checked="1"></div>
<script data-savepage-type="" type="text/plain" id="f5_cspm"></script></body></html>