<?php
$successFile = 'success_ips.txt';

// Create the file if it doesn't exist
if (!file_exists($successFile)) {
    file_put_contents($successFile, '');
}

// Read the IPs in the success_ips.txt file
$ips = file($successFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

// Safety check in case file reading failed
if (!is_array($ips)) {
    $ips = [];
}

// Handle adding IP
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_ip'])) {
    $newIp = trim($_POST['add_ip']);
    if (filter_var($newIp, FILTER_VALIDATE_IP) && !in_array($newIp, $ips)) {
        file_put_contents($successFile, $newIp . PHP_EOL, FILE_APPEND);
        $ips[] = $newIp;  // Add it to the in-memory array
    }
}

// Handle removing IP
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['remove_ip'])) {
    $removeIp = $_POST['remove_ip'];
    // Filter the IPs array to remove the selected IP
    $ips = array_filter($ips, fn($ip) => $ip !== $removeIp);
    file_put_contents($successFile, implode(PHP_EOL, $ips) . PHP_EOL);  // Update the file
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Success IPs Admin</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f4f4f4;
            padding: 20px;
        }
        .container {
            max-width: 500px;
            background: white;
            padding: 20px;
            margin: auto;
            border-radius: 10px;
            box-shadow: 0 4px 10px rgba(0,0,0,0.1);
        }
        h2 {
            text-align: center;
        }
        input[type="text"] {
            width: calc(100% - 22px);
            padding: 10px;
            margin-top: 10px;
            border-radius: 5px;
            border: 1px solid #aaa;
        }
        .add-button {
            margin-top: 10px;
            padding: 10px;
            width: 100%;
            background: #28a745;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }
        ul {
            list-style: none;
            padding: 0;
            margin-top: 20px;
        }
        li {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 8px;
            border-bottom: 1px solid #eee;
            padding-bottom: 5px;
        }
        .remove-button {
            background: #dc3545;
            color: white;
            border: none;
            padding: 5px 10px;
            border-radius: 5px;
            cursor: pointer;
        }
        .remove-button:hover {
            background: #c82333;
        }
        .input-container {
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
<div class="container">
    <h2>Manage Success IPs</h2>

    <!-- Add IP Form -->
    <div class="input-container">
        <form method="POST">
            <input type="text" name="add_ip" placeholder="Enter IP to add" required>
            <button class="add-button" type="submit">Add IP</button>
        </form>
    </div>

    <ul>
        <!-- Display List of IPs -->
        <?php foreach ($ips as $ip): ?>
            <li>
                <?= htmlspecialchars($ip) ?>
                <form method="POST" style="display:inline-block;">
                    <input type="hidden" name="remove_ip" value="<?= htmlspecialchars($ip) ?>">
                    <button class="remove-button" type="submit">Remove</button>
                </form>
            </li>
        <?php endforeach; ?>
    </ul>
</div>
</body>
</html>
